		
;LIST	
		
;24/03/2003 :	version initiale
;13/07/2003 :	ajout de movff
;		ajout de cjne2
;10/01/2004 :	modif de movlf --> movlf2 pour 2 octets
;		ajout de movlf pour 1 octet
		
 NOLIST	
		
		;bank0				pointe sur bank0 RAM
		;bank1				pointe sur bank1 RAM
		;bank2				pointe sur bank2 RAM
		;bank3				pointe sur bank3 RAM
		
		;movlf2	literal,reg0		ecrit "literal" dans "reg0" sur 2 octets
		;movlf	literal,reg0		ecrit "literal" dans "reg0"
		;movff	reg0,reg1		ecrit "reg0" dans "reg1"
		
		;jb	reg,bit,addr		teste bit de reg et saut si = 1
		;jnb	reg,bit,addr
		
		;jz	addr			teste Z de STATUS
		;jnz	addr
		
		;jc	addr			teste C de STATUS
		;jnc	addr
		
		;jfz	reg,addr		teste si f = 0 et saut si oui
		;jfnz	reg,addr		teste si f = 0 et saut si non
		
		;jfz2	reg,addr		teste si f (sur 2 octets) = 0 et saut si oui
		;jfnz2	reg,addr		teste si f (sur 2 octets) = 0 et saut si non
		
		;djnz	reg,addr		decremente reg et saut a addr si reg pas 0
		;djnz2	reg,addr		decremente reg (sur 2 octets) et saut si pas = 0
		
		;cjne	reg1,reg2,addr		compare reg1 et reg2 et saut si pas egaux
		;cje	reg1,reg2,addr		compare reg1 et eg2 et saut si egaux
		
		;cjne2	reg1,reg2,addr		compare reg1 et reg2 et saut si pas egaux (sur 2 octets)
		
		;cljne	literal,reg,addr	compare literal et reg et saut si pas egaux
		;clje	literal,reg,addr	compare literal et reg et saut si egaux
		
		asm

;************************************************************************
;			MACRO DE CHANGEMENT DE BANK
;************************************************************************
		
bank0		macro				; passer en banque0
		bcf		STATUS,RP0
		bcf		STATUS,RP1
		endm
		
;************************************************************************
		
bank1		macro				; passer en banque1
		bsf		STATUS,RP0
		bcf		STATUS,RP1
		endm
		
;************************************************************************
		
bank2		macro				; passer en banque2
		bcf		STATUS,RP0
		bsf		STATUS,RP1
		endm
		
;************************************************************************
		
bank3		macro				; passer en banque3
		bsf		STATUS,RP0
		bsf		STATUS,RP1
		endm	
				
;************************************************************************
		
movlf2		macro		literal,reg0
		movlw		literal/256
		movwf		reg0 + 1
		movlw		literal % 256
		movwf		reg0
		endm
		
;************************************************************************
		
movlf		macro		literal,reg0
		movlw		literal
		movwf		reg0
		endm
		
;************************************************************************
		
movff		macro		reg0,reg1
		movf		reg0,w
		movwf		reg1
		endm
		
;************************************************************************
		
movff2		macro		reg0,reg1,reg2,reg3
		movff		reg0,reg2
		movff		reg1,reg3
		endm
		
;************************************************************************
		
jb		macro		reg0,bit,addr
		btfsc		reg0,bit
		goto		addr
		endm
		
;************************************************************************
		
jnb		macro		reg0,bit,addr
		btfss		reg0,bit
		goto		addr
		endm
		
;************************************************************************
		
jz		macro		addr
		btfsc		3,2
		goto		addr
		endm
		
;************************************************************************
		
jnz		macro		addr
		btfss		3,2
		goto		addr
		endm
		
;************************************************************************
		
jc		macro		addr
		btfsc		3,0
		goto		addr
		endm
		
;************************************************************************
		
jnc		macro		addr
		btfss		3,0
		goto		addr
		endm
		
;************************************************************************
		
jfz		macro		reg0,addr
		movf		reg0,w
		btfsc		3,2
		goto		addr
		endm
		
;************************************************************************
		
jfnz		macro		reg0,addr
		movf		reg0,w
		btfss		3,2
		goto		addr
		endm
		
;************************************************************************
		
jfz2		macro		reg0,addr
		local		fin
		movf		reg0,w
		addwf		reg0+1,w
		btfsc		3,2		;status,z
		btfsc		3,0		;status,c
		goto		fin
		goto		addr
fin		
		endm
		
;************************************************************************
		
jfnz2		macro		reg0,addr
		movf		reg0,w
		addwf		reg0+1,w
		btfsc		3,2
		btfsc		3,0
		goto		addr
		endm
		
;************************************************************************
		
djnz		macro		reg0,addr
		decfsz		reg0,f
		goto		addr
 		
		endm
		
;************************************************************************
		
djnz2		macro		reg0,addr
		movf		reg0,w
		btfsc		3,2
		decf		reg0+1,f
		decf		reg0,f
		movf		reg0,w
		addwf		reg0+1,w
		btfsc		3,2
		btfsc		3,0
		goto		addr
		endm
		
;************************************************************************
		
cjne		macro		reg1,reg2,addr
		movf		reg1,w
		subwf		reg2,w
		btfss		3,2
		goto		addr
		endm
		
;************************************************************************
		
cje		macro		reg1,reg2,addr
		movf		reg1,w
		subwf		reg2,w
		btfsc		3,2
		goto		addr
		endm
		
;************************************************************************
		
cjne2		macro		reg1,reg2,addr
		local		fin
		movf		reg1,w
		subwf		reg2,w
		btfss		3,2			;z = 1 ? --> reg1 = reg2
		goto		fin
		movf		reg1+1,w
		subwf		reg2+1,w
		btfsc		3,2
		goto		addr
fin		
		endm
		
;************************************************************************
		
cljne		macro		literal,reg0,addr
		movlw		literal
		subwf		reg0,w
		btfss		3,2			;status,Z
		goto		addr
		endm
		
;************************************************************************
		
clje		macro		literal,reg0,addr
		movlw		literal
		subwf		reg0,w
		btfsc		3,2
		goto		addr
		endm
		
		endasm

;************************************************************************
		
 LIST
