'****************************************************************
'*  Name    : taz6cle.BAS                                       *
'*  Author  : Grard                                            *
'*  Date    : 29/08/2008                                        *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
		
;le but est de faire clignoter une LED sur RA3 avec une frquence de 1Hz
;en utilisant le Timer0
;le quartz sera un modle 3,2768MHz (multiple de 2)
;le prescaler ferra une division par 64, on aura une interruotion  la frquence de 50Hz

;jnb et cljne sont des macros que j'ai cris pour me faciliter le travail
;voir fichier macros.asm

;affectation des broches

;	1	A2				18	A1
;	2	A3	Clig 1Hz		17	A0	
;       3	A4			   	16	OSC1
;       4       MCLR				15	OSC2
;       5       VSS				14	VDD
;       6       B0				14	B7	
;       7       B1				12	B6	
;       8       B2				11	B5	
;       9       B3				10	B4	

;*************************************************************
;		DEFINITION DU PROCESSEUR
;*************************************************************
		
		Device = 16F84A
		
;*************************************************************
;		MOT DE CONFIGURATION
;*************************************************************
		
		Config   CP_OFF, PWRTE_ON, WDT_OFF, XT_OSC
		;3,2768MHz
		
;*************************************************************
;		DECLARATIONS + SYMBOLES + CONSTANTES
;*************************************************************
		
		Symbol		LED_SEC 	= PORTA.3
		
;*************************************************************
;		MACROS ASSEMBLEUR
;*************************************************************
		
		#include "macros.asm"
		
;*************************************************************
;		SAUT VERS INTERRUPTION TIMER0
;*************************************************************
		
on_interrupt	IRQ_TMR0
		
;*************************************************************
;		VARIABLES
;*************************************************************
		
                Dim     cpt             As Byte
                
;*************************************************************
;		PROGRAMME PRINCIPAL
;*************************************************************
		
		GoTo	INIT
		
;*************************************************************
;		ROUTINE D'INTERRUPTION DU TIMER0
;*************************************************************
		
IRQ_TMR0:       
		ASM
		
		bcf		INTCON, T0IF
                incf            cpt,f
                cljne           25,cpt,RESTORER_CONTEXTE
                
                clrf            cpt
		jnb		LED_SEC, M_A_1
		bcf		LED_SEC
		GoTo		RESTORER_CONTEXTE
		
M_A_1:		
		bsf		LED_SEC

		ENDASM
		
RESTORER_CONTEXTE:
		
		Context Restore
		
;*************************************************************
;		INITIALISATIONS
;*************************************************************
		
INIT:		
		INTCON		= %10100000	;GIE et TOIF = 1
		PORTA		= 0
		PORTB		= 0
		OPTION_REG	= %11000101	;prediv TMR0 / 64 irq 50Hz
		TRISA		= 0
		TRISB		= 0
		
                LED_SEC		= 1
                                
                cpt             = 0
                
;*************************************************************
;		PROGRAMME PRINCIPAL
;*************************************************************
		
		
MainLoop:		
		nop
		DelayMS       2500
		
		GoTo MainLoop
		
';*************************************************************
		
		End
		
