#include <htc.h> //fichier indispensable au compilateur Hi-tech
#ifndef _XTAL_FREQ 
 // Unless already defined assume 4MHz system frequency
 // This definition is required to calibrate __delay_us() and __delay_ms()
 #define _XTAL_FREQ 4000000 //dfinition du quartz
#endif
		

__CONFIG(WDTDIS & PWRTEN & INTIO & LVPDIS & MCLRDIS & BORDIS & UNPROTECT);
		/*Dfinition des fusibles:
				-Watch dog dsactiv
					-pwrt activ
						-osc interne
							-lvp dsactiv
								-mclr dsactiv
									-Brown Out Reset dsactiv
										-protection dsactive*/
		
char a = 0;

void main(void){
	
	TRISB = 0b00000000; //tous les ports en sortie
	TRISA = 0b00000000;
	CMCON = 0x07; //CAN dsactiv
	PORTB = 0b00000001; //initialisation du chenillard
	PORTA = 0b00000000;
	
	
	while(1){
		
		TRISA = 0b00000000; //RA0 en sortie, charge de la led
		RA0 = 1;
		_delay(500);
		TRISA = 0b00000001; //RA0 en entre
		
		
		while(RA0){ //boucle d'attente de la dcharge de la led
			__delay_ms(2);
			}
		
		if(PORTB == 0b10000000) a = 1; //detection de la fin du chenillard
		PORTB <<= 1; //rotation  gauche
		if(a){
			PORTB = 0b00000001; //"remise  1" du chenillard
			a = 0;
			}
		}
}