/*
Liaison micro carte affichage
CDE_AF 		RD3
PORTB[7:0] 	D[7:0]
PORTD[7:4] 	DS[4:1]
PRESSURE 	AN0 RA.0
Ce programme permet de gnrer la commande SM_CLOCK permettant de faire varier la vitesse du moteur
*/

//Configration du PIC
#pragma config OSC = XT		// Quartz de 4 Mhz
#pragma config PWRT = ON
#pragma config WDT = OFF
#pragma config BOR = ON
#pragma config BORV = 42	//Reset ds que la tension d'alimentation passe en dessous de 4.2V
#pragma config LVP = OFF

//include
#include <p18f452.h>
#include <stdlib.h>		// fonction atol:convertir une chaine  en un nombre

//#define duree_tour_ml 285480000 /* dure en micro seconde d'un tour moteur pour 1ml/h */
#define duree_tour_ml 280800000
//long duree_tour_ml=280800000, diviseur;
unsigned short long pas_moteur=200;

//#define pas_moteur 48 /* nombre de pas du moteur */

#define SM_CLOCK		LATCbits.LATC1 
#define SM_START_STOP 	LATEbits.LATE2 

#define CDE_AF PORTDbits.RD3
#define Front_Montant {CDE_AF= 1; _asm nop _endasm ; CDE_AF= 0;}	//impulsion positive de CDE_AF
#define VALID	PORTAbits.RA5
#define KEY	PORTDbits.RD0

#define digit_1000		0x00		//slection afficheur 1000
#define digit_100		0x10
#define digit_10		0x20
#define digit_1			0x30
#define digit_mode		0x40
#define digit_bargraf	0x50

#define b_start_stop 0x00
#define b_cent 0x10                   /* dfinition des adresses des diffrents boutons poussoirs */
#define b_dix 0x20
#define b_un 0x30
#define b_mode 0x40


#define p_25 0xFE		/* Adresse premire LED pression */
#define p_50 0xFC		/* Adresse deux premire LEDs pression */
#define p_75 0xF8		/* Adresse trois premire LEDs pression */
#define p_100 0xF0	/* Adresse des quatre LEDs pression */
#define led_goutte 0xEF    /* Adresse de la LED presence goutte */

#define pt_debit 0xDF	/* Adresse du digit du 5me afficheur correspondant au dbit */
#define pt_max_perf 0xFD	/* Adresse du digit du 5me afficheur correspondant au max  perfuser */
#define pt_micro_pompe 0xEF	/* Adresse du digit du 5me afficheur correspondant  la Pompe */
#define pt_start_stop 0xF7	/*  Adresse du digit du 5me afficheur correspondant au start/stop */
#define pt_vit_mot 0xBF	/* Adresse du digit du 5me afficheur correspondant  la vit moteur */
#define pt_tot_perf 0x7F	/* Adresse du digit du 5me afficheur correspondant au total perfus */
#define pt_reg_temps 0xFE

#define pas_volume 605	/* Valeur du nombre de pas ncessaire pour 1 ml de produit. */

enum 
	{
	m_debit=0,
	m_reg_temps,
	m_max_perf,
	m_tot_perf,
	m_vit_mot,
	m_UP,		//mode micro pompe
	m_autori_ctrl_goutte,
	m_alarme_home,
	m_alarme_meca,
	m_alarme_noir
	} mode=m_debit;





// prototype de fonctions
void int_compare_ccpr2 (void);
void int_priorite_haute (void);
void it_timer1_dep(void);
void affiche_valeur(int valeur);
int dec_7segments(int dec);
void affiche_bargraf(int valeur);
void afficheur_mode(int valeur);
void affichage(void);
int lire_touche(int bouton);
void reglage_param(int valeur);
int conversion(char voie);
int valeur_pression(void);


/* debit exprim en diziaime de ml */					 
unsigned short long  cpt_multiple=1, multiple, multiple_sauve; //400 ml/h
unsigned short long demi_T, tim3, reste_div,diviseur;
// variables
char debit_tab[5]={"0000"}, max_perf_tab[5]={"0000"}, reg_temps_tab[5]={"0000"};
int tableau_bargraf[9]={0xFE,0xFD,0xFB,0xF7,0xEF,0xDF,0xBF,0x7F,0x00};
unsigned int index;
unsigned int compteur_affichage=1,tot_perf=0;
unsigned int compteur_calcul_1mn=0, compteur_calcul_500ms=0, cpt_point=0, pt_aff=1, en_alarme=0, passage=0;
char bargraf=0xFF, aff5=0xFF, aff4=0xFF,aff3=0xFF, aff2=0xFF,aff1=0xFF;
char start_stop=0,micro_pompe=0,calcul_fait=0,passage_hall=0, pression=p_25,duree_goutte=0, goutte=0;
int i,touche=0;
char home_prec=0, home=0, al_home=0;
unsigned short long debit=0,reg_temps=0,max_perf=0,temps_heure=0, temps_minute=0,debit_reel=0,compteur_demi_pas=0;


#pragma code interrupt_high=0x08
void interrupt_high(void)
{
_asm
	goto int_priorite_haute
_endasm
}
#pragma code


#pragma interrupt int_priorite_haute
void int_priorite_haute(void)
{


	if (PIR2bits.CCP2IF&&PIE2bits.CCP2IE)		// galit entre CCPR2 et TMR3
		{
			int_compare_ccpr2();		// appel programme d'interruption
			PIR2bits.CCP2IF=0;			// effacer le drapeau correspondant
		}
	if (PIR1bits.TMR1IF&&PIE1bits.TMR1IE)		// dpassement du compteur TIMER1
		{
			it_timer1_dep();		// appel programme d'interruption
			PIR1bits.TMR1IF=0;			// effacer le drapeau correspondant
		}
}




/*****************************************************************************************
	Interruption du timer 3 lors de son utilisation en comparaison avec CCPR2. Son role est
	d'inverser automatiquent la sortie P4.7, de recalculer la valeur  mettre dans le 
	registre de comparaison. Permet galement d'incrmenter les variables compteur de
	demi-priodes.
*****************************************************************************************/

void int_compare_ccpr2 (void)
{ 	
   			if (cpt_multiple>multiple)
				{
				cpt_multiple=1;
				SM_CLOCK = ~SM_CLOCK;	//inverser l'tat de la sortie SM_CLOCK
				if ((tim3+reste_div)>0xFFFF)              // Cas du depassement de capacit 
						tim3=reste_div-(0xFFFF-tim3);    // du registre CCPR2 
				else tim3=tim3+reste_div;
				CCPR2L=(tim3)&0xFF;           // initialisation de la valeur des poids faible de CCPR2 
				CCPR2H=(tim3&0xFF00)>>8; // Initialisation des poids fort de CCPR2 
				}
			else 
				{
			//	CCP2CONbits.CCP2M0=0;	// Mode sortie inchange
				cpt_multiple++;	// incrmenter le compteur de boucle
				CCPR2L=(tim3)&0xFF;           // initialisation de la valeur des poids faible de CCPR2 
				CCPR2H=(tim3&0xFF00)>>8; // Initialisation des poids fort de CCPR2 
				}
}		

/**********************************************************************************************
	interruption  chaque dpassement du TIMER1 passage de 0xFFFF  0 rfrence de 4,096 ms
**********************************************************************************************/
void it_timer1_dep (void) 
{ 
	TMR1H=0xFD;		// TMR1=0xFFFF - 0x0200
	TMR1L=0xFF;
	affichage();     // appeler la fonction affichage 
	compteur_affichage++;   //* Incrment du compteur d'affichage 
	if (compteur_affichage==7)    //* si environ 40ms sont coules, 
			compteur_affichage=1;  //* remmetre  0 le compteur d'affichage. 
//	++compteur_calcul_1mn;
//	++compteur_calcul_500ms;		

}


/**************************************************************************************
			PROGRAMME PRINCIPAL
**************************************************************************************/
void main(void)
{                  
	    ADCON1 = 0x06; 	// configuration des entres Analogiques et numriques
	TRISA  = 0x0F;  // PORTA en entre bits 0-3 et sortie bits 4-7
     TRISB  = 0x00;   // PORTB en sortie
	TRISD  = 0x01;   // PORTD en sortie sauf bit0

     VALID=0;

// config du timer3 TMR1
	TMR1H=0xFD;		// TMR1=0xFFFF - 0x0200
	TMR1L=0xFF;	
	T1CONbits.RD16=0;		// mode ecriture en 2 octets L et H
	T1CONbits.T1CKPS1 = 1;		// Prdiviseur= 1/8 priode de sortie de 8us
	T1CONbits.T1CKPS0 = 1;		//
	T1CONbits.T1OSCEN = 0;		// dsactiver l'oscillateur externe
	T1CONbits.T1SYNC = 1;		// Pas de synchro
	T1CONbits.TMR1CS = 0;		// Compte les impulsions sur l'horloge interne
	T1CONbits.TMR1ON = 1;		// active le compteur TMR1

//config du Timer1
	PIE1bits.TMR1IE=1;	// autorisation d'interruption  chaque dpassement du TIMER1
	IPR1bits.TMR1IP=1;	//active la priorit d'interruption 

	TRISEbits.TRISE2 =1;	//RE2 en sortie
	TRISCbits.TRISC1 =0;	//RC1 en sortie 	
 
//TM2CON=0x0D; /* timer 2 en compteur incrment par fosc/(12*8) */
// config du timer3 TMR3
	T3CONbits.RD16=0;		// mode ecriture en 2 octets L et H
	T3CONbits.T3CCP1 = 1;		//comparaison de CCPR2 avec le timer TMR3   Attention	"OK vrifi ce n'est pas une erreur"

	T3CONbits.T3CKPS1 = 1;		// Prdiviseur= 1/8 priode de sortie de 8us
	T3CONbits.T3CKPS0 = 1;
	T3CONbits.T3SYNC = 1;		// Pas de synchro
	T3CONbits.TMR3CS = 0;		// Compte les impulsions sur l'horloge interne
// 	T3CONbits.TMR3ON = 1;

//config de CCP2
CCP2CON=0x0A;	// interruption sur comparaison russie avec CCPR2; sortie CCP2/RC1 inchange
			
IPR2bits.CCP2IP=1;	//active la priorit d'interruption de CCP2 mode compare


INTCONbits.PEIE=1;
RCONbits.IPEN=1;	 // activation Gnrale de la priorit des interruptions priphrique
INTCONbits.GIE=1;	// activation des toutes les interruptions

//TMOD=TMOD|0x05;	/* Timer 0 en compteur 16 bits dclench par T0 (P4.3 = Hall). */

while(1)
{
 	if (start_stop==1)		// vaut 1 lors de l'appuie sur le bouton start stop
		{
			if (calcul_fait==0)
					{
					if (debit!=0)
						{
						SM_START_STOP=0;	// commande du Reset du Pal actif  l'tat 1
						
				//		debit_reel=debit;
		//				demi_T=tim3=duree_tour_ml/(pas_moteur*2*2*8*debit);
						diviseur=pas_moteur*2*2*8*debit;
						demi_T=tim3=(duree_tour_ml)/diviseur;
	
						multiple=multiple_sauve=demi_T/0xFFFF;		// nombre multiple de 0xFFFF
						reste_div=tim3=demi_T-(0xFFFF*multiple);	// rcupre le reste de la division par 0xFFFF
								CCPR2L=(reste_div)&0xFF;  // initialisation de la valeur des poids faible de CCPR2 
								CCPR2H=(reste_div&0xFF00)>>8;// Initialisation des poids fort de CCPR2 avec dcalage  droite
					//			CCP2CON=0x02;	// interruption sur comparaison russie avec CCPR2; sortie CCP2/RC1 basculant d'tat
							
			
	
 
						PIE2bits.CCP2IE=1;	// Autorisation d'interruption sur comparaison avec CCPR1.
						TMR3L=TMR3H=0;
						T3CONbits.TMR3ON=1;	// Dmarrage timer 3  
						calcul_fait=1;	// Indique le passage dans cette boucle. 
						}
					}
		}
	else 
		{
			SM_START_STOP=1;	// commande du Reset du Pal actif  l'tat 1
			PIE2bits.CCP2IE=0;	// Interdiction d'interruption sur comparaison avec CCPR1
			T3CONbits.TMR3ON = 0;	// Arrt du timer 3. 
			calcul_fait=0;		// Indique qu'il faut faire les calculs lorsque start/stop=1. 
		}                                                                                   
}
}




/**************************************************************************************************
	Fonction affichage permettant d'allumer la LED goutte pendant une dure d'environ 500ms.
	cette fonction est appelle par l'interruption du timer 1, c'est  dire toutes les 40ms environ.
	rafraichit les afficheurs selon le mode slectionn.
**************************************************************************************************/
void affichage(void)
{

affiche_valeur(debit); 

if (compteur_affichage==5)  // si 5ime afficheur 7 segments concern
	{
			PORTB=aff4=0xFF;
			Front_Montant;  //impulsion positive de CDE_AF
			
			PORTD =(PORTD&0x0F)|digit_mode;	// slection du mode 
			PORTB=aff5=pt_debit;
			Front_Montant;  //impulsion positive de CDE_AF 
	
		if (start_stop&&(pt_aff==5)&&(!en_alarme))
			{
				cpt_point++;
				PORTB=aff5=aff5&pt_start_stop;	// allumer le point dcimal
				Front_Montant;  //impulsion positive de CDE_AF
				if (cpt_point>10)
					{
						cpt_point=0;
						pt_aff=1;
					}
			}
		if ((touche==0)||(touche==5))
			{
			if (lire_touche(b_mode)==1)	// cas o la touche mode est appuye 
				{
						if (touche==0)	// incrmente le mode uniquement si premier appuie dtect
								{
								if (start_stop==1)		// le systme est en fonction
									{
									if (mode==m_vit_mot) mode=m_debit;  
									else mode=mode+1;
									}
								else
									{
									if (mode==m_autori_ctrl_goutte) mode=m_debit;
									else mode=mode+1;
									}
								touche=5;		// permet de ne pas  incrmente le mode  nouveau
								}
				} 
			else 
				if (touche==5) touche=0;  // cas ou la touche n'est pas appuye
			}
	}
	
	
if (compteur_affichage==6)
		{
			PORTB=aff5=0xFF;
			Front_Montant;  //impulsion positive de CDE_AF
			PORTD =(PORTD&0x0F)|digit_bargraf;
			PORTB=bargraf=0xFF;
			Front_Montant;  //impulsion positive de CDE_AF 
	    }

}



/*******************************************************************************************
	Cette fonction permet de commander les 4 premiers afficheurs et d'afficher la valeur 
	transmise par l'appel de la fonction.
*******************************************************************************************/
void affiche_valeur(int valeur)
{
	int m, c, d, u;
	if (valeur<9999)
		{
		m=valeur/1000;      /* Valeur du chiffre du millier */
		c=(valeur-(1000*m))/100;   /* Valeur du chiffre de la centaine */
		d=(valeur-(1000*m)-(100*c))/10; /* Valeur du chiffre de la dizaine */
		u=valeur-(1000*m)-(100*c)-(10*d);   /* Valeur du chiffre de l'unit */
		}
	else 
	if (valeur==10000) { m=99; c=11; d=12; u=99; }		// code message des afficheurs 7 seg cf fonction "dec_7segments(int dec)"
	else 	if (valeur==10001) { m=99; c=13; d=14; u=99; }
			if (valeur==10002) { m=99; c=13; d=15; u=99; }
			else 	if (valeur==10003) { m=99; c=99; d=99; u=99; }
					else if (valeur==10004) {m=16; c=14; d=17; u=18; }
if (compteur_affichage==1) 
	{
		PORTB=bargraf=0xFF;
        Front_Montant;  //impulsion positive de CDE_AF
		PORTD =(PORTD&0x0F)| digit_1000;	//slection digit_1000
		if ((mode==m_vit_mot)||(mode==m_reg_temps)||(mode>m_UP))
			{
				m=dec_7segments(m);
				if (start_stop&&(pt_aff==1)&&(!en_alarme))
					{
						cpt_point++;
						m=m&pt_start_stop;
						if (cpt_point>10)
							{
								cpt_point=0;
								pt_aff=2;
							}
					}
				PORTB=aff1=m; /* Affichage des chiffres des milliers*/
	        	Front_Montant;  //impulsion positive de CDE_AF
			}
		else 
			{
			if (start_stop&&(pt_aff==1)&&(!en_alarme))
				{
					++cpt_point;
					PORTB=aff1=0xFF&pt_start_stop;	//effacer l'afficheur des 1000 et allumer le point
					Front_Montant;  //impulsion positive de CDE_AF
					if (cpt_point>10)
						{
							cpt_point=0;
							pt_aff=2;
						}
				}
			else 
				{
					PORTB=aff1=0xFF;
			        Front_Montant;  //impulsion positive de CDE_AF
				}
			}	
			if ((touche==0)||(touche==1))
				{
					if (start_stop==1)		// si pompe en Marche
					{
						if (lire_touche(b_start_stop)==1)
						{
							if (touche==0)
								{ 
									start_stop=0;  /* Arrt pompe si touche start/stop appuye. */
									touche=1;
								}
						}
						else 
							if (touche==1) touche=0;
					}
					else		// si pompe  l'arret
					{
						if (lire_touche(b_start_stop)==1)
							{
							if (touche==0)
								{
									start_stop=1;
									touche=1;
								}
							}
						else 
							if (touche==1) touche=0;
					}
				}
	}
if (compteur_affichage==2) 
	{
		PORTB=aff1=0xFF;		// etteindre l'afficheur1 des 1000
		Front_Montant;  //impulsion positive de CDE_AF
		PORTD=(PORTD&0x0F)|digit_100;
		c=dec_7segments(c);
		if (start_stop&&(pt_aff==2)&&(!en_alarme))
			{
				++cpt_point;
				c=c&pt_start_stop;
				if (cpt_point>10)
					{
						cpt_point=0;
						pt_aff=3;
					}
			}
		PORTB=aff2=c;
        Front_Montant;  //impulsion positive de CDE_AF
		if ((touche==0)||(touche==2))
			{
			if (start_stop==0)
				{
					if (lire_touche(b_cent)==1)
						{ 
						if (touche==0)
							{
							reglage_param(1);	/* cas o la touche 100 est appuye */
							touche=2;
							}
						}
					else if (touche==2) touche=0;
				}
			}
	}
if (compteur_affichage==3) 
	{
		PORTB=aff2=0xFF;
        Front_Montant;  //impulsion positive de CDE_AF		
		PORTD=(PORTD&0x0F)|digit_10;
		d=dec_7segments(d);
		if (start_stop&&(pt_aff==3)&&(!en_alarme))
			{
				++cpt_point;
				d=d&pt_start_stop;
				if (cpt_point>10)
					{
					cpt_point=0;
					pt_aff=4;
					}
			}
		PORTB=aff3=d;
        Front_Montant;  //impulsion positive de CDE_AF		
		if ((touche==0)||(touche==3))
			{
			if (start_stop==0)
				{
				if (lire_touche(b_dix)==1) 
					{
					if (touche==0)
						{
						reglage_param(2);	/* cas o la touche 10 est appuye */
						touche=3;
						}
					}
				else if (touche==3) touche=0;
				}
			}
	}
if (compteur_affichage==4) 
	{
		PORTB=aff3=0xFF;
        Front_Montant;  //impulsion positive de CDE_AF		
		PORTD=(PORTD&0x0F)|digit_1;
		u=dec_7segments(u);
		if (start_stop&&(pt_aff==4)&&(!en_alarme))
			{
				++cpt_point;
				u=u&pt_start_stop;
				if (cpt_point>10)
					{
						cpt_point=0;
						pt_aff=5;
					}
			}
		PORTB=aff4=u;
        Front_Montant;  //impulsion positive de CDE_AF		
		if ((touche==0)||(touche==4))
			{
			if (start_stop==0)
				{
				if (lire_touche(b_un)==1) 
					{
					if (touche==0)
						{
						reglage_param(3);	/* cas o la touche 1 est appuye */
						touche=4;
						}
					}
				else if (touche==4) touche=0;
				}
			}
	}
}

/**************************************************************************************************
	Cette fonction permet de modifier la valeur de la centaine ou de la dizaine ou de l'unit 
	du paramtre 'dbit' ou du paramtres 'max  perfuser'.
	remarque:
			atol : convertie un chaine de caractres (compose de chiffres) en la valeur numrique
					(de type long) correspondante.
***************************************************************************************************/  
void reglage_param(int valeur)
{
if (mode==m_debit)        // cas du rglage du dbit 
	{
		  //cas du mode standard : autorisation rglage de 0  600 du dbit
				
				if (valeur==1)         /* cas du rglage de la centaine */
					{
						if (debit_tab[1]!='6')	debit_tab[1]=debit_tab[1]+1;
							else 	debit_tab[1]='0';
						if (debit_tab[1]=='6') // fixe le dbit max  600 ml/h
							{
								debit_tab[2]='0';
								debit_tab[3]='0';
							}
					}
				else                           /* cas du rglage de la dizaine ou de l'unit */
					{
						
						if (debit_tab[valeur]=='9')
									debit_tab[valeur]='0';
						else debit_tab[valeur]=debit_tab[valeur]+1;
						if (debit_tab[1]=='6')  debit_tab[2]=debit_tab[3]='0';
					}
				
			debit=atol(debit_tab);  
	}

if (mode==m_max_perf)           /* cas du rglage du maximum  perfuser */
	{
		if (max_perf_tab[valeur]=='9')	max_perf_tab[valeur]='0';
			else max_perf_tab[valeur]=max_perf_tab[valeur]+1;
		max_perf=atol(max_perf_tab);
	}
		
if (mode==m_reg_temps)           /* cas du rglage du maximum  perfuser */
	{
		if (valeur==2)         /* cas du rglage de la centaine */
			{
				if (reg_temps_tab[2]!='5')	reg_temps_tab[2]=reg_temps_tab[2]+1;
				else 	reg_temps_tab[2]='0';
			}
		else
			{
				if (reg_temps_tab[valeur]=='9')	reg_temps_tab[valeur]='0';
				else reg_temps_tab[valeur]=reg_temps_tab[valeur]+1;
			}
		reg_temps=atol(reg_temps_tab);
	}
}



/*****************************************************************************************************
	fonction permettant de lire si la touche spcifi par le paramtre transmis est actionne ou non.
******************************************************************************************************/
int lire_touche(int bouton)
{
	int i;

	PORTD=(PORTD&0x0F)|bouton;       // Choix de la touche  lire
	for (i=1; i<20; i++) { }
	if (KEY==0)		// appuie sur le bouton slectionn
			return 0;
	 else  return 1;

}



/******************************************************************************************
	Cette fonction permet le dcodage decimal en 7 segments.
******************************************************************************************/
	int dec_7segments(int dec)
		{
		switch (dec)
			{
			case 0: 	return (0x88); break;
			case 1: 	return (0xEB); break;
			case 2: 	return (0x4C); break;
			case 3: 	return (0x49); break;
			case 4: 	return (0x2B); break;
			case 5: 	return (0x19); break;
			case 6: 	return (0x38); break;
			case 7: 	return (0xCB); break;
			case 8: 	return (0x08); break;
			case 9: 	return (0x09); break;
			case 10:	return (0xF7); break;   /* Virgule */
			case 11: return (0x2E); break;   /* Lettre U */
			case 12: return (0x06); break; 	/* Lettre P */
			case 13: return (0x2A); break; 	/* Lettre H */
			case 14: return (0x78); break; 	/* Lettre o */
			case 15: return (0x0A); break; 	/* Lettre A */
			case 16: return (0x09); break; 	/* Lettre g */
			case 17: return (0xF8); break; 	/* Lettre u */
			case 18: return (0x3C); break; 	/* Lettre t */
			case 19: return (0xFB); break; 	/* Lettre 1 minuscule */
			case 99: return (0xFF); break; 	/* Afficheur teint   */
			}
		}








