/********************************************************************
 FileName:		user.c
 Dependencies:	See INCLUDES section
 Processor:		PIC18 or PIC24 USB Microcontrollers
 Hardware:		The code is natively intended to be used on the following
 				hardware platforms: PICDEM FS USB Demo Board, 
 				PIC18F87J50 FS USB Plug-In Module, or
 				Explorer 16 + PIC24 USB PIM.  The firmware may be
 				modified for use on other USB platforms by editing the
 				HardwareProfile.h file.
 Complier:  	Microchip C18 (for PIC18) or C30 (for PIC24)
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement

 The software supplied herewith by Microchip Technology Incorporated
 (the Company) for its PIC Microcontroller is intended and
 supplied to you, the Companys customer, for use solely and
 exclusively on Microchip PIC Microcontroller products. The
 software is owned by the Company and/or its supplier, and is
 protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.

********************************************************************
 File Description:

 Change History:
  Rev   Date         Description
  1.0   11/19/2004   Initial release
  2.1   02/26/2007   Updated for simplicity and to use common
                     coding style
********************************************************************/

/** INCLUDES *******************************************************/

#include "Compiler.h"
#include "GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "usb_config.h"
#include "usb_device.h"
#include "usb.h"
#include "usb_function_generic.h"

#include "user.h"		// Modifiable. Contient les prototypes des fonctions

/** V A R I A B L E S ********************************************************/
#pragma udata
BYTE counter;
//BYTE trf_state;
//BYTE temp_mode;

#pragma udata USB_VARS
DATA_PACKET INPacket;
DATA_PACKET OUTPacket;
#pragma udata

//BYTE pTemp;                     // Pointer to current logging position, will
                                // loop to zero once the max index is reached
//BYTE valid_temp;                // Keeps count of the valid data points
//WORD temp_data[30];             // 30 points of data

USB_HANDLE USBGenericOutHandle = 0;
USB_HANDLE USBGenericInHandle = 0;

// Timer0 - 1 second interval setup.
// Fosc/4 = 12MHz
// Use /256 prescalar, this brings counter freq down to 46,875 Hz
// Timer0 should = 65536 - 46875 = 18661 or 0x48E5
#define TIMER0L_VAL         0xE5
#define TIMER0H_VAL         0x48

/** P R I V A T E  P R O T O T Y P E S ***************************************/
// Tous ces prototypes et fonctions peuvent etre supprimes, ci-dessous sont utilises uniquement pour
// les demoboard de chez Microchip.
			
		
void ServiceRequests(void);

/** D E C L A R A T I O N S **************************************************/
#pragma code
void UserInit(void)			// Ici on place les initialisations de depart du PIC (registres, ports, fonctions)
{

}//end UserInit


/******************************************************************************
 * Function:        void ProcessIO(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This function is a place holder for other user routines.
 *                  It is a mixture of both USB and non-USB tasks.
 *
 *				C'est cette fonction qui est appellee dans la boucle principle (while(1))
 *				Au lieu de modifier celle ci il suffit de mettre son code dans la fonction
 *				ProcessIO. 
 * 				Le code ci-dessous fait partie du demoboard de Microchip qui releve la temperature 
 *				toutes les 1 seconde et l'envoi au PC 
 *
 * Note:            None
 *****************************************************************************/
void ProcessIO(void)
{   

}//end ProcessIO

/******************************************************************************
 * Function:        void ServiceRequests(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    USB traffic can be generated
 *
 * Overview:        This function takes in the commands from the PC from the
 *                  application and executes the commands requested
 *
 * Note:            None
 *****************************************************************************/
void ServiceRequests(void)
{
    BYTE index;
    
    //Check to see if data has arrived
    if(!USBHandleBusy(USBGenericOutHandle))
    {        
        //if the handle is no longer busy then the last
        //transmission is complete
       
        counter = 0;

        INPacket.CMD=OUTPacket.CMD;
        INPacket.len=OUTPacket.len;

        //process the command
        switch(OUTPacket.CMD)
        {
            case READ_VERSION:
                //dataPacket._byte[1] is len
                INPacket._byte[2] = MINOR_VERSION;
                INPacket._byte[3] = MAJOR_VERSION;
                counter=0x04;
                break;

            case ID_BOARD:
                counter = 0x01;
                if(OUTPacket.ID == 0)
                {
                //    mLED_3_Off();mLED_4_Off();
                }
                else if(OUTPacket.ID == 1)
                {
                //    mLED_3_Off();mLED_4_On();
                }
                else if(OUTPacket.ID == 2)
                {
                 //   mLED_3_On();mLED_4_Off();
                }
                else if(OUTPacket.ID == 3)
                {
                  //  mLED_3_On();mLED_4_On();
                }
                else
                    counter = 0x00;
                break;

            case UPDATE_LED:
                // LED1 & LED2 are used as USB event indicators.
                if(OUTPacket.led_num == 3)
                {
                    //mLED_3 = OUTPacket.led_status;
                    counter = 0x01;
                }//end if
                else if(OUTPacket.led_num == 4)
                {
                    //mLED_4 = OUTPacket.led_status;
                    counter = 0x01;
                }//end if else
                break;
                
            case SET_TEMP_REAL:
              //  temp_mode = TEMP_REAL_TIME;
               // ResetTempLog();
                counter = 0x01;
                break;

            case RD_TEMP:
                
                   // INPacket._byte[1] = temperature.v[0];
                    //INPacket._byte[2] = temperature.v[1];
                    counter=0x03;

                break;

            case SET_TEMP_LOGGING:
              //  temp_mode = TEMP_LOGGING;
              //  ResetTempLog();
                counter=0x01;
                break;

            case RD_TEMP_LOGGING:
               // counter = (valid_temp<<1)+2;  // Update count in byte
               // INPacket.len = (valid_temp<<1);

              
                
            //    ResetTempLog();             // Once read, log will restart
                break;

            case RD_POT:
                {
                    WORD_VAL w;

                    INPacket._byte[1] = w.v[0];
                    INPacket._byte[2] = w.v[1];

                    counter=0x03;
                }
                break;
                
            case RESET:
                Reset();
                break;
                
            default:
                Nop();
                break;
        }//end switch()
        if(counter != 0)
        {
            if(!USBHandleBusy(USBGenericInHandle))
            {
                USBGenericInHandle = USBGenWrite(USBGEN_EP_NUM,(BYTE*)&INPacket,counter);
            }
        }//end if
        
        //Re-arm the OUT endpoint for the next packet
        USBGenericOutHandle = USBGenRead(USBGEN_EP_NUM,(BYTE*)&OUTPacket,USBGEN_EP_SIZE);
    }//end if

}//end ServiceRequests


/******************************************************************************
 * Function:        void TXbyte(BYTE data)
 *
 * PreCondition:    None
 *
 * Input:           BYTE data - send data to the UART(PIC18 only)
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        sends 'data' over the UART
 *
 * Note:            None
 *****************************************************************************/
void TXbyte(BYTE data)
{
    #if defined(__18CXX)
    while(TXSTAbits.TRMT==0);
    TXREG = data;
    #endif
}//end TXbyte

/** EOF user.c ***************************************************************/
