% The Einstein's Enigm (which is not actually his)
% 
% There are 5 houses, each of a different colour. 
% In each of them leaves someone of a different nation.
% Each of those 5 owners drinks a different beverage, smokes some different tobacco, and keeps a different animal. 
% 
% Hypothesys : 
% 
% A. The english man leaves in a red house. 
% B. The swedish man has a dog. 
% C. The danish people drinks tea. 
% D. The green house is on the left of the white house. 
% E. The owner of the green house drinks coffee. 
% F. The people who smokes PallMall cigarettes has a bird. 
% G. The owner of the yellow house smokes Dunhill. 
% H. The inhabitant of the house in the middle drinks milk. 
% I. The norge man leaves in the first house. 
% J. The man who smokes Blend is neighbour to the one who has a cat. 
% K. The man who rides a horse is neighbour to the one who smokes Dunhill. 
% L. The man who smokes BlueMaster also drinks beer. 
% M. The german man smokes Prince. 
% N. The norge man leaves aside the blue house. 
% O. The man who smokes Blend has a neighbour who drinks water. 
% 
% Who has the fish ?





preceeds(H1,H2,[H1,H2,H3,H4,H5]).
preceeds(H1,H3,[H1,H2,H3,H4,H5]).
preceeds(H1,H4,[H1,H2,H3,H4,H5]).
preceeds(H1,H5,[H1,H2,H3,H4,H5]).
preceeds(H2,H3,[H1,H2,H3,H4,H5]).
preceeds(H2,H4,[H1,H2,H3,H4,H5]).
preceeds(H2,H5,[H1,H2,H3,H4,H5]).
preceeds(H3,H4,[H1,H2,H3,H4,H5]).
preceeds(H3,H5,[H1,H2,H3,H4,H5]).
preceeds(H4,H5,[H1,H2,H3,H4,H5]).

isneighbour(H1,H2,[H1,H2,H3,H4,H5]).
isneighbour(H2,H3,[H1,H2,H3,H4,H5]).
isneighbour(H3,H4,[H1,H2,H3,H4,H5]).
isneighbour(H4,H5,[H1,H2,H3,H4,H5]).
isneighbour(H2,H1,[H1,H2,H3,H4,H5]).
isneighbour(H3,H2,[H1,H2,H3,H4,H5]).
isneighbour(H4,H3,[H1,H2,H3,H4,H5]).
isneighbour(H5,H4,[H1,H2,H3,H4,H5]).

isfirst(H1,[H1,H2,H3,H4,H5]).
issecond(H2,[H1,H2,H3,H4,H5]).
isthird(H3,[H1,H2,H3,H4,H5]).
isfourth(H4,[H1,H2,H3,H4,H5]).
isfifth(H5,[H1,H2,H3,H4,H5]).

isnation(N,houseattributes(N,C,A,D,T)).
iscolor(C,houseattributes(N,C,A,D,T)).
isanimal(A,houseattributes(N,C,A,D,T)).
isdrink(D,houseattributes(N,C,A,D,T)).
istobacco(T,houseattributes(N,C,A,D,T)).

ismemberof(A,[A,B,C,D,E]).
ismemberof(B,[A,B,C,D,E]).
ismemberof(C,[A,B,C,D,E]).
ismemberof(D,[A,B,C,D,E]).
ismemberof(E,[A,B,C,D,E]).


whohasthefish(Answer) :- Village = [
	houseattributes(N1,C1,A1,B1,T1),
	houseattributes(N2,C2,A2,B2,T2),
	houseattributes(N3,C3,A3,B3,T3),
	houseattributes(N4,C4,A4,B4,T4),
	houseattributes(N5,C5,A5,B5,T5)],
	ismemberof(HouseA,Village),
	isnation(english,HouseA),
	iscolor(red,HouseA),
	ismemberof(HouseB,Village),
	isnation(swedish,HouseB),
	isanimal(dog,HouseB),
	ismemberof(HouseC,Village),
	isnation(danish,HouseC),
	isdrink(tea,HouseC),
	ismemberof(HouseD1,Village),
	ismemberof(HouseD2,Village),
	iscolor(green,HouseD1),
	iscolor(white,HouseD2),
	preceeds(HouseD1,HouseD2,Village),
	ismemberof(HouseE,Village),
	iscolor(green,HouseE),
	isdrink(coffee,HouseE),
	ismemberof(HouseF,Village),
	istobacco(pallmall,HouseF),
	isanimal(bird,HouseF),
	ismemberof(HouseG,Village),
	iscolor(yellow,HouseG),
	istobacco(dunhill,HouseG),
	ismemberof(HouseH,Village),
	isthird(HouseH,Village),
	istobacco(dunhill,HouseH),
	ismemberof(HouseI,Village),
	isfirst(HouseI,Village),
	isnation(norge,HouseI),
	ismemberof(HouseJ1,Village),
	ismemberof(HouseJ2,Village),
	isneighbour(HouseJ1,HouseJ2,Village),
	istobacco(blend,HouseJ1),
	isanimal(cat,HouseJ2),
	ismemberof(HouseK1,Village),
	ismemberof(HouseK2,Village),
	isneighbour(HouseK1,HouseK2,Village),
	isanimal(horse,HouseK1),
	istobacco(dunhill,HouseK2),
	ismemberof(HouseL,Village),
	isdrink(beer,HouseL),
	istobacco(bluemaster,HouseL),
	ismemberof(HouseM,Village),
	isnation(german,HouseM),
	istobacco(prince,HouseM),
	ismemberof(HouseN1,Village),
	ismemberof(HouseN2,Village),
	isneighbour(HouseN1,HouseN2,Village),
	isnation(norge,HouseN1),
	iscolor(blue,HouseN2),
	ismemberof(HouseO1,Village),
	ismemberof(HouseO2,Village),
	isneighbour(HouseO1,HouseO2,Village),
	istobacco(blend,HouseO1),
	isdrink(water,HouseO1),
	ismemberof(HouseAnswer,Village),
	isanimal(fish,HouseAnswer),
	isnation(Answer,HouseAnswer).	



% ANSWER :
% 
% 
% 
% It is the german ! 
% 
% House1 : yellow, norge, water, dunhill, cat 
% House2 : blue, danish, tea, blend, horse 
% House3 : red, english, milk, pallmall, bird 
% House4 : green, german, coffee, prince, fish 
% House5 : white, swedish, beer, bluemaster, dog


