 ;*****************************************************************************
;   Ce fichier est la base de dpart pour une programmation avec             *
;   le PIC 16F88. Il contient  les informations de  base pour                *
;   dmarrer.                                                                *  
;   ecrit grace  Bigonoff par gilles.chevalerias@free.fr                    *
;*****************************************************************************
;                                                                            *
;    NOM:  TESTSON                                                           *
;    Date: 17/10/2007                                                        *
;    Version: 01                                                             *
;    Circuit: TESTPIC                                                        *
;    Auteur:  Chevalerias gilles                                             *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P16F88.inc                                              *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Notes:                                                                  *
;     Reproduire un son  partir d'un fichier wave                           *
;      avec le logiciel de www.RomanBlack.com                                *
;                                                                            *
;                                                                            *
;*****************************************************************************

	ERRORLEVEL -302			; suppression du message bank select 
	LIST      P=PIC16F88            ; Dfinition de processeur
	#include <p16F88.inc>           ; fichier include

	__CONFIG _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Choisir une valeur par groupe.
; Voici les valeurs et leurs dfinitions :

; Protection du programme
; -----------------------
;_CP_ALL		protection totale
;_CP_OFF		Pas de protection

;Selection de la pine pour CCP1
; -----------------------------
;_CCP1_RB0		CCP1 sur RB0	     
;_CCP1_RB3             	CCP1 sur RB3

; Debuggage
; ---------
;_DEBUG_ON		RB6 et RB7 utilises pour debugger
;_DEBUG_OFF		RB6 et RB7 en utilisation normale

; Accs  la flash programme
; --------------------------
;_WRT_PROTECT_OFF	Le programme peut crire dans toute la flash
;_WRT_PROTECT_256	Le programme ne peut pas crire dans la flash dans les 256 premier octets
;_WRT_PROTECT_2048	Le programme ne peut pas crire dans la flash dans les 2048 premier octets
;_WRT_PROTECT_ALL	Le programme ne peut pas crire dans la flash

; Protection de l'EEprom
; -----------------------
;_CPD_ON		Mmoire EEprom protge
;_CPD_OFF               Mmoire EEprom dprotge

; Programmation sur circuit
; -------------------------
;_LVP_ON		RB3 permet la programmation srie de la PIC
;_LVP_OFF		RB3 en utilisation normale

; Reset de la PIC si tension <4V
; ------------------------------
; _BODEN_ON		Reset tension en service
;			Valide PWRTE_ON automatiquement
; _BODEN_OFF		Reset tension hors service

;Utilisation de la pin MCLR
; -------------------------
;_MCLR_ON		RA5/MCLR est utilise pour le reset
;_MCLR_OFF		RA5/MCLR est utilise comme une entree/sortie

; Retard  la mise sous tension
; -----------------------------
;_PWRTE_OFF		Dmarrage rapide
;_PWRTE_ON		Dmarrage temporis

; Watchdog
; --------
;_WDT_ON		Watchdog en service
;_WDT_OFF		Watchdog hors service (on peut activer le watchdog dans le programme)

; Oscillateur
; -----------
;_EXTRC_CLKOUT	 	(RC) RC externe sur RA7 avec Fosc/4 sur RA6	    
;_EXTRC_IO		(RCIO) RC ecterne sur RA7 avec RA6 en I/O	    
;_INTRC_CLKOUT   	(INTIO1) oscillateur interne avec Fosc/4 sur RA6 et I/O sur RA7            
;_INTRC_IO		(INTIO2) oscillateur interne avec RA6 et RA7 en I/O	    
;_EXTCLK		(ECIO) oscillateur externe sue RA7 avec RA6 en I/O	        
;_LP_OSC 		Oscillateur basse vitesse (?<F<200Khz)        
;_XT_OSC                Oscilateur moyenne vitesse (0,1MHz<F<4Mhz)     
;_HS_OSC 		Oscillateur haute vitesse (4Mhz<F<20Mhz)

;-------------------------------------------------------------------------------
	__CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF

; IESO: Internal External Switch Over bit
;----------------------------------------
;_IESO_ON                    
;_IESO_OFF

; FCMEN: Fail-Safe Clock Monitor Enable bit
;------------------------------------------                    
;_FCMEN_ON                   
;_FCMEN_OFF                   

;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'10000000'
			; RBPU      b7 : 1= Rsistance rappel +5V hors service
			; INTEDG    b6 : 1= Interrupt sur front montant de RB0
			;                0= Interrupt sur front descendant de RB0
			; TOCS      b5 : 1= source clock = transition sur RA4
			;                0= horloge interne
			; TOSE      b4 : 1= Slection front descendant RA4(si B5=1)
			;                0= Slection front montant RA4
			; PSA       b3 : 1= Assignation prdiviseur sur Watchdog
			;                0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   b2/b0 valeur du prdiviseur
                        ;           000 =  1/1 (watchdog) ou 1/2 (tmr0)
			;           001 =  1/2               1/4
			;           010 =  1/4		     1/8
			;           011 =  1/8		     1/16
			;           100 =  1/16		     1/32
			;           101 =  1/32		     1/64
			;           110 =  1/64		     1/128
			;           111 =  1/128	     1/256


; REGISTRE INTCON (contrle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'00000000'
			; GIE       b7 : masque autorisation gnrale interrupt
                        ;                ne pas mettre ce bit  1 ici
                        ;                sera mis en temps utile
			; PEIE      b6 : masque autorisation gnrale priphriques
			; TMR0IE    b5 : masque interruption tmr0
			; INTE      b4 : masque interuption RB0/Int
			; RBIE      b3 : masque interruption RB4/RB7
			; TMR0IF    b2 : flag tmr0
			; INTF      b1 : flag RB0/Int
			; RBIF      b0 : flag interruption RB4/RB7

; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'
			; RESERVED  b7 : rserv, laisser  0 
			; ADIE      b6 : masque interrupt convertisseur A/D
			; RCIE      b5 : masque interrupt rception USART
			; TXIE      b4 : masque interrupt transmission USART
			; SSPIE     b3 : masque interrupt port srie synchrone
			; CCP1IE    b2 : masque interrupt CCP1
			; TMR2IE    b1 : masque interrupt TMR2 = PR2
			; TMR1IE    b0 : masque interrupt dbordement tmr1

; REGISTRE PIE2 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE2VAL		EQU	B'00000000'
			; OSFIE     b7 : masque de detection de defaut de l'oscillateur
			; CMIE      B6 : masque interrupt comparateur	
			; RESERVED  b5 : rserv, laisser  0
			; EEIE      b4 : masque interrupt criture EEPROM
			; RESERVED  b3 : rserv, laisser  0
			; RESERVED  b2 : rserv, laisser  0
			; RESERVED  b1 : rserv, laisser  0
			; RESERVED  b0 : rserv, laisser  0

; REGISTRE OSCCON (contrle de la vitesse de l'oscillateur interne)
; -----------------------------------------------------------------
OSCCONVAL	EQU	B'01110010'	; exemple 8 MHz
			; RESERVED  b7 : rserv, laisser  0
			; IRCF<2:0>  b6-4 : selection de la vitesse oscillateur inerne
				; 000 = 31.25 kHz
				; 001 = 125 kHz
				; 010 = 250 kHz
				; 011 = 500 kHz
				; 100 = 1 MHz
				; 101 = 2 MHz
				; 110 = 4 MHz
				; 111 = 8 MHz
			; OSTS     b3 : status de l'oscillateur en cours
			; IOFS	   b2 : flag de stabilisation de l'oscillateur pour un changement
					;de frequence en cours de programme  partir de 31.25KHz
			; SCS<1:0> b1-0 : selection du mode de l'oscillateur
				; 00 = le mode d'oscillateur est defini par FOSC<2:0> (LP, XT, HS, RC, EC) 
				; 01 = oscillateur secondaire sur RB6, RB7
				; 10 = l'oscillateur interne est utilis pour l'horloge (2 modes INTRC)
				; 11 = Reserved
; Pour utiliser l'oscillateur interne, on selectionne un des modes INTRC dans CONFIG1 
; on selectionne 10 pour les bits SCS<1:0> de OSCCON et la vitesse desir par les bits IRCF<2:0> de OSCCON

; REGISTRE ANSEL (contrle du convertisseur A/D)
; ----------------------------------------------
ANSELVAL	EQU	B'00000000'
			; RESERVED  b7 : rserv, laisser  0
			; ANS6	    b6 : 1=AN6/RB7 analogique, 0=AN6/RB7 digital
			; ANS5	    b5 : 1=AN5/RB6 analogique, 0=AN5/RB6 digital
			; ANS4	    b4 : 1=AN4/RA4 analogique, 0=AN4/RA4 digital
			; ANS3	    b3 : 1=AN3/RA3 analogique, 0=AN3/RA3 digital
			; ANS2	    b2 : 1=AN2/RA2 analogique, 0=AN2/RA2 digital
			; ANS1	    b1 : 1=AN1/RA1 analogique, 0=AN1/RA1 digital
			; ANS0	    b0 : 1=AN0/RA0 analogique, 0=AN0/RA0 digital


; REGISTRE CMCON (COMPARATEURS)
; -----------------------------
CMCONVAL	EQU	B'00000111' 
			; C2OUT	    b7 :sortie comparateur2
			; C1OUT     b6 :sortie comparateur1
			; C2INV     b5 :inverseur comparateur2
			; C1INV     b4 :inverseur comparateur1
			; CIS       b3 :selection entree des comparateurs
			; CM2-CM0   b2-0 :mode des comparateurs
			;configurer le mode 111 pour utiliser RA0 RA1 RA2 RA3 en I/O

; REGISTRE CVRCON (voltage reference module)
; ------------------------------------
CVRCONVAL	EQU	B'00000000'
			; CVREN      b7 :Validation du module
			; CVROE      b6 :Sortie sur RA2
			; CVRR       b5 :Choix de la plage 
			; RESERVED   b4 : rserv, laisser  0
			; CVR3-CVR0  b3-0 :Choix de la valeur dans la plage 
					; si CVRR=1 Vref=(CVR[3:0]/24)*Vdd
					; si CVRR=0 Vref=Vdd/4+(CVR[3:0]/32)*Vdd

; REGISTRE WDTCON (prediviseur et activation du watchdog)
; -------------------------------------------------------
; la valeur propose n'est pas charge pendant l'init,  vous de le faire si vous en avez besoin
;WDTCONVAL	EQU	B'00010110'	; par exemple debordement tout les (2,07 secondes*postdiviseur), on peut aller jusqu' 268 secondes 
			; RESERVED   b7-5 : rserv, laisser  0
			; WDTPS<3-0> b4-1 : prediviseur du watchdog qui oscille  31.25 kHz (32S)
			 	; 0000 = 1:32
				; 0001 = 1:64
				; 0010 = 1:128
				; 0011 = 1:256
				; 0100 = 1:512
				; 0101 = 1:1024
				; 0110 = 1:2048
				; 0111 = 1:4096
				; 1000 = 1:8192
				; 1001 = 1:16394
				; 1010 = 1:32768
				; 1011 = 1:65536
			; SWDTEN     b0  :  1 ce bit met en route le watchdog
					 ; si ce n'est dja fait dans le CONFIG1

; DIRECTION DES PORTS I/O
; -----------------------

DIRPORTA	EQU	B'11110000'	; Direction PORTA (1=entre)
DIRPORTB	EQU	B'11110110'	; Direction PORTB


;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; exemple
; -------
;MASQUE		EQU	H'00FF'


;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************

; exemple
; -------
#DEFINE LED1	PORTB,3			; LED de sortie 3
#DEFINE BP1	PORTB,4			; BP1
#DEFINE BP2	PORTB,5			; BP2
#DEFINE BP3	PORTB,5			; BP3
#DEFINE OUT1	PORTB,0			; sortie pour le module

;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

			; Changement de banques
			; ----------------------

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
		bcf	STATUS,RP1
	endm

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
		bcf	STATUS,RP1
	endm

BANK2	macro				; passer en banque2
		bcf	STATUS,RP0
		bsf	STATUS,RP1
	endm

BANK3	macro				; passer en banque3
		bsf	STATUS,RP0
		bsf	STATUS,RP1
	endm

			; Sous-routines inter-pages
			; -------------------------

CALLX	macro	ADRESSE			; call inter-page
	local BIT4 = (ADRESSE & 0x1000)	; voir bit 12
	local BIT3 = (ADRESSE & 0x0800) ; voir bit 11
	local	ICI			; adresse courante
ICI
	local PICI = (ICI+2 & 0x1800)	; page du saut
	IF BIT3				; si page 1 ou 3
	bsf	PCLATH , 3		; b3 de PCLATH = 1
	ELSE				; sinon
	bcf	PCLATH , 3		; b3 de PCLATH = 0
	ENDIF
	IF BIT4				; si page 2 ou 3
	bsf	PCLATH , 4		; b4 de PCLATH = 1
	ELSE				; sinon
	bcf	PCLATH , 4		; b4 de PCLATH = 0
	ENDIF
	call (ADRESSE & 0x7FF | PICI)	; adresse simule
	local BIT4 = ((ICI+5) & 0x1000)	; voir bit 12
	local BIT3 = ((ICI+5) & 0x0800)	; voir bit 11
	IF BIT3				; si page 1 ou 3
	bsf	PCLATH , 3		; b3 de PCLATH = 1
	ELSE				; sinon
	bcf	PCLATH , 3		; b3 de PCLATH = 0
	ENDIF
	IF BIT4				; si page 2 ou 3
	bsf	PCLATH , 4		; b4 de PCLATH = 1
	ELSE				; sinon
	bcf	PCLATH , 4		; b4 de PCLATH = 0
	ENDIF
	endm


;*****************************************************************************
;                      VARIABLES ZONE COMMUNE                                *
;*****************************************************************************

; Zone de 16 bytes
; ----------------

	CBLOCK 0x70			; Dbut de la zone (0x70  0x7F)
	w_temp : 1			; Sauvegarde registre W
	status_temp : 1			; sauvegarde registre STATUS
	FSR_temp : 1			; sauvegarde FSR (si indirect en interrupt)
	PCLATH_temp : 1			; sauvegarde PCLATH (si prog>2K)
	CMPT1 : 1   			; 2 variable pour les compteurs
	CMPT2 : 1
	VAR1 : 1				; variable pour traitement des bits
	PDel0 : 1				; variable tempo

	ENDC

;*****************************************************************************
;                        VARIABLES BANQUE 0                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0x20			; Dbut de la zone (0x20  0x6F)

	ENDC				; Fin de la zone

;Exemples
;--------
	;test :1			; Zone de 1 byte
	;table : 10			; zone de 10 bytes                        
;var1 		EQU 	H'006E'		; adresse impose


;*****************************************************************************
;                        VARIABLES BANQUE 1                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0xA0			; Dbut de la zone (0xA0  0xEF)

	ENDC				; Fin de la zone                        

;*****************************************************************************
;                        VARIABLES BANQUE 2                                  *
;*****************************************************************************

; Zone de 96 bytes
; ----------------

	CBLOCK	0x110			; Dbut de la zone (0x110  0x16F)

	ENDC				; Fin de la zone                        
;*****************************************************************************
;                        VARIABLES BANQUE 3                                  *
;*****************************************************************************

; Zone de 96 bytes
; ----------------

	CBLOCK	0x190		; Dbut de la zone (0x190  0x1EF)

	ENDC			; Fin de la zone                        
       

;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 			; Adresse de dpart aprs reset
  	goto    init			; Initialiser

; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Si on n'utilise pas l'adressage indirect dans les interrupts, on se passera
; de sauvegarder FSR ainsi que la restauration dans restorereg
; Si le programme ne fait pas plus de 2K, on se passera de la gestion de 
; PCLATH ainsi que la restauration dans restorereg
;-----------------------------------------------------------------------------
			;sauvegarder registres	
			;---------------------
	org 0x004			; adresse d'interruption
	movwf   w_temp  		; sauver registre W
	swapf	STATUS,w		; swap status avec rsultat dans w
	movwf	status_temp		; sauver status swapp
	movf	FSR , w			; charger FSR
	movwf	FSR_temp		; sauvegarder FSR
	movf	PCLATH , w		; charger PCLATH
	movwf	PCLATH_temp		; le sauver
	BANK0				; passer en banque0

			; switch vers diffrentes interrupts
			; inverser ordre pour modifier priorits
			; mais attention alors au test PEIE
			; effacer les inutiles
			;----------------------------------------
	
			; Interruption TMR0
			; -----------------

	btfsc	INTCON,TMR0IE		; tester si interrupt timer autorise
	btfss	INTCON,TMR0IF		; oui, tester si interrupt timer en cours
	goto 	intsw1			; non test suivant
	call	inttmr0			; oui, traiter interrupt tmr0
	bcf	INTCON,TMR0IF		; effacer flag interrupt tmr0
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; Interruption RB0/INT
			; --------------------
intsw1
	btfsc	INTCON,INTE		; tester si interrupt RB0 autorise
	btfss	INTCON,INTF		; oui, tester si interrupt RB0 en cours
	goto 	intsw2			; non sauter au test suivant
	call	intrb0			; oui, traiter interrupt RB0
	bcf	INTCON,INTF		; effacer flag interupt RB0
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; interruption RB4/RB7
			; --------------------
intsw2
	btfsc	INTCON,RBIE		; tester si interrupt RB4/7 autorise
	btfss	INTCON,RBIF		; oui, tester si interrupt RB4/7 en cours
	goto 	intsw3			; non sauter
	call	intrb4			; oui, traiter interrupt RB4/7
	bcf	INTCON,RBIF		; effacer flag interupt RB4/7
	goto	restorereg		; et fin d'interrupt

			; dtection interruptions priphriques
			; le test peut tre supprim si une seule
			; interrupt est traite  la fois
			; --------------------------------------
intsw3
	btfss	INTCON,PEIE		; tester interruption priphrique autorise
	goto	restorereg		; non, fin d'interruption

	



			; Interruption TMR2
			; -----------------
intsw8
	BANK1				; slectionner banque1
	btfss	PIE1,TMR2IE		; tester si interrupt autorise
	goto 	intsw9			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,TMR2IF		; oui, tester si interrupt en cours
	goto 	intsw9			; non sauter
	call	inttmr2			; oui, traiter interrupt
	bcf	PIR1,TMR2IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt

			; Interruption TMR1
			; -----------------
intsw9
	BANK1				; slectionner banque1
	btfss	PIE1,TMR1IE		; tester si interrupt autorise
	goto 	restorereg		; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,TMR1IF		; oui, tester si interrupt en cours
	goto 	restorereg		; non sauter
	call	inttmr1			; oui, traiter interrupt
	bcf	PIR1,TMR1IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt

	
			;restaurer registres
			;-------------------
restorereg
	movf	PCLATH_temp , w		; recharger ancien PCLATH
	movwf	PCLATH			; le restaurer
	movf	FSR_temp , w		; charger FSR sauv
	movwf	FSR			; restaurer FSR
	swapf	status_temp,w		; swap ancien status, rsultat dans w
	movwf   STATUS			; restaurer status
	swapf   w_temp,f		; Inversion L et H de l'ancien W
                       			; sans modifier Z
	swapf   w_temp,w  		; Rinversion de L et H dans W
					; W restaur sans modifier status
	retfie  			; return from interrupt

;*****************************************************************************
;                        INTERRUPTION TIMER 0                                *
;*****************************************************************************
inttmr0
	return				; fin d'interruption timer
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                        INTERRUPTION RB0/INT                                *
;*****************************************************************************
intrb0
	return				; fin d'interruption RB0/INT
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                         INTERRUPTION RB0/RB4                               *
;*****************************************************************************
intrb4
	return				; fin d'interruption RB0/RB4
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION TIMER 2                                   *
;*****************************************************************************
inttmr2
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION TIMER 1                                   *
;*****************************************************************************
inttmr1
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

			; initialisation PORTS (banque 0 et 1)
			; ------------------------------------
	BANK0				; slectionner banque0
	clrf	PORTA			; Sorties PORTA  0
	clrf	PORTB			; sorties PORTB  0
	BANK1				; passer en banque1
	movlw	DIRPORTA		; Direction PORTA
	movwf	TRISA			; criture dans registre direction
	movlw	DIRPORTB		; Direction PORTB
	movwf	TRISB			; criture dans registre direction

			; Registre de l'oscillateur
			; -------------------------
	movlw	OSCCONVAL		; charger le masque
	movwf	OSCCON			; initialiser registre
; les deux lignes suivantes ne passent pas la simulation sous MPLAB
;Stable  btfss   OSCCON,IOFS     	; oscillateur est il stable?   
        ;goto    Stable          	; non, on attend 

			; Registre d'options (banque 1)
			; -----------------------------
	movlw	OPTIONVAL		; charger masque
	movwf	OPTION_REG		; initialiser registre option

			; registres interruptions (banque 1)
			; ----------------------------------
	movlw	INTCONVAL		; charger valeur registre interruption
	movwf	INTCON			; initialiser interruptions
	movlw	PIE1VAL			; Initialiser registre 
	movwf	PIE1			; interruptions priphriques 1
	movlw	PIE2VAL			; Initialiser registre 
	movwf	PIE2			; interruptions priphriques 2
	movlw	CVRCONVAL		; charger masque
	movwf	CVRCON			; initialiser le registre tension de reference
	movlw	CMCONVAL		; charger masque
	movwf	CMCON			; initialiser le registre du comparateur
	movlw	ANSELVAL		; charger masque
	movwf	ANSEL			; initialiser le registre du convertisseur


			; Effacer RAM banque 0
			; ---------------------
	BANK0				; slectionner banque 0
	movlw	0x20			; initialisation pointeur
	movwf	FSR		 	; d'adressage indirect
init1
	clrf	INDF			; effacer ram
	incf	FSR,f			; pointer sur suivant
	btfss	FSR,7			; tester si fin zone atteinte (>7F)
	goto	init1			; non, boucler

			; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1			; effacer flags 1
	clrf	PIR2			; effacer flags 2
	bsf	INTCON,GIE		; valider interruptions
	goto	start			; programme principal

;*****************************************************************************
;                      SOUS ROUTINES                                         *
;*****************************************************************************

;-------------------------------------------------------------
; Code generated by PDEL  ver 1.0  on 20/10/2007 at 04:55:55
; Description: Waits 91 cycles
;-------------------------------------------------------------
PDelay  movlw     .21       ; 1 set number of repetitions
        movwf     PDel0     ; 1 |
PLoop0  clrwdt              ; 1 clear watchdog
        decfsz    PDel0, 1  ; 1 + (1) is the time over?
        goto      PLoop0    ; 2 no, loop
PDelL1  goto PDelL2         ; 2 cycles delay
PDelL2  
        return              ; 2+2 Done
;-------------------------------------------------------------

;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start

	clrwdt				; effacer watch dog

boucle1
	movf	CMPT1,w		; w=CMPT1
	CALLX	tableau1
	movwf	VAR1

	movlw	D'8'
	movwf	CMPT2
boucle1a
	btfsc	VAR1,7
	bsf		OUT1
	btfss	VAR1,7
	bcf		OUT1
	call    PDelay
	rlf		VAR1,f
	decfsz	CMPT2,f
	goto	boucle1a

	incf	CMPT1,f
	movlw	D'255'
	subwf	CMPT1,w
	btfsc	STATUS,Z
	goto 	$+2
	goto	boucle1
	clrf 	CMPT1
;****************************
boucle2
	movf	CMPT1,w		; w=CMPT1
	CALLX	tableau2
	movwf	VAR1

	movlw	D'8'
	movwf	CMPT2
boucle2a
	btfsc	VAR1,7
	bsf		OUT1
	btfss	VAR1,7
	bcf		OUT1
	call    PDelay
	rlf		VAR1,f
	decfsz	CMPT2,f
	goto	boucle2a

	incf	CMPT1,f
	movlw	D'254'
	subwf	CMPT1,w
	btfsc	STATUS,Z
	goto 	$+2
	goto	boucle2
	clrf 	CMPT1
;****************************
boucle3
	movf	CMPT1,w		; w=CMPT1
	CALLX	tableau3
	movwf	VAR1

	movlw	D'8'
	movwf	CMPT2
boucle3a
	btfsc	VAR1,7
	bsf		OUT1
	btfss	VAR1,7
	bcf		OUT1
	call    PDelay
	rlf		VAR1,f
	decfsz	CMPT2,f
	goto	boucle3a

	incf	CMPT1,f
	movlw	D'255'
	subwf	CMPT1,w
	btfsc	STATUS,Z
	goto 	$+2
	goto	boucle3
	clrf 	CMPT1
;****************************
boucle4
	movf	CMPT1,w		; w=CMPT1
	CALLX	tableau4
	movwf	VAR1

	movlw	D'8'
	movwf	CMPT2
boucle4a
	btfsc	VAR1,7
	bsf		OUT1
	btfss	VAR1,7
	bcf		OUT1
	call    PDelay
	rlf		VAR1,f
	decfsz	CMPT2,f
	goto	boucle4a

	incf	CMPT1,f
	movlw	D'255'
	subwf	CMPT1,w
	btfsc	STATUS,Z
	goto 	$+2
	goto	boucle4
	clrf 	CMPT1
;****************************


	goto 	start			; boucler


#INCLUDE  SRbt5_1B.asm


	END 				; directive fin de programme

