
#include <p18f6722.h>

#define GLCD_Data   PORTD
#define b_GLCD_GCS1 LATCbits.LATC6
#define b_GLCD_GCS2 LATCbits.LATC7
#define b_GLCD_RS   LATCbits.LATC1
#define b_GLCD_RW   LATCbits.LATC2
#define b_GLCD_E    LATCbits.LATC5
#define b_GLCD_On   LATBbits.LATB5
#define b_GLCD_BL   LATGbits.LATG0

#define TRIS_Data    TRISD
#define b_TRIS_GCS1  TRISCbits.TRISC6 //GCS1
#define b_TRIS_GCS2  TRISCbits.TRISC7 //GCS2 
#define b_TRIS_RS    TRISCbits.TRISC1 //RS 
#define b_TRIS_RW    TRISCbits.TRISC2 //RW 
#define b_TRIS_E     TRISCbits.TRISC5 //E 
#define b_TRIS_On    TRISBbits.TRISB5 //RST
#define b_TRIS_BL    TRISGbits.TRISG0 //backlight	

void Delay(void);
unsigned char GLCD_Read(void);
void Wait_Not_Busy(void);
void GLCD_Write_Cmd(unsigned char data);
void GLCD_Write_Data (unsigned char data);
void ClearScreen(void);
void Init_GLCD(void);
void PutChar(unsigned char data);
unsigned char GLCD_Read_Data(void);
void SetPos(unsigned char x,unsigned char y);
void WritePosition(void);
void plot(unsigned char x,unsigned char y);
void hline(unsigned char x,unsigned char y1,unsigned char y2);
void vline(unsigned char x1,unsigned char x2,unsigned char y);
void box(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2);
void PutMessage( char rom *Message);
void PutLogo( char rom *logo);
