;*****************************************************************************
;   Ce fichier est la base de dpart pour une programmation avec             *
;   le PIC 16F676. Il contient  les informations de  base pour               *
;   dmarrer.                                                                *  
;   ecrit grace  Bigonoff par gilles.chevalerias@free.fr                    *
;*****************************************************************************
;                                                                            *
;    NOM:                                                                    *
;    Date:                                                                   *
;    Version:                                                                *
;    Circuit:                                                                *
;    Auteur:                                                                 *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P16F676.inc                                             *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Notes:                                                                  *
;                                                                            *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************

; Ce modele est un peut particulier dans la serie des 16F, il peut travailler avec une tension 
; faible mme sans version LF, sa memmoire est mappe sur les deux banques comme un 16F84,
; il comporte un registre OSCCAL comme les 12F avec une valeur de calibration  sauver, 
; il se programme sur un support reserv au PIC 8 pattes comme un 12F, il a deux ports le A et le C
; qui n'ont que 6 I/O chacun, l'interruption RB0/int et sur RA2, les interruptions de changement d'etat
; sur le portB sont transferes sur le port A et individuellement reglable, idem pour les resistances de
; pullup.


	ERRORLEVEL -302			; suppression du message bank select 
	LIST      p=16F676            ; Dfinition de processeur
	#include <p16F676.inc>        ; fichier include

	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT 

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Choisir une valeur par groupe.
; Voici les valeurs et leurs dfinitions :

; Protection du programme
; -----------------------
;_CP_ALL		protection totale (attention relecture d'OSCCAL impossible)
;_CP_OFF		Pas de protection


; Protection de l'EEprom
; -----------------------
;_CPD_ON		Mmoire EEprom protge
;_CPD_OFF               Mmoire EEprom dprotge


; Reset de la PIC si tension <4V
; ------------------------------
; _BODEN		Reset tension en service
;			Valide PWRTE_ON automatiquement
; _BODEN_OFF		Reset tension hors service

;Utilisation de la pin MCLR
; ------------------------------
;_MCLRE_ON		RA5/MCLR est utilise pour le reset
;
;_MCLRE_OFF		RA5/MCLR est utilise comme une entree/sortie

; Retard  la mise sous tension
; -----------------------------

;_PWRTE_OFF		Dmarrage rapide
;_PWRTE_ON		Dmarrage temporis

; Watchdog
; --------

;_WDT_ON		Watchdog en service
;_WDT_OFF		Watchdog hors service

; Oscillateur
; -----------
;_EC_OSC 		(ECIO) oscillateur externe sur RA5 avec RA4 en I/O               
;_INTRC_OSC_CLKOUT	oscillateur interne clkout sur RA4, I/O sur RA5 (4MHz)    
;_INTRC_OSC_NOCLKOUT	oscillateur interne I/O sur RA4 et RA5 (4MHz)        
;_EXTRC_OSC_NOCLKOUT	(RCIO) RC externe sur RA5 avec RA4 en I/O
;_EXTRC_OSC_CLKOUT      (RC) RC externe sur RA5 avec Fosc/4 sur RA4         
;_LP_OSC 		Oscillateur basse vitesse (?<F<200Khz)        
;_XT_OSC                Oscilateur moyenne vitesse (0,1MHz<F<4Mhz)     
;_HS_OSC 		Oscillateur haute vitesse (1Mhz<F<20Mhz)


;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'00000000'
			; RAPU      b7 : 1= Rsistance rappel +5V hors service
			; INTEDG    b6 : 1= Interrupt sur front montant de RA2
			;                0= Interrupt sur front descendant de RA2
			; TOCS      b5 : 1= source clock = transition sur RA2
			;                0= horloge interne
			; TOSE      b4 : 1= Slection front descendant RA2(si B5=1)
			;                0= Slection front montant RA2
			; PSA       b3 : 1= Assignation prdiviseur sur Watchdog
			;                0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   b2/b0 valeur du prdiviseur
                        ;           000 =  1/1 (watchdog) ou 1/2 (tmr0)
			;           001 =  1/2               1/4
			;           010 =  1/4		     1/8
			;           011 =  1/8		     1/16
			;           100 =  1/16		     1/32
			;           101 =  1/32		     1/64
			;           110 =  1/64		     1/128
			;           111 =  1/128	     1/256


; REGISTRE INTCON (contrle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'00000000'
			; GIE       b7 : masque autorisation gnrale interrupt
                        ;                ne pas mettre ce bit  1 ici
                        ;                sera mis en temps utile
			; PEIE      b6 : masque autorisation gnrale priphriques
			; T0IE      b5 : masque interruption tmr0
			; INTE      b4 : masque interuption RA2/Int
			; RAIE      b3 : masque interruption change PORTA (IOCA doit tre activ)
			; T0IF      b2 : flag tmr0
			; INTF      b1 : flag RA2/Int
			; RAIF      b0 : flag interruption change PORTA


; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'
			; EEIE      b7 : masque interrupt criture EEPROM
			; ADIE      b6 : masque interrupt convertisseur A/D
			; RESERVED  b5 : rserv, laisser  0
			; RESERVED  b4 : rserv, laisser  0
			; CMIE      b3 : masque interrupt comparateur
			; RESERVED  b2 : rserv, laisser  0
			; RESERVED  b1 : rserv, laisser  0
			; TMR1IE    b0 : masque interrupt dbordement tmr1


; REGISTRE IOCA (contrle individuel des interruptions sur le PORTA)
; ------------------------------------------------------------------
IOCAVAL		EQU	B'00000000'
			; RESERVED  b7 : rserv, laisser  0 
			; RESERVED  b6 : rserv, laisser  0
			; IOCA5     b5 : masque interruption de changement sur RA5
			; IOCA4     b4 :        "             "     "       "  RA4 
			; IOCA3     b3 :        "             "     "       "  RA3
			; IOCA2     b2 :        "             "     "       "  RA2
			; IOCA1     b1 :        "             "     "       "  RA1
			; IOCA0     b0 :        "             "     "       "  RA0


; REGISTRE WPUA (contrle individuel des resistances de pull up)
; --------------------------------------------------------------
WPUAVAL	EQU		B'00000000'
			; RESERVED  b7 : rserv, laisser  0 
			; RESERVED  b6 : rserv, laisser  0
			; WPUA5     b5 : mettre  1 pour activ resistance sur RA5
			; WPUA4     b4 :        "           "       "       "  RA4 
			; WPUA3     b3 :        "           "       "       "  RA3
			; WPUA2     b2 :        "           "       "       "  RA2
			; WPUA1     b1 :        "           "       "       "  RA1
			; WPUA0     b0 :        "           "       "       "  RA0
	; pour utiliser les resistances de pull up, RAPU de OPTION doit tre  0


; REGISTRE CMCON (COMPARATEURS)
; ------------------------------------
CMCONVAL	EQU	B'00000111' 
			; RESERVED  b7 : rserv, laisser  0
			; COUT      b6 :sortie comparateur
			; RESERVED  b5 : rserv, laisser  0
			; CINV      b4 :inverseur comparateur
			; CIS       b3 :selection entree du comparateur
			; CM2-CM0   b2-0 :mode des comparateurs
			; configurer le mode 111 pour utiliser RA0 RA1 RA2 en I/O


; REGISTRE VRCON (voltage reference module)
; ------------------------------------
VRCONVAL	EQU	B'00000000'
			; VREN      b7 :Validation du module
			; RESERVED  b6 : rserv, laisser  0
			; VRR       b5 :Choix de la plage 
			; RESERVED  b4 : rserv, laisser  0
			; VR3-VR0   b3-0 :Choix de la valeur dans la plage 
					; si VRR=1 VREF=(VR[3:0]/24)*Vdd
					; si VRR=0 VREF=Vdd/4(VR[3:0]/32)*Vdd


; REGISTRE ANSEL (contrle du convertisseur A/D)
; ----------------------------------------------
ANSELVAL	EQU	B'00000000'
			; ANS7	    b7 : 1=AN7/RC3 analogique, 0=AN7/RC3 digital
			; ANS6	    b6 : 1=AN6/RC2 analogique, 0=AN6/RC2 digital
			; ANS5	    b5 : 1=AN5/RC1 analogique, 0=AN5/RC1 digital
			; ANS4	    b4 : 1=AN4/RC0 analogique, 0=AN4/RC0 digital
			; ANS3	    b3 : 1=AN3/RA4 analogique, 0=AN3/RA4 digital
			; ANS2	    b2 : 1=AN2/RA2 analogique, 0=AN2/RA2 digital
			; ANS1	    b1 : 1=AN1/RA1 analogique, 0=AN1/RA1 digital
			; ANS0	    b0 : 1=AN0/RA0 analogique, 0=AN0/RA0 digital


; DIRECTION DES PORTS I/O
; -----------------------

DIRPORTA	EQU	B'00111111'	; Direction PORTA  RA5  RA0 (1=entre)
DIRPORTC	EQU	B'00111111'	; Direction PORTC  RC5  RC0


;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; exemple
; -------
;MASQUE		EQU	H'00FF'


;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************

; exemple
; -------
;#DEFINE LED1	PORTB,1			; LED de sortie 1

;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

			; Changement de banques
			; ----------------------

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
	endm

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
	endm

	

			; oprations en mmoire eeprom
			; -----------------------------

REEPROM macro	adeeprom		; lire eeprom (adresse dans adeeprom & rsultat en w)
	movlw	adeeprom		; charger adresse eeprom (passage de la valeur en litteral)
	;movf	adeeprom,w		; charger adresse eeprom (passage de la valeur par une variable)
	clrwdt				; reset watchdog
	BANK1				; passer en banque1
	movwf	EEADR			; pointer sur adresse eeprom
	bsf	EECON1,RD		; ordre de lecture
	movf	EEDATA,w		; charger valeur lue
	BANK0				; passer en banque0
	endm


WEEPROM	macro	addwrite	  	; la donne se trouve dans W
	LOCAL	loop
	BANK1				; passer en banque1
	movwf	EEDATA			; placer data dans registre
	movlw	addwrite		; charger adresse d'criture (passage de la valeur en litteral)
	;movf	addwrite,w		; charger adresse d'criture (passage de la valeur par une variable)
	movwf	EEADR			; placer dans registre
	bsf	EECON1 , WREN		; autoriser accs criture
	bcf	INTCON , GIE		; interdire interruptions
	movlw	0x55			; charger 0x55
	movwf	EECON2			; envoyer commande
	movlw	0xAA			; charger 0xAA
	movwf	EECON2			; envoyer commande
	bsf	EECON1 , WR		; lancer cycle d'criture
	bsf	INTCON , GIE		; rautoriser interruptions
loop
	btfsc	EECON1 , WR		; tester si criture termine
	goto	loop			; non, attendre
	bcf	EECON1 , WREN		; verrouiller prochaine criture
	BANK0				; passer en banque0
	endm


;*****************************************************************************
;             VARIABLES BANQUE0 et BANQUE1 sont mappes (communes)           *
;*****************************************************************************

; Zone de 64 bytes
; ----------------

	CBLOCK	0x20			; Dbut de la zone (0x20  0x5F)
	w_temp : 1			; Sauvegarde registre W
	status_temp : 1			; sauvegarde registre STATUS


        ENDC				; Fin de la zone                        
;Exemples
;--------
	;test :1			; Zone de 1 byte
	;table : 10			; zone de 10 bytes
	;var1 	EQU H'006E'		; adresse impose


;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 			; Adresse de dpart aprs reset
  	goto    init			; Initialiser

; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************

			;sauvegarder registres	
			;---------------------
	org 	0x004			; adresse d'interruption
	movwf   w_temp  		; sauver registre W
	swapf	STATUS,w		; swap status avec rsultat dans w
	movwf	status_temp		; sauver status swapp

	BANK0				; passer en banque0

			; switch vers diffrentes interrupts
			; inverser ordre pour modifier priorits
			; mais attention alors au test PEIE
			; effacer les inutiles
			;----------------------------------------
	
			; Interruption TMR0
			; -----------------

	btfsc	INTCON,T0IE		; tester si interrupt timer autorise
	btfss	INTCON,T0IF		; oui, tester si interrupt timer en cours
	goto 	intsw1			; non test suivant
	call	inttmr0			; oui, traiter interrupt tmr0
	bcf	INTCON,T0IF		; effacer flag interrupt tmr0
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; Interruption RA2/INT
			; --------------------
intsw1
	btfsc	INTCON,INTE		; tester si interrupt RA2 autorise
	btfss	INTCON,INTF		; oui, tester si interrupt RA2 en cours
	goto 	intsw2			; non sauter au test suivant
	call	intrb0			; oui, traiter interrupt RA2
	bcf	INTCON,INTF		; effacer flag interupt RA2
	goto	restorereg		; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			; interruption "PORTA change"
			; --------------------
intsw2
	btfsc	INTCON,RAIE		; tester si interrupt "PORTA change" autorise
	btfss	INTCON,RAIF		; oui, tester si interrupt "PORTA change" en cours
	goto 	intsw3			; non sauter
	call	intrb4			; oui, traiter interrupt "PORTA change"
	bcf	INTCON,RAIF		; effacer flag interupt "PORTA change"
	goto	restorereg		; et fin d'interrupt

			; dtection interruptions priphriques
			; le test peut tre supprim si une seule
			; interrupt est traite  la fois
			; --------------------------------------
intsw3
	btfss	INTCON,PEIE		; tester interruption priphrique autorise
	goto	restorereg		; non, fin d'interruption

	



			; Interruption comparateurs
			; -------------------------
intsw6
	BANK1				; slectionner banque1
	btfss	PIE1,CMIE		; tester si interrupt autorise
	goto 	intsw7			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,CMIF		; oui, tester si interrupt en cours
	goto 	intsw7			; non sauter
	call	intcmp			; oui, traiter interrupt
	goto	restorereg		; et fin d'interrupt


			; Interruption convertisseur A/D
			; ------------------------------
intsw7
	BANK1				; slectionner banque1
	btfss	PIE1,ADIE		; tester si interrupt autorise
	goto 	intsw9			; non sauter
	bcf	STATUS,RP0		; oui, slectionner banque0
	btfss	PIR1,ADIF		; tester si interrupt en cours
	goto 	intsw9			; non sauter
	call	intad			; oui, traiter interrupt
	bcf	PIR1,ADIF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt
	



			; Interruption TMR1
			; -----------------
intsw9
	BANK1				; slectionner banque1
	btfss	PIE1,TMR1IE		; tester si interrupt autorise
	goto 	intswA			; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,TMR1IF		; oui, tester si interrupt en cours
	goto 	intswA			; non sauter
	call	inttmr1			; oui, traiter interrupt
	bcf	PIR1,TMR1IF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt

			; Interruption EEPROM
			; -------------------
intswA
	BANK1				; slectionner banque1
	btfss	PIE1,EEIE		; tester si interrupt autorise
	goto 	restorereg		; non sauter
	BANK0				; oui, slectionner banque0
	btfss	PIR1,EEIF		; oui, tester si interrupt en cours
	goto 	restorereg		; non sauter
	call	inteprom		; oui, traiter interrupt
	bcf	PIR1,EEIF		; effacer flag interupt 
	goto	restorereg		; et fin d'interrupt

	
			;restaurer registres
			;-------------------
restorereg
	swapf	status_temp,w		; swap ancien status, rsultat dans w
	movwf   STATUS			; restaurer status
	swapf   w_temp,f		; Inversion L et H de l'ancien W
                       			; sans modifier Z
	swapf   w_temp,w  		; Rinversion de L et H dans W
					; W restaur sans modifier status
	retfie  			; return from interrupt

;*****************************************************************************
;                        INTERRUPTION TIMER 0                                *
;*****************************************************************************
inttmr0
	return				; fin d'interruption timer
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                        INTERRUPTION RA2/INT                                *
;*****************************************************************************
intrb0
	return				; fin d'interruption RB0/INT
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                         INTERRUPTION "PORTA change"                        *
;*****************************************************************************
intrb4
	return				; fin d'interruption "PORTA change"
					; peut tre remplac par 
					; retlw pour retour code d'erreur


;****************************************************************************
;                      INTERUPTION COMPARATEUR                              *
;****************************************************************************
intcmp
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur
;

;*****************************************************************************
;                     INTERRUPTION TIMER 1                                   *
;*****************************************************************************
inttmr1
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur

;*****************************************************************************
;                     INTERRUPTION CONVERTISSEUR A/D                         *
;*****************************************************************************
intad
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur


;*****************************************************************************
;                     INTERRUPTION EEPROM                                    *
;*****************************************************************************
inteprom
	return				; fin d'interruption
					; peut tre remplac par 
					; retlw pour retour code d'erreur


; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

			; initialisation PORTS (banque 0 et 1)
			; ------------------------------------
	BANK0				; slectionner banque0
	clrf	PORTA			; Sorties PORTA  0
	clrf	PORTC			; sorties PORTC  0
	BANK1				; passer en banque1
	movlw	DIRPORTA		; Direction PORTA
	movwf	TRISA			; criture dans registre direction
	movlw	DIRPORTC		; Direction PORTC
	movwf	TRISC			; criture dans registre direction

			; Registre d'options (banque 1)
			; -----------------------------
	movlw	OPTIONVAL		; charger masque
	movwf	OPTION_REG		; initialiser registre option

			; registres interruptions (banque 1)
			; ----------------------------------
	movlw	INTCONVAL		; charger valeur registre interruption
	movwf	INTCON			; initialiser interruptions
	movlw	PIE1VAL			; Initialiser registre 
	movwf	PIE1			; interruptions priphriques 1
	movlw	VRCONVAL		; charger valeur registre interruption
	movwf	VRCON			; initialiser interruptions
	movlw	IOCAVAL			; charger valeur registre interruption
	movwf	IOCA			; initialiser interruptions
	movlw	ANSELVAL		; charger valeur registre interruption
	movwf	ANSEL			; initialiser registre
	movlw	WPUAVAL			; charger valeur registre interruption
	movwf	WPUA			; initialiser registre
	BANK0				; slectionner banque 0
	movlw	CMCONVAL		; charger valeur registre interruption
	movwf	CMCON			; initialiser interruptions

			; Effacer RAM banque 0
			; ---------------------
	movlw	0x20			; initialisation pointeur
	movwf	FSR		 	; d'adressage indirect
init1
	clrf	INDF			; effacer ram
	incf	FSR,f			; pointer sur suivant
	btfss	FSR,7			; tester si fin zone atteinte (>7F)
	goto	init1			; non, boucler

			; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1			; effacer flags 1
	bsf	INTCON,GIE		; valider interruptions
	goto	start			; programme principal


;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start

	clrwdt				; effacer watch dog
	goto 	start			; boucler




	END 				; directive fin de programme

