;*****************************************************************************
;   Ce fichier est la base de dpart pour une programmation avec             *
;   le PIC 16F877A. Il contient  les informations de  base pour              *
;   dmarrer.                                                                *  
;                                                                            *
;*****************************************************************************
;                                                                            *
;    NOM: 5kHz.asm                                                           *
;    Date:                                                                   *
;    Version:                                                                *
;    Circuit:                                                                *
;    Auteur:                                                                 *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P16F877A.inc                                            *
;                                                                            *
;    Frequence quartz: 4MHz                                                  *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Notes: Generer un signal carr de 5kHz                                  *
;                                                                            *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************

	ERRORLEVEL -302			; suppression du message bank select 
	LIST      p=16F877a            ; Dfinition de processeur
	#include <p16F877a.inc>        ; fichier include

	__CONFIG   _CP_OFF & _DEBUG_OFF & _WRT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC 

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Choisir une valeur par groupe.
; Voici les valeurs et leurs dfinitions :

; Protection du programme en lecture
; -----------------------
;_CP_ALL		protection totale
;_CP_OFF		Pas de protection

; Debuggage
; ---------
;_DEBUG_ON		RB6 et RB7 utilises pour debugger
;_DEBUG_OFF		RB6 et RB7 en utilisation normale

; Accs  la flash programme
; --------------------------

;_WRT_OFF		Le programme peut crire dans la flash
;_WRT_256		Le programme ne peut pas crire dans la flash dans les 256 premier octets
;_WRT_1FOURTH		Le programme ne peut pas crire dans la flash dans le premier quart
;_WRT_HALF		Le programme ne peut pas crire dans la flash dans la premiere moitie

; Protection de la EEprom
; -----------------------

;_CPD_ON		Mmoire EEprom protge
;_CPD_OFF               Mmoire EEprom dprotge

; Programmation sur circuit
; -------------------------

;_LVP_ON		RB3 permet la programmation srie de la PIC
;_LVP_OFF		RB3 en utilisation normale

; Reset de la PIC si tension <4V
; ------------------------------
; _BODEN_ON		Reset tension en service
;			Valide PWRTE_ON automatiquement
; _BODEN_OFF		Reset tension hors service

; Retard  la mise sous tension
; -----------------------------

;_PWRTE_OFF		Dmarrage rapide
;_PWRTE_ON		Dmarrage temporis

; Watchdog
; --------

;_WDT_ON		Watchdog en service
;_WDT_OFF		Watchdog hors service

; Oscillateur
; -----------
;_LP_OSC		Oscillateur basse vitesse (32<F<200Khz)
;_XT_OSC		Oscilateur moyenne vitesse (200Khz<F<4Mhz)
;_HS_OSC		Oscillateur haute vitesse (4Mhz<F<20Mhz)
;_RC_OSC		Oscillateur  rseau RC

;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'10000000'
			; RBPU     b7 : 1= Rsistance rappel +5V hors service
			; INTEDG   b6 : 1= Interrupt sur flanc montant de RB0
			;               0= Interrupt sur flanc descend. de RB0
			; TOCS      b5 : 1= source clock = transition sur RA4
			;                0= horloge interne
			; TOSE      b4 : 1= Slection flanc montant RA4(si B5=1)
			;                0= Slection flanc descendant RA4
			; PSA       b3 : 1= Assignation prdiviseur sur Watchdog
			;                0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   b2/b0 valeur du prdiviseur
                        		;           000 =  1/1 (watchdog) ou 1/2 (tmr0)
			;           001 =  1/2               1/4
			;           010 =  1/4		     1/8
			;           011 =  1/8		     1/16
			;           100 =  1/16		     1/32
			;           101 =  1/32		     1/64
			;           110 =  1/64		     1/128
			;           111 =  1/128	     1/256


; REGISTRE INTCON (contrle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'00000000'
			; GIE       b7 : masque autorisation gnrale interrupt
                        ;                ne pas mettre ce bit  1 ici
                        ;                sera mis en temps utile
			; PEIE      b6 : masque autorisation gnrale priphriques
			; T0IE      b5 : masque interruption tmr0
			; INTE      b4 : masque interuption RB0/Int
			; RBIE      b3 : masque interruption RB4/RB7
			; T0IF      b2 : flag tmr0
			; INTF      b1 : flag RB0/Int
			; RBIF      b0 : flag interruption RB4/RB7

; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'
			; PSPIE     b7 : Toujours 0 sur PIC 16F786
			; ADIE      b6 : masque interrupt convertisseur A/D
			; RCIE      b5 : masque interrupt rception USART
			; TXIE      b4 : masque interrupt transmission USART
			; SSPIE     b3 : masque interrupt port srie synchrone
			; CCP1IE    b2 : masque interrupt CCP1
			; TMR2IE    b1 : masque interrupt TMR2 = PR2
			; TMR1IE    b0 : masque interrupt dbordement tmr1

; REGISTRE PIE2 (contrle interruptions particulires)
; ----------------------------------------------------
PIE2VAL		EQU	B'00000000'
			; UNUSED    b7 : inutilis, laisser  0
			; RESERVED  b6 : rserv, laisser  0
			; UNUSED    b5 : inutilis, laisser  0
			; EEIE      b4 : masque interrupt criture EEPROM
			; BCLIE     b3 : masque interrupt collision bus
			; UNUSED    b2 : inutilis, laisser  0
			; UNUSED    b1 : inutilis, laisser  0
			; CCP2IE    b0 : masque interrupt CCP2

; REGISTRE CMCON (COMPARATEURS)
; ------------------------------------
CMCONVAL	EQU	B'00000111' 
			; C2OUT	    b7 :sortie comparateur2
			; C1OUT     b6 :sortie comparateur1
			; C2INV     b5 :inverseur comparateur2
			; C1INV     b4 :inverseur comparateur1
			; CIS       b3 :selection entree des comparateurs
			; CM2-CM0   b2-0 :mode des comparateurs
			;configurer le mode 111 pour utiliser RA0 RA1 RA2 RA3 en I/O

; REGISTRE VRCON (voltage reference module)
; ------------------------------------
CVRCONVAL	EQU	B'00000000'
			; CVREN     b7 :Validation du module
			; CVROE     b6 :Sortie sur RA2
			; CVRR      b5 :Choix de la plage 
			; RESERVED  b4 : rserv, laisser  0
			; CVR3-CVR0 b3-0 :Choix de la valeur dans la plage 
					; si CVRR=1 CVREF=(VR[3:0]/24)*Vdd
					; si CVRR=0 CVREF=(1/4*Vdd)+(VR[3:0]/32)*Vdd

; REGISTRE ADCON1 (ANALOGIQUE/DIGITAL)
; ------------------------------------
ADCON1VAL	EQU	B'00000110' ; PORTA en mode digital

; DIRECTION DES PORTS I/O
; -----------------------

DIRPORTA	EQU	B'11111011'	; Direction PORTA (1=entre)
DIRPORTB	EQU	B'11111111'	; Direction PORTB
DIRPORTC	EQU	B'11111111'	; Direction PORTC
DIRPORTD	EQU	B'11111111'	; Direction PORTD
DIRPORTE	EQU	B'00000111'	; Direction PORTE


;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; exemple
; -------
;MASQUE		EQU	H'00FF'


;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************

; exemple
; -------
#DEFINE	signal	PORTA,2

;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
		bcf	STATUS,RP1
	endm

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
		bcf	STATUS,RP1
	endm

BANK2	macro				; passer en banque2
		bcf	STATUS,RP0
		bsf	STATUS,RP1
	endm

BANK3	macro				; passer en banque3
		bsf	STATUS,RP0
		bsf	STATUS,RP1
	endm


;*****************************************************************************
;                      VARIABLES ZONE COMMUNE                                *
;*****************************************************************************

; Zone de 16 bytes
; ----------------

	CBLOCK 0x70		; Dbut de la zone (0x70  0x7F)
	w_temp : 1		; Sauvegarde registre W
	status_temp : 1		; sauvegarde registre STATUS
	PDel0 : 1		; deux variables pour la tempo
	PDel1 : 1

	ENDC
;*****************************************************************************
;                        VARIABLES BANQUE 0                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0x20		; Dbut de la zone (0x20  0x6F)


;Exemples
;--------
;	test :1			; Zone de 1 byte
;	table : 10		; zone de 10 bytes

        ENDC			; Fin de la zone                        
;Exemples
;--------
;var1 	EQU H'006E'		; adresse impose



;*****************************************************************************
;                        VARIABLES BANQUE 1                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0xA0		; Dbut de la zone (0xA0  0xEF)

	ENDC			; Fin de la zone                        

;*****************************************************************************
;                        VARIABLES BANQUE 2                                  *
;*****************************************************************************

; Zone de 96 bytes
; ----------------

	CBLOCK	0x110		; Dbut de la zone (0x110  0x16F)

	ENDC			; Fin de la zone                        

;*****************************************************************************
;                        VARIABLES BANQUE 3                                  *
;*****************************************************************************

; Zone de 96 bytes
; ----------------

	CBLOCK	0x190		; Dbut de la zone (0x190  0x1EF)

	ENDC			; Fin de la zone                        

;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 		; Adresse de dpart aprs reset
	clrf    PCLATH          ; Effacer slecteur de pages
  	goto    init		; Initialiser

; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Si on n'utilise pas l'adressage indirect dans les interrupts, on se passera
; de sauvegarder FSR
; Si le programme ne fait pas plus de 2K, on se passera de la gestion de 
; PCLATH
;-----------------------------------------------------------------------------
			;sauvegarder registres	
			;---------------------
	org 0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp
	BANK0			; passer en banque0

			;restaurer registres
			;-------------------
restorereg
	swapf	status_temp,w	; swap ancien status, rsultat dans w
	movwf   STATUS		; restaurer status
	swapf   w_temp,f	; Inversion L et H de l'ancien W
                       		; sans modifier Z
	swapf   w_temp,w  	; Rinversion de L et H dans W
				; W restaur sans modifier status
	retfie  		; return from interrupt



; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************

init

			; initialisation PORTS (banque 0 et 1)
			; ------------------------------------
	BANK0			; slectionner banque0
	clrf	PORTA		; Sorties PORTA  0
	clrf	PORTB		; sorties PORTB  0
	clrf	PORTC		; sorties PORTC  0
	clrf	PORTD		; sorties PORTD  0
	clrf	PORTE		; sorties PORTE  0
	bsf	STATUS,RP0	; passer en banque1
	movlw	ADCON1VAL	; PORTA en mode digital/analogique
	movwf	ADCON1		; criture dans contrle A/D
	movlw	DIRPORTA	; Direction PORTA
	movwf	TRISA		; criture dans registre direction
	movlw	DIRPORTB	; Direction PORTB
	movwf	TRISB		; criture dans registre direction
	movlw	DIRPORTC	; Direction PORTC
	movwf	TRISC		; criture dans registre direction
	movlw	DIRPORTD	; Direction PORTD
	movwf	TRISD		; criture dans registre direction
	movlw	DIRPORTE	; Direction PORTE
	movwf	TRISE		; criture dans registre direction

			; Registre d'options (banque 1)
			; -----------------------------
	movlw	OPTIONVAL	; charger masque
	movwf	OPTION_REG	; initialiser registre option

			; registres interruptions (banque 1)
			; ----------------------------------
	movlw	INTCONVAL	; charger valeur registre interruption
	movwf	INTCON		; initialiser interruptions
	movlw	PIE1VAL		; Initialiser registre 
	movwf	PIE1		; interruptions priphriques 1
	movlw	PIE2VAL		; initialiser registre
	movwf	PIE2		; interruptions priphriques 2
	movlw	CVRCONVAL	; charger la valeur du registre pour VREF
	movwf	CVRCON		; initialiser le registre
	movlw	CMCONVAL	; charger la valeur du registre des comparateurs
	movwf	CMCON		; initialiser le registre


			; Effacer RAM banque 0
			; ---------------------
	bcf	STATUS,RP0	; slectionner banque 0
	movlw	0x20		; initialisation pointeur
	movwf	FSR		; d'adressage indirect
init1
	clrf	INDF		; effacer ram
	incf	FSR,f		; pointer sur suivant
	btfss	FSR,7		; tester si fin zone atteinte (>7F)
	goto	init1		; non, boucler

			; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1		; effacer flags 1
	clrf	PIR2		; effacer flags 2
	bsf	INTCON,GIE	; valider interruptions
	goto	start		; programme principal

;*****************************************************************************
;                        SOUS PROGRAMMEs                                     *
;*****************************************************************************
;-------------------------------------------------------------
; Code generated by PDEL  ver 1.0  on 31/03/2009 at 19:59:51
; Description: Waits 99995 cycles  99.995ms
;-------------------------------------------------------------
PDelay  movlw     .110      ; 1 set number of repetitions (B)
        movwf     PDel0     ; 1 |
PLoop1  movlw     .181      ; 1 set number of repetitions (A)
        movwf     PDel1     ; 1 |
PLoop2  clrwdt              ; 1 clear watchdog
        clrwdt              ; 1 cycle delay
        decfsz    PDel1, 1  ; 1 + (1) is the time over? (A)
        goto      PLoop2    ; 2 no, loop
        decfsz    PDel0,  1 ; 1 + (1) is the time over? (B)
        goto      PLoop1    ; 2 no, loop
        return              ; 2+2 Done
;-------------------------------------------------------------


;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start

	clrwdt			; effacer watch dog
	BANK1
	bcf	signal		; mise en sortie de la pin utilise
	BANK0

signal_1
	bsf	signal		; signal  1
	call	PDelay		; tempo 99 995s
	nop			; 3 nop pour ajuster
	nop
	nop
signal_0
	bcf	signal		; signal  0
	call	PDelay
	nop
	nop
	goto	signal_1	; on boucle
	
	goto start		; boucler
	END 			; directive fin de programme
