;**********************************************************************
;   Ce fichier est la base de dpart pour une programmation avec      *
;   le PIC 16F84. Il contient  les informations de  base pour         *
;   dmarrer.                                                         *  
;                                                                     *
;   Si les interruptions ne sont pas utilises, supprimez les lignes  *
;   entre ORG 0x004 et l'tiquette init. De plus, les variables       *
;   w_temp et status_temp peuvent tre supprimes.                    *
;                                                                     *
;**********************************************************************
;                                                                     *
;    NOM: PAS62884                                                    *
;    Date: 26/05/2003                                                 *
;    Version:  1                                                      *
;    Circuit: proteus                                                 *
;    Auteur: Gilles Chevalerias                                       *
;     gilles.chevalerias@free.fr                                      *
;**********************************************************************
;                                                                     *
;    Fichier requis: P16F84.inc ou P16F628.inc                        *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:  tester le fonctionnement d'un moteur pas  pas           *
;    RB2 RB3 selection de mode                                        *
;    11 mode 1/2 pas-10 mode monophase-01 mode biphase-00 mode essai  *
;    RB4-RB7 phase moteur                                             *
;    RB0 RB1 clock et dir                                             *
;                                                                     *
;**********************************************************************


	ERRORLEVEL -302			; suppression du message bank select 

	LIST      p=16F84            	; choisir le bon processeur 
	#include <p16F84.inc>        	; Dfinitions des constantes
	;LIST      p=16F628		; Dfinition de processeur
	;#include <p16f628.inc>

	IFDEF __16F84A
	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC
	ENDIF

	IFDEF __16F628
		__CONFIG   _CP_OFF & & _DATA_CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC & _MCLRE_ON & _BODEN_OFF & _LVP_OFF
	ENDIF

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Voici les valeurs et leurs dfinitions :
;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service
;	_WDT_ON		Watch-dog en service
;	_WDT_OFF	Watch-dog hors service
;	_LP_OSC		Oscillateur quartz basse vitesse
;	_XT_OSC		Oscillateur quartz moyenne vitesse
;	_HS_OSC		Oscillateur quartz grande vitesse
;	_RC_OSC		Oscillateur  rseau RC

;*********************************************************************
;                              ASSIGNATIONS                          *
;*********************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'11000000'
			; RBPU      b7 : 1= Rsistance rappel +5V hors service
			; INTEDG    b6 : 1= Interrupt sur flanc montant de RB0
			;                0= Interrupt sur flanc descend. de RB0
			; TOCS      b5 : 1= source clock = transition sur RA4
			;                0= horloge interne
			; TOSE      b4 : 1= Slection flanc montant RA4(si B5=1)
			;                0= Slection flanc descendant RA4
			; PSA       b3 : 1= Assignation prdiviseur sur Watchdog
			;                0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   b2/b0 valeur du prdiviseur
                        ;           000 =  1/1 (watchdog) ou 1/2 (tmr0)
			;           001 =  1/2               1/4
			;           010 =  1/4		     1/8
			;           011 =  1/8		     1/16
			;           100 =  1/16		     1/32
			;           101 =  1/32		     1/64
			;           110 =  1/64		     1/128
			;           111 =  1/128	     1/256

; REGISTRE INTCON (contrle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'10010000'
			; GIE       b7 : masque autorisation gnrale interrupt
                        ;                ne pas mettre ce bit  1 ici
                        ;                sera mis en temps utile
			; PEIE      b6 : masque autorisation gnrale priphriques (16f628)
			;	    b6 : masque interution ecriture eeprom (16f84)	
			; T0IE      b5 : masque interruption tmr0
			; INTE      b4 : masque interuption RB0/Int
			; RBIE      b3 : masque interruption RB4/RB7
			; T0IF      b2 : flag tmr0
			; INTF      b1 : flag RB0/Int
			; RBIF      b0 : flag interruption RB4/RB7
	IFDEF __16F628
; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'
			; EEIE      b7 : masque interrupt criture EEPROM
			; CMIE      b6 : masque interrupt comparateur
			; RCIE      b5 : masque interrupt rception USART
			; TXIE      b4 : masque interrupt transmission USART
			; RESERVED  b3 : rserv, laisser  0
			; CCP1IE    b2 : masque interrupt CCP1
			; TMR2IE    b1 : masque interrupt TMR2 = PR2
			; TMR1IE    b0 : masque interrupt dbordement tmr1


; REGISTRE CMCON (COMPARATEURS)
; ------------------------------------
CMCONVAL	EQU	B'00000000' 
			; C2OUT	    b7 :sortie comparateur2
			; C1OUT     b6 :sortie comparateur1
			; C2INV     b5 :inverseur comparateur2
			; C1INV     b4 :inverseur comparateur1
			; CIS       b3 :selection entree des comparateurs
			; CM2-CM0   b2-0 :mode des comparateurs
			; configurer le mode 111 pour utiliser RA0 RA1 RA2 RA3 en I/O
ENDIF

; DIRECTION DES PORTS I/O
; -----------------------

DIRPORTA	EQU	B'11111111'	; Direction PORTA (1=entre)
DIRPORTB	EQU	B'00001111'	; Direction PORTB


;*********************************************************************
;                             DEFINE                                 *
;*********************************************************************

; exemple
; -------
;#DEFINE LED1	PORTB,1		; LED de sortie 1
;*********************************************************************
;                             MACRO                                  *
;*********************************************************************

BANK0	macro
	bcf	STATUS , RP0	; passer banque0
	endm

BANK1	macro
	bsf	STATUS , RP0	; passer banque1
	endm


;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************

	IFDEF __16F84
#define RAM_START	H'0C'
#define RAM_END		RAM_START+d'68' 	; 16F84 a 68 octets de ram
	ENDIF

	IFDEF __16F628
#define RAM_START	H'20'	
#define RAM_END		RAM_START+D'16' 	; F628 a 16 octets de ram commune
	ENDIF

	CBLOCK RAM_START   	; dbut de la zone variables
	w_temp :1		; Sauvegarde du registre W
	status_temp : 1		; Sauvegarde du registre STATUS
	cmpt : 1		; pour le pas en cours
	temp : 1		;pour conserver PORTB masque
	PDel0 : 1		;pour tempo
	PDel1 : 1		;pour tempo
        ENDC			; Fin de la zone                        

;*********************************************************************
;                   DECLARATIONS DE LA ZONE EEPROM                   *
;*********************************************************************
	org 0x2100		; adresse dbut zone eeprom

;#DEFINE	eereload	0x00	; adresse eeprom de la data

;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

	org 0x000 		; Adresse de dpart aprs reset
  	goto    init		; Adresse 0: initialiser

;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

			;sauvegarder registres	
			;---------------------
	org 0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp

			; switch vers diffrentes interrupts
			; inverser ordre pour modifier priorits
			;----------------------------------------

;------------------interuption RB0--------------------------
intsw1
	btfsc	INTCON,INTE	; tester si interrupt RB0 autorise
	btfss	INTCON,INTF	; oui, tester si interrupt RB0 en cours
	goto 	intsw2		; non sauter au test suivant
	call	intrb0		; oui, traiter interrupt RB0
	bcf	INTCON,INTF	; effacer flag interupt RB0
	goto	restorereg	; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

intsw2
	
			;restaurer registres
			;-------------------
restorereg
	swapf	status_temp,w	; swap ancien status, rsultat dans w
	movwf   STATUS		; restaurer status
	swapf   w_temp,f	; Inversion L et H de l'ancien W
                       		; sans modifier Z
	swapf   w_temp,w  	; Rinversion de L et H dans W
				; W restaur sans modifier status
	retfie  		; return from interrupt



;**********************************************************************
;                     INTERRUPTION RB0/INT                            *
;**********************************************************************
intrb0
	btfsc 	PORTB,2		;tester RB2
	goto	biphtest	;si RB2=1
	btfss	PORTB,3		;tester RB3
	goto	modeessai	;si RB3=0 mode 00
	goto	biphase		;si RB3=1 mode 01

biphtest
	btfss	PORTB,3		;tester RB3
	goto	monophase	;si RB3=0 mode 10
	goto	demipas		;si RB3=1 mode 11


	return			; fin d'interruption RB0/INT
				; peut tre remplac par 
				; retlw pour retour code d'erreur





;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************

init

	BANK1			; passer banque1
	movlw	OPTIONVAL	; charger masque
	movwf	OPTION_REG	; initialiser registre option
 	clrf	EEADR		; permet de diminuer la consommation

			; Effacer RAM
			; ------------
	movlw	0x0c		; initialisation pointeur
	movwf	FSR		; pointeur d'adressage indirect
init1
	clrf	INDF		; effacer ram
	incf	FSR,f		; pointer sur suivant
	btfss	FSR,6		; tester si fin zone atteinte (>=40)
	goto	init1		; non, boucler
	btfss	FSR,4		; tester si fin zone atteinte (>=50)
	goto	init1		; non, boucler


		; initialisation PORTS (banque 0 et 1)
		; ------------------------------------
	BANK0			; slectionner banque0
	clrf	PORTA		; Sorties PORTA  0
	clrf	PORTB		; sorties PORTB  0
	BANK1			; passer en banque1
	movlw	DIRPORTA	; Direction PORTA
	movwf	TRISA		; criture dans registre direction
	movlw	DIRPORTB	; Direction PORTB
	movwf	TRISB		; criture dans registre direction



	movlw	INTCONVAL	; masque interruption
	movwf	INTCON		; charger interrupt control

	IFDEF __16F628
	 movlw	PIE1VAL		; Initialiser registre 
	 movwf	PIE1		; interruptions priphriques 1
	 BANK0			; slectionner banque 0
	 movlw	CMCONVAL	; charger valeur registre interruption
	 movwf	CMCON		; initialiser interruptions
	ENDIF
	BANK0			; slectionner banque 0
	clrf	cmpt		; mettre compteur a 0
	goto	start		; sauter programme principal


;*********************************************************************
;              Sous routine pour le mode 1/2 pas                     *
;*********************************************************************

demipas
	btfss	PORTB,1		; tester le sens 
	goto	normal		;
	goto	inverse

normal
	incf	cmpt,f		; incrementer cmpt
	movlw	8		; w=8
	subwf	cmpt,w		; w=cmpt-w
	btfsc	STATUS,Z	; tester le resultat
	clrf	cmpt		; compteur a 0
	goto 	step

inverse
	decf	cmpt,f		; decrementer cmpt
	movlw	D'255'		; w=255
	subwf	cmpt,w		; tester si cmpt=255
	btfss	STATUS,Z
	goto 	step		; si non traiter le pas
	movlw	D'7'		; si oui mettre 7 dans cmpt
	movwf	cmpt		
	goto	step		; traiter le pas

;*********************************************************************
;              Sous routine pour le mode monophase                   *
;*********************************************************************

monophase
	btfss	PORTB,1		; tester le sens 
	goto	normal1
	goto	inverse1

normal1
	btfsc	cmpt,0		; tester si cmpt est pair
	incf	cmpt,f		; si non le rendre pair
	incf	cmpt,f		; incrementer 2 fois cmpt
	incf	cmpt,f

	movlw	D'8'		; tester si cmp=8
	subwf	cmpt,w
	btfsc	STATUS,Z
	clrf	cmpt		; si oui cmpt=0	

	movlw	D'10'		; tester si cmpt=10
	subwf	cmpt,w
	btfsc	STATUS,Z
	clrf	cmpt		; si oui cmpt=0

	goto 	step		; traiter le pas

inverse1
	btfsc	cmpt,0		; tester si cmpt est pair
	decf	cmpt,f		; si non le rendre pair
	decf	cmpt,f		; decrementer 2 fois cmpt	
	decf	cmpt,f	
	
	movlw	D'254'		; tester si cmp=254
	subwf	cmpt,w
	btfss	STATUS,Z
	goto	step		; si non traiter le pas
	movlw	D'6'		; si oui cmpt=6
	movwf	cmpt
	goto	step		; traiter le pas

;*********************************************************************
;              Sous routine pour le mode biphase                     *
;*********************************************************************

biphase
	btfss	PORTB,1		; tester le sens 
	goto	normal2
	goto	inverse2

normal2
	btfss	cmpt,0		; tester si cmpt est impair
	incf	cmpt,f		; si non le rendre impair
	incf	cmpt,f		; incrementer 2 fois cmpt
	incf	cmpt,f

	movlw	D'9'		; tester si cmpt=9
	subwf	cmpt,w
	btfsc	STATUS,Z
	clrf	cmpt		; si oui cmpt=0
	goto	step		; traiter le pas	

inverse2
	btfss	cmpt,0		; tester si cmpt est impair
	decf	cmpt,f		; si non le rendre impair
	decf	cmpt,f		; decrementer 2 fois cmpt
	decf	cmpt,f

	movlw	D'253'		; tester si cmpt=253
	subwf	cmpt,w
	btfsc	STATUS,Z
	goto	prestep

	movlw	D'255'		; tester si cmpt=255
	subwf	cmpt,w
	btfsc	STATUS,Z
	goto	prestep
	goto	step		; traiter le pas

prestep
	movlw	D'7'		; cmpt=7
	movwf	cmpt
	goto	step		; traiter le pas


;-------------------------------------------------------------
; Code generated by PDEL  ver 1.0  on 29/05/03 at 18:22:54
; Description: Waits 10000 cycles
;-------------------------------------------------------------
PDelay  movlw     .8        ; 1 set number of repetitions (B)
        movwf     PDel0     ; 1 |
PLoop1  movlw     .249      ; 1 set number of repetitions (A)
        movwf     PDel1     ; 1 |
PLoop2  clrwdt              ; 1 clear watchdog
        clrwdt              ; 1 cycle delay
        decfsz    PDel1, 1  ; 1 + (1) is the time over? (A)
        goto      PLoop2    ; 2 no, loop
        decfsz    PDel0,  1 ; 1 + (1) is the time over? (B)
        goto      PLoop1    ; 2 no, loop
PDelL1  goto PDelL2         ; 2 cycles delay
PDelL2  clrwdt              ; 1 cycle delay
        return              ; 2+2 Done
;-------------------------------------------------------------


	
		
;*********************************************************************
;                      PROGRAMME PRINCIPAL                           *
;*********************************************************************

start

	clrwdt			; effacer watch dog
	btfsc	PORTB,2		; tester RB2 pour le mode
	goto	start
	btfss	PORTB,3		; tester RB3 pour le mode
	goto	modeessai
	goto	start


modeessai			; mode autonome en sens normal et 1/2 pas
	incf	cmpt,f
	movlw	8		; w=8
	subwf	cmpt,w		; w=cmpt-w
	btfsc	STATUS,Z	; tester le resultat
	clrf	cmpt		; compteur a 0
	movf	PORTB,w
	andlw	B'00001111'	; appliquer le masque pour conserver RB[0-3]
	movwf	temp		; conserver PORTB masquer
	movf	cmpt,w
	call	tableau		; appeller le tableau avec cmpt dans w
	iorwf	temp,w		; ne changer que les bits de poid fort
	movwf	PORTB		; transferer dans PORTB avec RB[0-3]

	call PDelay      	; Delay 10ms cycles (including call+return)

	call PDelay      	; Delay 10ms cycles (including call+return)

	goto	start


step
	movf	PORTB,w
	andlw	B'00001111'	; appliquer le masque pour conserver RB[0-3]
	movwf	temp		; conserver PORTB masquer
	movf	cmpt,w
	call	tableau		; appeller le tableau avec cmpt dans w
	iorwf	temp,w		; ne changer que les bits de poid fort
	movwf	PORTB		; transferer dans PORTB avec RB[0-3]
a	btfss	PORTB,0		; attendre la fin du creneau de clock(RB0)
	return			; sortir de l'interuption		
	goto	a



tableau
	addwf	PCL,f		;PCL=PCL+w
	retlw	B'10000000'	;0
	retlw	B'11000000'	;1
	retlw	B'01000000'	;2	
	retlw	B'01100000'	;3
	retlw	B'00100000'	;4
	retlw	B'00110000'	;5
	retlw	B'00010000'	;6
	retlw	B'10010000'	;7
	





	END 			; directive fin de programme

