#include "APP_IHM.h"
#include <stdio.h>
#include <stdlib.h>
#include <avr/pgmspace.h>

#define cAnimActive

//cSplashScreen Declaration {
const U8 IhmStringcSplashScreen1[] PROGMEM =  "Appli OieOieOie!";
const U8 IhmStringcSplashScreen2[] PROGMEM =  "  Version 1.00  ";
//cSplashScreen Declaration }

//cMainScreen Declaration   {
#define cCommandStartPosition        12
const U8 IhmStringcMainScreen1[] PROGMEM =    ".oO Tremie:     ";
const U8 IhmStringcMainScreen2[] PROGMEM =    "Consigne  :     ";
static S16 Wheight ;
static U8 weightToDisp[4];
static U8 commandCounter;
static U16 WheightCommand;
//cMainScreen Declaration   }

//cConfirmScreen Declaration {
#define cCommandConfStartPosition    9
const U8 IhmStringcConfirmScreen1[] PROGMEM = "Consigne     Kg?";
const U8 IhmStringcConfirmScreen2[] PROGMEM = "* = Non  # = Oui";
//cConfirmScreen Declaration }       

//cConfirmScreen Declaration {
const U8 IhmStringcWarnScreen1   [] PROGMEM = "Remplis en cours";
const U8 IhmStringcWarnScreen2   [] PROGMEM = "Annuler? # = Oui";
//cConfirmScreen Declaration }                             

//cConfigScreen Declaration {
#define cConfigStartPosition        12
const U8 IhmStringcConfigScreen1 [] PROGMEM = "Menu Config     ";
const U8 IhmStringcConfigScreen2 [] PROGMEM = "1:Manu    2:Tare";
//cConfigScreen Declaration }                             

//cManualScreen Declaration {
#define cManualStartPosition		12
const U8 IhmStringcManualScreen1[] PROGMEM     = ".oO Tremie:     ";
const U8 IhmStringcManualScreen2[] PROGMEM     = "1 = On   2 = Off";

#ifdef cAnimActive
const U8 IhmStringcManualScreenAnim0[] PROGMEM = "   ";
const U8 IhmStringcManualScreenAnim1[] PROGMEM = ".  ";
const U8 IhmStringcManualScreenAnim2[] PROGMEM = ".o ";
const U8 IhmStringcManualScreenAnim3[] PROGMEM = ".oO";
const U8 IhmStringcManualScreenAnim4[] PROGMEM = ".oO";

static U1 IhmManualAnimIsActive;
static U8 IhmManualAnimCounter;
static void AppIhmManualScreenCallBack(void);
#endif //cAnimActive
//cManualScreen Declaration }                             

static U8 IhmLcdBuffer[cNumberOfLines][cNumberOfCharSize];
static void (*AppIhmScreenList[cNumberOfScreen])(void);


static Screen IhmCurrentScreen;
static U8 AppIhmCallBackNumber;
static U8 AppActiveKey;


static void AppIhmSplashScreenCallBack(void)
{
    IhmCurrentScreen.ScreenType = cMainScreen;
    IhmCurrentScreen.IsBUilt = cFalse;
    IhmCurrentScreen.NeedRefresh = cFalse;
    MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
}

static void AppIhmSplashScreen(void)
{
    if(IhmCurrentScreen.IsBUilt == cFalse)
    {
        //wRITE SCREEN
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcSplashScreen1,cNumberOfChar);
        memcpy_P(&IhmLcdBuffer[cLineNumber_2],IhmStringcSplashScreen2,cNumberOfChar);
        
        AppIhmCallBackNumber = MdwTmrSubscribeCallBack(&AppIhmSplashScreenCallBack, 3000);
        
        IhmCurrentScreen.NeedRefresh = cTrue;        
        IhmCurrentScreen.IsBUilt     = cTrue;
    }
    else 
    {                
        if(AppActiveKey != cConsumedKey)
        {
            switch(AppActiveKey)
            {
            case cKey_00:
                MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
                IhmCurrentScreen.ScreenType = cConfigScreen;
                IhmCurrentScreen.IsBUilt = cFalse;                                
                break;
                
            }
            AppActiveKey = cConsumedKey;
        }
        else {}

    }
}

static void AppIhmMainScreen(void)
{
    if(IhmCurrentScreen.IsBUilt == cFalse)
    {
        //wRITE SCREEN
		//Wheight        = mMDWReadDataByIndex(cChannelEng,cCurrentWheight);
		WheightCommand = mMDWReadDataByIndex(cChannelEng,cWheightCommand);
        
		memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcMainScreen1,cNumberOfChar);
        sprintf((char*)weightToDisp,"%d",Wheight);
        mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
                
        memcpy_P(&IhmLcdBuffer[cLineNumber_2],IhmStringcMainScreen2,cNumberOfChar);
        sprintf((char*)weightToDisp,"%d",WheightCommand);
        mLibMemcpy(&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
        
        IhmCurrentScreen.NeedRefresh = cTrue;        
        IhmCurrentScreen.IsBUilt     = cTrue;
        
        commandCounter = 0;
        
#ifdef cAnimActive        
        if((IhmManualAnimIsActive == cFalse) && (mMDWReadDataByIndex(cChannelEng,cAutoManState) == cAutoOn))
        {
            IhmManualAnimCounter = 0;        
            AppIhmCallBackNumber = MdwTmrSubscribeCallBack(&AppIhmManualScreenCallBack, 233);
            IhmManualAnimIsActive = cTrue;
        } 
        else {}
#endif //cAnimActive
    }
    else 
    {        
        //Adc Display
        if(Wheight != mMDWReadDataByIndex(cChannelEng,cCurrentWheight))
        {
            Wheight = mMDWReadDataByIndex(cChannelEng,cCurrentWheight);
            sprintf((char*)weightToDisp,"%d",Wheight);
            mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
            IhmCurrentScreen.NeedRefresh = cTrue;
        }
        else {}
        
        if(AppActiveKey != cConsumedKey)
        {
            if(mMDWReadDataByIndex(cChannelEng,cAutoManState) == cAutoOff)
            {
                
            
                if((commandCounter == 0) && (AppActiveKey < cKey_ST))
                {
                    sprintf((char*)weightToDisp,"%d",(AppActiveKey+1));
                    mLibMemcpy(&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
                    commandCounter++;
                    IhmCurrentScreen.NeedRefresh = cTrue;
                    
                }
                
                else if((commandCounter < 3) && (AppActiveKey < cKey_ST))
                {
                    mLibMemcpy(weightToDisp,&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],sizeof(weightToDisp));
                    WheightCommand = (U16)atoi((char*)weightToDisp);
                    WheightCommand *= 10;
                    sprintf((char*)weightToDisp,"%d",(AppActiveKey+1+WheightCommand));
                    mLibMemcpy(&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
                    commandCounter++;
                    IhmCurrentScreen.NeedRefresh = cTrue;
                    
                }
                
                else if((commandCounter < 3) && (AppActiveKey == cKey_00))
                {
                    mLibMemcpy(weightToDisp,&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],sizeof(weightToDisp));
                    WheightCommand = (U16)atoi((char*)weightToDisp);
                    WheightCommand *= 10;
                    sprintf((char*)weightToDisp,"%d",WheightCommand);
                    mLibMemcpy(&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
                    commandCounter++;
                    IhmCurrentScreen.NeedRefresh = cTrue;
                    
                }
                else if((commandCounter > 0) && (AppActiveKey == cKey_ST))
                {
                    mLibMemcpy(weightToDisp,&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],sizeof(weightToDisp));
                    WheightCommand = (U16)atoi((char*)weightToDisp);
                    WheightCommand /= 10;
                    sprintf((char*)weightToDisp,"%d",WheightCommand);
                    mLibMemcpy(&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],weightToDisp,sizeof(weightToDisp));
                    commandCounter--;
                    IhmCurrentScreen.NeedRefresh = cTrue;
                    
                }
                else if((commandCounter > 0) &&(AppActiveKey == cKey_SH))
                {
                    mLibMemcpy(weightToDisp,&IhmLcdBuffer[cLineNumber_2][cCommandStartPosition],sizeof(weightToDisp));
                    WheightCommand = (U16)atoi((char*)weightToDisp);
                    IhmCurrentScreen.ScreenType = cConfirmScreen;
                    IhmCurrentScreen.IsBUilt = cFalse;
                }    
                else {}        
                AppActiveKey = cConsumedKey;
            }
            else
            {
#ifdef cAnimActive
                if((IhmManualAnimIsActive != cFalse) && (mMDWReadDataByIndex(cChannelEng,cAutoManState) == cAutoOn))
                {
                    MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
                    IhmManualAnimIsActive = cFalse;
                }
                else {}
#endif //cAnimActive
                IhmCurrentScreen.ScreenType = cWarnScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                IhmCurrentScreen.NeedRefresh = cFalse;
                AppActiveKey = cConsumedKey;
            }
        }
    }
}


static void AppIhmConfirmScreen(void)
{
    if(IhmCurrentScreen.IsBUilt == cFalse) 
    {
        //wRITE SCREEN
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcConfirmScreen1,cNumberOfChar);
        sprintf((char*)weightToDisp,"%d",WheightCommand);
        mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cCommandConfStartPosition],weightToDisp,sizeof(weightToDisp));
        memcpy_P(&IhmLcdBuffer[cLineNumber_2],IhmStringcConfirmScreen2,cNumberOfChar);
        
        IhmCurrentScreen.NeedRefresh = cTrue;        
        IhmCurrentScreen.IsBUilt     = cTrue;
    }
    else 
    {    

        if(AppActiveKey != cConsumedKey)
        {
            switch(AppActiveKey)
            {
            case cKey_ST:
                WheightCommand = 0;
                mMDWWriteDataByIndex(cChannelEng,WheightCommand,cWheightCommand);
                IhmCurrentScreen.ScreenType = cMainScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                break;
                
            case cKey_SH:    
                IhmCurrentScreen.ScreenType = cMainScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                mMDWWriteDataByIndex(cChannelEng,WheightCommand,cWheightCommand);
                mMDWWriteDataByIndex(cChannelEng,cAutoOn,cAutoManState);
                break;
            }
            AppActiveKey = cConsumedKey;
        }
        else {}
    }
}


static void AppIhmWarnScreenCallBack(void)
{
    IhmCurrentScreen.ScreenType = cMainScreen;
    IhmCurrentScreen.IsBUilt = cFalse;
    IhmCurrentScreen.NeedRefresh = cFalse;
    MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
}

static void AppIhmWarnScreen(void)
{
    if(IhmCurrentScreen.IsBUilt == cFalse)
    {
        //wRITE SCREEN
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcWarnScreen1,cNumberOfChar);
        memcpy_P(&IhmLcdBuffer[cLineNumber_2],IhmStringcWarnScreen2,cNumberOfChar);

        AppIhmCallBackNumber = MdwTmrSubscribeCallBack(&AppIhmWarnScreenCallBack, 2000);
        
        IhmCurrentScreen.NeedRefresh = cTrue;        
        IhmCurrentScreen.IsBUilt     = cTrue;
    }
    else 
    {
        if(AppActiveKey != cConsumedKey)
        {
            switch(AppActiveKey)
            {  
            case cKey_SH:    
                IhmCurrentScreen.ScreenType = cMainScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                WheightCommand = 0;
                mMDWWriteDataByIndex(cChannelEng,WheightCommand,cWheightCommand);
                mMDWWriteDataByIndex(cChannelEng,cAutoOff,cAutoManState);
                break;
            }
            AppActiveKey = cConsumedKey;
        }
        else {}
    }
}

static void AppIhmConfigScreen(void)
{
    if(IhmCurrentScreen.IsBUilt == cFalse)
    {
        //wRITE SCREEN
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcConfigScreen1,cNumberOfChar);
        memcpy_P(&IhmLcdBuffer[cLineNumber_2],IhmStringcConfigScreen2,cNumberOfChar);
		
		sprintf((char*)weightToDisp,"%d",Wheight);
		mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cConfigStartPosition],weightToDisp,sizeof(weightToDisp));
                                             
        IhmCurrentScreen.NeedRefresh = cTrue;        
        IhmCurrentScreen.IsBUilt     = cTrue;
    }
    else 
    {
		if(Wheight != mMDWReadDataByIndex(cChannelEng,cCurrentWheight))
        {
            Wheight = mMDWReadDataByIndex(cChannelEng,cCurrentWheight);
            sprintf((char*)weightToDisp,"%d",Wheight);
            mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cConfigStartPosition],weightToDisp,sizeof(weightToDisp));
            IhmCurrentScreen.NeedRefresh = cTrue;
        }
        else {}
        if(AppActiveKey != cConsumedKey)
        {
            switch(AppActiveKey)
            {
            case cKey_01:
                IhmCurrentScreen.ScreenType = cManualScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                break;
                
            case cKey_02:
                mMDWWriteDataByIndex(cChannelEng,0,cZeroSensor);
                IhmCurrentScreen.ScreenType = cConfigScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                break;
                
            case cKey_ST:
                IhmCurrentScreen.ScreenType = cSplashScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                break;
            }
            AppActiveKey = cConsumedKey;
        }
        else {}
    }
}
#ifdef cAnimActive
static void AppIhmManualScreenCallBack(void)
{
    IhmManualAnimCounter++;
    
    switch(IhmManualAnimCounter)
    {
    case cAnimState0:
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcManualScreenAnim0,3);
        break;
    
    case cAnimState1:
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcManualScreenAnim1,3);
        break;

    case cAnimState2:
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcManualScreenAnim2,3);
        break;

    case cAnimState3:
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcManualScreenAnim3,3);
        break;

    case cAnimState4:
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcManualScreenAnim4,3);
        IhmManualAnimCounter = 0;
        break;
    }
    
    IhmCurrentScreen.NeedRefresh = cTrue;

}
#endif //cAnimActive


static void AppIhmManualScreen(void)
{
    if(IhmCurrentScreen.IsBUilt == cFalse)
    {
        //wRITE SCREEN
        memcpy_P(&IhmLcdBuffer[cLineNumber_1],IhmStringcManualScreen1,cNumberOfChar);
        memcpy_P(&IhmLcdBuffer[cLineNumber_2],IhmStringcManualScreen2,cNumberOfChar);

		sprintf((char*)weightToDisp,"%d",Wheight);
		mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cManualStartPosition],weightToDisp,sizeof(weightToDisp));
        
        IhmCurrentScreen.NeedRefresh = cTrue;        
        IhmCurrentScreen.IsBUilt     = cTrue;
    }
    else 
    {   
		if(Wheight != mMDWReadDataByIndex(cChannelEng,cCurrentWheight))
        {
            Wheight = mMDWReadDataByIndex(cChannelEng,cCurrentWheight);
            sprintf((char*)weightToDisp,"%d",Wheight);
            mLibMemcpy(&IhmLcdBuffer[cLineNumber_1][cManualStartPosition],weightToDisp,sizeof(weightToDisp));
            IhmCurrentScreen.NeedRefresh = cTrue;
        }
        else {}
		
        if(AppActiveKey != cConsumedKey)
        {
            switch(AppActiveKey)
            {
            case cKey_01:
				mMDWWriteDataByIndex(cChannelEng,cManOn,cAutoManState);
#ifdef cAnimActive
                if(IhmManualAnimIsActive == cFalse)
                {
                    IhmManualAnimCounter = 0;        
                    AppIhmCallBackNumber = MdwTmrSubscribeCallBack(&AppIhmManualScreenCallBack, 233);
                    IhmManualAnimIsActive = cTrue;
                }
#endif //cAnimActive  
                break;

      
            case cKey_02:
				mMDWWriteDataByIndex(cChannelEng,cManOff,cAutoManState);
#ifdef cAnimActive
                if(IhmManualAnimIsActive != cFalse)
                {
                    MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
                    IhmCurrentScreen.ScreenType = cManualScreen;
                    IhmCurrentScreen.IsBUilt = cFalse;
                    IhmManualAnimIsActive = cFalse;
                }
#endif //cAnimActive       
                break;
                
            case cKey_ST:
				mMDWWriteDataByIndex(cChannelEng,cManOff,cAutoManState);
#ifdef cAnimActive            
                if(IhmManualAnimIsActive != cFalse)
                {
                    MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
                    IhmCurrentScreen.IsBUilt = cFalse;
                    IhmManualAnimIsActive = cFalse;
                }
#endif //cAnimActive       
                IhmCurrentScreen.ScreenType = cConfigScreen;
                IhmCurrentScreen.IsBUilt = cFalse;
                break;
                
            }
            AppActiveKey = cConsumedKey;
        }
        else {}
    }
}

void AppIhmInit(void)
{
    mLibMemset(IhmLcdBuffer,0,sizeof(IhmLcdBuffer));
    
    IhmCurrentScreen.ScreenType = cSplashScreen;
    IhmCurrentScreen.IsBUilt = cFalse;
    IhmCurrentScreen.NeedRefresh = cFalse;

#ifdef cAnimActive    
    IhmManualAnimCounter = 1;
    IhmManualAnimIsActive = cFalse;
#endif //cAnimActive

    AppIhmScreenList[cSplashScreen] = &AppIhmSplashScreen;
    AppIhmScreenList[cMainScreen]   = &AppIhmMainScreen;
    AppIhmScreenList[cConfirmScreen]= &AppIhmConfirmScreen;
    AppIhmScreenList[cWarnScreen]   = &AppIhmWarnScreen;
    AppIhmScreenList[cConfigScreen] = &AppIhmConfigScreen;
    AppIhmScreenList[cManualScreen] = &AppIhmManualScreen;
  
    
    AppActiveKey = cConsumedKey;

}

void AppIhmRefresh(void)
{
    U8 LineNumber = cLineNumber_1;
    U8 Position   = 0;
    
    if((mMDWReadDataByIndex(cChannelKbd,cReadReleasedkey) != cConsumedKey) &&
       (AppActiveKey == cConsumedKey)
      )
    {
        AppActiveKey = mMDWReadDataByIndex(cChannelKbd,cReadReleasedkey);
        mMDWReadDataByIndex(cChannelKbd,cClearKeyState);
    }
    else {}
    
    if((IhmCurrentScreen.ScreenType < cNumberOfScreen) &&
       (AppIhmScreenList[IhmCurrentScreen.ScreenType] != NULL)
      ) 
    {
        AppIhmScreenList[IhmCurrentScreen.ScreenType]();
    }

    
    if(IhmCurrentScreen.NeedRefresh != cFalse)
    {
        mMDWWriteDataByIndex(cChannelLcd,&LineNumber  ,cLineNumber);
        mMDWWriteDataByIndex(cChannelLcd,&Position    ,cCursorPosition);
        mMDWWriteDataByIndex(cChannelLcd,IhmLcdBuffer[cLineNumber_1]    ,cDataTosend);
        
        LineNumber = cLineNumber_2;
        
        mMDWWriteDataByIndex(cChannelLcd,&LineNumber  ,cLineNumber);
        mMDWWriteDataByIndex(cChannelLcd,&Position    ,cCursorPosition);
        mMDWWriteDataByIndex(cChannelLcd,IhmLcdBuffer[cLineNumber_2]    ,cDataTosend);
        
        IhmCurrentScreen.NeedRefresh = cFalse;
    }
}

void IhmExternRefresh(void)
{
    IhmCurrentScreen.NeedRefresh = cTrue;
#ifdef cAnimActive
	if(IhmManualAnimIsActive != cFalse)
	{
		MdwTmrUnsubscribeCallBack(AppIhmCallBackNumber);
		IhmCurrentScreen.IsBUilt = cFalse;
		IhmManualAnimIsActive = cFalse;
	}
#endif
}