#include "DRV_KBD.h"

//       Keyboard Matrix
//                      Input_F       PORTB3
//              F E D   Input_E       PORTB4 
//              ^ ^ ^   Input_D       PORTB5 
//              | | |    
//          K-> 1 2 3   Output_K      PORTC5 
//          J-> 4 5 6   Output_J      PORTB0 
//          H-> 7 8 9   Output_H      PORTB1 
//          G-> * 0 #   Output_G      PORTB2 
//                       
                       
static U8  KeyCount[2][cNumberOfKeys];
static U16 KeyPressed;
static U16 KeyReleased;
static U8 LocalCounter;
                        
void DRVKbdinit(void)
{
    DDRC  |=  (1<<PORTC5); // Output_K
    DDRB  |=  (1<<PORTB0); // Output_J
    DDRB  |=  (1<<PORTB1); // Output_H
    DDRB  |=  (1<<PORTB2); // Output_G
                            
    
    DDRB  &= ~(1<<PORTB3); // Input_F
    DDRB  &= ~(1<<PORTB4); // Input_E
    DDRB  &= ~(1<<PORTB5); // Input_D
                               
    
    PORTB &= ~(1<<PORTB3); // Input_F
    PORTB &= ~(1<<PORTB4); // Input_E
    PORTB &= ~(1<<PORTB5); // Input_D
                               
}


static void DRVKbdScanKeys(void)
{    
    PORTC |=  (1<<PORTC5);
    mLibNop();
    if((PINB >> PORTB3) & 0x01) KeyCount[cKeyPressed][cKey_01] += 1  ; // F
    else if (KeyPressed & (1<<cKey_01)) KeyCount[cKeyReleased][cKey_01] += 1  ;
    if((PINB >> PORTB4) & 0x01) KeyCount[cKeyPressed][cKey_02] += 1  ; // E
    else if (KeyPressed & (1<<cKey_02)) KeyCount[cKeyReleased][cKey_02] += 1  ;
    if((PINB >> PORTB5) & 0x01) KeyCount[cKeyPressed][cKey_03] += 1  ; // D
    else if (KeyPressed & (1<<cKey_03)) KeyCount[cKeyReleased][cKey_03] += 1  ;
    PORTC &= ~(1<<PORTC5);  

    mLibNop();

    PORTB |=  (1<<PORTB0);
    mLibNop();
    if((PINB >> PORTB3) & 0x01) KeyCount[cKeyPressed][cKey_04] += 1  ; // F
    else if (KeyPressed & (1<<cKey_04)) KeyCount[cKeyReleased][cKey_04] += 1  ;
    if((PINB >> PORTB4) & 0x01) KeyCount[cKeyPressed][cKey_05] += 1  ; // E
    else if (KeyPressed & (1<<cKey_05)) KeyCount[cKeyReleased][cKey_05] += 1  ;
    if((PINB >> PORTB5) & 0x01) KeyCount[cKeyPressed][cKey_06] += 1  ; // D
    else if (KeyPressed & (1<<cKey_06)) KeyCount[cKeyReleased][cKey_06] += 1  ;
    PORTB &= ~(1<<PORTB0);            

    mLibNop();

    PORTB |=  (1<<PORTB1);
    mLibNop();
    if((PINB >> PORTB3) & 0x01) KeyCount[cKeyPressed][cKey_07] += 1  ; // F
    else if (KeyPressed & (1<<cKey_07)) KeyCount[cKeyReleased][cKey_07] += 1  ;
    if((PINB >> PORTB4) & 0x01) KeyCount[cKeyPressed][cKey_08] += 1  ; // E
    else if (KeyPressed & (1<<cKey_08)) KeyCount[cKeyReleased][cKey_08] += 1  ;
    if((PINB >> PORTB5) & 0x01) KeyCount[cKeyPressed][cKey_09] += 1  ; // D
    else if (KeyPressed & (1<<cKey_09)) KeyCount[cKeyReleased][cKey_09] += 1  ;
    PORTB &= ~(1<<PORTB1);              
 
    mLibNop();

    PORTB |=  (1<<PORTB2);
    mLibNop();
    if((PINB >> PORTB3) & 0x01) KeyCount[cKeyPressed][cKey_ST] += 1  ; // F
    else if (KeyPressed & (1<<cKey_ST)) KeyCount[cKeyReleased][cKey_ST] += 1  ;
    if((PINB >> PORTB4) & 0x01) KeyCount[cKeyPressed][cKey_00] += 1  ; // E
    else if (KeyPressed & (1<<cKey_00)) KeyCount[cKeyReleased][cKey_00] += 1  ;
    if((PINB >> PORTB5) & 0x01) KeyCount[cKeyPressed][cKey_SH] += 1  ; // D
    else if (KeyPressed & (1<<cKey_SH)) KeyCount[cKeyReleased][cKey_SH] += 1  ;
    PORTB &= ~(1<<PORTB2);      


    
    for(LocalCounter = 0;LocalCounter < cNumberOfKeys; LocalCounter++)
    {
        if(KeyCount[cKeyPressed][LocalCounter]  > cKeyPressedFilterThereshold)  KeyPressed  |= (1 << LocalCounter);
        if(KeyCount[cKeyReleased][LocalCounter] > cKeyReleasedFilterThereshold) KeyReleased |= (1 << LocalCounter);
    }
    
 
}


void DRVKbdCommand(tAddress aAddr,Buffer * aBuffer)
{
    switch(aAddr)
    {
    case cScanKeyboard:
        DRVKbdScanKeys();
        break;
        
    case cReadPressedkey:
        mLibMemcpy(aBuffer->Address,&KeyPressed,sizeof(KeyPressed));
        break;
       
    case cReadReleasedkey:
        mLibMemcpy(aBuffer->Address,&KeyReleased,sizeof(KeyPressed));
        break;
        
    case cClearKeyState:
        KeyPressed = 0;
        KeyReleased= 0;
        mLibMemset(KeyCount,0,24);
        break;
        
#ifdef AssertActive        
    default:

        mLibAssert(cTrue);
        break;
#endif        
    }    

}












