#ifndef DRV_REG_RW
#define DRV_REG_RW

#include <avr/io.h>


// Reg Access Macros
#define mWriteReg(RegName,Data)					mWriteReg##RegName(Data)
#define mReadReg(RegName)						mReadReg##RegName()
#define mWrite1BitInReg(RegName,Data,BitNb)		mWrite1BitInReg##RegName(Data,BitNb)
#define mRead1BitInReg(RegName,BitNb)			mRead1BitInReg##RegName(BitNb)


//Write
#define mWriteRegOTGTCON(Data)          (OTGTCON = Data)
#define mWriteRegUPINT(Data)            (UPINT = Data)
#define mWriteRegUPBCHX(Data)           (UPBCHX = Data)
#define mWriteRegUPBCLX(Data)           (UPBCLX = Data)
#define mWriteRegUPERRX(Data)           (UPERRX = Data)
#define mWriteRegUEINT(Data)            (UEINT = Data)
#define mWriteRegUEBCHX(Data)           (UEBCHX = Data)
#define mWriteRegUEBCLX(Data)           (UEBCLX = Data)
#define mWriteRegUEDATX(Data)           (UEDATX = Data)
#define mWriteRegUEIENX(Data)           (UEIENX = Data)
#define mWriteRegUESTA1X(Data)          (UESTA1X = Data)
#define mWriteRegUESTA0X(Data)          (UESTA0X = Data)
#define mWriteRegUECFG1X(Data)          (UECFG1X = Data)
#define mWriteRegUECFG0X(Data)          (UECFG0X = Data)
#define mWriteRegUECONX(Data)           (UECONX = Data)
#define mWriteRegUERST(Data)            (UERST = Data)
#define mWriteRegUENUM(Data)            (UENUM = Data)
#define mWriteRegUEINTX(Data)           (UEINTX = Data)
#define mWriteRegUDTST(Data)            (UDTST = Data)
#define mWriteRegUDMFN(Data)            (UDMFN = Data)
#define mWriteRegUDFNUMH(Data)          (UDFNUMH = Data)
#define mWriteRegUDFNUML(Data)          (UDFNUML = Data)
#define mWriteRegUDADDR(Data)           (UDADDR = Data)
#define mWriteRegUDIEN(Data)            (UDIEN = Data)
#define mWriteRegUDINT(Data)            (UDINT = Data)
#define mWriteRegUDCON(Data)            (UDCON = Data)
#define mWriteRegOTGINT(Data)           (OTGINT = Data)
#define mWriteRegOTGIEN(Data)           (OTGIEN = Data)
#define mWriteRegOTGCON(Data)           (OTGCON = Data)
#define mWriteRegUDPADDH(Data)          (UDPADDH = Data)
#define mWriteRegUDPADDL(Data)          (UDPADDL = Data)
#define mWriteRegUSBINT(Data)           (USBINT = Data)
#define mWriteRegUSBSTA(Data)           (USBSTA = Data)
#define mWriteRegUSBCON(Data)           (USBCON = Data)
#define mWriteRegUHWCON(Data)           (UHWCON = Data)
#define mWriteRegUDR1(Data)             (UDR1 = Data)
#define mWriteRegUBRR1H(Data)           (UBRR1H = Data)
#define mWriteRegUBRR1L(Data)           (UBRR1L = Data)
#define mWriteRegUCSR1C(Data)           (UCSR1C = Data)
#define mWriteRegUCSR1B(Data)           (UCSR1B = Data)
#define mWriteRegUCSR1A(Data)           (UCSR1A = Data)
#define mWriteRegTWAMR(Data)            (TWAMR = Data)
#define mWriteRegTWCR(Data)             (TWCR = Data)
#define mWriteRegTWDR(Data)             (TWDR = Data)
#define mWriteRegTWAR(Data)             (TWAR = Data)
#define mWriteRegTWSR(Data)             (TWSR = Data)
#define mWriteRegTWBR(Data)             (TWBR = Data)
#define mWriteRegASSR(Data)             (ASSR = Data)
#define mWriteRegOCR2B(Data)            (OCR2B = Data)
#define mWriteRegOCR2A(Data)            (OCR2A = Data)
#define mWriteRegTCNT2(Data)            (TCNT2 = Data)
#define mWriteRegTCCR2B(Data)           (TCCR2B = Data)
#define mWriteRegTCCR2A(Data)           (TCCR2A = Data)
#define mWriteRegUPDATX(Data)           (UPDATX = Data)
#define mWriteRegUPIENX(Data)           (UPIENX = Data)
#define mWriteRegUPCFG2X(Data)          (UPCFG2X = Data)
#define mWriteRegUPSTAX(Data)           (UPSTAX = Data)
#define mWriteRegUPCFG1X(Data)          (UPCFG1X = Data)
#define mWriteRegUPCFG0X(Data)          (UPCFG0X = Data)
#define mWriteRegUPCONX(Data)           (UPCONX = Data)
#define mWriteRegUPRST(Data)            (UPRST = Data)
#define mWriteRegUPNUM(Data)            (UPNUM = Data)
#define mWriteRegUPINTX(Data)           (UPINTX = Data)
#define mWriteRegUPINRQX(Data)          (UPINRQX = Data)
#define mWriteRegUHFLEN(Data)           (UHFLEN = Data)
#define mWriteRegUHFNUMH(Data)          (UHFNUMH = Data)
#define mWriteRegUHFNUML(Data)          (UHFNUML = Data)
#define mWriteRegUHADDR(Data)           (UHADDR = Data)
#define mWriteRegUHIEN(Data)            (UHIEN = Data)
#define mWriteRegUHINT(Data)            (UHINT = Data)
#define mWriteRegUHCON(Data)            (UHCON = Data)
#define mWriteRegOCR3CH(Data)           (OCR3CH = Data)
#define mWriteRegOCR3CL(Data)           (OCR3CL = Data)
#define mWriteRegOCR3BH(Data)           (OCR3BH = Data)
#define mWriteRegOCR3BL(Data)           (OCR3BL = Data)
#define mWriteRegOCR3AH(Data)           (OCR3AH = Data)
#define mWriteRegOCR3AL(Data)           (OCR3AL = Data)
#define mWriteRegICR3H(Data)            (ICR3H = Data)
#define mWriteRegICR3L(Data)            (ICR3L = Data)
#define mWriteRegTCNT3H(Data)           (TCNT3H = Data)
#define mWriteRegTCNT3L(Data)           (TCNT3L = Data)
#define mWriteRegTCCR3C(Data)           (TCCR3C = Data)
#define mWriteRegTCCR3B(Data)           (TCCR3B = Data)
#define mWriteRegTCCR3A(Data)           (TCCR3A = Data)
#define mWriteRegOCR1CH(Data)           (OCR1CH = Data)
#define mWriteRegOCR1CL(Data)           (OCR1CL = Data)
#define mWriteRegOCR1BH(Data)           (OCR1BH = Data)
#define mWriteRegOCR1BL(Data)           (OCR1BL = Data)
#define mWriteRegOCR1AH(Data)           (OCR1AH = Data)
#define mWriteRegOCR1AL(Data)           (OCR1AL = Data)
#define mWriteRegICR1H(Data)            (ICR1H = Data)
#define mWriteRegICR1L(Data)            (ICR1L = Data)
#define mWriteRegTCNT1H(Data)           (TCNT1H = Data)
#define mWriteRegTCNT1L(Data)           (TCNT1L = Data)
#define mWriteRegTCCR1C(Data)           (TCCR1C = Data)
#define mWriteRegTCCR1B(Data)           (TCCR1B = Data)
#define mWriteRegTCCR1A(Data)           (TCCR1A = Data)
#define mWriteRegDIDR1(Data)            (DIDR1 = Data)
#define mWriteRegDIDR0(Data)            (DIDR0 = Data)
#define mWriteRegADMUX(Data)            (ADMUX = Data)
#define mWriteRegADCSRB(Data)           (ADCSRB = Data)
#define mWriteRegADCSRA(Data)           (ADCSRA = Data)
#define mWriteRegADCH(Data)             (ADCH = Data)
#define mWriteRegADCL(Data)             (ADCL = Data)
#define mWriteRegXMCRB(Data)            (XMCRB = Data)
#define mWriteRegXMCRA(Data)            (XMCRA = Data)
#define mWriteRegTIMSK3(Data)           (TIMSK3 = Data)
#define mWriteRegTIMSK2(Data)           (TIMSK2 = Data)
#define mWriteRegTIMSK1(Data)           (TIMSK1 = Data)
#define mWriteRegTIMSK0(Data)           (TIMSK0 = Data)
#define mWriteRegPCMSK0(Data)           (PCMSK0 = Data)
#define mWriteRegEICRB(Data)            (EICRB = Data)
#define mWriteRegEICRA(Data)            (EICRA = Data)
#define mWriteRegPCICR(Data)            (PCICR = Data)
#define mWriteRegOSCCAL(Data)           (OSCCAL = Data)
#define mWriteRegPRR1(Data)             (PRR1 = Data)
#define mWriteRegPRR0(Data)             (PRR0 = Data)
#define mWriteRegCLKPR(Data)            (CLKPR = Data)
#define mWriteRegWDTCSR(Data)           (WDTCSR = Data)
#define mWriteRegSREG(Data)             (SREG = Data)
#define mWriteRegSPH(Data)              (SPH = Data)
#define mWriteRegSPL(Data)              ( SPL = Data)
#define mWriteRegRAMPZ(Data)            ( RAMPZ = Data)
#define mWriteRegSPMCSR(Data)           (SPMCSR = Data)
#define mWriteRegMCUCR(Data)            (MCUCR = Data)
#define mWriteRegMCUSR(Data)            (MCUSR = Data)
#define mWriteRegSMCR(Data)             (SMCR = Data)
#define mWriteRegOCDR(Data)             (OCDR = Data)
#define mWriteRegMONDR(Data)            (MONDR = Data)
#define mWriteRegACSR(Data)             (ACSR = Data)
#define mWriteRegSPDR(Data)             (SPDR = Data)
#define mWriteRegSPSR(Data)             (SPSR = Data)
#define mWriteRegSPCR(Data)             (SPCR = Data)
#define mWriteRegGPIOR2(Data)           (GPIOR2 = Data)
#define mWriteRegGPIOR1(Data)           (GPIOR1 = Data)
#define mWriteRegPLLCSR(Data)           (PLLCSR = Data)
#define mWriteRegOCR0B(Data)            (OCR0B = Data)
#define mWriteRegOCR0A(Data)            (OCR0A = Data)
#define mWriteRegTCNT0(Data)            (TCNT0 = Data)
#define mWriteRegTCCR0B(Data)           (TCCR0B = Data)
#define mWriteRegTCCR0A(Data)           (TCCR0A = Data)
#define mWriteRegGTCCR(Data)            (GTCCR = Data)
#define mWriteRegEEARH(Data)            (EEARH = Data)
#define mWriteRegEEARL(Data)            (EEARL = Data)
#define mWriteRegEEDR(Data)             (EEDR = Data)
#define mWriteRegEECR(Data)             (EECR = Data)
#define mWriteRegGPIOR0(Data)           (GPIOR0 = Data)
#define mWriteRegEIMSK(Data)            (EIMSK = Data)
#define mWriteRegEIFR(Data)             (EIFR = Data)
#define mWriteRegPCIFR(Data)            (PCIFR = Data)
#define mWriteRegTIFR3(Data)            (TIFR3 = Data)
#define mWriteRegTIFR2(Data)            (TIFR2 = Data)
#define mWriteRegTIFR1(Data)            (TIFR1 = Data)
#define mWriteRegTIFR0(Data)            (TIFR0 = Data)
#define mWriteRegPORTF(Data)            (PORTF = Data)
#define mWriteRegDDRF(Data)             (DDRF = Data)
#define mWriteRegPINF(Data)             (PINF = Data)
#define mWriteRegPORTE(Data)            (PORTE = Data)
#define mWriteRegDDRE(Data)             (DDRE = Data)
#define mWriteRegPINE(Data)             (PINE = Data)
#define mWriteRegPORTD(Data)            (PORTD = Data)
#define mWriteRegDDRD(Data)             (DDRD = Data)
#define mWriteRegPIND(Data)             (PIND = Data)
#define mWriteRegPORTC(Data)            (PORTC = Data)
#define mWriteRegDDRC(Data)             (DDRC = Data)
#define mWriteRegPINC(Data)             (PINC = Data)
#define mWriteRegPORTB(Data)            (PORTB = Data)
#define mWriteRegDDRB(Data)             (DDRB = Data)
#define mWriteRegPINB(Data)             (PINB = Data)
#define mWriteRegPORTA(Data)            (PORTA = Data)
#define mWriteRegDDRA(Data)             (DDRA = Data)
#define mWriteRegPINA(Data)             (PINA = Data)

//Read
#define mReadRegOTGTCON()               (U8)(OTGTCON)
#define mReadRegUPINT()                 (U8)(UPINT)
#define mReadRegUPBCHX()                (U8)(UPBCHX)
#define mReadRegUPBCLX()                (U8)(UPBCLX)
#define mReadRegUPERRX()                (U8)(UPERRX)
#define mReadRegUEINT()                 (U8)(UEINT)
#define mReadRegUEBCHX()                (U8)(UEBCHX)
#define mReadRegUEBCLX()                (U8)(UEBCLX)
#define mReadRegUEDATX()                (U8)(UEDATX)
#define mReadRegUEIENX()                (U8)(UEIENX)
#define mReadRegUESTA1X()               (U8)(UESTA1X)
#define mReadRegUESTA0X()               (U8)(UESTA0X)
#define mReadRegUECFG1X()               (U8)(UECFG1X)
#define mReadRegUECFG0X()               (U8)(UECFG0X)
#define mReadRegUECONX()                (U8)(UECONX)
#define mReadRegUERST()                 (U8)(UERST)
#define mReadRegUENUM()                 (U8)(UENUM)
#define mReadRegUEINTX()                (U8)(UEINTX)
#define mReadRegUDTST()                 (U8)(UDTST)
#define mReadRegUDMFN()                 (U8)(UDMFN)
#define mReadRegUDFNUMH()               (U8)(UDFNUMH)
#define mReadRegUDFNUML()               (U8)(UDFNUML)
#define mReadRegUDADDR()                (U8)(UDADDR)
#define mReadRegUDIEN()                 (U8)(UDIEN)
#define mReadRegUDINT()                 (U8)(UDINT)
#define mReadRegUDCON()                 (U8)(UDCON)
#define mReadRegOTGINT()                (U8)(OTGINT)
#define mReadRegOTGIEN()                (U8)(OTGIEN)
#define mReadRegOTGCON()                (U8)(OTGCON)
#define mReadRegUDPADDH()               (U8)(UDPADDH)
#define mReadRegUDPADDL()               (U8)(UDPADDL)
#define mReadRegUSBINT()                (U8)(USBINT)
#define mReadRegUSBSTA()                (U8)(USBSTA)
#define mReadRegUSBCON()                (U8)(USBCON)
#define mReadRegUHWCON()                (U8)(UHWCON)
#define mReadRegUDR1()                  (U8)(UDR1)
#define mReadRegUBRR1H()                (U8)(UBRR1H)
#define mReadRegUBRR1L()                (U8)(UBRR1L)
#define mReadRegUCSR1C()                (U8)(UCSR1C)
#define mReadRegUCSR1B()                (U8)(UCSR1B)
#define mReadRegUCSR1A()                (U8)(UCSR1A)
#define mReadRegTWAMR()                 (U8)(TWAMR)
#define mReadRegTWCR()                  (U8)(TWCR)
#define mReadRegTWDR()                  (U8)(TWDR)
#define mReadRegTWAR()                  (U8)(TWAR)
#define mReadRegTWSR()                  (U8)(TWSR)
#define mReadRegTWBR()                  (U8)(TWBR)
#define mReadRegASSR()                  (U8)(ASSR)
#define mReadRegOCR2B()                 (U8)(OCR2B)
#define mReadRegOCR2A()                 (U8)(OCR2A)
#define mReadRegTCNT2()                 (U8)(TCNT2)
#define mReadRegTCCR2B()                (U8)(TCCR2B)
#define mReadRegTCCR2A()                (U8)(TCCR2A)
#define mReadRegUPDATX()                (U8)(UPDATX)
#define mReadRegUPIENX()                (U8)(UPIENX)
#define mReadRegUPCFG2X()               (U8)(UPCFG2X)
#define mReadRegUPSTAX()                (U8)(UPSTAX)
#define mReadRegUPCFG1X()               (U8)(UPCFG1X)
#define mReadRegUPCFG0X()               (U8)(UPCFG0X)
#define mReadRegUPCONX()                (U8)(UPCONX)
#define mReadRegUPRST()                 (U8)(UPRST)
#define mReadRegUPNUM()                 (U8)(UPNUM)
#define mReadRegUPINTX()                (U8)(UPINTX)
#define mReadRegUPINRQX()               (U8)(UPINRQX)
#define mReadRegUHFLEN()                (U8)(UHFLEN)
#define mReadRegUHFNUMH()               (U8)(UHFNUMH)
#define mReadRegUHFNUML()               (U8)(UHFNUML)
#define mReadRegUHADDR()                (U8)(UHADDR)
#define mReadRegUHIEN()                 (U8)(UHIEN)
#define mReadRegUHINT()                 (U8)(UHINT)
#define mReadRegUHCON()                 (U8)(UHCON)
#define mReadRegOCR3CH()                (U8)(OCR3CH)
#define mReadRegOCR3CL()                (U8)(OCR3CL)
#define mReadRegOCR3BH()                (U8)(OCR3BH)
#define mReadRegOCR3BL()                (U8)(OCR3BL)
#define mReadRegOCR3AH()                (U8)(OCR3AH)
#define mReadRegOCR3AL()                (U8)(OCR3AL)
#define mReadRegICR3H()                 (U8)(ICR3H)
#define mReadRegICR3L()                 (U8)(ICR3L)
#define mReadRegTCNT3H()                (U8)(TCNT3H)
#define mReadRegTCNT3L()                (U8)(TCNT3L)
#define mReadRegTCCR3C()                (U8)(TCCR3C)
#define mReadRegTCCR3B()                (U8)(TCCR3B)
#define mReadRegTCCR3A()                (U8)(TCCR3A)
#define mReadRegOCR1CH()                (U8)(OCR1CH)
#define mReadRegOCR1CL()                (U8)(OCR1CL)
#define mReadRegOCR1BH()                (U8)(OCR1BH)
#define mReadRegOCR1BL()                (U8)(OCR1BL)
#define mReadRegOCR1AH()                (U8)(OCR1AH)
#define mReadRegOCR1AL()                (U8)(OCR1AL)
#define mReadRegICR1H()                 (U8)(ICR1H)
#define mReadRegICR1L()                 (U8)(ICR1L)
#define mReadRegTCNT1H()                (U8)(TCNT1H)
#define mReadRegTCNT1L()                (U8)(TCNT1L)
#define mReadRegTCCR1C()                (U8)(TCCR1C)
#define mReadRegTCCR1B()                (U8)(TCCR1B)
#define mReadRegTCCR1A()                (U8)(TCCR1A)
#define mReadRegDIDR1()                 (U8)(DIDR1)
#define mReadRegDIDR0()                 (U8)(DIDR0)
#define mReadRegADMUX()                 (U8)(ADMUX)
#define mReadRegADCSRB()                (U8)(ADCSRB)
#define mReadRegADCSRA()                (U8)(ADCSRA)
#define mReadRegADCH()                  (U8)(ADCH)
#define mReadRegADCL()                  (U8)(ADCL)
#define mReadRegXMCRB()                 (U8)(XMCRB)
#define mReadRegXMCRA()                 (U8)(XMCRA)
#define mReadRegTIMSK3()                (U8)(TIMSK3)
#define mReadRegTIMSK2()                (U8)(TIMSK2)
#define mReadRegTIMSK1()                (U8)(TIMSK1)
#define mReadRegTIMSK0()                (U8)(TIMSK0)
#define mReadRegPCMSK0()                (U8)(PCMSK0)
#define mReadRegEICRB()                 (U8)(EICRB)
#define mReadRegEICRA()                 (U8)(EICRA)
#define mReadRegPCICR()                 (U8)(PCICR)
#define mReadRegOSCCAL()                (U8)(OSCCAL)
#define mReadRegPRR1()                  (U8)(PRR1)
#define mReadRegPRR0()                  (U8)(PRR0)
#define mReadRegCLKPR()                 (U8)(CLKPR)
#define mReadRegWDTCSR()                (U8)(WDTCSR)
#define mReadRegSREG()                  (U8)(SREG)
#define mReadRegSPH()                   (U8)(SPH)
#define mReadRegSPL()                   (U8)( SPL)
#define mReadRegRAMPZ()                 (U8)( RAMPZ)
#define mReadRegSPMCSR()                (U8)(SPMCSR)
#define mReadRegMCUCR()                 (U8)(MCUCR)
#define mReadRegMCUSR()                 (U8)(MCUSR)
#define mReadRegSMCR()                  (U8)(SMCR)
#define mReadRegOCDR()                  (U8)(OCDR)
#define mReadRegMONDR()                 (U8)(MONDR)
#define mReadRegACSR()                  (U8)(ACSR)
#define mReadRegSPDR()                  (U8)(SPDR)
#define mReadRegSPSR()                  (U8)(SPSR)
#define mReadRegSPCR()                  (U8)(SPCR)
#define mReadRegGPIOR2()                (U8)(GPIOR2)
#define mReadRegGPIOR1()                (U8)(GPIOR1)
#define mReadRegPLLCSR()                (U8)(PLLCSR)
#define mReadRegOCR0B()                 (U8)(OCR0B)
#define mReadRegOCR0A()                 (U8)(OCR0A)
#define mReadRegTCNT0()                 (U8)(TCNT0)
#define mReadRegTCCR0B()                (U8)(TCCR0B)
#define mReadRegTCCR0A()                (U8)(TCCR0A)
#define mReadRegGTCCR()                 (U8)(GTCCR)
#define mReadRegEEARH()                 (U8)(EEARH)
#define mReadRegEEARL()                 (U8)(EEARL)
#define mReadRegEEDR()                  (U8)(EEDR)
#define mReadRegEECR()                  (U8)(EECR)
#define mReadRegGPIOR0()                (U8)(GPIOR0)
#define mReadRegEIMSK()                 (U8)(EIMSK)
#define mReadRegEIFR()                  (U8)(EIFR)
#define mReadRegPCIFR()                 (U8)(PCIFR)
#define mReadRegTIFR3()                 (U8)(TIFR3)
#define mReadRegTIFR2()                 (U8)(TIFR2)
#define mReadRegTIFR1()                 (U8)(TIFR1)
#define mReadRegTIFR0()                 (U8)(TIFR0)
#define mReadRegPORTF()                 (U8)(PORTF)
#define mReadRegDDRF()                  (U8)(DDRF)
#define mReadRegPINF()                  (U8)(PINF)
#define mReadRegPORTE()                 (U8)(PORTE)
#define mReadRegDDRE()                  (U8)(DDRE)
#define mReadRegPINE()                  (U8)(PINE)
#define mReadRegPORTD()                 (U8)(PORTD)
#define mReadRegDDRD()                  (U8)(DDRD)
#define mReadRegPIND()                  (U8)(PIND)
#define mReadRegPORTC()                 (U8)(PORTC)
#define mReadRegDDRC()                  (U8)(DDRC)
#define mReadRegPINC()                  (U8)(PINC)
#define mReadRegPORTB()                 (U8)(PORTB)
#define mReadRegDDRB()                  (U8)(DDRB)
#define mReadRegPINB()                  (U8)(PINB)
#define mReadRegPORTA()                 (U8)(PORTA)
#define mReadRegDDRA()                  (U8)(DDRA)
#define mReadRegPINA()                  (U8)(PINA)


//Write1BitInReg 
#define mWrite1BitInRegOTGTCON(Data,BitNb)          {  OTGTCON &= ~(1<<(BitNb)); OTGTCON |= (Data << BitNb);   }
#define mWrite1BitInRegUPINT(Data,BitNb)            {  UPINT &= ~(1<<(BitNb));   UPINT |= (Data << BitNb);     }
#define mWrite1BitInRegUPBCHX(Data,BitNb)           {  UPBCHX &= ~(1<<(BitNb));  UPBCHX |= (Data << BitNb);    }
#define mWrite1BitInRegUPBCLX(Data,BitNb)           {  UPBCLX &= ~(1<<(BitNb));  UPBCLX |= (Data << BitNb);    }
#define mWrite1BitInRegUPERRX(Data,BitNb)           {  UPERRX &= ~(1<<(BitNb));  UPERRX |= (Data << BitNb);    }
#define mWrite1BitInRegUEINT(Data,BitNb)            {  UEINT &= ~(1<<(BitNb));   UEINT |= (Data << BitNb);     }
#define mWrite1BitInRegUEBCHX(Data,BitNb)           {  UEBCHX &= ~(1<<(BitNb));  UEBCHX |= (Data << BitNb);    }
#define mWrite1BitInRegUEBCLX(Data,BitNb)           {  UEBCLX &= ~(1<<(BitNb));  UEBCLX |= (Data << BitNb);    }
#define mWrite1BitInRegUEDATX(Data,BitNb)           {  UEDATX &= ~(1<<(BitNb));  UEDATX |= (Data << BitNb);    }
#define mWrite1BitInRegUEIENX(Data,BitNb)           {  UEIENX &= ~(1<<(BitNb));  UEIENX |= (Data << BitNb);    }
#define mWrite1BitInRegUESTA1X(Data,BitNb)          {  UESTA1X &= ~(1<<(BitNb)); UESTA1X |= (Data << BitNb);   }
#define mWrite1BitInRegUESTA0X(Data,BitNb)          {  UESTA0X &= ~(1<<(BitNb)); UESTA0X |= (Data << BitNb);   }
#define mWrite1BitInRegUECFG1X(Data,BitNb)          {  UECFG1X &= ~(1<<(BitNb)); UECFG1X |= (Data << BitNb);   }
#define mWrite1BitInRegUECFG0X(Data,BitNb)          {  UECFG0X &= ~(1<<(BitNb)); UECFG0X |= (Data << BitNb);   }
#define mWrite1BitInRegUECONX(Data,BitNb)           {  UECONX &= ~(1<<(BitNb));  UECONX |= (Data << BitNb);    }
#define mWrite1BitInRegUERST(Data,BitNb)            {  UERST &= ~(1<<(BitNb));   UERST |= (Data << BitNb);     }
#define mWrite1BitInRegUENUM(Data,BitNb)            {  UENUM &= ~(1<<(BitNb));   UENUM |= (Data << BitNb);     }
#define mWrite1BitInRegUEINTX(Data,BitNb)           {  UEINTX &= ~(1<<(BitNb));  UEINTX |= (Data << BitNb);    }
#define mWrite1BitInRegUDTST(Data,BitNb)            {  UDTST &= ~(1<<(BitNb));   UDTST |= (Data << BitNb);     }
#define mWrite1BitInRegUDMFN(Data,BitNb)            {  UDMFN &= ~(1<<(BitNb));   UDMFN |= (Data << BitNb);     }
#define mWrite1BitInRegUDFNUMH(Data,BitNb)          {  UDFNUMH &= ~(1<<(BitNb)); UDFNUMH |= (Data << BitNb);   }
#define mWrite1BitInRegUDFNUML(Data,BitNb)          {  UDFNUML &= ~(1<<(BitNb)); UDFNUML |= (Data << BitNb);   }
#define mWrite1BitInRegUDADDR(Data,BitNb)           {  UDADDR &= ~(1<<(BitNb));  UDADDR |= (Data << BitNb);    }
#define mWrite1BitInRegUDIEN(Data,BitNb)            {  UDIEN &= ~(1<<(BitNb));   UDIEN |= (Data << BitNb);     }
#define mWrite1BitInRegUDINT(Data,BitNb)            {  UDINT &= ~(1<<(BitNb));   UDINT |= (Data << BitNb);     }
#define mWrite1BitInRegUDCON(Data,BitNb)            {  UDCON &= ~(1<<(BitNb));   UDCON |= (Data << BitNb);     }
#define mWrite1BitInRegOTGINT(Data,BitNb)           {  OTGINT &= ~(1<<(BitNb));  OTGINT |= (Data << BitNb);    }
#define mWrite1BitInRegOTGIEN(Data,BitNb)           {  OTGIEN &= ~(1<<(BitNb));  OTGIEN |= (Data << BitNb);    }
#define mWrite1BitInRegOTGCON(Data,BitNb)           {  OTGCON &= ~(1<<(BitNb));  OTGCON |= (Data << BitNb);    }
#define mWrite1BitInRegUDPADDH(Data,BitNb)          {  UDPADDH &= ~(1<<(BitNb)); UDPADDH |= (Data << BitNb);   }
#define mWrite1BitInRegUDPADDL(Data,BitNb)          {  UDPADDL &= ~(1<<(BitNb)); UDPADDL |= (Data << BitNb);   }
#define mWrite1BitInRegUSBINT(Data,BitNb)           {  USBINT &= ~(1<<(BitNb));  USBINT |= (Data << BitNb);    }
#define mWrite1BitInRegUSBSTA(Data,BitNb)           {  USBSTA &= ~(1<<(BitNb));  USBSTA |= (Data << BitNb);    }
#define mWrite1BitInRegUSBCON(Data,BitNb)           {  USBCON &= ~(1<<(BitNb));  USBCON |= (Data << BitNb);    }
#define mWrite1BitInRegUHWCON(Data,BitNb)           {  UHWCON &= ~(1<<(BitNb));  UHWCON |= (Data << BitNb);    }
#define mWrite1BitInRegUDR1(Data,BitNb)             {  UDR1 &= ~(1<<(BitNb));    UDR1 |= (Data << BitNb);      }
#define mWrite1BitInRegUBRR1H(Data,BitNb)           {  UBRR1H &= ~(1<<(BitNb));  UBRR1H |= (Data << BitNb);    }
#define mWrite1BitInRegUBRR1L(Data,BitNb)           {  UBRR1L &= ~(1<<(BitNb));  UBRR1L |= (Data << BitNb);    }
#define mWrite1BitInRegUCSR1C(Data,BitNb)           {  UCSR1C &= ~(1<<(BitNb));  UCSR1C |= (Data << BitNb);    }
#define mWrite1BitInRegUCSR1B(Data,BitNb)           {  UCSR1B &= ~(1<<(BitNb));  UCSR1B |= (Data << BitNb);    }
#define mWrite1BitInRegUCSR1A(Data,BitNb)           {  UCSR1A &= ~(1<<(BitNb));  UCSR1A |= (Data << BitNb);    }
#define mWrite1BitInRegTWAMR(Data,BitNb)            {  TWAMR &= ~(1<<(BitNb));   TWAMR |= (Data << BitNb);     }
#define mWrite1BitInRegTWCR(Data,BitNb)             {  TWCR &= ~(1<<(BitNb));    TWCR |= (Data << BitNb);      }
#define mWrite1BitInRegTWDR(Data,BitNb)             {  TWDR &= ~(1<<(BitNb));    TWDR |= (Data << BitNb);      }
#define mWrite1BitInRegTWAR(Data,BitNb)             {  TWAR &= ~(1<<(BitNb));    TWAR |= (Data << BitNb);      }
#define mWrite1BitInRegTWSR(Data,BitNb)             {  TWSR &= ~(1<<(BitNb));    TWSR |= (Data << BitNb);      }
#define mWrite1BitInRegTWBR(Data,BitNb)             {  TWBR &= ~(1<<(BitNb));    TWBR |= (Data << BitNb);      }
#define mWrite1BitInRegASSR(Data,BitNb)             {  ASSR &= ~(1<<(BitNb));    ASSR |= (Data << BitNb);      }
#define mWrite1BitInRegOCR2B(Data,BitNb)            {  OCR2B &= ~(1<<(BitNb));   OCR2B |= (Data << BitNb);     }
#define mWrite1BitInRegOCR2A(Data,BitNb)            {  OCR2A &= ~(1<<(BitNb));   OCR2A |= (Data << BitNb);     }
#define mWrite1BitInRegTCNT2(Data,BitNb)            {  TCNT2 &= ~(1<<(BitNb));   TCNT2 |= (Data << BitNb);     }
#define mWrite1BitInRegTCCR2B(Data,BitNb)           {  TCCR2B &= ~(1<<(BitNb));  TCCR2B |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR2A(Data,BitNb)           {  TCCR2A &= ~(1<<(BitNb));  TCCR2A |= (Data << BitNb);    }
#define mWrite1BitInRegUPDATX(Data,BitNb)           {  UPDATX &= ~(1<<(BitNb));  UPDATX |= (Data << BitNb);    }
#define mWrite1BitInRegUPIENX(Data,BitNb)           {  UPIENX &= ~(1<<(BitNb));  UPIENX |= (Data << BitNb);    }
#define mWrite1BitInRegUPCFG2X(Data,BitNb)          {  UPCFG2X &= ~(1<<(BitNb)); UPCFG2X |= (Data << BitNb);   }
#define mWrite1BitInRegUPSTAX(Data,BitNb)           {  UPSTAX &= ~(1<<(BitNb));  UPSTAX |= (Data << BitNb);    }
#define mWrite1BitInRegUPCFG1X(Data,BitNb)          {  UPCFG1X &= ~(1<<(BitNb)); UPCFG1X |= (Data << BitNb);   }
#define mWrite1BitInRegUPCFG0X(Data,BitNb)          {  UPCFG0X &= ~(1<<(BitNb)); UPCFG0X |= (Data << BitNb);   }
#define mWrite1BitInRegUPCONX(Data,BitNb)           {  UPCONX &= ~(1<<(BitNb));  UPCONX |= (Data << BitNb);    }
#define mWrite1BitInRegUPRST(Data,BitNb)            {  UPRST &= ~(1<<(BitNb));   UPRST |= (Data << BitNb);     }
#define mWrite1BitInRegUPNUM(Data,BitNb)            {  UPNUM &= ~(1<<(BitNb));   UPNUM |= (Data << BitNb);     }
#define mWrite1BitInRegUPINTX(Data,BitNb)           {  UPINTX &= ~(1<<(BitNb));  UPINTX |= (Data << BitNb);    }
#define mWrite1BitInRegUPINRQX(Data,BitNb)          {  UPINRQX &= ~(1<<(BitNb)); UPINRQX |= (Data << BitNb);   }
#define mWrite1BitInRegUHFLEN(Data,BitNb)           {  UHFLEN &= ~(1<<(BitNb));  UHFLEN |= (Data << BitNb);    }
#define mWrite1BitInRegUHFNUMH(Data,BitNb)          {  UHFNUMH &= ~(1<<(BitNb)); UHFNUMH |= (Data << BitNb);   }
#define mWrite1BitInRegUHFNUML(Data,BitNb)          {  UHFNUML &= ~(1<<(BitNb)); UHFNUML |= (Data << BitNb);   }
#define mWrite1BitInRegUHADDR(Data,BitNb)           {  UHADDR &= ~(1<<(BitNb));  UHADDR |= (Data << BitNb);    }
#define mWrite1BitInRegUHIEN(Data,BitNb)            {  UHIEN &= ~(1<<(BitNb));   UHIEN |= (Data << BitNb);     }
#define mWrite1BitInRegUHINT(Data,BitNb)            {  UHINT &= ~(1<<(BitNb));   UHINT |= (Data << BitNb);     }
#define mWrite1BitInRegUHCON(Data,BitNb)            {  UHCON &= ~(1<<(BitNb));   UHCON |= (Data << BitNb);     }
#define mWrite1BitInRegOCR3CH(Data,BitNb)           {  OCR3CH &= ~(1<<(BitNb));  OCR3CH |= (Data << BitNb);    }
#define mWrite1BitInRegOCR3CL(Data,BitNb)           {  OCR3CL &= ~(1<<(BitNb));  OCR3CL |= (Data << BitNb);    }
#define mWrite1BitInRegOCR3BH(Data,BitNb)           {  OCR3BH &= ~(1<<(BitNb));  OCR3BH |= (Data << BitNb);    }
#define mWrite1BitInRegOCR3BL(Data,BitNb)           {  OCR3BL &= ~(1<<(BitNb));  OCR3BL |= (Data << BitNb);    }
#define mWrite1BitInRegOCR3AH(Data,BitNb)           {  OCR3AH &= ~(1<<(BitNb));  OCR3AH |= (Data << BitNb);    }
#define mWrite1BitInRegOCR3AL(Data,BitNb)           {  OCR3AL &= ~(1<<(BitNb));  OCR3AL |= (Data << BitNb);    }
#define mWrite1BitInRegICR3H(Data,BitNb)            {  ICR3H &= ~(1<<(BitNb));   ICR3H |= (Data << BitNb);     }
#define mWrite1BitInRegICR3L(Data,BitNb)            {  ICR3L &= ~(1<<(BitNb));   ICR3L |= (Data << BitNb);     }
#define mWrite1BitInRegTCNT3H(Data,BitNb)           {  TCNT3H &= ~(1<<(BitNb));  TCNT3H |= (Data << BitNb);    }
#define mWrite1BitInRegTCNT3L(Data,BitNb)           {  TCNT3L &= ~(1<<(BitNb));  TCNT3L |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR3C(Data,BitNb)           {  TCCR3C &= ~(1<<(BitNb));  TCCR3C |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR3B(Data,BitNb)           {  TCCR3B &= ~(1<<(BitNb));  TCCR3B |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR3A(Data,BitNb)           {  TCCR3A &= ~(1<<(BitNb));  TCCR3A |= (Data << BitNb);    }
#define mWrite1BitInRegOCR1CH(Data,BitNb)           {  OCR1CH &= ~(1<<(BitNb));  OCR1CH |= (Data << BitNb);    }
#define mWrite1BitInRegOCR1CL(Data,BitNb)           {  OCR1CL &= ~(1<<(BitNb));  OCR1CL |= (Data << BitNb);    }
#define mWrite1BitInRegOCR1BH(Data,BitNb)           {  OCR1BH &= ~(1<<(BitNb));  OCR1BH |= (Data << BitNb);    }
#define mWrite1BitInRegOCR1BL(Data,BitNb)           {  OCR1BL &= ~(1<<(BitNb));  OCR1BL |= (Data << BitNb);    }
#define mWrite1BitInRegOCR1AH(Data,BitNb)           {  OCR1AH &= ~(1<<(BitNb));  OCR1AH |= (Data << BitNb);    }
#define mWrite1BitInRegOCR1AL(Data,BitNb)           {  OCR1AL &= ~(1<<(BitNb));  OCR1AL |= (Data << BitNb);    }
#define mWrite1BitInRegICR1H(Data,BitNb)            {  ICR1H &= ~(1<<(BitNb));   ICR1H |= (Data << BitNb);     }
#define mWrite1BitInRegICR1L(Data,BitNb)            {  ICR1L &= ~(1<<(BitNb));   ICR1L |= (Data << BitNb);     }
#define mWrite1BitInRegTCNT1H(Data,BitNb)           {  TCNT1H &= ~(1<<(BitNb));  TCNT1H |= (Data << BitNb);    }
#define mWrite1BitInRegTCNT1L(Data,BitNb)           {  TCNT1L &= ~(1<<(BitNb));  TCNT1L |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR1C(Data,BitNb)           {  TCCR1C &= ~(1<<(BitNb));  TCCR1C |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR1B(Data,BitNb)           {  TCCR1B &= ~(1<<(BitNb));  TCCR1B |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR1A(Data,BitNb)           {  TCCR1A &= ~(1<<(BitNb));  TCCR1A |= (Data << BitNb);    }
#define mWrite1BitInRegDIDR1(Data,BitNb)            {  DIDR1 &= ~(1<<(BitNb));   DIDR1 |= (Data << BitNb);     }
#define mWrite1BitInRegDIDR0(Data,BitNb)            {  DIDR0 &= ~(1<<(BitNb));   DIDR0 |= (Data << BitNb);     }
#define mWrite1BitInRegADMUX(Data,BitNb)            {  ADMUX &= ~(1<<(BitNb));   ADMUX |= (Data << BitNb);     }
#define mWrite1BitInRegADCSRB(Data,BitNb)           {  ADCSRB &= ~(1<<(BitNb));  ADCSRB |= (Data << BitNb);    }
#define mWrite1BitInRegADCSRA(Data,BitNb)           {  ADCSRA &= ~(1<<(BitNb));  ADCSRA |= (Data << BitNb);    }
#define mWrite1BitInRegADCH(Data,BitNb)             {  ADCH &= ~(1<<(BitNb));    ADCH |= (Data << BitNb);      }
#define mWrite1BitInRegADCL(Data,BitNb)             {  ADCL &= ~(1<<(BitNb));    ADCL |= (Data << BitNb);      }
#define mWrite1BitInRegXMCRB(Data,BitNb)            {  XMCRB &= ~(1<<(BitNb));   XMCRB |= (Data << BitNb);     }
#define mWrite1BitInRegXMCRA(Data,BitNb)            {  XMCRA &= ~(1<<(BitNb));   XMCRA |= (Data << BitNb);     }
#define mWrite1BitInRegTIMSK3(Data,BitNb)           {  TIMSK3 &= ~(1<<(BitNb));  TIMSK3 |= (Data << BitNb);    }
#define mWrite1BitInRegTIMSK2(Data,BitNb)           {  TIMSK2 &= ~(1<<(BitNb));  TIMSK2 |= (Data << BitNb);    }
#define mWrite1BitInRegTIMSK1(Data,BitNb)           {  TIMSK1 &= ~(1<<(BitNb));  TIMSK1 |= (Data << BitNb);    }
#define mWrite1BitInRegTIMSK0(Data,BitNb)           {  TIMSK0 &= ~(1<<(BitNb));  TIMSK0 |= (Data << BitNb);    }
#define mWrite1BitInRegPCMSK0(Data,BitNb)           {  PCMSK0 &= ~(1<<(BitNb));  PCMSK0 |= (Data << BitNb);    }
#define mWrite1BitInRegEICRB(Data,BitNb)            {  EICRB &= ~(1<<(BitNb));   EICRB |= (Data << BitNb);     }
#define mWrite1BitInRegEICRA(Data,BitNb)            {  EICRA &= ~(1<<(BitNb));   EICRA |= (Data << BitNb);     }
#define mWrite1BitInRegPCICR(Data,BitNb)            {  PCICR &= ~(1<<(BitNb));   PCICR |= (Data << BitNb);     }
#define mWrite1BitInRegOSCCAL(Data,BitNb)           {  OSCCAL &= ~(1<<(BitNb));  OSCCAL |= (Data << BitNb);    }
#define mWrite1BitInRegPRR1(Data,BitNb)             {  PRR1 &= ~(1<<(BitNb));    PRR1 |= (Data << BitNb);      }
#define mWrite1BitInRegPRR0(Data,BitNb)             {  PRR0 &= ~(1<<(BitNb));    PRR0 |= (Data << BitNb);      }
#define mWrite1BitInRegCLKPR(Data,BitNb)            {  CLKPR &= ~(1<<(BitNb));   CLKPR |= (Data << BitNb);     }
#define mWrite1BitInRegWDTCSR(Data,BitNb)           {  WDTCSR &= ~(1<<(BitNb));  WDTCSR |= (Data << BitNb);    }
#define mWrite1BitInRegSREG(Data,BitNb)             {  SREG &= ~(1<<(BitNb));    SREG |= (Data << BitNb);      }
#define mWrite1BitInRegSPH(Data,BitNb)              {  SPH &= ~(1<<(BitNb));     SPH |= (Data << BitNb);       }
#define mWrite1BitInRegSPL(Data,BitNb)              {   SPL &= ~(1<<(BitNb));    SPL |= (Data << BitNb);       }
#define mWrite1BitInRegRAMPZ(Data,BitNb)            {   RAMPZ &= ~(1<<(BitNb));  RAMPZ |= (Data << BitNb);     }
#define mWrite1BitInRegSPMCSR(Data,BitNb)           {  SPMCSR &= ~(1<<(BitNb));  SPMCSR |= (Data << BitNb);    }
#define mWrite1BitInRegMCUCR(Data,BitNb)            {  MCUCR &= ~(1<<(BitNb));   MCUCR |= (Data << BitNb);     }
#define mWrite1BitInRegMCUSR(Data,BitNb)            {  MCUSR &= ~(1<<(BitNb));   MCUSR |= (Data << BitNb);     }
#define mWrite1BitInRegSMCR(Data,BitNb)             {  SMCR &= ~(1<<(BitNb));    SMCR |= (Data << BitNb);      }
#define mWrite1BitInRegOCDR(Data,BitNb)             {  OCDR &= ~(1<<(BitNb));    OCDR |= (Data << BitNb);      }
#define mWrite1BitInRegMONDR(Data,BitNb)            {  MONDR &= ~(1<<(BitNb));   MONDR |= (Data << BitNb);     }
#define mWrite1BitInRegACSR(Data,BitNb)             {  ACSR &= ~(1<<(BitNb));    ACSR |= (Data << BitNb);      }
#define mWrite1BitInRegSPDR(Data,BitNb)             {  SPDR &= ~(1<<(BitNb));    SPDR |= (Data << BitNb);      }
#define mWrite1BitInRegSPSR(Data,BitNb)             {  SPSR &= ~(1<<(BitNb));    SPSR |= (Data << BitNb);      }
#define mWrite1BitInRegSPCR(Data,BitNb)             {  SPCR &= ~(1<<(BitNb));    SPCR |= (Data << BitNb);      }
#define mWrite1BitInRegGPIOR2(Data,BitNb)           {  GPIOR2 &= ~(1<<(BitNb));  GPIOR2 |= (Data << BitNb);    }
#define mWrite1BitInRegGPIOR1(Data,BitNb)           {  GPIOR1 &= ~(1<<(BitNb));  GPIOR1 |= (Data << BitNb);    }
#define mWrite1BitInRegPLLCSR(Data,BitNb)           {  PLLCSR &= ~(1<<(BitNb));  PLLCSR |= (Data << BitNb);    }
#define mWrite1BitInRegOCR0B(Data,BitNb)            {  OCR0B &= ~(1<<(BitNb));   OCR0B |= (Data << BitNb);     }
#define mWrite1BitInRegOCR0A(Data,BitNb)            {  OCR0A &= ~(1<<(BitNb));   OCR0A |= (Data << BitNb);     }
#define mWrite1BitInRegTCNT0(Data,BitNb)            {  TCNT0 &= ~(1<<(BitNb));   TCNT0 |= (Data << BitNb);     }
#define mWrite1BitInRegTCCR0B(Data,BitNb)           {  TCCR0B &= ~(1<<(BitNb));  TCCR0B |= (Data << BitNb);    }
#define mWrite1BitInRegTCCR0A(Data,BitNb)           {  TCCR0A &= ~(1<<(BitNb));  TCCR0A |= (Data << BitNb);    }
#define mWrite1BitInRegGTCCR(Data,BitNb)            {  GTCCR &= ~(1<<(BitNb));   GTCCR |= (Data << BitNb);     }
#define mWrite1BitInRegEEARH(Data,BitNb)            {  EEARH &= ~(1<<(BitNb));   EEARH |= (Data << BitNb);     }
#define mWrite1BitInRegEEARL(Data,BitNb)            {  EEARL &= ~(1<<(BitNb));   EEARL |= (Data << BitNb);     }
#define mWrite1BitInRegEEDR(Data,BitNb)             {  EEDR &= ~(1<<(BitNb));    EEDR |= (Data << BitNb);      }
#define mWrite1BitInRegEECR(Data,BitNb)             {  EECR &= ~(1<<(BitNb));    EECR |= (Data << BitNb);      }
#define mWrite1BitInRegGPIOR0(Data,BitNb)           {  GPIOR0 &= ~(1<<(BitNb));  GPIOR0 |= (Data << BitNb);    }
#define mWrite1BitInRegEIMSK(Data,BitNb)            {  EIMSK &= ~(1<<(BitNb));   EIMSK |= (Data << BitNb);     }
#define mWrite1BitInRegEIFR(Data,BitNb)             {  EIFR &= ~(1<<(BitNb));    EIFR |= (Data << BitNb);      }
#define mWrite1BitInRegPCIFR(Data,BitNb)            {  PCIFR &= ~(1<<(BitNb));   PCIFR |= (Data << BitNb);     }
#define mWrite1BitInRegTIFR3(Data,BitNb)            {  TIFR3 &= ~(1<<(BitNb));   TIFR3 |= (Data << BitNb);     }
#define mWrite1BitInRegTIFR2(Data,BitNb)            {  TIFR2 &= ~(1<<(BitNb));   TIFR2 |= (Data << BitNb);     }
#define mWrite1BitInRegTIFR1(Data,BitNb)            {  TIFR1 &= ~(1<<(BitNb));   TIFR1 |= (Data << BitNb);     }
#define mWrite1BitInRegTIFR0(Data,BitNb)            {  TIFR0 &= ~(1<<(BitNb));   TIFR0 |= (Data << BitNb);     }
#define mWrite1BitInRegPORTF(Data,BitNb)            {  PORTF &= ~(1<<(BitNb));   PORTF |= (Data << BitNb);     }
#define mWrite1BitInRegDDRF(Data,BitNb)             {  DDRF &= ~(1<<(BitNb));    DDRF |= (Data << BitNb);      }
#define mWrite1BitInRegPINF(Data,BitNb)             {  PINF &= ~(1<<(BitNb));    PINF |= (Data << BitNb);      }
#define mWrite1BitInRegPORTE(Data,BitNb)            {  PORTE &= ~(1<<(BitNb));   PORTE |= (Data << BitNb);     }
#define mWrite1BitInRegDDRE(Data,BitNb)             {  DDRE &= ~(1<<(BitNb));    DDRE |= (Data << BitNb);      }
#define mWrite1BitInRegPINE(Data,BitNb)             {  PINE &= ~(1<<(BitNb));    PINE |= (Data << BitNb);      }
#define mWrite1BitInRegPORTD(Data,BitNb)            {  PORTD &= ~(1<<(BitNb));   PORTD |= (Data << BitNb);     }
#define mWrite1BitInRegDDRD(Data,BitNb)             {  DDRD &= ~(1<<(BitNb));    DDRD |= (Data << BitNb);      }
#define mWrite1BitInRegPIND(Data,BitNb)             {  PIND &= ~(1<<(BitNb));    PIND |= (Data << BitNb);      }
#define mWrite1BitInRegPORTC(Data,BitNb)            {  PORTC &= ~(1<<(BitNb));   PORTC |= (Data << BitNb);     }
#define mWrite1BitInRegDDRC(Data,BitNb)             {  DDRC &= ~(1<<(BitNb));    DDRC |= (Data << BitNb);      }
#define mWrite1BitInRegPINC(Data,BitNb)             {  PINC &= ~(1<<(BitNb));    PINC |= (Data << BitNb);      }
#define mWrite1BitInRegPORTB(Data,BitNb)            {  PORTB &= ~(1<<(BitNb));   PORTB |= (Data << BitNb);     }
#define mWrite1BitInRegDDRB(Data,BitNb)             {  DDRB &= ~(1<<(BitNb));    DDRB |= (Data << BitNb);      }
#define mWrite1BitInRegPINB(Data,BitNb)             {  PINB &= ~(1<<(BitNb));    PINB |= (Data << BitNb);      }
#define mWrite1BitInRegPORTA(Data,BitNb)            {  PORTA &= ~(1<<(BitNb));   PORTA |= (Data << BitNb);     }
#define mWrite1BitInRegDDRA(Data,BitNb)             {  DDRA &= ~(1<<(BitNb));    DDRA |= (Data << BitNb);      }
#define mWrite1BitInRegPINA(Data,BitNb)             {  PINA &= ~(1<<(BitNb));    PINA |= (Data << BitNb);      }

//mRead1BitInReg
#define mRead1BitInRegOTGTCON(BitNb)          (U8)( (OTGTCON >> BitNb) & 0x01 )
#define mRead1BitInRegUPINT(BitNb)            (U8)( (UPINT >> BitNb) & 0x01 )
#define mRead1BitInRegUPBCHX(BitNb)           (U8)( (UPBCHX >> BitNb) & 0x01 )
#define mRead1BitInRegUPBCLX(BitNb)           (U8)( (UPBCLX >> BitNb) & 0x01 )
#define mRead1BitInRegUPERRX(BitNb)           (U8)( (UPERRX >> BitNb) & 0x01 )
#define mRead1BitInRegUEINT(BitNb)            (U8)( (UEINT >> BitNb) & 0x01 )
#define mRead1BitInRegUEBCHX(BitNb)           (U8)( (UEBCHX >> BitNb) & 0x01 )
#define mRead1BitInRegUEBCLX(BitNb)           (U8)( (UEBCLX >> BitNb) & 0x01 )
#define mRead1BitInRegUEDATX(BitNb)           (U8)( (UEDATX >> BitNb) & 0x01 )
#define mRead1BitInRegUEIENX(BitNb)           (U8)( (UEIENX >> BitNb) & 0x01 )
#define mRead1BitInRegUESTA1X(BitNb)          (U8)( (UESTA1X >> BitNb) & 0x01 )
#define mRead1BitInRegUESTA0X(BitNb)          (U8)( (UESTA0X >> BitNb) & 0x01 )
#define mRead1BitInRegUECFG1X(BitNb)          (U8)( (UECFG1X >> BitNb) & 0x01 )
#define mRead1BitInRegUECFG0X(BitNb)          (U8)( (UECFG0X >> BitNb) & 0x01 )
#define mRead1BitInRegUECONX(BitNb)           (U8)( (UECONX >> BitNb) & 0x01 )
#define mRead1BitInRegUERST(BitNb)            (U8)( (UERST >> BitNb) & 0x01 )
#define mRead1BitInRegUENUM(BitNb)            (U8)( (UENUM >> BitNb) & 0x01 )
#define mRead1BitInRegUEINTX(BitNb)           (U8)( (UEINTX >> BitNb) & 0x01 )
#define mRead1BitInRegUDTST(BitNb)            (U8)( (UDTST >> BitNb) & 0x01 )
#define mRead1BitInRegUDMFN(BitNb)            (U8)( (UDMFN >> BitNb) & 0x01 )
#define mRead1BitInRegUDFNUMH(BitNb)          (U8)( (UDFNUMH >> BitNb) & 0x01 )
#define mRead1BitInRegUDFNUML(BitNb)          (U8)( (UDFNUML >> BitNb) & 0x01 )
#define mRead1BitInRegUDADDR(BitNb)           (U8)( (UDADDR >> BitNb) & 0x01 )
#define mRead1BitInRegUDIEN(BitNb)            (U8)( (UDIEN >> BitNb) & 0x01 )
#define mRead1BitInRegUDINT(BitNb)            (U8)( (UDINT >> BitNb) & 0x01 )
#define mRead1BitInRegUDCON(BitNb)            (U8)( (UDCON >> BitNb) & 0x01 )
#define mRead1BitInRegOTGINT(BitNb)           (U8)( (OTGINT >> BitNb) & 0x01 )
#define mRead1BitInRegOTGIEN(BitNb)           (U8)( (OTGIEN >> BitNb) & 0x01 )
#define mRead1BitInRegOTGCON(BitNb)           (U8)( (OTGCON >> BitNb) & 0x01 )
#define mRead1BitInRegUDPADDH(BitNb)          (U8)( (UDPADDH >> BitNb) & 0x01 )
#define mRead1BitInRegUDPADDL(BitNb)          (U8)( (UDPADDL >> BitNb) & 0x01 )
#define mRead1BitInRegUSBINT(BitNb)           (U8)( (USBINT >> BitNb) & 0x01 )
#define mRead1BitInRegUSBSTA(BitNb)           (U8)( (USBSTA >> BitNb) & 0x01 )
#define mRead1BitInRegUSBCON(BitNb)           (U8)( (USBCON >> BitNb) & 0x01 )
#define mRead1BitInRegUHWCON(BitNb)           (U8)( (UHWCON >> BitNb) & 0x01 )
#define mRead1BitInRegUDR1(BitNb)             (U8)( (UDR1 >> BitNb) & 0x01 )
#define mRead1BitInRegUBRR1H(BitNb)           (U8)( (UBRR1H >> BitNb) & 0x01 )
#define mRead1BitInRegUBRR1L(BitNb)           (U8)( (UBRR1L >> BitNb) & 0x01 )
#define mRead1BitInRegUCSR1C(BitNb)           (U8)( (UCSR1C >> BitNb) & 0x01 )
#define mRead1BitInRegUCSR1B(BitNb)           (U8)( (UCSR1B >> BitNb) & 0x01 )
#define mRead1BitInRegUCSR1A(BitNb)           (U8)( (UCSR1A >> BitNb) & 0x01 )
#define mRead1BitInRegTWAMR(BitNb)            (U8)( (TWAMR >> BitNb) & 0x01 )
#define mRead1BitInRegTWCR(BitNb)             (U8)( (TWCR >> BitNb) & 0x01 )
#define mRead1BitInRegTWDR(BitNb)             (U8)( (TWDR >> BitNb) & 0x01 )
#define mRead1BitInRegTWAR(BitNb)             (U8)( (TWAR >> BitNb) & 0x01 )
#define mRead1BitInRegTWSR(BitNb)             (U8)( (TWSR >> BitNb) & 0x01 )
#define mRead1BitInRegTWBR(BitNb)             (U8)( (TWBR >> BitNb) & 0x01 )
#define mRead1BitInRegASSR(BitNb)             (U8)( (ASSR >> BitNb) & 0x01 )
#define mRead1BitInRegOCR2B(BitNb)            (U8)( (OCR2B >> BitNb) & 0x01 )
#define mRead1BitInRegOCR2A(BitNb)            (U8)( (OCR2A >> BitNb) & 0x01 )
#define mRead1BitInRegTCNT2(BitNb)            (U8)( (TCNT2 >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR2B(BitNb)           (U8)( (TCCR2B >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR2A(BitNb)           (U8)( (TCCR2A >> BitNb) & 0x01 )
#define mRead1BitInRegUPDATX(BitNb)           (U8)( (UPDATX >> BitNb) & 0x01 )
#define mRead1BitInRegUPIENX(BitNb)           (U8)( (UPIENX >> BitNb) & 0x01 )
#define mRead1BitInRegUPCFG2X(BitNb)          (U8)( (UPCFG2X >> BitNb) & 0x01 )
#define mRead1BitInRegUPSTAX(BitNb)           (U8)( (UPSTAX >> BitNb) & 0x01 )
#define mRead1BitInRegUPCFG1X(BitNb)          (U8)( (UPCFG1X >> BitNb) & 0x01 )
#define mRead1BitInRegUPCFG0X(BitNb)          (U8)( (UPCFG0X >> BitNb) & 0x01 )
#define mRead1BitInRegUPCONX(BitNb)           (U8)( (UPCONX >> BitNb) & 0x01 )
#define mRead1BitInRegUPRST(BitNb)            (U8)( (UPRST >> BitNb) & 0x01 )
#define mRead1BitInRegUPNUM(BitNb)            (U8)( (UPNUM >> BitNb) & 0x01 )
#define mRead1BitInRegUPINTX(BitNb)           (U8)( (UPINTX >> BitNb) & 0x01 )
#define mRead1BitInRegUPINRQX(BitNb)          (U8)( (UPINRQX >> BitNb) & 0x01 )
#define mRead1BitInRegUHFLEN(BitNb)           (U8)( (UHFLEN >> BitNb) & 0x01 )
#define mRead1BitInRegUHFNUMH(BitNb)          (U8)( (UHFNUMH >> BitNb) & 0x01 )
#define mRead1BitInRegUHFNUML(BitNb)          (U8)( (UHFNUML >> BitNb) & 0x01 )
#define mRead1BitInRegUHADDR(BitNb)           (U8)( (UHADDR >> BitNb) & 0x01 )
#define mRead1BitInRegUHIEN(BitNb)            (U8)( (UHIEN >> BitNb) & 0x01 )
#define mRead1BitInRegUHINT(BitNb)            (U8)( (UHINT >> BitNb) & 0x01 )
#define mRead1BitInRegUHCON(BitNb)            (U8)( (UHCON >> BitNb) & 0x01 )
#define mRead1BitInRegOCR3CH(BitNb)           (U8)( (OCR3CH >> BitNb) & 0x01 )
#define mRead1BitInRegOCR3CL(BitNb)           (U8)( (OCR3CL >> BitNb) & 0x01 )
#define mRead1BitInRegOCR3BH(BitNb)           (U8)( (OCR3BH >> BitNb) & 0x01 )
#define mRead1BitInRegOCR3BL(BitNb)           (U8)( (OCR3BL >> BitNb) & 0x01 )
#define mRead1BitInRegOCR3AH(BitNb)           (U8)( (OCR3AH >> BitNb) & 0x01 )
#define mRead1BitInRegOCR3AL(BitNb)           (U8)( (OCR3AL >> BitNb) & 0x01 )
#define mRead1BitInRegICR3H(BitNb)            (U8)( (ICR3H >> BitNb) & 0x01 )
#define mRead1BitInRegICR3L(BitNb)            (U8)( (ICR3L >> BitNb) & 0x01 )
#define mRead1BitInRegTCNT3H(BitNb)           (U8)( (TCNT3H >> BitNb) & 0x01 )
#define mRead1BitInRegTCNT3L(BitNb)           (U8)( (TCNT3L >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR3C(BitNb)           (U8)( (TCCR3C >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR3B(BitNb)           (U8)( (TCCR3B >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR3A(BitNb)           (U8)( (TCCR3A >> BitNb) & 0x01 )
#define mRead1BitInRegOCR1CH(BitNb)           (U8)( (OCR1CH >> BitNb) & 0x01 )
#define mRead1BitInRegOCR1CL(BitNb)           (U8)( (OCR1CL >> BitNb) & 0x01 )
#define mRead1BitInRegOCR1BH(BitNb)           (U8)( (OCR1BH >> BitNb) & 0x01 )
#define mRead1BitInRegOCR1BL(BitNb)           (U8)( (OCR1BL >> BitNb) & 0x01 )
#define mRead1BitInRegOCR1AH(BitNb)           (U8)( (OCR1AH >> BitNb) & 0x01 )
#define mRead1BitInRegOCR1AL(BitNb)           (U8)( (OCR1AL >> BitNb) & 0x01 )
#define mRead1BitInRegICR1H(BitNb)            (U8)( (ICR1H >> BitNb) & 0x01 )
#define mRead1BitInRegICR1L(BitNb)            (U8)( (ICR1L >> BitNb) & 0x01 )
#define mRead1BitInRegTCNT1H(BitNb)           (U8)( (TCNT1H >> BitNb) & 0x01 )
#define mRead1BitInRegTCNT1L(BitNb)           (U8)( (TCNT1L >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR1C(BitNb)           (U8)( (TCCR1C >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR1B(BitNb)           (U8)( (TCCR1B >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR1A(BitNb)           (U8)( (TCCR1A >> BitNb) & 0x01 )
#define mRead1BitInRegDIDR1(BitNb)            (U8)( (DIDR1 >> BitNb) & 0x01 )
#define mRead1BitInRegDIDR0(BitNb)            (U8)( (DIDR0 >> BitNb) & 0x01 )
#define mRead1BitInRegADMUX(BitNb)            (U8)( (ADMUX >> BitNb) & 0x01 )
#define mRead1BitInRegADCSRB(BitNb)           (U8)( (ADCSRB >> BitNb) & 0x01 )
#define mRead1BitInRegADCSRA(BitNb)           (U8)( (ADCSRA >> BitNb) & 0x01 )
#define mRead1BitInRegADCH(BitNb)             (U8)( (ADCH >> BitNb) & 0x01 )
#define mRead1BitInRegADCL(BitNb)             (U8)( (ADCL >> BitNb) & 0x01 )
#define mRead1BitInRegXMCRB(BitNb)            (U8)( (XMCRB >> BitNb) & 0x01 )
#define mRead1BitInRegXMCRA(BitNb)            (U8)( (XMCRA >> BitNb) & 0x01 )
#define mRead1BitInRegTIMSK3(BitNb)           (U8)( (TIMSK3 >> BitNb) & 0x01 )
#define mRead1BitInRegTIMSK2(BitNb)           (U8)( (TIMSK2 >> BitNb) & 0x01 )
#define mRead1BitInRegTIMSK1(BitNb)           (U8)( (TIMSK1 >> BitNb) & 0x01 )
#define mRead1BitInRegTIMSK0(BitNb)           (U8)( (TIMSK0 >> BitNb) & 0x01 )
#define mRead1BitInRegPCMSK0(BitNb)           (U8)( (PCMSK0 >> BitNb) & 0x01 )
#define mRead1BitInRegEICRB(BitNb)            (U8)( (EICRB >> BitNb) & 0x01 )
#define mRead1BitInRegEICRA(BitNb)            (U8)( (EICRA >> BitNb) & 0x01 )
#define mRead1BitInRegPCICR(BitNb)            (U8)( (PCICR >> BitNb) & 0x01 )
#define mRead1BitInRegOSCCAL(BitNb)           (U8)( (OSCCAL >> BitNb) & 0x01 )
#define mRead1BitInRegPRR1(BitNb)             (U8)( (PRR1 >> BitNb) & 0x01 )
#define mRead1BitInRegPRR0(BitNb)             (U8)( (PRR0 >> BitNb) & 0x01 )
#define mRead1BitInRegCLKPR(BitNb)            (U8)( (CLKPR >> BitNb) & 0x01 )
#define mRead1BitInRegWDTCSR(BitNb)           (U8)( (WDTCSR >> BitNb) & 0x01 )
#define mRead1BitInRegSREG(BitNb)             (U8)( (SREG >> BitNb) & 0x01 )
#define mRead1BitInRegSPH(BitNb)              (U8)( (SPH >> BitNb) & 0x01 )
#define mRead1BitInRegSPL(BitNb)              (U8)( ( SPL >> BitNb) & 0x01 )
#define mRead1BitInRegRAMPZ(BitNb)            (U8)( ( RAMPZ >> BitNb) & 0x01 )
#define mRead1BitInRegSPMCSR(BitNb)           (U8)( (SPMCSR >> BitNb) & 0x01 )
#define mRead1BitInRegMCUCR(BitNb)            (U8)( (MCUCR >> BitNb) & 0x01 )
#define mRead1BitInRegMCUSR(BitNb)            (U8)( (MCUSR >> BitNb) & 0x01 )
#define mRead1BitInRegSMCR(BitNb)             (U8)( (SMCR >> BitNb) & 0x01 )
#define mRead1BitInRegOCDR(BitNb)             (U8)( (OCDR >> BitNb) & 0x01 )
#define mRead1BitInRegMONDR(BitNb)            (U8)( (MONDR >> BitNb) & 0x01 )
#define mRead1BitInRegACSR(BitNb)             (U8)( (ACSR >> BitNb) & 0x01 )
#define mRead1BitInRegSPDR(BitNb)             (U8)( (SPDR >> BitNb) & 0x01 )
#define mRead1BitInRegSPSR(BitNb)             (U8)( (SPSR >> BitNb) & 0x01 )
#define mRead1BitInRegSPCR(BitNb)             (U8)( (SPCR >> BitNb) & 0x01 )
#define mRead1BitInRegGPIOR2(BitNb)           (U8)( (GPIOR2 >> BitNb) & 0x01 )
#define mRead1BitInRegGPIOR1(BitNb)           (U8)( (GPIOR1 >> BitNb) & 0x01 )
#define mRead1BitInRegPLLCSR(BitNb)           (U8)( (PLLCSR >> BitNb) & 0x01 )
#define mRead1BitInRegOCR0B(BitNb)            (U8)( (OCR0B >> BitNb) & 0x01 )
#define mRead1BitInRegOCR0A(BitNb)            (U8)( (OCR0A >> BitNb) & 0x01 )
#define mRead1BitInRegTCNT0(BitNb)            (U8)( (TCNT0 >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR0B(BitNb)           (U8)( (TCCR0B >> BitNb) & 0x01 )
#define mRead1BitInRegTCCR0A(BitNb)           (U8)( (TCCR0A >> BitNb) & 0x01 )
#define mRead1BitInRegGTCCR(BitNb)            (U8)( (GTCCR >> BitNb) & 0x01 )
#define mRead1BitInRegEEARH(BitNb)            (U8)( (EEARH >> BitNb) & 0x01 )
#define mRead1BitInRegEEARL(BitNb)            (U8)( (EEARL >> BitNb) & 0x01 )
#define mRead1BitInRegEEDR(BitNb)             (U8)( (EEDR >> BitNb) & 0x01 )
#define mRead1BitInRegEECR(BitNb)             (U8)( (EECR >> BitNb) & 0x01 )
#define mRead1BitInRegGPIOR0(BitNb)           (U8)( (GPIOR0 >> BitNb) & 0x01 )
#define mRead1BitInRegEIMSK(BitNb)            (U8)( (EIMSK >> BitNb) & 0x01 )
#define mRead1BitInRegEIFR(BitNb)             (U8)( (EIFR >> BitNb) & 0x01 )
#define mRead1BitInRegPCIFR(BitNb)            (U8)( (PCIFR >> BitNb) & 0x01 )
#define mRead1BitInRegTIFR3(BitNb)            (U8)( (TIFR3 >> BitNb) & 0x01 )
#define mRead1BitInRegTIFR2(BitNb)            (U8)( (TIFR2 >> BitNb) & 0x01 )
#define mRead1BitInRegTIFR1(BitNb)            (U8)( (TIFR1 >> BitNb) & 0x01 )
#define mRead1BitInRegTIFR0(BitNb)            (U8)( (TIFR0 >> BitNb) & 0x01 )
#define mRead1BitInRegPORTF(BitNb)            (U8)( (PORTF >> BitNb) & 0x01 )
#define mRead1BitInRegDDRF(BitNb)             (U8)( (DDRF >> BitNb) & 0x01 )
#define mRead1BitInRegPINF(BitNb)             (U8)( (PINF >> BitNb) & 0x01 )
#define mRead1BitInRegPORTE(BitNb)            (U8)( (PORTE >> BitNb) & 0x01 )
#define mRead1BitInRegDDRE(BitNb)             (U8)( (DDRE >> BitNb) & 0x01 )
#define mRead1BitInRegPINE(BitNb)             (U8)( (PINE >> BitNb) & 0x01 )
#define mRead1BitInRegPORTD(BitNb)            (U8)( (PORTD >> BitNb) & 0x01 )
#define mRead1BitInRegDDRD(BitNb)             (U8)( (DDRD >> BitNb) & 0x01 )
#define mRead1BitInRegPIND(BitNb)             (U8)( (PIND >> BitNb) & 0x01 )
#define mRead1BitInRegPORTC(BitNb)            (U8)( (PORTC >> BitNb) & 0x01 )
#define mRead1BitInRegDDRC(BitNb)             (U8)( (DDRC >> BitNb) & 0x01 )
#define mRead1BitInRegPINC(BitNb)             (U8)( (PINC >> BitNb) & 0x01 )
#define mRead1BitInRegPORTB(BitNb)            (U8)( (PORTB >> BitNb) & 0x01 )
#define mRead1BitInRegDDRB(BitNb)             (U8)( (DDRB >> BitNb) & 0x01 )
#define mRead1BitInRegPINB(BitNb)             (U8)( (PINB >> BitNb) & 0x01 )
#define mRead1BitInRegPORTA(BitNb)            (U8)( (PORTA >> BitNb) & 0x01 )
#define mRead1BitInRegDDRA(BitNb)             (U8)( (DDRA >> BitNb) & 0x01 )
#define mRead1BitInRegPINA(BitNb)             (U8)( (PINA >> BitNb) & 0x01 )

#endif //DRV_REG_RW
