#include "DRV_TMR.h"


#ifdef __AVR_ATmega8__

static void DRVTmrStartTimer(void);

static void (*Timer_HandlerFPtr)(void);

void DRVTmrInit(void)
{
    TCCR0 = 0x02;
    
    mLibEnableInterrupt();

}

static void DRVTmrStartTimer(void)
{
    //mLibEnableInterrupt();
    TCNT0 = 135; // 1ms Tick with internal oscillator
    TIMSK = (1<<TOIE0);    
}

static void DRVTmrStopTimer(void)
{
    TIMSK = ~(1<<TOIE0);
    TIFR &= ~(1 << TOV0);    
}

static void DRVTmrSetHandler(void (*aFPtr)(void))
{
	/* Call interrupt handler set function */
	Timer_HandlerFPtr = aFPtr;
}


void TIMER0_OVF_vect( void )  __attribute__ ( ( signal ) );
void TIMER0_OVF_vect( void )
{
    //CallBack
    Timer_HandlerFPtr();
}

void DrvTmrControl(Buffer * aBufferTmr,tAddress aAddress)
{
    switch(aAddress)
    {
    case cStartTimer      :
        DRVTmrStartTimer();
        break;
        
    case cStopTimer       :
        DRVTmrStopTimer();
        break;
        
    case cSetTimerCallBack:
        DRVTmrSetHandler((void*)aBufferTmr->Address);
        break;
        
#ifdef AssertActive        
    default:
        mLibAssert(cTrue);
        break;
#endif        

    }
}

#elif (__AVR_ATmega88__ || __AVR_ATmega168__)

void DRVTmrStartTimer(void);

void (*Timer_HandlerFPtr)(void);

void DRVTmrInit(void)
{
    TCCR0A = 0x00;
    TCCR0B = 0x05;
    
    mLibEnableInterrupt();

}

void DRVTmrStartTimer(void)
{
    //mLibEnableInterrupt();
    TCNT0 = 255; // 1ms Tick with internal oscillator
    TIMSK0 = (1<<TOIE0);    
}

void DRVTmrStopTimer(void)
{
    TIMSK0 = ~(1<<TOIE0);
    TIFR0 &= ~(1 << TOV0);    
}

void DRVTmrSetHandler(void (*aFPtr)(void))
{
	/* Call interrupt handler set function */
	Timer_HandlerFPtr = aFPtr;
}


void TIMER0_OVF_vect( void )  __attribute__ ( ( signal ) );
void TIMER0_OVF_vect( void )
{
    //CallBack
    Timer_HandlerFPtr();
}

void DrvTmrControl(Buffer * aBufferTmr,tAddress aAddress)
{
    switch(aAddress)
    {
    case cStartTimer      :
        DRVTmrStartTimer();
        break;
        
    case cStopTimer       :
        DRVTmrStopTimer();
        break;
        
    case cSetTimerCallBack:
        DRVTmrSetHandler((void*)aBufferTmr->Address);
        break;
        
#ifdef AssertActive        
    default:

        mLibAssert(cTrue);
        break;
#endif        

    }
}
#endif //__AVR_ATmega8__