#ifndef API_H
#define API_H


//Component include
//DRV
#include "DRV_LCD.h"
#include "DRV_KBD.h"
#include "DRV_TMR.h"
#include "DRV_ADC.h"
//MDW
#include "MDW_LCD.h"
#include "MDW_KBD.h"
#include "MDW_TMR.h"
#include "MDW_ADC.h"
#include "MDW_ENG.h"
//APP
#include "APP_IHM.h"


// APP <=> MDW communication macros
#define mMDWReadData(Channel)								mMDWReadData##Channel()
#define mMDWReadDataByIndex(Channel,Index)					mMDWReadDataByIndex##Channel(Index)
#define mMDWWriteData(Channel,Data)							mMDWWriteData##Channel(Data)
#define mMDWWriteDataByIndex(Channel,Data,Index)			mMDWWriteDataByIndex##Channel(Data,Index)
#define mMDWControl(Channel,Control)						mMDWControl##Channel(Control)

// MDW <=> DRV communication macros
#define mDRVReceiveWithoutAddr(Channel,Buffer)				mDRVReceiveWithoutAddr##Channel(Buffer)
#define mDRVReceiveWithAddr(Channel,Buffer,Address)			mDRVReceiveWithAddr##Channel(Buffer,Address)
#define mDRVSendWithoutAddr(Channel,Buffer)					mDRVSendWithoutAddr##Channel(Buffer)
#define mDRVSendWithAddr(Channel,Buffer,Address)			mDRVSendWithAddr##Channel(Buffer,Address)
#define mDRVControl(Channel,Control)						mDRVControl##Channel(Control)

//Channels declaration
#define cChannelLcd
#define cChannelKbd
#define cChannelTmr
#define cChannelAdc
#define cChannelEng


#ifdef cChannelLcd
	//Control
    #define cLineNumber_1                                       0
    #define cLineNumber_2                                       1

    
	//DRV Address
    #define cCommand                                            0
    #define cData                                               1
    #define cChar                                               2
    
	//MDW Address
    #define cLineNumber                                         0
    #define cCursorPosition                                     1
    #define cDataTosend                                         2
    #define cCharToSend                                         3
    
	//Access Maccros
	// MDW mMacros Access
	#define mMDWWriteDataByIndexcChannelLcd(Data,Index)			MdwLcdSendDataOrCommand(Data,Index)
//	#define mMDWControlcChannelLed(Control)						MDWLedControl(Control)
	// DRV mMacros Access
	#define mDRVSendWithAddrcChannelLcd(Buffer,Address)		    DrvLcdCommand(Buffer,Address)
#endif //cChannelLcd


#ifdef cChannelKbd
	//Control
    #define cNumberOfKeys                                       12
    
    
    #define cKey_01                                             0
    #define cKey_02                                             1
    #define cKey_03                                             2
    #define cKey_04                                             3
    #define cKey_05                                             4
    #define cKey_06                                             5
    #define cKey_07                                             6
    #define cKey_08                                             7
    #define cKey_09                                             8
    #define cKey_ST                                             9
    #define cKey_00                                            10 
    #define cKey_SH                                            11
    
    #define cKeyPressed                                         0
    #define cKeyReleased                                        1
    
    #define cConsumedKey                                        0xFF
    
	//Address
	#define cScanKeyboard   									0
	#define cReadPressedkey                                     1
	#define cReadReleasedkey                                    2
	#define cClearKeyState                                      3
	
	//Access Maccros
	// MDW mMacros Access
	#define mMDWReadDataByIndexcChannelKbd(Index)			    MdwKbdReadKeyState(Index)
	// DRV mMacros Access
	#define mDRVSendWithAddrcChannelKbd(Buffer,Address)			DRVKbdCommand(Buffer,Address)
#endif //cChannelKbd

#ifdef cChannelTmr
	//Control
    
	//Address
    #define cStartTimer                                         0
    #define cStopTimer                                          1
    #define cSetTimerCallBack                                   2
	
	//Access Maccros
	// MDW mMacros Access

	// DRV mMacros Access
	#define mDRVSendWithAddrcChannelTmr(Buffer,Address)         DrvTmrControl(Buffer,Address)
#endif //cChannelTmr

#ifdef cChannelAdc
	//Control
    
	//Address
    #define cStartAdc                                           0
    #define cStopAdc                                            1
    #define cReadAdcValue                                       2
	
	//Access Maccros
	// MDW mMacros Access
    #define mMDWReadDatacChannelAdc()                           MdwAdcReadFilteredValue()
	// DRV mMacros Access
	#define mDRVSendWithAddrcChannelAdc(Buffer,Address)         DrvAdcControl(Buffer,Address)
#endif //cChannelAdc

#ifdef cChannelEng
	//Control
    #define cManOff                                             0
    #define cManOn                                              1
    #define cAutoOff                                            2
    #define cAutoOn                                             3
    
    
	//Address
    #define cAutoManState                                       0
    #define cWheightCommand                                     1
    #define cZeroSensor                                         2
    #define cCurrentWheight                                     3
	
	//Access Maccros
	// MDW mMacros Access
    #define mMDWReadDataByIndexcChannelEng(Index)               MdwEngGet(Index)
    #define mMDWWriteDataByIndexcChannelEng(Data,Index)         MdwEngSet(Data,Index)
	// DRV mMacros Access
	//#define mDRVSendWithAddrcChannelAdc(Buffer,Address)         DrvAdcControl(Buffer,Address)
#endif //cChannelEng

#endif	// API_H
