#include "MDW_ADC.h"

static U16 MdwAdcValue;
static float MdwAdcFilteredValue;
static U16 MdwResultValue;
static Buffer MdwAdcBuffer;

#define cTimeConstant                     (float)( ((float)(100)/1000) / (((float)(100)/1000) + 2 ))

void MdwAdcInit(void)
{
/*    MdwAdcValue = 0;
    MdwAdcFilteredValue = 0;*/
    MdwAdcBuffer.Address = (U8*)&MdwAdcValue;
    
    MdwTmrSubscribeCallBack(&MdwAdcRead, 100);
    mDRVSendWithAddr(cChannelAdc,&MdwAdcBuffer,cStartAdc);
}


void MdwAdcRead(void)
{   
    mDRVSendWithAddr(cChannelAdc,&MdwAdcBuffer,cReadAdcValue);

    MdwAdcValue = (((U32)MdwAdcValue*5000)/1024) ;
	
	MdwAdcFilteredValue = ((cTimeConstant * (float)(MdwAdcValue)) + (( (float)(1) - cTimeConstant) * MdwAdcFilteredValue));
	
	MdwResultValue = (U16)(MdwAdcFilteredValue);	
}


U16 MdwAdcReadFilteredValue(void)
{    
    return MdwResultValue;
}