#include "MDW_ENG.h"
#include <avr/eeprom.h>

#define mMotorOn()                    (PORTC  |=  (1<<PORTC4))
#define mMotorOff()                   (PORTC  &= ~(1<<PORTC4))

static EngineConfig MdwEngConf;

static S16 MdwCurrentWheight;

static void MdwEngSaveConfig(void);

void MdwEngInit(void)
{
	DDRC  |=  (1<<PORTC4); // Output_Power
    PORTC &= ~(1<<PORTC4);
    
    
	mLibDisableInterrupt();
    eeprom_read_block((void*)&MdwEngConf,0,sizeof(MdwEngConf));
    mLibEnableInterrupt();
	
    MdwTmrSubscribeCallBack(&MdwEngRefresh, 233);
    
}



void MdwEngRefresh(void)
{
    MdwCurrentWheight =  mMDWReadData(cChannelAdc); 
    MdwCurrentWheight = (((U32)(MdwCurrentWheight)*550)/4800) - MdwEngConf.SensorZero;


	switch(MdwEngConf.MdwEngAutoMan)
	{
	case cManOff :
		mMotorOff();
		break;


	case cManOn  :
		mMotorOn();
		break;


	case cAutoOff:
        mMotorOff();
		break;


	case cAutoOn :
		if(MdwCurrentWheight < MdwEngConf.WheightCommand)
        {
            mMotorOn();
        }
		else
        {
            MdwEngConf.MdwEngAutoMan = cAutoOff;
            MdwEngConf.WheightCommand = 0;
            MdwEngSaveConfig();
            mMotorOff();
            mAppIhmExternRefresh();
        }
		break;
	}
	
}




void MdwEngSet(U16 aData,tAddress aIndex)
{
    switch(aIndex)
    {
    case cAutoManState  :
        MdwEngConf.MdwEngAutoMan  = (U8)aData;
		if(MdwEngConf.MdwEngAutoMan < cAutoOff)
		{
			MdwEngConf.WheightCommand = 0;
		}
        break;


    case cWheightCommand:
        MdwEngConf.WheightCommand = aData;
        break;


    case cZeroSensor    :
        MdwEngConf.SensorZero     += MdwCurrentWheight;
        break;
    }
    MdwEngSaveConfig();
}


S16 MdwEngGet(tAddress aIndex)
{
    S16 Value;
    switch(aIndex)
    {
    case cAutoManState  :
        Value = (U16)MdwEngConf.MdwEngAutoMan;
        break;


    case cWheightCommand:
        Value = MdwEngConf.WheightCommand;
        break;

    case cCurrentWheight:
        Value = MdwCurrentWheight;
        break;
        
    default:
        Value = 0xFFFF;
        break;

    }
    
    return Value;
}


static void MdwEngSaveConfig(void)
{
    while(!eeprom_is_ready());
    eeprom_write_block((const void*)&MdwEngConf,0,sizeof(MdwEngConf));
}




