#include "MDW_LCD.h"

static U8 Position;
static U8 Line;
static U8 Command;
static Buffer MdwLcdBuffer;



void MdwLcdInit(void)
{
}


static void MdwLcdDisplayThisString(U8 * aString)
{
    if(Line != cLineNumber_1)
    {
        Command = 0xC0;
    }
    else
    {
        Command = 0x00;
    }
    
    Command += Position;

    MdwLcdBuffer.Address = &Command;
    mDRVSendWithAddr(cChannelLcd,cCommand,&MdwLcdBuffer);
    
    MdwLcdBuffer.Address = aString;
    mDRVSendWithAddr(cChannelLcd,cData,&MdwLcdBuffer);
    
} 


void MdwLcdSendDataOrCommand(U8 * aData,tAddress aIndex)
{
    switch(aIndex)
    {
    case cLineNumber    :
        Line = *aData;
        break;
        
    case cCursorPosition:
        Position = *aData;
        break;
        
    case cDataTosend    :
        MdwLcdDisplayThisString(aData);
        break;
 
#ifdef AssertActive        
    default:
        mLibAssert(cTrue);
        break;
#endif
    }    
}
