#include "MDW_TMR.h"


static Buffer   MdwTmrBuffer;
static U16      MdwTmrCounter;
static void (*MdwTmrCallbackCollection[cMaxCallback])(void);
static U16 MdwTmrCallbackCollectionCounter[cMaxCallback];
static U16 MdwTmrCallbackCollectionInterval[cMaxCallback];
static U8 MdwTmrCallbackCounter;

void MdwTmrInit(void)
{
    MdwTmrBuffer.Address = (U8*)&MdwTmrCallback;
    
    mDRVSendWithAddr(cChannelTmr,&MdwTmrBuffer,cSetTimerCallBack);    
}

void MdwTmrCallback(void)
{    
    U8 callbackCount;
    
    mDRVSendWithAddr(cChannelTmr,&MdwTmrBuffer,cStopTimer);
    
    MdwTmrCounter++;
    
    for(callbackCount = 0; callbackCount < MdwTmrCallbackCounter; callbackCount++)
    {
        if((MdwTmrCallbackCollectionCounter[callbackCount] == MdwTmrCounter) &&
           ( MdwTmrCallbackCollection[callbackCount] != NULL)
          )
        {
            MdwTmrCallbackCollection[callbackCount]();
            MdwTmrCallbackCollectionCounter[callbackCount]  = (MdwTmrCallbackCollectionInterval[callbackCount] + MdwTmrCounter);
        }
    }
    
    mDRVSendWithAddr(cChannelTmr,&MdwTmrBuffer,cStartTimer);
}

U8 MdwTmrSubscribeCallBack(void (*aFPtr)(void), U16 aTimeIntervalInMs)
{
    if(MdwTmrCallbackCounter < cMaxCallback)
    {
        MdwTmrCallbackCollection[MdwTmrCallbackCounter] = (*aFPtr);
        MdwTmrCallbackCollectionInterval[MdwTmrCallbackCounter] = aTimeIntervalInMs;
        MdwTmrCallbackCollectionCounter[MdwTmrCallbackCounter]  = (MdwTmrCallbackCollectionInterval[MdwTmrCallbackCounter] + MdwTmrCounter);
        
        MdwTmrCallbackCounter++;
        
        mDRVSendWithAddr(cChannelTmr,&MdwTmrBuffer,cStartTimer);
    }
    else {}
    
    return (MdwTmrCallbackCounter-1);
}

void MdwTmrUnsubscribeCallBack(U8 aCallbackNumber)
{
    MdwTmrCallbackCounter--;
    MdwTmrCallbackCollection[aCallbackNumber] = NULL;
    MdwTmrCallbackCollectionInterval[aCallbackNumber] = 0;
    MdwTmrCallbackCollectionCounter[aCallbackNumber]  = 0;
}