#ifndef APP_IHM_H
#define APP_IHM_H

#include "TypeDefinition.h"
#include "LIB.h"

//Local Constant
#define cNumberOfLines          2
#define cNumberOfChar          16
#define cNumberOfCharSize      cNumberOfChar+1



typedef struct
{
  U8 ScreenType;
  U1 IsBUilt;
  U1 NeedRefresh;
}Screen;

enum
{
    cSplashScreen =0,
    cMainScreen,
    cConfirmScreen,
    cWarnScreen,
    cConfigScreen,
    cManualScreen,
    cNumberOfScreen
} cScreenList;

enum
{
    cAnimState0 =1,
    cAnimState1,
    cAnimState2,
    cAnimState3,
    cAnimState4,    
    cNumberAnimState
} cAnimSequence;


// Init Section
#define mAPPIhmInit()			AppIhmInit()


// Communication Section
#define mAppIhmRefresh()        AppIhmRefresh()
#define mAppIhmExternRefresh()  IhmExternRefresh();

//extern fonction declaration
extern void AppIhmInit(void);
extern void AppIhmRefresh(void);

//extern void AppIhmSplashScreenCallBack(void);
//extern void AppIhmWarnScreenCallBack(void);
extern void IhmExternRefresh(void);
#endif	// APP_IHM_H
