#include "DRV_ADC.h"


#ifdef __AVR_ATmega8__

static U16 AnalogValue;

void DRVAdcInit(void)
{
    ADMUX  = 0x43;
    ADCSRA = (1<<ADEN) | (1<<ADIE) | 0x03;
}

static void DRVAdcStart(void)
{
    ADCSRA |= (1<<ADSC);
}


static void DRVAdcStop(void)
{
    ADCSRA &= ~(1<<ADSC);
}


void ADC_vect( void )  __attribute__ ( ( signal ) );
void ADC_vect( void )
{
    DRVAdcStop();
    AnalogValue = 0;
    AnalogValue = ADCL;
    AnalogValue |= (U16)(ADCH<<8);
    DRVAdcStart();    
}

void DrvAdcControl(Buffer * aBufferAdc,tAddress aAddress)
{
    switch(aAddress)
    {
    case cStartAdc      :
        DRVAdcStart();
        break;
        
    case cStopAdc       :
        DRVAdcStop();
        break;
        
    case cReadAdcValue  :
        mLibMemcpy(aBufferAdc->Address,&AnalogValue,sizeof(AnalogValue));
        break;
        
#ifdef AssertActive        
    default             :
        mLibAssert(cTrue);
        break;
#endif        

    }
}

#elif (__AVR_ATmega88__ || __AVR_ATmega168__)

#include "DRV_ADC.h"

static U16 AnalogValue;
static U1  IsRead;

void DRVAdcInit(void)
{
    ADMUX  = 0x43;
    ADCSRA = (1<<ADEN) | (1<<ADIE) | 0x03;
    ADCSRB = 0;
    AnalogValue = 0;
    IsRead = 0;
}

void DRVAdcStart(void)
{
    ADCSRA |= (1<<ADSC);
}


void DRVAdcStop(void)
{
    ADCSRA &= ~(1<<ADSC);
}


void ADC_vect( void )  __attribute__ ( ( signal ) );
void ADC_vect( void )
{
    DRVAdcStop();
    AnalogValue = 0;
    AnalogValue = ADCL;
    AnalogValue |= (U16)(ADCH<<8);
    DRVAdcStart();    
}

void DrvAdcControl(Buffer * aBufferAdc,tAddress aAddress)
{
    switch(aAddress)
    {
    case cStartAdc      :
        DRVAdcStart();
        break;
        
    case cStopAdc       :
        DRVAdcStop();
        break;
        
    case cReadAdcValue  :
        mLibMemcpy(aBufferAdc->Address,&AnalogValue,sizeof(AnalogValue));
        break;
        
#ifdef AssertActive        
    default             :
        mLibAssert(cTrue);
        break;
#endif        

    }
}

#endif //__AVR_ATmega8__
