#ifndef LIB_H
#define LIB_H

#include "string.h"
#include "API.h"
#include "CompilationOption.h"
#include "TypeDefinition.h"
#include <util/delay_basic.h>

/* Scheduler include files. */



#define mLibMemcpy(Dest,Source,Size)				memcpy(Dest,Source,Size)
#define mLibMemset(Dest,Value,Size)					memset(Dest,Value,Size)

#define mLibDisableInterrupt()						asm volatile ( "cli" :: );
#define mLibEnableInterrupt()						asm volatile ( "sei" :: );

#define mLibNop()                                   asm volatile ( "nop" :: );

#define mBagoteTestPortC4()             \
{                                       \
mWrite1BitInReg(DDRC,cTrue,PORTC4);     \
mWrite1BitInReg(PORTC,cTrue,PORTC4);    \
mLibNop();                              \
mLibNop();                              \
mWrite1BitInReg(PORTC,cFalse,PORTC4);   \
}

#define mLibMSB(u16)        (((U8* )&u16)[1])
#define mLibLSB(u16)        (((U8* )&u16)[0])
#define mLibMSW(u32)        (((U16*)&u32)[1])
#define mLibLSW(u32)        (((U16*)&u32)[0])
#define mLibMSB0(u32)       (((U8* )&u32)[3])
#define mLibMSB1(u32)       (((U8* )&u32)[2])
#define mLibMSB2(u32)       (((U8* )&u32)[1])
#define mLibMSB3(u32)       (((U8* )&u32)[0])
#define mLibLSB0(u32)       MSB3(u32)
#define mLibLSB1(u32)       MSB2(u32)
#define mLibLSB2(u32)       MSB1(u32)
#define mLibLSB3(u32)       MSB0(u32)



#ifdef AssertActive
	#define mLibAssert(Data)						Assert(Data);
#endif

// Macros  for Layers Initialisation
#define mDRVInit()		\
{						\
	mDrvLcdInit();		\
    mDrvKBDInit();      \
    mDrvTmrInit();      \
    mDrvAdcInit();      \
}

#define mMDWInit()		\
{						\
	mMDWLcdInit();		\
	mMDWTmrInit();		\
	mMDWKbdInit();		\
	mMDWAdcInit();		\
	mMDWEngInit();		\
}

#define mAPPInit()		\
{						\
	mAPPIhmInit();		\
}


#ifdef AssertActive
	extern void Assert(U8 TestingResult);
#endif

#endif	// LIB_H
