
#include "MDW_KBD.h"


static Buffer MdwKbdBuffer;

static U16 MdwKeyReleased;
static U8 ActiveKey;


void MdwKbdInit(void)
{
    MdwTmrSubscribeCallBack(&MdwKbdScan, 10);
}

static void MdwKbdRead(void)
{
    MdwKbdBuffer.Address = (U8*) &MdwKeyReleased;
    mDRVSendWithAddr(cChannelKbd,cReadReleasedkey,&MdwKbdBuffer);
}

static void MdwKbdFindKey(void)
{
    U8 keyCounter;
    
    for(keyCounter = 0;keyCounter < cNumberOfKeys; keyCounter++)
    {
        if( ((MdwKeyReleased >> keyCounter) & 0x01) )
        {
            ActiveKey = keyCounter;
            keyCounter = cNumberOfKeys;
        }
    }
}

void MdwKbdScan(void)
{

	mDRVSendWithAddr(cChannelKbd,cScanKeyboard,&MdwKbdBuffer);
	MdwKbdRead();
	MdwKbdFindKey(); 
	
}



U8 MdwKbdReadKeyState(tControl aIndex)
{
    switch(aIndex)
    {
    case cReadReleasedkey:
        return ActiveKey;
        break;
        
    case cClearKeyState:
        ActiveKey = cConsumedKey;
        MdwKeyReleased = 0;
        mDRVSendWithAddr(cChannelKbd,cClearKeyState,&MdwKbdBuffer);
        break;
        
    default:
        break;
    }
    
    return 0;
}

