


/**********************************************************
copyright (c) 2006
Title: RFM12A transmitter simple example based on PIC C
Current version: v1.0
Function: Package send Demo
Processor PIC16F73 DIP-28
Clock: 10MHz Crystal
Operate frequency: 434MHz
Data rate: 4.8kbps
Package size: 23byte
Author: Robben
Company: Hope microelectronic Co.,Ltd.
Contact: +86-0755-86106557
E-MAIL: hopefsk@hoperf.com
Date: 2006-11-21
********************************************************/
//#include "pic.h"
unsigned char i,d1,d2,d3;
typedef unsigned char uchar;
typedef unsigned int uint;
#define SDI portB.f4
#define SDO portC.f7
#define SCK portA.f1
#define nSEL portA.f0
#define SDI_OUT() TRISB.f4=0
#define SDO_IN() TRISC.f7=1
#define SCK_OUT() TRISA.f1=0
#define nSEL_OUT() TRISA.f0=0
void Init_RF12(void);
void Write0( void );
void Write1( void );
void WriteCMD( uint CMD );
void DelayUs( uint us );
void DelayMs(uint ms);
void WriteFSKbyte( uchar DATA );
//CONFIG(0x3FF2);



void Init_RF12(void)
{
nSEL_OUT();
SDI_OUT();
SDO_IN();
SCK_OUT();
nSEL=1;
SDI=1;
SCK=0;
WriteCMD(0x80D8);//enable register,433MHz,12.5pF
WriteCMD(0x8208);//Turn on crystal,!PA
WriteCMD(0xA640);//
WriteCMD(0xC647);//
WriteCMD(0x94C0);//VDI,FAST,134kHz,0dBm,-103dBm
WriteCMD(0xC2AC);
WriteCMD(0xCA80);
WriteCMD(0xCED4);
WriteCMD(0xCA83);//FIFO8,SYNC,
WriteCMD(0xC49B);
WriteCMD(0x9850);//!mp,90kHz,MAX OUT
WriteCMD(0xCC77);
WriteCMD(0xE000);//NOT USE
WriteCMD(0xC80E);//NOT USE
WriteCMD(0xC000);//1.0MHz,2.2V
}
void main()
{


uint ChkSum=0;
Init_RF12();

//trisb.f5=1;
//trisb.f6=1;
//trisb.f7=1;

trisa.f2=0;
porta.f2=1;

trisc.f3=0;
portc.f3=0;
//trisc.f4=0;
//portc.f4=0;
//
//trisc.f5=0;
//portc.f5=0;


ANSEL=0b00000000;
ANSELH=0;
ADCON0=0;
//i=0;

while(1)
{

WriteCMD(0x8228); //OPEN PA   0b1000 0010 0010 1000
DelayUs( 4 );
WriteCMD(0x8238);  //0b1000 0010 0011 1000
asm nop;//NOP();
asm nop;//NOP();
//WriteFSKbyte( 0xAA );
WriteFSKbyte( 0xAA );
WriteFSKbyte( 0xAA );
WriteFSKbyte( 0xAA );
WriteFSKbyte( 0x2D );
WriteFSKbyte( 0xD4 );
WriteFSKbyte( 0x30 );//DATA0    //48
ChkSum+=0x30;
WriteFSKbyte( 0x30 );//DATA1    //49
ChkSum+=0x31;
WriteFSKbyte( 0x32 );//DATA2           //50
ChkSum+=0x32;
WriteFSKbyte( 0x33 );//DATA3           //51
ChkSum+=0x33;
WriteFSKbyte( 0x34 );//DATA4           //52
ChkSum+=0x34;
WriteFSKbyte( 0x35 );//DATA5           //53
ChkSum+=0x35;
WriteFSKbyte( 0x36 );//DATA6           //54
ChkSum+=0x36;
WriteFSKbyte( 0x37 );//DATA7           //55
ChkSum+=0x37;
WriteFSKbyte( 0x38 );//DATA8           //56
ChkSum+=0x38;
WriteFSKbyte( 0x39 );//DATA9           //57
ChkSum+=0x39;
WriteFSKbyte( 0x3A );//DATA10           //58
ChkSum+=0x3A;
WriteFSKbyte( 0x3B );//DATA11           //59
ChkSum+=0x3B;
WriteFSKbyte( 0x3C );//DATA12           //60
ChkSum+=0x3C;
WriteFSKbyte(0x3D); //DATA13            //61
ChkSum+=0x3D;
WriteFSKbyte( 0x3E );//DATA14           //62
ChkSum+=0x3E;
WriteFSKbyte( 0x3F );//DATA15   //63
ChkSum+=0x3F;
ChkSum&=0x0FF;
WriteFSKbyte( ChkSum );//DATA16
WriteFSKbyte( 0xAA );
WriteCMD( 0x8208 ); //CLOSE PA
DelayMs(100);
portc.f3=~portc.f3;
}
}
void Write0( void )
{
SDI=0;
SCK=0;
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
SCK=1;
asm nop; //NOP();
}
void Write1( void )
{
SDI=1;
SCK=0;
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
asm nop; //NOP();
SCK=1;
asm nop; //NOP();
}
void WriteCMD( uint CMD )
{
uchar n=16;
SCK=0;
nSEL=0;
while(n--)
{
if(CMD&0x8000)
Write1();
else
Write0();
CMD=CMD<<1;
}
SCK=0;
nSEL=1;
}
void WriteFSKbyte( uchar DATA )
{
uchar RGIT=0;
uint temp=0xB800;
temp|=DATA;
Loop: SCK=0;
nSEL=0;
SDI=0;
SCK=1;
if(SDO) //Polling SDO
{
RGIT=1;
}
else
{
RGIT=0;
}
SCK=0;
SDI=1;
nSEL=1;
if(RGIT==0)
{
goto Loop;
}
else
{
RGIT=0;
WriteCMD(temp);
}
}
void DelayUs( uint us )
{
uint i;
while( us-- )
{
i=2;
while( i-- )
{
asm nop; //NOP();
}
}
}
void DelayMs(uint ms)
{
uchar i;
while(ms--)
{
i=35;
while(i--)
{
DelayUs(1);
}
}
}

