;LogiPic   v2.11  IdMax@free.fr - http://IdMax.free.fr
;*****************************************************************************
;* rectifcomp.prj
;* Pic 16f628a
;* Code source inspir des ouvrages de Bigonoff
;*****************************************************************************

	LIST	p=16f628a; Dfinition de processeur

	#include <p16f628a.inc>; Dfinitions de constantes

	__CONFIG	_CP_OFF & _PWRTE_ON & _WDT_OFF & _MCLRE_OFF & _LVP_OFF & _INTOSC_OSC_NOCLKOUT & _BODEN_OFF


;*********************************************************************
;ASSIGNATIONS
;*********************************************************************

;*********************************************************************
;DEFINE
;*********************************************************************

;*****************************************************************************
;MACROS
;*****************************************************************************
BANK0	macro
	bcf		STATUS,RP1
	bcf		STATUS,RP0		;passage en banque 0
	endm

BANK1	macro
	bcf		STATUS,RP1
	bsf		STATUS,RP0		;passage en banque 1
	endm

BANK2	macro
	bsf		STATUS,RP1
	bcf		STATUS,RP0		;passage en banque 2
	endm

BANK3	macro
	bsf		STATUS,RP1
	bsf		STATUS,RP0		;passage en banque 3
	endm

;*****************************************************************************
;VARIABLES
;*****************************************************************************

;*****************************************************************************
;                      VARIABLES BANQUE 0                                 *
;*****************************************************************************
; Zone de 96 bytes
; ----------------
	CBLOCK 0x20
	memtmp : 1
	memtmp2 : 1
	cmpt1 : 1
	cmpt2 : 1
	cmpt3 : 1
	V_Nb : 1		;ex : compteur de boucle
	ENDC

;*****************************************************************************
;DEMARRAGE SUR RESET
;*****************************************************************************
	org		0x000		; Adresse de dpart aprs reset

	goto		_init_		; Adresse 0: initialiser

;*****************************************************************************
;Initialisation
;*****************************************************************************
_init_
	BANK0		;Passage en banque 0
	MOVLW		 b'00000000'
	MOVWF		PORTA
	BANK0		;Passage en banque 0
	MOVLW		 b'00000000'
	MOVWF		PORTB
	BANK0		;Passage en banque 0
	MOVLW		 b'00000111'
	MOVWF		CMCON
	BANK1		;Passage en banque 1
	MOVLW		 b'00000000'
	MOVWF		VRCON

	BANK0		;Passage en banque 0

	goto		start	; sauter au programme principal

;*****************************************************************************
;Routines
;*****************************************************************************
;*****************************************************************************
;* Temporisation
;*****************************************************************************
_tmpT_1
	nop
	movlw		d'123'
	movwf		cmpt3
_b3T_1
	movlw		d'131'
	movwf		cmpt2
_b2T_1
	movlw		d'9'
	movwf		cmpt1
_b1T_1
	decfsz		cmpt1,f
	goto		_b1T_1
	decfsz		cmpt2,f
	goto		_b2T_1
	decfsz		cmpt3,f
	goto		_b3T_1
	return

;*****************************************************************************
;Programme principal
;*****************************************************************************
start	; 
_sautj0_3
	;***Opration***
	movlw		D'0'
	BANK0		;Passage en banque 0
	movwf		V_Nb

_sautj0_2
	;***Test sur une entre***
	BANK1		;Passage en banque 1
	bsf		TRISA,0
	BANK0		;Passage en banque 0
	btfss		PORTA,0
	goto		_sautb0_7

	;***Opration***
	incf		,w
	BANK0		;Passage en banque 0
	movwf		V_Nb

	call		_tmpT_1
	goto		_sautj0_2

_sautb0_7

	;***Test***
	BANK0		;Passage en banque 0
	movf		V_Nb,w
	sublw		D'5'	; soustraire memtmp de W
	btfsc		STATUS, C	; comparer le resultat
	goto		_sautb0_1

	;***Inversion d'une sortie***
	BANK1		;Passage en banque 1
	bcf		TRISA,3
	BANK0		;Passage en banque 0
	movlw		D'8'
	xorwf		PORTA, f

	goto		_sautj0_3

_sautb0_1

	goto		_sautj0_2

	END		; directive fin de programme
