#include "utils.h"


void delay_ms (unsigned int Attente)
{
unsigned int TempoInterne;
	
	for (; Attente > 0; Attente --)
	{
#if (CLOCK_QUARTZ >20)
		for (TempoInterne = 0; TempoInterne < 1999; TempoInterne+=NB_100ns_POUR_1CYCLE);
#elif (CLOCK_QUARTZ <=20)
		for (TempoInterne = 0; TempoInterne < 999; TempoInterne+=NB_100ns_POUR_1CYCLE);
#else
	#error utils.h - mauvaise valeur sur parametre CLOCK_QUARTZ
#endif

	}
}

void delay_s (unsigned char Attente)
{
unsigned int TempoInterne;
unsigned int TempoInterne2;

	for (; Attente > 0; Attente --)
	{
		for (TempoInterne = 0; TempoInterne < 1000; TempoInterne++)

		#if (CLOCK_QUARTZ >20)
		for (TempoInterne2 = 0; TempoInterne2 < 1997; TempoInterne2+=NB_100ns_POUR_1CYCLE);
		#elif (CLOCK_QUARTZ <=20)
		for (TempoInterne2 = 0; TempoInterne2 < 998; TempoInterne2+=NB_100ns_POUR_1CYCLE);
		#else
		#error utils.h - mauvaise valeur sur parametre CLOCK_QUARTZ
		#endif	
}
	
}


/*
///////////////////////////////////////////////////
void delay_us (unsigned int Attente)
{
	unsigned int Data;
	if (Attente > 10)
	{
		Data = Attente <<2;
		Data += Attente;
		Data <<=1;
		Data -= 96;
	}
	
	for (;Data > 20*NB_100ns_POUR_1CYCLE ; Data -= 20*NB_100ns_POUR_1CYCLE);
}

///////////////////////////////////////////////////

void delay_ms (unsigned int Attente)
{
unsigned int TempoInterne;
	
	for (; Attente > 0; Attente --)
	{
		for (TempoInterne = 0; TempoInterne < 900; TempoInterne+=NB_100ns_POUR_1CYCLE);
	}
}

///////////////////////////////////////////////////

void delay_s (unsigned char Attente)
{
unsigned int TempoInterne;
unsigned int TempoInterne2;

	for (; Attente > 0; Attente --)
	{
		for (TempoInterne = 0; TempoInterne < 500; TempoInterne++)
			for (TempoInterne2 = 0; TempoInterne2 < 951; TempoInterne2+=NB_100ns_POUR_1CYCLE);
	}
	
}
*/
///////////////////////////////////////////////////
//------------------------------------------------------------------------------
               //Ecriture eeprom octet
//------------------------------------------------------------------------------
void ecriture_eeprom (unsigned char adresse_ecriture, unsigned char donnee_a_ecrire)
{
	unsigned char EtatPrecedentInt;

	if (INTCONbits.GIE)
		EtatPrecedentInt = 1;
	else
		EtatPrecedentInt = 0;

	EEADR = adresse_ecriture;
	EEDATA = donnee_a_ecrire;

	EECON1bits.EEPGD = 0;
	EECON1bits.CFGS = 0;
	EECON1bits.WREN = 1;
	
	INTCONbits.GIE = 0;
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	while (EECON1bits.WR == 1);
	EECON1bits.WREN = 0;
	if (EtatPrecedentInt)
		INTCONbits.GIE = 1;

}

//------------------------------------------------------------------------------
               //Lecture eeprom octet
//------------------------------------------------------------------------------
unsigned char lecture_eeprom (unsigned char adresse_lire)
{
	unsigned char EtatPrecedentInt;

	if (INTCONbits.GIE)
		EtatPrecedentInt = 1;
	else
		EtatPrecedentInt = 0;
	
       INTCONbits.GIE = 0;   // Toutes les IT dmasques hautes priorits INTERDIT
	EEADR = (unsigned char)(adresse_lire&0x00FF);
	EEADR = adresse_lire;
	
	EECON1bits.EEPGD = 0;
	EECON1bits.CFGS = 0;
	EECON1bits.RD = 1;
	if (EtatPrecedentInt)
		INTCONbits.GIE = 1;
	return EEDATA;
}



//------------------------------------------------------------------------------
               //Ecriture eeprom 2 octets LSB en premier
//------------------------------------------------------------------------------
void ecriture_eeprom_16bits (unsigned char adresse_ecriture, unsigned int donnee_a_ecrire)
{
	ecriture_eeprom(adresse_ecriture+1, (unsigned char)(donnee_a_ecrire>>8));
	ecriture_eeprom(adresse_ecriture, (unsigned char)(donnee_a_ecrire&0x00FF));

}

//------------------------------------------------------------------------------
               //Ecriture eeprom long LSB en premier
//------------------------------------------------------------------------------
void ecriture_eeprom_32bits (unsigned char adresse_ecriture, unsigned long donnee_a_ecrire)
{
	ecriture_eeprom(adresse_ecriture+3, (unsigned char)(donnee_a_ecrire>>24));
	ecriture_eeprom(adresse_ecriture+2, (unsigned char)(donnee_a_ecrire>>16));
	ecriture_eeprom(adresse_ecriture+1, (unsigned char)(donnee_a_ecrire>>8));
	ecriture_eeprom(adresse_ecriture, (unsigned char)(donnee_a_ecrire&0x00FF));
}

//------------------------------------------------------------------------------
               //Lecture eeprom 16 bits 
//------------------------------------------------------------------------------
unsigned int lecture_eeprom_16bits (unsigned char adresse_lire)
{
	unsigned int retour;
	unsigned char Data;
	
	retour = lecture_eeprom(adresse_lire+1);
	retour<<=8;
	Data = lecture_eeprom(adresse_lire);
	retour += Data;
	
	return retour;
}

//------------------------------------------------------------------------------
               //Lecture eeprom 32bits
//------------------------------------------------------------------------------
unsigned long lecture_eeprom_32bits (unsigned char adresse_lire)
{
	unsigned long retour;
	unsigned char Data;

	
	retour = lecture_eeprom(adresse_lire+3);
	retour <<= 8;
	Data = lecture_eeprom(adresse_lire+2);
	retour += Data;
	retour<<=8;
	Data = lecture_eeprom(adresse_lire+1);
	retour += Data;
	retour<<=8;
	Data = lecture_eeprom(adresse_lire);
	retour += Data;
	
	return retour;
}


//------------------------------------------------------------------------------
//               Fonction valeur Absolue
//------------------------------------------------------------------------------
unsigned int abs (int Valeur)
{
unsigned int Retour;

	if (Valeur < 0)
		Retour = 0 - Valeur;
	else
		Retour = Valeur;
		
return Retour;
	
}

#pragma code
//----------------------------------------------------------------------------
unsigned char ConvertAsciiToChar (char* Val)
{
unsigned char Temp, Retour;

			Temp = Val[0] -0x30;
			if (Temp > 9)
				Temp -= 7;
			Retour = Temp <<4;

			Temp = Val[1] - 0x30;
			if (Temp > 9)
				Temp -= 7;
			Retour += Temp;

return Retour;
}
//----------------------------------------------------------------------------
void ConvertCharToAscii (unsigned char Val, char* Ascii)
{
unsigned char Temp;

		Temp = Val >>4;
		if (Temp > 9)
			Temp += 0x37;
		else
			Temp += 0x30;
		Ascii[0] = Temp;

		Temp = Val & 0x0F;
		if (Temp > 9)
			Temp += 0x37;
		else
			Temp += 0x30;
		Ascii[1] = Temp;
}
