/*--------------------------------------------------------------------

  Filename    : rc_decoder.c

----------------------------------------------------------------------

  CHANGE HISTORY

  Jean-Christophe PAPELARD

  Issue   Modifier  Date      Change Description
  1.0     RW        09/05/09  premire version

--------------------------------------------------------------------*/




#include <p18cxxx.h>
#include "decoder_rc5.h"




#pragma code

/*--- initialise rc decoder interrupt ---*/

void init_rc_decoder(void)
  {

    init_timer_1();
    INTCON2bits.INTEDG0 = 0 ; //interruption INT0 sur RB0 sur front descendant
    INTCONbits.INT0IF = 0;  // efface flag inerruption INT0
    INTCONbits.PEIE = 1;
    INTCONbits.GIE = 1;   // Toutes les IT dmasques hautes priorits autorises
    INTCONbits.INT0IE = 1;  // active les interruptions inerruption INT0

  }
unsigned int ReadTimer1(void)
{
  union Timers timer;

  timer.bt[0] = TMR1L;    // lecture Lower byte
  timer.bt[1] = TMR1H;    //lecture  upper byte

  return (timer.lt);      // Retourne la valeur 16-bit
}

void WriteTimer1(unsigned int timer1)
{
  union Timers timer;

  timer.lt = timer1;    // Save valeur 16-bit

  TMR1H = timer.bt[1];  // Ecrit high byte dans Timer1 High byte
  TMR1L = timer.bt[0];  // Ecrit low byte dans Timer1 Low byte
}



void init_timer_1(void)  // init timer 1
  {
  T1CON = 0;     // mets a 0 registre de config du timer

  T1CONbits.RD16 = 1;   // mode 16 bit
  T1CONbits.T1CKPS0 = 1;
  T1CONbits.T1CKPS1 = 1;  /* Prescale 1:8 */
  TMR1H = 0x00;
  TMR1L = 0x00;           
  PIR1bits.TMR1IF = 0;  
  PIE1bits.TMR1IE = 0;    /* pas d'interruption sur le timer  */
  T1CONbits.TMR1ON = 1;    // active timer
  }




/*--- RC decoder function ---*/
unsigned char rc_decoder(unsigned char *RC5addr, unsigned char *RC5data)
  {
  unsigned int  bit_time, test_time, limit, rc_code;
  unsigned char bit_counter;

  WriteTimer1(0);
  if(!wait_while_low()){ // attends que RC_PIN passe a 1
    return 0;
    }
  if(!wait_while_high()){ // attends que RC_PIN passe a 0
    return 0;
    }
  //PORTC = TMR1L;
  //PORTD = TMR1H; 
  bit_time = ReadTimer1();  /* Calibrate bit time, valeur correspond a la mesure entre le temps bas et haut */
  //if (bit_time < 432 || bit_time > 447 ) return 0;  // filtre parasite :uniquement pour 8Mhz 
  //if (bit_time < 1000 || bit_time > 2000  ) return 0;  // filtre parasite :uniquement pour 32Mhz 
  if (bit_time < 2050 || bit_time > 3840  ) return 0;  // filtre parasite :uniquement pour 40Mhz 

  test_time = (bit_time / 4) * 3; /* 3/4 bit time */
  limit = (bit_time / 4) * 5;     /* Out of limits */
  WriteTimer1(0);
  for(bit_counter = 0; bit_counter < 12; bit_counter++)
    {
    while(ReadTimer1() < test_time){
      continue;
      }

    if(RC_PIN == 1)  // bit =1
      {
      if(!wait_while_high()){
        return 0;
        }

      bit_time = ReadTimer1();
        WriteTimer1(0);

      if(bit_time < limit){
        rc_code <<= 1;
        rc_code |= 1;  // mets un 1 sur le bit 0
       }
      }
    else if(RC_PIN == 0)   // bit =0
      {
      if(!wait_while_low()){
        return 0;
        }

      bit_time = ReadTimer1();
      WriteTimer1(0);

      if(bit_time < limit){
        rc_code <<= 1;
        rc_code &= 0xfffe;  // mets un 0 sur le bit 0
        }
      }
    }

   wait_while_low();  // attend que  RC_PIN repasse a 1

   //tempo de detection d'erreur : si 32Mhz, alors T timer 1 (prescale sur 8) : 1s, donc si valeur depart timer 1 = 0 , alors tempo de 65,535ms environ
   // pour calcul T timer 1 et prscaler sur 8: 8/(32000000/4)=  1S 
   PIR1bits.TMR1IF = 0; // efface flag du timer 1(en cas si il a debord)
   WriteTimer1(65535-10000);  // pour faire tempo de 30ms a 32mhz
   while (PIR1bits.TMR1IF == 0)  
   {
    if (RC_PIN == 0) return 0;  // regarde si la patte est pass a 0 pendant la tempo (dans ce cas erreur)
   }
   
  *RC5addr = (rc_code >> 6) & 0x001f;  // rcup l'adresse
  *RC5data = rc_code & 0x003f;  // rcup la commande
  //RC_CODESbits.toggle = (rc_code >> 11) & 0x0001;  // rcup toggle ( =1 si nouvelle touche appuy)
  
  return 1;  // return la valeur 1 si un code a bien t recus
  }

/*--- sous prog : attends tant que la patte du capteur est a 0---*/
unsigned char wait_while_low(void)
  {
  unsigned char result = 1;
  PIR1bits.TMR1IF = 0;  // efface flag du timer 1(en cas si il a debord)

  while(RC_PIN == 0){
    if(PIR1bits.TMR1IF == 1){  /* Timeout : regarde si le timer a debord*/
      result = 0;
      break;
      }

    }
  return result;
  }

/*--- sous prog : attends tant que la patte du capteur est a 0---*/
unsigned char wait_while_high(void)
  {
  unsigned char result = 1;

  PIR1bits.TMR1IF = 0; // efface flag du timer 1(en cas si il a debord)

  while(RC_PIN == 1){
    if(PIR1bits.TMR1IF == 1){  /* Timeout */
      result = 0;
      break;
      }
    }
  return 1;
  }
