#ifndef __DECODER_RC5_H
#define __DECODER_RC5_H



/*--- Macros ---*/

#define RC_PIN PORTBbits.RB0  //le capteur IR est branch sur entr interruption de front INT0 (RB0)

#define RC_ADDRESS      0U  // valeur 0 si tlcommande type TV
#define RC_VOLUME_UP    16U
#define RC_VOLUME_DOWN  17U
#define RC_PROG_UP     32U
#define RC_PROG_DOWN   33U
#define RC_MUTE         13U
#define RC_STANDBY      12U


/* utilis pour sauvegard la variable 16-bit */
union Timers
{
  unsigned int lt;
  char bt[2];
};


//volatile RC_EVENT RC_EVENTbits;

/*--- Local function prototype ---*/

void init_rc_decoder(void);
void init_timer_1(void);
unsigned int ReadTimer1(void);
void WriteTimer1(unsigned int timer1);
unsigned char rc_decoder(unsigned char *RC5addr, unsigned char *RC5data);
unsigned char wait_while_low(void);
unsigned char wait_while_high(void);
void execute_rc_event(void);

