/*--------------------------------------------------------------------

  Filename    : rc_decoder.c

----------------------------------------------------------------------

  CHANGE HISTORY

  Jean-Christophe PAPELARD

  Issue   Modifier  Date      Change Description
  1.0     J-C P        26/05/09  Premire version
  1.1     J-C P        30/05/09  Correctif bug, amliorations
  1.2     J-C P        10/06/09 amlioration de la commande du moteur   

--------------------------------------------------------------------*/

#include <p18cxxx.h>
#include "decoder_rc5.h"
#include "utils.h"
#include "config_pic.h"


// tableau d'quivalence pour la commande de l'afficheur

unsigned char RC5_adress, RC5_data;  // variable du code RC5_recus
unsigned char RC5_data_old, compteur_RC5_data;

unsigned char standby_flag, mute_flag,  mise_en_marche_flag;
signed char mode_flag;

/*--- Local function prototype ---*/
void interrupt_at_high_vector(void);
void interrupt_at_low_vector(void);
void interrupt_low(void);
void interrupt_high(void);
void Mode_telecommande(void);
//void init_telecommande_mode (void);


///** I N T E R R U P T V E C T O R S ****************************** ***********/

#pragma code high_vector=0x08
void interrupt_at_high_vector(void)
{
_asm goto interrupt_high _endasm
}
#pragma code


#pragma code low_vector=0x18
void interrupt_at_low_vector(void)
{
_asm goto interrupt_low _endasm
}
#pragma code

#pragma interrupt interrupt_low
void interrupt_low(void){}

/*--- Rc interrupt ---*/
#pragma interrupt interrupt_high
void interrupt_high(void)
  {

  if(rc_decoder(&RC5_adress, &RC5_data ) == 1) 
{
	if (RC5_adress == 0) // c'est a dire reception d'un code TV, alors :
	{
       
	if (RC5_data_old == RC5_data && INTCONbits.TMR0IF == 0) // si mme apuis que prcdement et que le timer 0 na pas debord
	{ compteur_RC5_data++;}// pour detection d'appuis long
	else compteur_RC5_data=0; // nouvelle appuis
	
	// reset du timer 0
	TMR0H = 0x4F;
 	TMR0L = 0x00;           
  	INTCONbits.TMR0IF = 0; // efface flag du timer 0 

	RC5_data_old = RC5_data;
	}

  }

    INTCONbits.INT0IF = 0;  // efface flag inerruption INT0
    INTCONbits.INT0IE = 1;  // active les interruptions inerruption INT0
  }

#pragma code

void main()
{

ADCON1 = 0x0F;     // toute les pattes de sortie en numrique
 CMCON= 0x07;       // desactive les comparateurs  uniquement si utilisation d'un PIC18F4520

PORTB=0;
TRISB=0b00000001;  // RB0 en entre, RB1  RB7 en entre
PORTC=0;
TRISC=0;
PORTD=0;
TRISD=0;
PORTE=0;
TRISE=0;
PORTA=0;
TRISA=0;

INTCON2bits.RBPU = 0; // active des rsistance de pull-up sur le portB

mise_en_marche_flag =1 ; // vus que l'appareil viens de ce mettre en marche, pour dire a la suite de restaur les valeur
// config timer 0 qui va servir a detecter l'espace entre l'appuis (en temps)de touches de la tlcommande




while(1){


Mode_telecommande();



}
}

void Mode_telecommande(void)
{
unsigned char eeprom_flag;


init_rc_decoder(); // initialise timer 1+ active interruption INT0


//init variable comptage
compteur_RC5_data = 0;
RC5_data_old = 0;
// reset du timer 0
TMR0H = 0x4F;
TMR0L = 0x00;             
INTCONbits.TMR0IF = 0; // efface flag du timer 0 
INTCONbits.TMR0IE = 0; // pas d'interruption du timer 0 
T0CON =0b00010100; //  timer off (au demarage)/mode 16bit/prescaler actif/prdiviseur sur 32
T0CONbits.TMR0ON = 1;  //active le comptage du timer 0


while(1)
{
PORTC = RC5_data;
PORTD = RC5_adress;
/*
///////////////////  MUTE  /////////////////
if (  (RC5_data== RC_MUTE)) // detection de la touche mute appuy
{

	if (mute_flag) // si dja en veille, restaure le dernier sortie selectionn
	{mute_flag=0;
	PORTD  = 0xFF;
//      commande_relais(mode_flag);   // restaure relais
//	LATC = table_display[mode_flag];
	}
	else {
//	LATC = table_display[6]; //passage en veille : affiche le -
	mute_flag=1;
	PORTD  = 0x00;

	}

RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait
eeprom_flag = 1; // pour dire de sauvegarder lorsque que la touche va tre relach
}
*/

}

}
////if (mise_en_marche_flag) init_telecommande_mode ();

////if (standby_flag && mute_flag ) mute_flag=0;  // detecttion d'erreur
//if (standby_flag) LATC = table_display[5]; // restaure la veille
//else if (mute_flag) LATC = table_display[6]; // sinon restaure le mute
//else LATC = table_display[mode_flag]; // sinon affiche la dernire sortie selectionn


/*
do  // boucle gnral, qui regarde qui on est encore en mode tlcommande
{

///////////////////  MUTE  /////////////////
if (  (RC5_data== RC_MUTE) && !compteur_RC5_data && !standby_flag ) // detection de la touche mute appuy
{

	if (mute_flag) // si dja en veille, restaure le dernier sortie selectionn
	{mute_flag=0;
//      commande_relais(mode_flag);   // restaure relais
//	LATC = table_display[mode_flag];
	}
	else {
//	LATC = table_display[6]; //passage en veille : affiche le -
	mute_flag=1;
	}

RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait
eeprom_flag = 1; // pour dire de sauvegarder lorsque que la touche va tre relach
}

///////////////////  STANDBY  /////////////////
else if (  (RC5_data== RC_STANDBY) && !compteur_RC5_data )
{
	if (standby_flag) // si dja en veille, restaure le dernier sortie selectionn
	{standby_flag=0;
	mute_flag=0; // desactive le mute
//	commande_relais(mode_flag); // restaure relais
	//LATC = table_display[mode_flag];
	}
	else {
//	LATC = table_display[5]; //passage en veille : affiche le .
	standby_flag=1;
	}

RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait
eeprom_flag = 1; // pour dire de sauvegarder lorsque que la touche va tre relach
}

///////////////////  PROG UP  /////////////////
else if (  (RC5_data== RC_PROG_UP) && (compteur_RC5_data  > 3) && !standby_flag && !mute_flag)
{
mode_flag++;
if (mode_flag == 5) mode_flag=4;
//LATC = table_display[mode_flag];
RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait
compteur_RC5_data =0;
mute_flag = 0;
standby_flag = 0;
eeprom_flag = 1; // pour dire de sauvegarder lorsque que la touche va tre relach
}

///////////////////  PROG DOWN  /////////////////
else if (  (RC5_data== RC_PROG_DOWN) && (compteur_RC5_data  > 3) && !standby_flag && !mute_flag)
{
mode_flag--;
if (mode_flag == -1) mode_flag=0;
//LATC = table_display[mode_flag];
RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait
compteur_RC5_data =0;
mute_flag = 0;
standby_flag = 0;
eeprom_flag = 1; // pour dire de sauvegarder lorsque que la touche va tre relach
}

///////////////////  VOLUME_UP  /////////////////
else if (  (RC5_data== RC_VOLUME_UP) && !standby_flag && !mute_flag)
{


mute_flag = 0;
standby_flag = 0;
RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait

}
/////////////////// VOLUME_DOWN  /////////////////

else if (  (RC5_data== RC_VOLUME_DOWN) && !standby_flag && !mute_flag)
{

mute_flag = 0;
standby_flag = 0;
RC5_data= 0; //reset de la donne recus, car elle viens d'tre trait

}
/////////////////// si pas de code valide recus ////////////
else
{


if (INTCONbits.TMR0IF && !mute_flag && !standby_flag)
{

LATA = 0x00;
LATD = 0x00;
}
if (eeprom_flag == 1)
{
ecriture_eeprom (0x00, standby_flag);
ecriture_eeprom (0x01, mute_flag);
ecriture_eeprom (0x02, mode_flag);
eeprom_flag = 0;
}
}


/////////////////////   FIN BOUCLE //////////////////
} while (!PORTBbits.RB6);
INTCONbits.GIE = 0;   // Toutes les IT dmasques hautes priorits interdite (interdit telecommande)
TRISB = 0b11111111;
*/

//}


/*

void init_telecommande_mode (void)
{
// si l'appareil viens de ce mettre en marche : restauration data eeprom sauvegard
standby_flag = lecture_eeprom (0x00);  // si =1 alors appareil en veille
if (standby_flag > 1) standby_flag =0; // detection si eeprom vide
mute_flag = lecture_eeprom (0x01);  // si =1 alors appareil en mute
if (mute_flag  > 1) mute_flag =0; // detection si eeprom vide
mode_flag = lecture_eeprom (0x02); // 0= affiche 1/1= affiche2/ 2 = affiche 3/ 3= affiche 4/ 4= affiche 5
if (mode_flag > 4 || mode_flag < 0 ) mode_flag=0;  // detection si eeprom vide

mise_en_marche_flag =0 ;
}

*/