import processing.core.*; import java.applet.*; import java.awt.*; import java.awt.image.*; import java.awt.event.*; import java.io.*; import java.net.*; import java.text.*; import java.util.*; import java.util.zip.*; public class Xelyx_diffusionCoeurLeger13_04 extends PApplet {//simulation Xelyx du coeur l\u00e9ger.
//Bas\u00e9e sur le texte de Robert Mellet
// que l'on peut trouver ici: http://pagesperso-orange.fr/robert.mellet/diff/diff_01.htm
// version 0.013 du 13/04/2008

float h=0.005f;//mesure d'un pas de division en m\u00e8tre
float k=5;//pas des temps en secondes

int pasEnMm=PApplet.parseInt(h*1000);//5
int mmEnPixel=2;
int pasEnPixel=pasEnMm*mmEnPixel;//10
int marge=30;

int lB40_pas,lmat_pas,lmor_pas,lhab2_pas;
int lB40_mm,lmat_mm,lmor_mm,lhab2_mm;
int largeMur_mm,largeur_mm,largeur_pas,largeMur_pas,largeMur_pix;

boolean locked = false;
float[] TableTemperatures=new float[200];//les temperatures \u00e0 l'instant t
float[] TableTempProvisoire=new float[200];//les temp\u00e9ratures \u00e0 l'intant t+k
float[] TableTempDepart=new float[200];//les temp\u00e9ratures au d\u00e9part
float[] tempExterne=new float[25];
float[] tempFeu=new float[25];
float tempFeuPB[]={412,283,238,215,202,193,185,176,167,159,148,142,137,132,127,122,118,114,110,107,103,99,95};
float tempExternePB[]={49,55.5f,64,68.5f,70.5f,69.5f,68.8f,68,67.1f,66.3f,65.5f,64,62.5f,61,59.5f,58,56,55,54,53,51.5f,50,49};
String etat;
float Hhabillage2=h*h/k/0.0000016f;//diffusivit\u00e9 du Habillage2 permet de calculer H
float Hbrique=h*h/k/0.0000008f;//difusivit\u00e9 de la  B40N permet de calculer H
float Hbriquo=h*h/k/0.0000007f;//difusivit\u00e9 de la  brique ordinaire permet de calculer H
float Hmortier=h*h/k/0.0000007f;//difusivit\u00e9 de la  mortier permet de calculer H(mortier tr\u00e8s serr\u00e9)
float Hmat=h*h/k/0.00000008f;//difusivit\u00e9 du mat de verre permet de calculer H (laine de roche)
float Hair=h*h/k/0.00000015f;//difusivit\u00e9 de l'air permet de calculer H
float secondes=0;
float incremental,kWh,kWhTir,tempSur,tempInt,valCoefEchange;
int minutes;
float heuref;
int heure=0;
int mn,e1;//minutes et epaisseurs en pas
float tf;
int couleur=20;
PFont font16,font12,font8;
Tirette kWhTirette, tempSurfaceExterne,CoefEchange,capacitHabillage,conductiHabillage, capacitHabillage2,conductiHabillage2;
Tirette epaisMat,epaisB40,epaisMor,epaishab2, coefHeat, tempSuperficielleInt,capacitMat,conductiMat;
RectButton boutonGo;
//////////////////////////////////////////////////////////
public void setup(){
  size(900,680);

  font16 = loadFont("Arial16.vlw");
  font12 = loadFont("Arial12.vlw"); 
   font8= loadFont("Arial8.vlw"); 
   kWhTirette=new Tirette(700,480,160, 40 , 105,"kW.h = ",40,1, font12);
   tempSurfaceExterne=new Tirette(700,510,160, 20 , 80,"t\u00b0 ext\u00e9rieure = ",50,1, font12);
   tempSuperficielleInt=new Tirette(700,450,160, 50 , 180,"t\u00b0 int\u00e9rieure = ",110,1, font12);
   CoefEchange=new Tirette(700,540,160,4 ,50,"coef d'\u00e9change = ",15,1, font12);
   coefHeat=new Tirette(700,570,160,0 ,0.025f,"coef d'\u00e9change = ",0.005f,0.001f, font12);
    
  epaisB40=new Tirette(30,480,120,50 ,180,"B40N",65,5, font12);
  epaisMat=new Tirette(190,480,120,10 ,100," Mat",30,10, font12);
  capacitMat=new Tirette(190,510,120,10,2300 ,"capacit\u00e9 kJ/m3/K",100,10, font12);
  conductiMat=new Tirette(190,540,120,0.05f ,3.0f,"conductiv\u00e9 W/m/K",0.05f,0.05f, font12);
  epaisMor=new Tirette(350,480,120,10 ,150,"mortier",50,10, font12);
  epaishab2=new Tirette(510,480,120,10 ,150,"Habillage2",100,10, font12);

  capacitHabillage=new Tirette(350,510,120,1000,2300 ,"capacit\u00e9 kJ/m3/K",1650,10, font12);
  conductiHabillage=new Tirette(350,540,120,0.5f ,3,"conductiv\u00e9 W/m/K",1.15f,0.05f, font12);
  capacitHabillage2=new Tirette(510,510,120,1000,2300 ,"capacit\u00e9 kJ/m3/K",2100,10, font12);
  conductiHabillage2=new Tirette(510,540,120,0.5f ,3.0f,"conductiv\u00e9 W/m/K",1.75f,0.05f, font12);
  
  
  boutonGo=new RectButton(700, 600, 160,60, 190, 125); 
  initialise();
}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
public void draw(){ 
  background(255-couleur,220+couleur,220+couleur);
 
  if (secondes==0) {
     fill(205,215,255);
     rect(10,550,660,120);
      boutonGo.display();
      CoefEchange.actualiser();
      kWhTirette.actualiser();             kWhTir= kWhTirette.getValeur();
      tempSurfaceExterne.actualiser();     tempSur=tempSurfaceExterne.getValeur();
      tempSuperficielleInt.actualiser();   tempInt=tempSuperficielleInt.getValeur();
      coefHeat.actualiser();   
         
           
           epaisMat.actualiser();   lmat_mm=PApplet.parseInt(epaisMat.getValeur());      lmat_pas=PApplet.parseInt(epaisMat.getValeur()/pasEnMm);
           epaisB40.actualiser();   lB40_mm=PApplet.parseInt(epaisB40.getValeur());      lB40_pas=PApplet.parseInt(epaisB40.getValeur()/pasEnMm);
           epaisMor.actualiser();   lmor_mm=PApplet.parseInt(epaisMor.getValeur());      lmor_pas=PApplet.parseInt(epaisMor.getValeur()/pasEnMm);
           epaishab2.actualiser();  lhab2_mm=PApplet.parseInt(epaishab2.getValeur());   lhab2_pas=PApplet.parseInt(epaishab2.getValeur()/pasEnMm);
            
           largeMur_mm=lmat_mm+lB40_mm+lmor_mm+lhab2_mm;//la dimension r\u00e9elle du mur
           largeur_mm=largeMur_mm+30;//mur+couche d'air
           largeur_pas=PApplet.parseInt(largeur_mm/pasEnMm);// en pas virtuel(1 pas= 5mmm=10pixels)
           largeMur_pas=PApplet.parseInt(largeMur_mm/pasEnMm);
           largeMur_pix=PApplet.parseInt(largeMur_mm*mmEnPixel);
     
    
      
      
      valCoefEchange=CoefEchange.getValeur();
      Hair=h*h/k/valCoefEchange;
      capacitHabillage.actualiser();
      conductiHabillage.actualiser();
      capacitHabillage2.actualiser();
      conductiHabillage2.actualiser();
      capacitMat.actualiser();
      conductiMat.actualiser();
      Hmat=h*h/k/(conductiMat.getValeur()/(capacitMat.getValeur()*1000));
      Hmortier=h*h/k/(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
      Hhabillage2=h*h/k/(conductiHabillage2.getValeur()/(capacitHabillage2.getValeur()*1000));
     // float dif=(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
    
      tempExterne[0]=tempSur;
      initialise();
      actualiserBouton(mouseX,mouseY);
   
  }else{
  modifierTemps();
  afficherDonnees();
  if(secondes<7200){
    flambee();
  }
  else{ couleur=0;
    if (secondes<86400){

      recalculertout();  
    } 
  } 
  }
  dessiner();
  montrertempExterne();
  delay(50);
}
//////////////////////////////////////
public void afficherDonnees(){
 montrerTempFeu(); 
 textFont(font12);


 text("epaisseur B40N      = "+lB40_mm+" mm",660,465);
 text("epaisseur mat       = "+lmat_mm+" mm",660,480);
 text("epaisseur hab1       = "+lmor_mm+" mm",660,495);
 text("capacit\u00e9 th hab1     = "+capacitHabillage.getValeur()+" kJ/m3/K",660,510);
 text("conductivit\u00e9 hab1    = "+conductiHabillage.getValeur()+" W/m/K",660,525);
  text("\u00e9paisseur Habillage2     = "+epaishab2.getValeur()+" mm",660,540);
 text("capacit\u00e9 Habillage2     = "+capacitHabillage2.getValeur()+" kJ/m3/K",660,555);
 text("conductivit\u00e9 Habillage2    = "+conductiHabillage2.getValeur()+" W/m/K",660,570);
 text("coef de transfert  =  "+valCoefEchange+" W/m2/K",660,585);
 text("temperature ext hab = "+tempSur+" degr\u00e9s",660,600);
 text("kiloWattheures     = "+ kWhTir+" kW.h",660,615);
}



//////////////////////////////////////
public void actualiserBouton(int x,int y){
  boutonGo.update();
  if(boutonGo.pressed()) {
      secondes=1;
}}



//////////////////////////////////////
public void modifierTemps(){
  if(secondes<86400){
    secondes+=k;
    minutes=PApplet.parseInt(secondes/60);

    heuref=secondes/3600f;
    if(PApplet.parseInt(heuref)>heure){
      heure=PApplet.parseInt(heuref);
      tempExterne[ heure ]=TableTemperatures[largeMur_pas];
       //Remplir le tableau tempFeu
    if(heure>1) {tempFeu[heure]=TableTemperatures[0];}
    }
    mn=minutes-60*heure;
   
  }
}



//////////////////////////////////////////////////////////
public void initialise(){
  

  for(int i=0;i<largeMur_pas;i++){  
    TableTemperatures[i]=tempInt-i*(tempInt-tempSur)/largeMur_pas;
     TableTempDepart[i]=TableTemperatures[i];
  }
  for(int i=0;i<6;i++){  
    TableTemperatures[i+largeMur_pas]=tempSur-(tempSur-20)/5*i;
    TableTempDepart[i+largeMur_pas]=TableTemperatures[i+largeMur_pas];
  }
}
//////////////////////////////////////////////////////////
public void dessiner(){
  fill(255);
  rect(marge,0,largeMur_pix,450);
  textFont(font16);
  axes();
  
  for(int i=0;i<largeMur_pas;i++){
    stroke(0);
    line(marge+i*pasEnPixel,450-TableTemperatures[i],marge+(1+i)*pasEnPixel,450-TableTemperatures[i+1]);
  }
          textFont(font16);fill(0); text("THELYX  : la  Diffusion thermique dans le coeur et l'habillage",290,30);
         
          
            textFont(font16);  fill(150, 102, 43);  text("http://www.xelyx.com   le coeur l\u00e9ger",340,45);
          text("t\u00b0\u00e0 0mm    = "+TableTemperatures[0], 4+marge, 440-TableTemperatures[0]);
          text("temp\u00e9rature de surface  = "+TableTemperatures[largeMur_pas], 220 ,570);
 
   textFont(font16); 
          if(heure<2)  {    text("accumumulation : "+kWh + " kWh ",marge+30,430);  } 
              else {    text("diffusion : "+kWh + " kWh ",marge+70,430);  }
    
  fill(0, 102, 200);  text(heure+" heure(s) "+mn+" minute(s) ", marge+350, 430);
}

/////////////////////////////////////////////////////
public void recalculer(float H1, int d, int a){  
  for(int i=d;i<=a;i++){
    TableTempProvisoire[i] =TableTemperatures[i+1]/H1+TableTemperatures[i]*(1-2/H1)+TableTemperatures[i-1]/H1;  
  }
}
/////////////////////////////////////////////////////
public void flambee(){
 
  if(secondes<3600){
  tf=110+390*sq(sin(secondes/7200*3.14f));}else {tf=500;}
  TableTemperatures[0]=tf;
  TableTempProvisoire[0] =tf;
  recalculertout();
}
//////////////////////////////////////////////////////lB40_pas,lmat_pas,lmor_pas
public void recalculertout(){
  e1=lB40_pas;
  
  recalculer(Hbrique,1,e1-1);
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmat+TableTemperatures[e1]*(1-1/Hbrique-1/Hmat)+TableTemperatures[e1-1]/Hbrique;
  recalculer(Hmat,e1+1,e1+lmat_pas-1);
   e1=lB40_pas+lmat_pas;
   
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmortier+TableTemperatures[e1]*(1-1/Hmortier-1/Hmat)+TableTemperatures[e1-1]/Hmat;
  recalculer(Hmortier,e1+1,e1+lmor_pas-1);
  e1=lB40_pas+lmat_pas+lmor_pas;
  
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hhabillage2+TableTemperatures[e1]*(1-1/Hmortier-1/Hhabillage2)+TableTemperatures[e1-1]/Hmortier;
  recalculer(Hhabillage2,e1+1,e1+lhab2_pas-1);
  e1=lB40_pas+lmat_pas+lmor_pas+lhab2_pas;
  TableTempProvisoire[e1] =TableTemperatures[e1-1]-valCoefEchange*h*(TableTemperatures[e1]-20)/conductiHabillage2.getValeur();
 
 
   if(secondes>=7200) 
  
   TableTempProvisoire[0]= calculerTemperature0(TableTemperatures[1],TableTemperatures[0]);
   
  //recopier et calculer la variation de t\u00b0
   incremental=0;
  for(int i=0;i<largeur_pas;i++){    
    TableTemperatures[i]=TableTempProvisoire[i];
  }
if(secondes<7200){
  calculerkWhdans();
}else{
  calculerkWhhors(); 
  }
  
}
//////////////////////////////////////////////////////////

public void calculerkWhhors(){
   incremental=0;
  for(int i=0;i<lB40_pas;i++){    
    incremental+=TableTempDepart[i]-TableTemperatures[i];
  }
  kWh=incremental*0.569f*h*8;
  incremental=0;
  for(int i=lB40_pas;i<lB40_pas+lmat_pas+lmor_pas;i++){    
    incremental+=(TableTempDepart[i]-TableTemperatures[i]);
  }
  kWh+=incremental*capacitHabillage.getValeur()/3600*8*h;
  incremental=0;
  for(int i=lB40_pas+lmat_pas+lmor_pas;i<largeur_pas;i++){    
    incremental+=(TableTempDepart[i]-TableTemperatures[i]);
  }
  kWh+=incremental*capacitHabillage2.getValeur()/3600*8*h; 
  kWh=PApplet.parseInt(kWh*10F)/10F;
}
  
  
//////////////////////////////////////////////////////////


public void calculerkWhdans(){
  incremental=0;
  for(int i=0;i<lB40_pas;i++){    
    incremental+=(TableTemperatures[i]-TableTempDepart[i]);
  }
  
  kWh=incremental*0.569f*h*8;//0.569 est la capacit\u00e9 de B40N en kW.h/m3/deltaT, 8est la surface en m\u00b2 et h est l'epaisseur d'une tranche
  incremental=0;// /36 c'es pour convertir en heures
  for(int i=lB40_pas;i<lB40_pas+lmat_pas+lmor_pas;i++){    
    incremental+=TableTemperatures[i]-TableTempDepart[i];
  }
  kWh+=incremental*capacitHabillage.getValeur()/3600*8*h;//capacitHabillage.getValeur() en kJ/m3/K doit \u00eatre divis\u00e9 par 3600 pour ontenir des kW.h/m3/K
 
   incremental=0;// /36 c'es pour converit en heures
  for(int i=lB40_pas+lmat_pas+lmor_pas;i<largeMur_pas;i++){    
    incremental+=TableTemperatures[i]-TableTempDepart[i];
  }
  kWh+=incremental*capacitHabillage2.getValeur()/3600*8*h;
 
  kWh=PApplet.parseInt(kWh*10F)/10F;
 // recopier la table dans la table d\u00e9part pout le calcul des kwh en sortie
  if(kWh>kWhTir){ 
        secondes=7200;    
        tempExterne[2]=TableTemperatures[largeMur_pas];
        for(int i=0;i<largeur_pas;i++){    
            TableTempDepart[i]=TableTemperatures[i];
        }
  }
  }
//////////////////////////////////////////////////////////
public void axes(){
  //int largeMur_pix=pasEnPixel*largeMur_pas;
  float r=mmEnPixel;
  float pos;

  stroke(150);
  line(marge,450,marge+largeMur_pix,450);
  line(marge,400,marge+largeMur_pix,400);
  line(marge,400,marge+largeMur_pix,400);
  line(marge,350,marge+largeMur_pix,350);
  line(marge,300,marge+largeMur_pix,300);
  line(marge,250,marge+largeMur_pix,250);
  line(marge,200,marge+largeMur_pix,200); 
  line(marge,150,marge+largeMur_pix,150);
  line(marge,100,marge+largeMur_pix,100);
  line(marge,50,marge+largeMur_pix,50);
  line(marge,0,marge+largeMur_pix,0);

  line(marge,0,marge,450);
  line(marge+largeMur_pix,0,marge+largeMur_pix,450); 
textFont(font8);
fill(50);
for(int i=0;i<80;i+=10){ 
  line(marge,650-i,marge+580,650-i);
  text(" "+i,marge+580,654-i);
  text(" "+i,marge-10,654-i);
}

  line(marge+lB40_mm*r,0,marge+lB40_mm*r,450);
  line(marge+(lB40_mm+lmat_mm)*r,0,marge+(lB40_mm+lmat_mm)*r,450);
  line(marge+(lB40_mm+lmat_mm+lmor_mm)*r,0,marge+(lB40_mm+lmat_mm+lmor_mm)*r,450);
 
  fill(255,0,0);textFont(font12);
  for(int i=0;i<10;i++){
    int j=i*50; 
    text(" "+j,marge-25,455-i*50);
    text(" "+j,largeMur_pix+30,455-i*50);
  }

}
//////////////////////////////////////////////////////////
public void montrertempExterne(){    
  stroke(0,0,255);
  for(int i=0;i<heure-2;i++){//print(tempExterne[i]+"  ");
    line(marge+24*i,650-tempExterne[i+2],marge+24*(i+1),650-tempExterne[i+3]);
  }
  stroke(255,0,0);
  for(int i=0;i<22;i++){
    line(marge+24*i,650-tempExternePB[i],marge+24*(i+1),650-tempExternePB[i+1]);
  } 
}
//////////////////////////////////////////////////////////
public void montrerTempFeu(){
textFont(font8);
int tem;
fill(50);
for(int i=0;i<=8;i++){
 stroke(255); 
  line(marge,540-i*10,marge+580,540-i*10);
  tem=70+i*30;
  text(" "+tem,marge+580,544-i*10);
  text(" "+tem,marge-16,544-i*10);
}
 stroke(255,0,0);
  for(int i=0;i<22;i++){
    line(marge+24*i,540-(-70+tempFeuPB[i])/3,marge+24*(i+1),540-(-70+tempFeuPB[i+1])/3);
  }
 stroke(0,0,255);
  for(int i=2;i<heure;i++){
    line(marge+24*(i-2),540-(-70+tempFeu[i])/3,marge+24*(i-1),540-(-70+tempFeu[i+1])/3);
}
}

/////////////////////////////////////////////////////////////
 public float calculerTemperature0(float t1,float t0){
    float res= 0.95f*t0+0.05f*t1+coefHeat.getValeur();//
  // float res= 0.985*t0+0.015*t1;//
   return res;
    }
    
    



class Button
{
  int x, y;
  int xsize,ysize;
  int basecolor, highlightcolor;
  int currentcolor;
  boolean over = false;
  boolean pressed = false;   
 int decale=0;
  public void update() 
  {
    if(over()) {
      currentcolor = highlightcolor;
    } 
    else {
      currentcolor = basecolor;
    }
  }

  public boolean pressed() 
  {
    if(over) {
      locked = true;
      return true;
    } 
    else {
      locked = false;
      return false;
    }    
  }

  public boolean over() 
  { 
    return true; 
  }

  public boolean overRect(int x, int y, int width, int height) 
  {
    if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height  ) {
        {if(mousePressed == true) {decale=0 ; return true;}else{decale=1; return false;}}
    } 
    else {decale=0;
      return false;
    }
  }

  public boolean overCircle(int x, int y, int diameter) 
  {
    float disX = x - mouseX;
    float disY = y - mouseY;
    if(sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
      return true;
    } 
    else {
      return false;
    }
  }

}



class RectButton extends Button
{
  RectButton(int ix, int iy, int xsiz,int ysiz, int icolor, int ihighlight) 
  {
    x = ix;
    y = iy;
    xsize = xsiz;
    ysize = ysiz;
    basecolor = icolor;
    highlightcolor = ihighlight;
    currentcolor = basecolor;
  }

  public boolean over() 
  {
    if( overRect(x, y, xsize, ysize) ) {
      over = true;
      return true;
    } 
    else {
      over = false;
      return false;
    }
  }

  public void display() 
  {
    stroke(50,50,255);
    fill(currentcolor);
    rect(x, y, xsize, ysize);
     fill(155,150,255);
    rect(x+4+decale, y+4+decale, xsize-8, ysize-8);
       fill(255,0,0);
    textFont(font16);
    text("start",x+xsize/2-16,y+ysize/2+3);
      fill(255);
       text("start",x+xsize/2-17,y+ysize/2+4); 
  }
}






///////////////////////////TIRETTE
public class Tirette {
  float xpos,xbut,longueur;
  int x,y,couleur1,couleur2;
  float valmin,valmax,coef,valeur,precision;
  String titre;
  boolean survol,drag;
  PFont lafonte;


  //**********************************************************
  public Tirette(int x,int y,float longueur,float valmin
    ,float valmax,String titre,float valdepart,float precision,PFont  lafont){
    this.x=x;
    this.y=y;
  
    this.survol=false;
    this.drag=false;
    this.longueur=longueur;
    this.valmin=valmin;
    this.valmax=valmax;
    this.coef=(valmax-valmin)/longueur;
     this.xpos=x+(valdepart-valmin)/coef;println(coef+" //////    "+xpos);
    this.xbut=x+(valdepart-valmin)/coef;
    this.titre=titre;
    this.valeur=valdepart;
     this.precision=precision;
    this.lafonte=lafont;
    
  }
  //******************************************************
  public void actualiser(){
    if(!mousePressed && drag) drag=false;
    survol= (mouseX>xpos-10)&&(mouseX<xpos+10)&&(mouseY>y-10)&&(mouseY<y+10);
    if(!drag){drag=survol&&mousePressed;};
    if(drag)  xbut=constrain(mouseX,x,x+longueur);
    xpos+=(xbut-xpos)/1.2f;
    this.calculer();
    this.dessinerbarre();
  }
  //****************************************************
  public  void calculer(){
    valeur=valmin+(xpos-x)*coef;
    valeur=Math.round(valeur/precision)*precision;
  }
  public float getValeur(){
    return valeur;
  }
  public void setValeur(float v){
    xpos=((v-valmin)/(float)coef )+x;  //Math.round
    
    xbut=xpos;
  }
  //****************************************************
  public void dessinerbarre(){

    stroke(couleur1);
    fill(160,140,230);
    rect(x,y-3,xpos-x,6);
    fill(255);
    rect(xpos,y-1,longueur+x-xpos,2);
  
    fill(couleur1);
    textFont(lafonte);
    
    text(titre+" = "+valeur,x,y-7);
  }

  //****************************************************  
  public void setposition(float valeur){
    xpos=(int)((valeur-valmin)/coef+x);
    xbut=xpos;
  }
}

  static public void main(String args[]) {     PApplet.main(new String[] { "Xelyx_diffusionCoeurLeger13_04" });  }}