//simulation Xelyx du coeur lger.
//Base sur le texte de Robert Mellet
// que l'on peut trouver ici: http://pagesperso-orange.fr/robert.mellet/diff/diff_01.htm
// version 0.013 du 13/04/2008

float h=0.005;//mesure d'un pas de division en mtre
float k=5;//pas des temps en secondes

int pasEnMm=int(h*1000);//5
int mmEnPixel=2;
int pasEnPixel=pasEnMm*mmEnPixel;//10
int marge=30;

int lB40_pas,lmat_pas,lmor_pas,lhab2_pas;
int lB40_mm,lmat_mm,lmor_mm,lhab2_mm;
int largeMur_mm,largeur_mm,largeur_pas,largeMur_pas,largeMur_pix;

boolean locked = false;
float[] TableTemperatures=new float[200];//les temperatures  l'instant t
float[] TableTempProvisoire=new float[200];//les tempratures  l'intant t+k
float[] TableTempDepart=new float[200];//les tempratures au dpart
float[] tempExterne=new float[25];
float[] tempFeu=new float[25];
float tempFeuPB[]={412,283,238,215,202,193,185,176,167,159,148,142,137,132,127,122,118,114,110,107,103,99,95};
float tempExternePB[]={49,55.5,64,68.5,70.5,69.5,68.8,68,67.1,66.3,65.5,64,62.5,61,59.5,58,56,55,54,53,51.5,50,49};
String etat;
float Hhabillage2=h*h/k/0.0000016f;//diffusivit du Habillage2 permet de calculer H
float Hbrique=h*h/k/0.0000008f;//difusivit de la  B40N permet de calculer H
float Hbriquo=h*h/k/0.0000007f;//difusivit de la  brique ordinaire permet de calculer H
float Hmortier=h*h/k/0.0000007f;//difusivit de la  mortier permet de calculer H(mortier trs serr)
float Hmat=h*h/k/0.00000008f;//difusivit du mat de verre permet de calculer H (laine de roche)
float Hair=h*h/k/0.00000015f;//difusivit de l'air permet de calculer H
float secondes=0;
float incremental,kWh,kWhTir,tempSur,tempInt,valCoefEchange;
int minutes;
float heuref;
int heure=0;
int mn,e1;//minutes et epaisseurs en pas
float tf;
int couleur=20;
PFont font16,font12,font8;
Tirette kWhTirette, tempSurfaceExterne,CoefEchange,capacitHabillage,conductiHabillage, capacitHabillage2,conductiHabillage2;
Tirette epaisMat,epaisB40,epaisMor,epaishab2, coefHeat, tempSuperficielleInt,capacitMat,conductiMat;
RectButton boutonGo;
//////////////////////////////////////////////////////////
void setup(){
  size(900,680);

  font16 = loadFont("Arial16.vlw");
  font12 = loadFont("Arial12.vlw"); 
   font8= loadFont("Arial8.vlw"); 
   kWhTirette=new Tirette(700,480,160, 40 , 105,"kW.h = ",40,1, font12);
   tempSurfaceExterne=new Tirette(700,510,160, 20 , 80,"t extrieure = ",50,1, font12);
   tempSuperficielleInt=new Tirette(700,450,160, 50 , 180,"t intrieure = ",110,1, font12);
   CoefEchange=new Tirette(700,540,160,4 ,50,"coef d'change = ",15,1, font12);
   coefHeat=new Tirette(700,570,160,0 ,0.025,"coef d'change = ",0.005,0.001, font12);
    
  epaisB40=new Tirette(30,480,120,50 ,180,"B40N",65,5, font12);
  epaisMat=new Tirette(190,480,120,10 ,100," Mat",30,10, font12);
  capacitMat=new Tirette(190,510,120,10,2300 ,"capacit kJ/m3/K",100,10, font12);
  conductiMat=new Tirette(190,540,120,0.05 ,3.0,"conductiv W/m/K",0.05,0.05, font12);
  epaisMor=new Tirette(350,480,120,10 ,150,"mortier",50,10, font12);
  epaishab2=new Tirette(510,480,120,10 ,150,"Habillage2",100,10, font12);

  capacitHabillage=new Tirette(350,510,120,1000,2300 ,"capacit kJ/m3/K",1650,10, font12);
  conductiHabillage=new Tirette(350,540,120,0.5 ,3,"conductiv W/m/K",1.15,0.05, font12);
  capacitHabillage2=new Tirette(510,510,120,1000,2300 ,"capacit kJ/m3/K",2100,10, font12);
  conductiHabillage2=new Tirette(510,540,120,0.5 ,3.0,"conductiv W/m/K",1.75,0.05, font12);
  
  
  boutonGo=new RectButton(700, 600, 160,60, 190, 125); 
  initialise();
}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
void draw(){ 
  background(255-couleur,220+couleur,220+couleur);
 
  if (secondes==0) {
     fill(205,215,255);
     rect(10,550,660,120);
      boutonGo.display();
      CoefEchange.actualiser();
      kWhTirette.actualiser();             kWhTir= kWhTirette.getValeur();
      tempSurfaceExterne.actualiser();     tempSur=tempSurfaceExterne.getValeur();
      tempSuperficielleInt.actualiser();   tempInt=tempSuperficielleInt.getValeur();
      coefHeat.actualiser();   
         
           
           epaisMat.actualiser();   lmat_mm=int(epaisMat.getValeur());      lmat_pas=int(epaisMat.getValeur()/pasEnMm);
           epaisB40.actualiser();   lB40_mm=int(epaisB40.getValeur());      lB40_pas=int(epaisB40.getValeur()/pasEnMm);
           epaisMor.actualiser();   lmor_mm=int(epaisMor.getValeur());      lmor_pas=int(epaisMor.getValeur()/pasEnMm);
           epaishab2.actualiser();  lhab2_mm=int(epaishab2.getValeur());   lhab2_pas=int(epaishab2.getValeur()/pasEnMm);
            
           largeMur_mm=lmat_mm+lB40_mm+lmor_mm+lhab2_mm;//la dimension relle du mur
           largeur_mm=largeMur_mm+30;//mur+couche d'air
           largeur_pas=int(largeur_mm/pasEnMm);// en pas virtuel(1 pas= 5mmm=10pixels)
           largeMur_pas=int(largeMur_mm/pasEnMm);
           largeMur_pix=int(largeMur_mm*mmEnPixel);
     
    
      
      
      valCoefEchange=CoefEchange.getValeur();
      Hair=h*h/k/valCoefEchange;
      capacitHabillage.actualiser();
      conductiHabillage.actualiser();
      capacitHabillage2.actualiser();
      conductiHabillage2.actualiser();
      capacitMat.actualiser();
      conductiMat.actualiser();
      Hmat=h*h/k/(conductiMat.getValeur()/(capacitMat.getValeur()*1000));
      Hmortier=h*h/k/(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
      Hhabillage2=h*h/k/(conductiHabillage2.getValeur()/(capacitHabillage2.getValeur()*1000));
     // float dif=(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
    
      tempExterne[0]=tempSur;
      initialise();
      actualiserBouton(mouseX,mouseY);
   
  }else{
  modifierTemps();
  afficherDonnees();
  if(secondes<7200){
    flambee();
  }
  else{ couleur=0;
    if (secondes<86400){

      recalculertout();  
    } 
  } 
  }
  dessiner();
  montrertempExterne();
  delay(50);
}
//////////////////////////////////////
void afficherDonnees(){
 montrerTempFeu(); 
 textFont(font12);


 text("epaisseur B40N      = "+lB40_mm+" mm",660,465);
 text("epaisseur mat       = "+lmat_mm+" mm",660,480);
 text("epaisseur hab1       = "+lmor_mm+" mm",660,495);
 text("capacit th hab1     = "+capacitHabillage.getValeur()+" kJ/m3/K",660,510);
 text("conductivit hab1    = "+conductiHabillage.getValeur()+" W/m/K",660,525);
  text("paisseur Habillage2     = "+epaishab2.getValeur()+" mm",660,540);
 text("capacit Habillage2     = "+capacitHabillage2.getValeur()+" kJ/m3/K",660,555);
 text("conductivit Habillage2    = "+conductiHabillage2.getValeur()+" W/m/K",660,570);
 text("coef de transfert  =  "+valCoefEchange+" W/m2/K",660,585);
 text("temperature ext hab = "+tempSur+" degrs",660,600);
 text("kiloWattheures     = "+ kWhTir+" kW.h",660,615);
}



//////////////////////////////////////
void actualiserBouton(int x,int y){
  boutonGo.update();
  if(boutonGo.pressed()) {
      secondes=1;
}}



//////////////////////////////////////
void modifierTemps(){
  if(secondes<86400){
    secondes+=k;
    minutes=int(secondes/60);

    heuref=secondes/3600f;
    if(int(heuref)>heure){
      heure=int(heuref);
      tempExterne[ heure ]=TableTemperatures[largeMur_pas];
       //Remplir le tableau tempFeu
    if(heure>1) {tempFeu[heure]=TableTemperatures[0];}
    }
    mn=minutes-60*heure;
   
  }
}



//////////////////////////////////////////////////////////
void initialise(){
  

  for(int i=0;i<largeMur_pas;i++){  
    TableTemperatures[i]=tempInt-i*(tempInt-tempSur)/largeMur_pas;
     TableTempDepart[i]=TableTemperatures[i];
  }
  for(int i=0;i<6;i++){  
    TableTemperatures[i+largeMur_pas]=tempSur-(tempSur-20)/5*i;
    TableTempDepart[i+largeMur_pas]=TableTemperatures[i+largeMur_pas];
  }
}
//////////////////////////////////////////////////////////
void dessiner(){
  fill(255);
  rect(marge,0,largeMur_pix,450);
  textFont(font16);
  axes();
  
  for(int i=0;i<largeMur_pas;i++){
    stroke(0);
    line(marge+i*pasEnPixel,450-TableTemperatures[i],marge+(1+i)*pasEnPixel,450-TableTemperatures[i+1]);
  }
          textFont(font16);fill(0); text("THELYX  : la  Diffusion thermique dans le coeur et l'habillage",290,30);
         
          
            textFont(font16);  fill(150, 102, 43);  text("http://www.xelyx.com   le coeur lger",340,45);
          text("t 0mm    = "+TableTemperatures[0], 4+marge, 440-TableTemperatures[0]);
          text("temprature de surface  = "+TableTemperatures[largeMur_pas], 220 ,570);
 
   textFont(font16); 
          if(heure<2)  {    text("accumumulation : "+kWh + " kWh ",marge+30,430);  } 
              else {    text("diffusion : "+kWh + " kWh ",marge+70,430);  }
    
  fill(0, 102, 200);  text(heure+" heure(s) "+mn+" minute(s) ", marge+350, 430);
}

/////////////////////////////////////////////////////
void recalculer(float H1, int d, int a){  
  for(int i=d;i<=a;i++){
    TableTempProvisoire[i] =TableTemperatures[i+1]/H1+TableTemperatures[i]*(1-2/H1)+TableTemperatures[i-1]/H1;  
  }
}
/////////////////////////////////////////////////////
void flambee(){
 
  if(secondes<3600){
  tf=110+390*sq(sin(secondes/7200*3.14));}else {tf=500;}
  TableTemperatures[0]=tf;
  TableTempProvisoire[0] =tf;
  recalculertout();
}
//////////////////////////////////////////////////////lB40_pas,lmat_pas,lmor_pas
void recalculertout(){
  e1=lB40_pas;
  
  recalculer(Hbrique,1,e1-1);
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmat+TableTemperatures[e1]*(1-1/Hbrique-1/Hmat)+TableTemperatures[e1-1]/Hbrique;
  recalculer(Hmat,e1+1,e1+lmat_pas-1);
   e1=lB40_pas+lmat_pas;
   
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmortier+TableTemperatures[e1]*(1-1/Hmortier-1/Hmat)+TableTemperatures[e1-1]/Hmat;
  recalculer(Hmortier,e1+1,e1+lmor_pas-1);
  e1=lB40_pas+lmat_pas+lmor_pas;
  
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hhabillage2+TableTemperatures[e1]*(1-1/Hmortier-1/Hhabillage2)+TableTemperatures[e1-1]/Hmortier;
  recalculer(Hhabillage2,e1+1,e1+lhab2_pas-1);
  e1=lB40_pas+lmat_pas+lmor_pas+lhab2_pas;
  TableTempProvisoire[e1] =TableTemperatures[e1-1]-valCoefEchange*h*(TableTemperatures[e1]-20)/conductiHabillage2.getValeur();
 
 
   if(secondes>=7200) 
  
   TableTempProvisoire[0]= calculerTemperature0(TableTemperatures[1],TableTemperatures[0]);
   
  //recopier et calculer la variation de t
   incremental=0;
  for(int i=0;i<largeur_pas;i++){    
    TableTemperatures[i]=TableTempProvisoire[i];
  }
if(secondes<7200){
  calculerkWhdans();
}else{
  calculerkWhhors(); 
  }
  
}
//////////////////////////////////////////////////////////

void calculerkWhhors(){
   incremental=0;
  for(int i=0;i<lB40_pas;i++){    
    incremental+=TableTempDepart[i]-TableTemperatures[i];
  }
  kWh=incremental*0.569*h*8;
  incremental=0;
  for(int i=lB40_pas;i<lB40_pas+lmat_pas+lmor_pas;i++){    
    incremental+=(TableTempDepart[i]-TableTemperatures[i]);
  }
  kWh+=incremental*capacitHabillage.getValeur()/3600*8*h;
  incremental=0;
  for(int i=lB40_pas+lmat_pas+lmor_pas;i<largeur_pas;i++){    
    incremental+=(TableTempDepart[i]-TableTemperatures[i]);
  }
  kWh+=incremental*capacitHabillage2.getValeur()/3600*8*h; 
  kWh=int(kWh*10F)/10F;
}
  
  
//////////////////////////////////////////////////////////


void calculerkWhdans(){
  incremental=0;
  for(int i=0;i<lB40_pas;i++){    
    incremental+=(TableTemperatures[i]-TableTempDepart[i]);
  }
  
  kWh=incremental*0.569*h*8;//0.569 est la capacit de B40N en kW.h/m3/deltaT, 8est la surface en m et h est l'epaisseur d'une tranche
  incremental=0;// /36 c'es pour convertir en heures
  for(int i=lB40_pas;i<lB40_pas+lmat_pas+lmor_pas;i++){    
    incremental+=TableTemperatures[i]-TableTempDepart[i];
  }
  kWh+=incremental*capacitHabillage.getValeur()/3600*8*h;//capacitHabillage.getValeur() en kJ/m3/K doit tre divis par 3600 pour ontenir des kW.h/m3/K
 
   incremental=0;// /36 c'es pour converit en heures
  for(int i=lB40_pas+lmat_pas+lmor_pas;i<largeMur_pas;i++){    
    incremental+=TableTemperatures[i]-TableTempDepart[i];
  }
  kWh+=incremental*capacitHabillage2.getValeur()/3600*8*h;
 
  kWh=int(kWh*10F)/10F;
 // recopier la table dans la table dpart pout le calcul des kwh en sortie
  if(kWh>kWhTir){ 
        secondes=7200;    
        tempExterne[2]=TableTemperatures[largeMur_pas];
        for(int i=0;i<largeur_pas;i++){    
            TableTempDepart[i]=TableTemperatures[i];
        }
  }
  }
//////////////////////////////////////////////////////////
void axes(){
  //int largeMur_pix=pasEnPixel*largeMur_pas;
  float r=mmEnPixel;
  float pos;

  stroke(150);
  line(marge,450,marge+largeMur_pix,450);
  line(marge,400,marge+largeMur_pix,400);
  line(marge,400,marge+largeMur_pix,400);
  line(marge,350,marge+largeMur_pix,350);
  line(marge,300,marge+largeMur_pix,300);
  line(marge,250,marge+largeMur_pix,250);
  line(marge,200,marge+largeMur_pix,200); 
  line(marge,150,marge+largeMur_pix,150);
  line(marge,100,marge+largeMur_pix,100);
  line(marge,50,marge+largeMur_pix,50);
  line(marge,0,marge+largeMur_pix,0);

  line(marge,0,marge,450);
  line(marge+largeMur_pix,0,marge+largeMur_pix,450); 
textFont(font8);
fill(50);
for(int i=0;i<80;i+=10){ 
  line(marge,650-i,marge+580,650-i);
  text(" "+i,marge+580,654-i);
  text(" "+i,marge-10,654-i);
}

  line(marge+lB40_mm*r,0,marge+lB40_mm*r,450);
  line(marge+(lB40_mm+lmat_mm)*r,0,marge+(lB40_mm+lmat_mm)*r,450);
  line(marge+(lB40_mm+lmat_mm+lmor_mm)*r,0,marge+(lB40_mm+lmat_mm+lmor_mm)*r,450);
 
  fill(255,0,0);textFont(font12);
  for(int i=0;i<10;i++){
    int j=i*50; 
    text(" "+j,marge-25,455-i*50);
    text(" "+j,largeMur_pix+30,455-i*50);
  }

}
//////////////////////////////////////////////////////////
void montrertempExterne(){    
  stroke(0,0,255);
  for(int i=0;i<heure-2;i++){//print(tempExterne[i]+"  ");
    line(marge+24*i,650-tempExterne[i+2],marge+24*(i+1),650-tempExterne[i+3]);
  }
  stroke(255,0,0);
  for(int i=0;i<22;i++){
    line(marge+24*i,650-tempExternePB[i],marge+24*(i+1),650-tempExternePB[i+1]);
  } 
}
//////////////////////////////////////////////////////////
void montrerTempFeu(){
textFont(font8);
int tem;
fill(50);
for(int i=0;i<=8;i++){
 stroke(255); 
  line(marge,540-i*10,marge+580,540-i*10);
  tem=70+i*30;
  text(" "+tem,marge+580,544-i*10);
  text(" "+tem,marge-16,544-i*10);
}
 stroke(255,0,0);
  for(int i=0;i<22;i++){
    line(marge+24*i,540-(-70+tempFeuPB[i])/3,marge+24*(i+1),540-(-70+tempFeuPB[i+1])/3);
  }
 stroke(0,0,255);
  for(int i=2;i<heure;i++){
    line(marge+24*(i-2),540-(-70+tempFeu[i])/3,marge+24*(i-1),540-(-70+tempFeu[i+1])/3);
}
}

/////////////////////////////////////////////////////////////
 float calculerTemperature0(float t1,float t0){
    float res= 0.95*t0+0.05*t1+coefHeat.getValeur();//
  // float res= 0.985*t0+0.015*t1;//
   return res;
    }
    
    
