//simulation Xelyx d'un dphasage.
//Base sur le texte de Robert Mellet
// que l'on peut trouver ici: http://pagesperso-orange.fr/robert.mellet/diff/diff_01.htm
// version 0.00 08/04/2008

float h=0.005;//mesure d'un pas de division en mtre
float k=5;//pas des temps en secondes

int pasEnMm=int(h*1000);//5
int mmEnPixel=2;
int pasEnPixel=pasEnMm*mmEnPixel;//10
int marge=30;

int lB40_pas,lmat_pas,lmor_pas,lgra_pas;
int lB40_mm,lmat_mm,lmor_mm,lgra_mm;
int largeMur_mm,largeur_mm,largeur_pas,largeMur_pas,largeMur_pix;

boolean locked = false;
float[] TableTemperatures=new float[200];//les temperatures  l'instant t
float[] TableTempProvisoire=new float[200];//les tempratures  l'intant t+k
float[] TableTempDepart=new float[200];//les tempratures au dpart
float[] tempExterne=new float[5000];
float[] tempFeu=new float[5000];

String etat;
float Hgranit=h*h/k/0.0000016f;//diffusivit du granit permet de calculer H
float Hbrique=h*h/k/0.0000008f;//difusivit de la  B40N permet de calculer H
float Hbriquo=h*h/k/0.0000007f;//difusivit de la  brique ordinaire permet de calculer H
float Hmortier=h*h/k/0.0000007f;//difusivit de la  mortier permet de calculer H(mortier trs serr)
float Hmat=h*h/k/0.00000036f;//difusivit du mat de verre permet de calculer H (laine de roche)
float Hair=h*h/k/0.00000015f;//difusivit de l'air permet de calculer H
float secondes=0;
float incremental,kWh,kWhTir,tempSur,valCoefEchange;
int minutes;
float heuref;
int heure=0;
int mn,e1;//minutes et epaisseurs en pas
float tf;
int couleur=20;
PFont font16,font12,font8;
Tirette kWhTirette, tempSurface,CoefEchange,capacitHabillage,conductiHabillage, capacitGranit,conductiGranit;
Tirette epaisMat,epaisB40,epaisMor,epaisGra;
RectButton boutonGo;
//////////////////////////////////////////////////////////
void setup(){
  size(900,680);

  font16 = loadFont("Arial16.vlw");
  font12 = loadFont("Arial12.vlw"); 
   font8= loadFont("Arial8.vlw"); 
   kWhTirette=new Tirette(700,480,160, 40 , 105,"kW.h = ",85,1, font12);
   tempSurface=new Tirette(700,510,160, 0 , 30,"t surface = ",17,1, font12);
   CoefEchange=new Tirette(700,540,160,4 ,50,"coef d'change = ",20,1, font12);
    
  epaisB40=new Tirette(30,480,120,110 ,180,"B40N",115,5, font12);
  epaisMat=new Tirette(190,480,120,4 ,35," Mat",5,5, font12);
  epaisMor=new Tirette(350,480,120,10 ,50,"mortier",25,5, font12);
  epaisGra=new Tirette(510,480,120,90 ,200,"Granit",110,10, font12);

  capacitHabillage=new Tirette(350,510,120,1000,2300 ,"capacit kJ/m3/K",1650,1, font12);
  conductiHabillage=new Tirette(350,540,120,0.3 ,3,"conductiv W/m/K",1.15,0.01, font12);
  capacitGranit=new Tirette(510,510,120,1000,2300 ,"capacit kJ/m3/K",1820,1, font12);
  conductiGranit=new Tirette(510,540,120,1.1 ,3.2,"conductiv W/m/K",3.0,0.01, font12);
  
  
  boutonGo=new RectButton(700, 560, 160,100, 190, 125); 
  initialise();
}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
void draw(){ 
  background(255-couleur,220+couleur,220+couleur);
 
  if (secondes==0) {
     fill(205,215,255);
     rect(10,550,860,120);
      boutonGo.display();
      CoefEchange.actualiser();
      kWhTirette.actualiser();       kWhTir= kWhTirette.getValeur();
      tempSurface.actualiser();     tempSur=tempSurface.getValeur();
           
         
           
           epaisMat.actualiser();   lmat_mm=int(epaisMat.getValeur());      lmat_pas=int(epaisMat.getValeur()/pasEnMm);
           epaisB40.actualiser();   lB40_mm=int(epaisB40.getValeur());      lB40_pas=int(epaisB40.getValeur()/pasEnMm);
           epaisMor.actualiser();   lmor_mm=int(epaisMor.getValeur());      lmor_pas=int(epaisMor.getValeur()/pasEnMm);
           epaisGra.actualiser();   lgra_mm=int(epaisGra.getValeur());      lgra_pas=int(epaisGra.getValeur()/pasEnMm);
            
           largeMur_mm=lmat_mm+lB40_mm+lmor_mm+lgra_mm;//la dimension relle du mur
           largeur_mm=largeMur_mm+30;//mur+couche d'air
           largeur_pas=int(largeur_mm/pasEnMm);// en pas virtuel(1 pas= 5mmm=10pixels)
           largeMur_pas=int(largeMur_mm/pasEnMm);
           largeMur_pix=int(largeMur_mm*mmEnPixel);
     
    
      
      
      valCoefEchange=CoefEchange.getValeur();
      Hair=h*h/k/valCoefEchange;
      capacitHabillage.actualiser();
      conductiHabillage.actualiser();
      capacitGranit.actualiser();
      conductiGranit.actualiser();
      
      Hmortier=h*h/k/(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
      Hgranit=h*h/k/(conductiGranit.getValeur()/(capacitGranit.getValeur()*1000));
      float dif=(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
    
      tempExterne[0]=tempSur;
      initialise();
      actualiserBouton(mouseX,mouseY);
   
  }else{
  modifierTemps();
  afficherDonnees();
 
    flambee();
 
 
    

      recalculertout();  
  
  } 
 
  dessiner();
  montrertempExterne();
  delay(50);
}
//////////////////////////////////////
void afficherDonnees(){
 montrerTempFeu(); 

}



//////////////////////////////////////
void actualiserBouton(int x,int y){
  boutonGo.update();
  if(boutonGo.pressed()) {
      secondes=1;
}}



//////////////////////////////////////
void modifierTemps(){
  
    secondes+=k;
    minutes=int(secondes/60);

    heuref=secondes/3600f;
    if(int(heuref)>heure){
      heure=int(heuref);
      
      tempExterne[ heure ]=TableTemperatures[largeMur_pas];
      tempFeu[heure]=TableTemperatures[0];
    }
    mn=minutes-60*heure;
   
 
}



//////////////////////////////////////////////////////////
void initialise(){
  

  for(int i=0;i<=largeMur_pas;i++){  
    TableTemperatures[i]=17;
     TableTempDepart[i]=TableTemperatures[i];
  }
  for(int i=0;i<6;i++){  
    TableTemperatures[i+largeMur_pas]=tempSur-(tempSur-20)/5*i;
    TableTempDepart[i+largeMur_pas]=TableTemperatures[i+largeMur_pas];
  }
   tempFeu[0]=TableTemperatures[0];
}
//////////////////////////////////////////////////////////
void dessiner(){
  fill(255);
  rect(marge,0,largeMur_pix,450);
  textFont(font16);
  axes();
   stroke(255,0,0);
  for(int i=0;i<largeMur_pas;i++){
   
    line(marge+i*pasEnPixel,350-10*TableTemperatures[i],marge+(1+i)*pasEnPixel,350-10*TableTemperatures[i+1]);
  }
          textFont(font12);fill(0); text("Dphasage thermique dans un mur",39,30);
           fill(255); text("Dphasage thermique dans un mur",40,31);
            textFont(font12);  fill(150, 102, 43);  text("http://www.xelyx.com   le coeur lger",40,45);
          text("tde surface extrieure    = "+TableTemperatures[0], 4+marge, 340-TableTemperatures[0]*10);
          text("tde surface intrieure = "+TableTemperatures[largeMur_pas], largeMur_pix-70 ,370-TableTemperatures[largeMur_pas]*10);
 
   textFont(font16); 
          if(heure<2)  {    text("accumumulation : "+kWh + " kWh ",marge+30,430);  } 
              else {    text("diffusion : "+kWh + " kWh ",marge+70,430);  }
    
  fill(0, 102, 200);  text(heure+" heure(s) "+mn+" minute(s) ", marge+350, 430);
}

/////////////////////////////////////////////////////
void recalculer(float H1, int d, int a){ 
  
  for(int i=d;i<=a;i++){
 
    TableTempProvisoire[i] =TableTemperatures[i+1]/H1+TableTemperatures[i]*(1-2/H1)+TableTemperatures[i-1]/H1;  
  }
}
/////////////////////////////////////////////////////
void flambee(){
 
 
  tf=17+20*sin(secondes/86400*6.28);
  TableTemperatures[0]=tf;
  TableTempProvisoire[0] =tf;
  recalculertout();}

//////////////////////////////////////////////////////lB40_pas,lmat_pas,lmor_pas
void recalculertout(){
  e1=lB40_pas;
  
  recalculer(Hbrique,1,e1-1);
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmat+TableTemperatures[e1]*(1-1/Hbrique-1/Hmat)+TableTemperatures[e1-1]/Hbrique;
  recalculer(Hmat,e1+1,e1+lmat_pas-1);
   e1=lB40_pas+lmat_pas;
   
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmortier+TableTemperatures[e1]*(1-1/Hmortier-1/Hmat)+TableTemperatures[e1-1]/Hmat;
  recalculer(Hmortier,e1+1,e1+lmor_pas-1);
  e1=lB40_pas+lmat_pas+lmor_pas;
  
  TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hgranit+TableTemperatures[e1]*(1-1/Hmortier-1/Hgranit)+TableTemperatures[e1-1]/Hmortier;
  recalculer(Hgranit,e1+1,e1+lgra_pas-1);
  e1=lB40_pas+lmat_pas+lmor_pas+lgra_pas;
  TableTempProvisoire[e1] =TableTemperatures[e1-1]-valCoefEchange*h*(TableTemperatures[e1]-20)/conductiGranit.getValeur();
  
  //TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hair+TableTemperatures[e1]*(1-1/Hair-1/Hgranit)+TableTemperatures[e1-1]/Hgranit;
 // recalculer(Hair,e1+1,e1+5);
  //TableTempProvisoire[e1+6]=20;//largeur avec air=lB40_pas+lmat_pas+lmor_pas+6
  //TableTempProvisoire[0]=0.012*TableTempProvisoire[1]+0.988*TableTempProvisoire[0];
 
   
  //recopier et calculer la variation de t
   incremental=0;
  for(int i=0;i<largeur_pas;i++){    
    TableTemperatures[i]=TableTempProvisoire[i];
  }
if(secondes<7200){
  calculerkWhdans();
}else{
  calculerkWhhors(); 
  }
  
}
//////////////////////////////////////////////////////////

void calculerkWhhors(){
   incremental=0;
  for(int i=0;i<lB40_pas;i++){    
    incremental+=TableTempDepart[i]-TableTemperatures[i];
  }
  kWh=incremental*0.569*h*8;
  incremental=0;
  for(int i=lB40_pas;i<lB40_pas+lmat_pas+lmor_pas;i++){    
    incremental+=(TableTempDepart[i]-TableTemperatures[i]);
  }
  kWh+=incremental*capacitHabillage.getValeur()/3600*8*h;
  incremental=0;
  for(int i=lB40_pas+lmat_pas+lmor_pas;i<largeur_pas;i++){    
    incremental+=(TableTempDepart[i]-TableTemperatures[i]);
  }
  kWh+=incremental*capacitGranit.getValeur()/3600*8*h; 
  kWh=int(kWh*10F)/10F;
}
  
  
//////////////////////////////////////////////////////////


void calculerkWhdans(){
  incremental=0;
  for(int i=0;i<lB40_pas;i++){    
    incremental+=(TableTemperatures[i]-TableTempDepart[i]);
  }
  
  kWh=incremental*0.569*h*8;//0.569 est la capacit de B40N en kW.h/m3/deltaT, 8est la surface en m et h est l'epaisseur d'une tranche
  incremental=0;// /36 c'es pour convertir en heures
  for(int i=lB40_pas;i<lB40_pas+lmat_pas+lmor_pas;i++){    
    incremental+=TableTemperatures[i]-TableTempDepart[i];
  }
  kWh+=incremental*capacitHabillage.getValeur()/3600*8*h;//capacitHabillage.getValeur() en kJ/m3/K doit tre divis par 3600 pour ontenir des kW.h/m3/K
 
   incremental=0;// /36 c'es pour converit en heures
  for(int i=lB40_pas+lmat_pas+lmor_pas;i<largeMur_pas;i++){    
    incremental+=TableTemperatures[i]-TableTempDepart[i];
  }
  kWh+=incremental*capacitGranit.getValeur()/3600*8*h;
 
  kWh=int(kWh*10F)/10F;
 // recopier la table dans la table dpart pout le calcul des kwh en sortie
  if(kWh>kWhTir){ 
        secondes=7200;    
        tempExterne[2]=TableTemperatures[largeMur_pas];
        for(int i=0;i<largeur_pas;i++){    
            TableTempDepart[i]=TableTemperatures[i];
        }
  }
  }
//////////////////////////////////////////////////////////
void axes(){
  //int largeMur_pix=pasEnPixel*largeMur_pas;
  float r=mmEnPixel;
  float pos;

 /* stroke(150);
  line(marge,450,marge+largeMur_pix,450);
  line(marge,400,marge+largeMur_pix,400);
  line(marge,400,marge+largeMur_pix,400);
  line(marge,350,marge+largeMur_pix,350);
  line(marge,300,marge+largeMur_pix,300);
  line(marge,250,marge+largeMur_pix,250);
  line(marge,200,marge+largeMur_pix,200); 
  line(marge,150,marge+largeMur_pix,150);
  line(marge,100,marge+largeMur_pix,100);
  line(marge,50,marge+largeMur_pix,50);
  line(marge,0,marge+largeMur_pix,0);*/

  line(marge,0,marge,450);
  line(marge+largeMur_pix,0,marge+largeMur_pix,450); 
textFont(font12);
fill(50); stroke(150);

for(int i=-10;i<50;i+=5){ 
  line(marge,350-10*i,marge+marge+largeMur_pix-20,350-10*i);
  text(" "+i,marge+largeMur_pix,350-10*i+4);
  text(" "+i,marge-10,350-10*i+4);
}

  line(marge+lB40_mm*r,0,marge+lB40_mm*r,450);
  line(marge+(lB40_mm+lmat_mm)*r,0,marge+(lB40_mm+lmat_mm)*r,450);
  line(marge+(lB40_mm+lmat_mm+lmor_mm)*r,0,marge+(lB40_mm+lmat_mm+lmor_mm)*r,450);
 


}
//////////////////////////////////////////////////////////
void montrertempExterne(){    
  stroke(100,255,0);
  for(int i=0;i<heure-1;i++){//print(tempExterne[i]+"  ");
    line(marge+24*i,640-tempExterne[i]*3,marge+24*(i+1),640-tempExterne[i+1]*3);
  }
 
}
//////////////////////////////////////////////////////////
void montrerTempFeu(){
textFont(font8);
int tem;
fill(50);stroke(255); 


for(int i=-10;i<=50;i+=5){
  line(marge,640-i*3,marge+850,640-i*3);
  tem=i;
  text(" "+tem,marge+850,644-i*3);
  text(" "+tem,marge-16,644-i*3);
}

 stroke(0,0,255);
 
 
  for(int i=0;i<heure-1;i++){
    line(marge+24*i,640-tempFeu[i]*3,marge+24*(i+1),640-tempFeu[i+1]*3);
}
}


    
    
