//simulation Xelyx des  dephasages dans une paroi de pdm.
//Basee sur le texte de Robert Mellet
// que l'on peut trouver ici: http://pagesperso-orange.fr/robert.mellet/diff/diff_01.htm
// version 0.01   du   27/12/2008

float h=0.005;//mesure d'un pas de division en metre
float k=5;//pas des temps en secondes 
boolean locked;
int pasEnMm=int(h*1000);//5
int mmEnPixel=2;
int pasEnPixel=pasEnMm*mmEnPixel;//10
int marge=30;

int lB40_pas,lmat_pas,lmor_pas,lgra_pas;
int lB40_mm,lmat_mm,lmor_mm,lgra_mm;
int largeMur_mm,largeur_mm,largeur_pas,largeMur_pas,largeMur_pix;


float[] TableTemperatures=new float[200];//les temperatures a l'instant t
float[] TableTempProvisoire=new float[200];//les temperatures a l'intant t+k
float[] TableTempDepart=new float[200];//les temperatures au depart
float[] tempExterne=new float[5000];
float[] tempFeu=new float[5000];

String etat;
float Hgranit=h*h/k/0.0000016f;//diffusivite du granit permet de calculer H
float Hbrique=h*h/k/0.0000008f;//difusivite de la  B40N permet de calculer H
float Hbriquo=h*h/k/0.0000007f;//difusivite de la  brique ordinaire permet de calculer H
float Hmortier=h*h/k/0.0000007f;//difusivite de la  mortier permet de calculer H(mortier tres serre)
float Hmat=h*h/k/0.00000036f;//difusivite du mat de verre permet de calculer H (laine de roche)
float Hair=h*h/k/0.00000015f;//difusivite de l'air permet de calculer H
float secondes=0;
float tempSur,valCoefEchange;
int minutes;
float heuref, tempdephasage,dephasage;
int heure=0;
int mn,e1;//minutes et epaisseurs en pas
float tf;
int couleur=50;
PFont font16,font12;
Tirette CoefEchange,capacitHabillage,conductiHabillage, capacitGranit,conductiGranit;
Tirette epaisMat,epaisB40,epaisMor,epaisGra;
RectButton boutonGo;
//////////////////////////////////////////////////////////
void setup(){
     size(900,850);

     font16 = loadFont("Arial16.vlw");
     font12 = loadFont("Arial12.vlw"); 



     CoefEchange=new Tirette(700,540,160,4 ,50,"coef d'echange = ",20,1, font12);
     epaisB40=new Tirette(30,480,120,110 ,180,"B40N",115,5, font12);
     epaisMat=new Tirette(190,480,120,4 ,35," Mat",5,5, font12);
     epaisMor=new Tirette(350,480,120,10 ,50,"mortier",25,5, font12);
     epaisGra=new Tirette(510,480,120,90 ,200,"Granit",110,10, font12);

     capacitHabillage=new Tirette(350,510,120,1000,2300 ,"capacite kJ/m3/K",1650,1, font12);
     conductiHabillage=new Tirette(350,540,120,0.3 ,3,"conductive W/m/K",1.15,0.01, font12);
     capacitGranit=new Tirette(510,510,120,1000,2300 ,"capacite kJ/m3/K",1820,1, font12);
     conductiGranit=new Tirette(510,540,120,1.1 ,3.2,"conductive W/m/K",3.0,0.01, font12);


     boutonGo=new RectButton(700, 560, 160,100, 190, 125); 

}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
void draw(){ 
     background(200,200,250);

     if (secondes==0) {
          fill(250,180,180);
          rect(10,550,860,120);
          boutonGo.display();
          CoefEchange.actualiser();

          epaisMat.actualiser();   
          lmat_mm=int(epaisMat.getValeur());      
          lmat_pas=int(epaisMat.getValeur()/pasEnMm);
          epaisB40.actualiser();   
          lB40_mm=int(epaisB40.getValeur());      
          lB40_pas=int(epaisB40.getValeur()/pasEnMm);
          epaisMor.actualiser();   
          lmor_mm=int(epaisMor.getValeur());      
          lmor_pas=int(epaisMor.getValeur()/pasEnMm);
          epaisGra.actualiser();   
          lgra_mm=int(epaisGra.getValeur());      
          lgra_pas=int(epaisGra.getValeur()/pasEnMm);

          largeMur_mm=lmat_mm+lB40_mm+lmor_mm+lgra_mm;//la dimension reelle du mur
          largeur_mm=largeMur_mm+5;//mur+couche d'air
          largeur_pas=int(largeur_mm/pasEnMm);// en pas virtuel(1 pas= 5mm=10pixels)
          largeMur_pas=int(largeMur_mm/pasEnMm);
          largeMur_pix=int(largeMur_mm*mmEnPixel);

          valCoefEchange=CoefEchange.getValeur();
          Hair=h*h/k/valCoefEchange;
          capacitHabillage.actualiser();
          conductiHabillage.actualiser();
          capacitGranit.actualiser();
          conductiGranit.actualiser();

          Hmortier=h*h/k/(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));
          Hgranit=h*h/k/(conductiGranit.getValeur()/(capacitGranit.getValeur()*1000));
          float dif=(conductiHabillage.getValeur()/(capacitHabillage.getValeur()*1000));

          tempExterne[0]=tempSur;
          initialise();
          actualiserBouton(mouseX,mouseY);

     }
     else{if(minutes<1440){
             fill(155,195,255);
          rect(30,470,600,350);
          modifierTemps();
          flambee();
     }
          else{
               fill(255,195,255);
          rect(30,470,600,350);
         }
          montrerTempFeu();    
          montrertempExterne();
     } 
   dessiner();


}

//////////////////////////////////////
void actualiserBouton(int x,int y){
     boutonGo.update();
     if(boutonGo.pressed()) {
          secondes=1;
     }
}



//////////////////////////////////////
void modifierTemps(){

     secondes+=k;
     int minutesAnciennes=minutes;
     minutes=int(secondes/60);

     heuref=secondes/3600f;
     if(int(heuref)>heure){
          heure=int(heuref);
     }
     //on stocke les temperatures externes et internes toutes les minutes
     if(minutes>minutesAnciennes){
          tempExterne[minutes ]=TableTemperatures[largeur_pas];
          tempFeu[minutes]=TableTemperatures[0];
     }
     mn=minutes-60*heure;


}



//////////////////////////////////////////////////////////
void initialise(){


     for(int i=0;i<=largeMur_pas;i++){  
          TableTemperatures[i]=150-100*i/(largeur_pas);
          TableTempDepart[i]=TableTemperatures[i];
     }

     TableTemperatures[largeur_pas]= TableTemperatures[largeMur_pas]-5;
     TableTempDepart[largeur_pas]=TableTemperatures[largeur_pas];

     tempFeu[0]=TableTemperatures[0];
}
//////////////////////////////////////////////////////////
void dessiner(){
     fill(255);
     rect(marge,0,largeur_mm*mmEnPixel,450);
     axes();
     stroke(255,0,0);
     for(int i=0;i<largeur_pas;i++){  
          line(marge+i*pasEnPixel,400-0.5f*TableTemperatures[i],marge+(1+i)*pasEnPixel,400-0.5f*TableTemperatures[i+1]);
     }
     fill(0); 
       textFont(font16);
     text("Dephasage thermique",700,30);   
     text(" dans un mur",730,50);
     fill(150, 102, 43);  
     text("http://www.xelyx.com",700,70);
     text(" leCoeurLeger",730,85);
     fill(0, 52, 200);  
     text(heure+" heure(s) "+mn+" minute(s) ", marge+350, 430);
     fill(0); 
     text("temperature interne   = "+TableTemperatures[0], 20+marge, 400-TableTemperatures[0]*0.5f);
     text("temperature externe = "+TableTemperatures[largeur_pas], largeMur_pix+40 ,400-TableTemperatures[largeur_pas]*0.5f);
}

/////////////////////////////////////////////////////
void recalculer(float H1, int d, int a){ 

     for(int i=d;i<=a;i++){

          TableTempProvisoire[i] =TableTemperatures[i+1]/H1+TableTemperatures[i]*(1-2/H1)+TableTemperatures[i-1]/H1;  
     }
}
/////////////////////////////////////////////////////
void flambee(){
     if (secondes<1200){//20mn de montee en temp
          tf=100+secondes*(600-100)/1200;
     }
     else{
          if(secondes<3000){
               tf=600;
          }
          else{

               tf=60+540*10000/(secondes+7000);
          }
     }

     TableTemperatures[0]=tf;
     TableTempProvisoire[0] =tf;
     recalculertout();
}

//////////////////////////////////////////////////////lB40_pas,lmat_pas,lmor_pas
void recalculertout(){
     e1=lB40_pas;

     recalculer(Hbrique,1,e1-1);
     TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmat+TableTemperatures[e1]*(1-1/Hbrique-1/Hmat)+TableTemperatures[e1-1]/Hbrique;
     recalculer(Hmat,e1+1,e1+lmat_pas-1);
     e1=lB40_pas+lmat_pas;

     TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hmortier+TableTemperatures[e1]*(1-1/Hmortier-1/Hmat)+TableTemperatures[e1-1]/Hmat;
     recalculer(Hmortier,e1+1,e1+lmor_pas-1);
     e1=lB40_pas+lmat_pas+lmor_pas;

     TableTempProvisoire[e1] =TableTemperatures[e1+1]/Hgranit+TableTemperatures[e1]*(1-1/Hmortier-1/Hgranit)+TableTemperatures[e1-1]/Hmortier;
     recalculer(Hgranit,e1+1,e1+lgra_pas-1);
     e1=lB40_pas+lmat_pas+lmor_pas+lgra_pas;
     TableTempProvisoire[e1] =TableTemperatures[e1-1]-valCoefEchange*h*(TableTemperatures[e1]-20)/conductiGranit.getValeur();
     TableTempProvisoire[1+e1]= TableTempProvisoire[e1]-5;
     //recopier et calculer la variation de temperature
     for(int i=0;i<=largeur_pas;i++){    
          TableTemperatures[i]=TableTempProvisoire[i];
     }

}

//////////////////////////////////////////////////////////
void axes(){

     float r=mmEnPixel;
     float pos;
     line(marge,0,marge,450);
     line(marge+largeMur_pix,0,marge+largeMur_pix,450); 
     textFont(font12);
     fill(0); 
     stroke(0);
     int ii;
     for(int i=0;i<800;i+=50){ 
          ii=400-i/2;
          line(marge,ii,marge+marge+largeMur_pix-20,ii);
          text(" "+i,marge+largeur_mm*mmEnPixel,ii+4);
          text(" "+i,0,ii+4);
     }
     line(marge+lB40_mm*r,0,marge+lB40_mm*r,400);
     line(marge+(lB40_mm+lmat_mm)*r,0,marge+(lB40_mm+lmat_mm)*r,400);
     line(marge+(lB40_mm+lmat_mm+lmor_mm)*r,0,marge+(lB40_mm+lmat_mm+lmor_mm)*r,400);



}
//////////////////////////////////////////////////////////
void montrertempExterne(){    
     stroke(255,0,0);
     for(int i=6;i<minutes-6;i=i+5){
          line(marge+0.4*i,800-tempExterne[i]*0.4,marge+0.4*(i+5),800-tempExterne[i+5]*0.4);
     }
     text("temperature externe = "+TableTemperatures[largeur_pas],marge+0.4*(minutes),800-tempExterne[minutes]*0.4 );
     if(tempExterne[minutes]>tempdephasage){
          dephasage=minutes-20;
          tempdephasage=int(tempExterne[minutes]);
     };
     if(minutes>20){
          text("dephasage =: "+ dephasage+" minutes", 670,600);
          text("temperature ext max =: "+ tempdephasage, 670,620);
     }
}
//////////////////////////////////////////////////////////
void montrerTempFeu(){
     textFont(font16);
     stroke(255); fill(0);
     for(int i=0;i<=700;i+=50){
          line(marge,800-i*0.4,marge+600,800-i*0.4);
          text(" "+i,marge+600,804-i*0.4);
          text(" "+i,0,804-i*0.4);
     }
     stroke(0,0,255);
     for(int i=6;i<minutes-6;i=i+5){
          line(marge+0.4*i,800-tempFeu[i]*0.4,marge+0.4*(i+5),800-tempFeu[i+5]*0.4);
     }
     text("temperature interne   = "+TableTemperatures[0],marge+0.4*(minutes),800-tempFeu[minutes]*0.4); 
}








