//##############################################################################
//#																			   #
//# fichier	: SDL text.c								version : V1.0		   #
//# projet	: SDL text									date :	13/12/2005	   #
//# par		: aerith														   #
//#																			   #
//# affichage de text dans SDL												   #
//#																			   #
//##############################################################################

#include	"SDL_text.h"

void	SDLText(SDL_Surface *pScreen, char *pText, rect rZone, float fSize, color cTop, color cBack)
{
	int		c, l, h, lm, hm, lp, hp;
	rect	Zone;

	SDLTextInit();

	lp = (int)(TEXT_WIDTH * fSize);
	hp = (int)(TEXT_HEIGHT * fSize);
	lm = (int)(rZone.l / lp);
	hm = (int)(rZone.h / hp);
	l = -1;
	h = 0;
	Zone.x = rZone.x;
	Zone.y = rZone.y;
	Zone.l = rZone.l;
	Zone.h = rZone.h;

	for(c = 0; pText[c]; c++)
	{
		if(((l + 1) <= lm) && (pText[c] != '\n'))
		{
			l++;
		}
		else
		{
			if(pText[c] == '\n')
				c++;

			if((h + 1) <= hm)
			{
				l = 0;
				h++;
			}
			else
				return;
		}

		Zone.x = rZone.x *2 + l * lp;
		Zone.y = rZone.y + h * hp;
		SDLTextCarac(pScreen, pText[c], Zone.x, Zone.y, fSize, cTop, cBack);
	}
}

void	SDLTextCarac(SDL_Surface *pSpcreen, char cCar, int x, int y, float fSize, color cTop, color cBack)
{
	int  	px, py;

	for(py = 0; py < (TEXT_HEIGHT * fSize); py++)
	{
		for(px = 0; px < (TEXT_WIDTH * fSize); px++)
		{
			if(TableCar[cCar][(int)(py / fSize)][(int)(px / fSize)] == 49)
   			{
				SDLTextPoint(pSpcreen, x + px, y + py, cTop);
			}
			else
			{
				if((cBack.r != -1) && (cBack.g != -1) && (cBack.b != -1))
					SDLTextPoint(pSpcreen, x + px, y + py, cBack);
			}
		}
	}
}

void	SDLTextPoint(SDL_Surface *pScreen, int x, int y, color cColor)
{
	Uint16	*pPxl;

	if((x > 0) && (x < (pScreen->w*2)) && (y > 0) && (y < (pScreen->h*2)))
	{
		pPxl = (Uint16*)pScreen->pixels + ((pScreen->pitch / 2 * y) + x);
		*pPxl = SDL_MapRGB(pScreen->format, (Uint8)cColor.r, (Uint8)cColor.g, (Uint8)cColor.b);
	}else{
	
	printf("out");
	}
}

void	SDLTextInit()
{
	/* ' ' */
	strcpy_s(TableCar[32][0], "000000");
	strcpy_s(TableCar[32][1], "000000");
	strcpy_s(TableCar[32][2], "000000");
	strcpy_s(TableCar[32][3], "000000");
	strcpy_s(TableCar[32][4], "000000");
	strcpy_s(TableCar[32][5], "000000");
	strcpy_s(TableCar[32][6], "000000");
	strcpy_s(TableCar[32][7], "000000");
	strcpy_s(TableCar[32][8], "000000");

	/* '(' */
	strcpy_s(TableCar[40][0], "000010");
	strcpy_s(TableCar[40][1], "000100");
	strcpy_s(TableCar[40][2], "001000");
	strcpy_s(TableCar[40][3], "001000");
	strcpy_s(TableCar[40][4], "001000");
	strcpy_s(TableCar[40][5], "000100");
	strcpy_s(TableCar[40][6], "000010");
	strcpy_s(TableCar[40][7], "000000");
	strcpy_s(TableCar[40][8], "000000");
	/* ')' */
	strcpy_s(TableCar[41][0], "100000");
	strcpy_s(TableCar[41][1], "010000");
	strcpy_s(TableCar[41][2], "001000");
	strcpy_s(TableCar[41][3], "001000");
	strcpy_s(TableCar[41][4], "001000");
	strcpy_s(TableCar[41][5], "010000");
	strcpy_s(TableCar[41][6], "100000");
	strcpy_s(TableCar[41][7], "000000");
	strcpy_s(TableCar[41][8], "000000");
	/* '*' */
	strcpy_s(TableCar[42][0], "000000");
	strcpy_s(TableCar[42][1], "000000");
	strcpy_s(TableCar[42][2], "000000");
	strcpy_s(TableCar[42][3], "010100");
	strcpy_s(TableCar[42][4], "001000");
	strcpy_s(TableCar[42][5], "010100");
	strcpy_s(TableCar[42][6], "000000");
	strcpy_s(TableCar[42][7], "000000");
	strcpy_s(TableCar[42][8], "000000");
	/* '+' */
	strcpy_s(TableCar[43][0], "000000");
	strcpy_s(TableCar[43][1], "000000");
	strcpy_s(TableCar[43][2], "000000");
	strcpy_s(TableCar[43][3], "001000");
	strcpy_s(TableCar[43][4], "011100");
	strcpy_s(TableCar[43][5], "001000");
	strcpy_s(TableCar[43][6], "000000");
	strcpy_s(TableCar[43][7], "000000");
	strcpy_s(TableCar[43][8], "000000");
	/* ',' */
	strcpy_s(TableCar[44][0], "000000");
	strcpy_s(TableCar[44][1], "000000");
	strcpy_s(TableCar[44][2], "000000");
	strcpy_s(TableCar[44][3], "000000");
	strcpy_s(TableCar[44][4], "000000");
	strcpy_s(TableCar[44][5], "000000");
	strcpy_s(TableCar[44][6], "010000");
	strcpy_s(TableCar[44][7], "010000");
	strcpy_s(TableCar[44][8], "000000");
	/* '-' */
	strcpy_s(TableCar[45][0], "000000");
	strcpy_s(TableCar[45][1], "000000");
	strcpy_s(TableCar[45][2], "000000");
	strcpy_s(TableCar[45][3], "000000");
	strcpy_s(TableCar[45][4], "011100");
	strcpy_s(TableCar[45][5], "000000");
	strcpy_s(TableCar[45][6], "000000");
	strcpy_s(TableCar[45][7], "000000");
	strcpy_s(TableCar[45][8], "000000");
	/* '.' */
	strcpy_s(TableCar[46][0], "000000");
	strcpy_s(TableCar[46][1], "000000");
	strcpy_s(TableCar[46][2], "000000");
	strcpy_s(TableCar[46][3], "000000");
	strcpy_s(TableCar[46][4], "000000");
	strcpy_s(TableCar[46][5], "000000");
	strcpy_s(TableCar[46][6], "010000");
	strcpy_s(TableCar[46][7], "000000");
	strcpy_s(TableCar[46][8], "000000");
	/* '/' */
	strcpy_s(TableCar[47][0], "000100");
	strcpy_s(TableCar[47][1], "000100");
	strcpy_s(TableCar[47][2], "001000");
	strcpy_s(TableCar[47][3], "001000");
	strcpy_s(TableCar[47][4], "001000");
	strcpy_s(TableCar[47][5], "010000");
	strcpy_s(TableCar[47][6], "010000");
	strcpy_s(TableCar[47][7], "000000");
	strcpy_s(TableCar[47][8], "000000");
	/* '0' */
	strcpy_s(TableCar[48][0], "011100");
	strcpy_s(TableCar[48][1], "100010");
	strcpy_s(TableCar[48][2], "100010");
	strcpy_s(TableCar[48][3], "101010");
	strcpy_s(TableCar[48][4], "100010");
	strcpy_s(TableCar[48][5], "100010");
	strcpy_s(TableCar[48][6], "011100");
	strcpy_s(TableCar[48][7], "000000");
	strcpy_s(TableCar[48][8], "000000");
	/* '1' */
	strcpy_s(TableCar[49][0], "001000");
	strcpy_s(TableCar[49][1], "011000");
	strcpy_s(TableCar[49][2], "001000");
	strcpy_s(TableCar[49][3], "001000");
	strcpy_s(TableCar[49][4], "001000");
	strcpy_s(TableCar[49][5], "001000");
	strcpy_s(TableCar[49][6], "011100");
	strcpy_s(TableCar[49][7], "000000");
	strcpy_s(TableCar[49][8], "000000");
	/* '2' */
	strcpy_s(TableCar[50][0], "011100");
	strcpy_s(TableCar[50][1], "100010");
	strcpy_s(TableCar[50][2], "000010");
	strcpy_s(TableCar[50][3], "000100");
	strcpy_s(TableCar[50][4], "001000");
	strcpy_s(TableCar[50][5], "010000");
	strcpy_s(TableCar[50][6], "111110");
	strcpy_s(TableCar[50][7], "000000");
	strcpy_s(TableCar[50][8], "000000");
	/* '3' */
	strcpy_s(TableCar[51][0], "011100");
	strcpy_s(TableCar[51][1], "100010");
	strcpy_s(TableCar[51][2], "000010");
	strcpy_s(TableCar[51][3], "001100");
	strcpy_s(TableCar[51][4], "000010");
	strcpy_s(TableCar[51][5], "100010");
	strcpy_s(TableCar[51][6], "011100");
	strcpy_s(TableCar[51][7], "000000");
	strcpy_s(TableCar[51][8], "000000");
	/* '4' */
	strcpy_s(TableCar[52][0], "000100");
	strcpy_s(TableCar[52][1], "001000");
	strcpy_s(TableCar[52][2], "010000");
	strcpy_s(TableCar[52][3], "010000");
	strcpy_s(TableCar[52][4], "100100");
	strcpy_s(TableCar[52][5], "111110");
	strcpy_s(TableCar[52][6], "000100");
	strcpy_s(TableCar[52][7], "000000");
	strcpy_s(TableCar[52][8], "000000");
	/* '5' */
	strcpy_s(TableCar[53][0], "111110");
	strcpy_s(TableCar[53][1], "100000");
	strcpy_s(TableCar[53][2], "100000");
	strcpy_s(TableCar[53][3], "111100");
	strcpy_s(TableCar[53][4], "000010");
	strcpy_s(TableCar[53][5], "100010");
	strcpy_s(TableCar[53][6], "011100");
	strcpy_s(TableCar[53][7], "000000");
	strcpy_s(TableCar[53][8], "000000");
	/* '6' */
	strcpy_s(TableCar[54][0], "001100");
	strcpy_s(TableCar[54][1], "010000");
	strcpy_s(TableCar[54][2], "100000");
	strcpy_s(TableCar[54][3], "111100");
	strcpy_s(TableCar[54][4], "100010");
	strcpy_s(TableCar[54][5], "100010");
	strcpy_s(TableCar[54][6], "011100");
	strcpy_s(TableCar[54][7], "000000");
	strcpy_s(TableCar[54][8], "000000");
	/* '7' */
	strcpy_s(TableCar[55][0], "111110");
	strcpy_s(TableCar[55][1], "000010");
	strcpy_s(TableCar[55][2], "000100");
	strcpy_s(TableCar[55][3], "000100");
	strcpy_s(TableCar[55][4], "001000");
	strcpy_s(TableCar[55][5], "001000");
	strcpy_s(TableCar[55][6], "001000");
	strcpy_s(TableCar[55][7], "000000");
	strcpy_s(TableCar[55][8], "000000");
	/* '8' */
	strcpy_s(TableCar[56][0], "011100");
	strcpy_s(TableCar[56][1], "100010");
	strcpy_s(TableCar[56][2], "100010");
	strcpy_s(TableCar[56][3], "011100");
	strcpy_s(TableCar[56][4], "100010");
	strcpy_s(TableCar[56][5], "100010");
	strcpy_s(TableCar[56][6], "011100");
	strcpy_s(TableCar[56][7], "000000");
	strcpy_s(TableCar[56][8], "000000");
	/* '9' */
	strcpy_s(TableCar[57][0], "011100");
	strcpy_s(TableCar[57][1], "100010");
	strcpy_s(TableCar[57][2], "100010");
	strcpy_s(TableCar[57][3], "011110");
	strcpy_s(TableCar[57][4], "000010");
	strcpy_s(TableCar[57][5], "000100");
	strcpy_s(TableCar[57][6], "011000");
	strcpy_s(TableCar[57][7], "000000");
	strcpy_s(TableCar[57][8], "000000");
	/* ':' */
	strcpy_s(TableCar[58][0], "000000");
	strcpy_s(TableCar[58][1], "000000");
	strcpy_s(TableCar[58][2], "000000");
	strcpy_s(TableCar[58][3], "001000");
	strcpy_s(TableCar[58][4], "000000");
	strcpy_s(TableCar[58][5], "000000");
	strcpy_s(TableCar[58][6], "001000");
	strcpy_s(TableCar[58][7], "000000");
	strcpy_s(TableCar[58][8], "000000");
	/* ';' */
	strcpy_s(TableCar[59][0], "000000");
	strcpy_s(TableCar[59][1], "000000");
	strcpy_s(TableCar[59][2], "000000");
	strcpy_s(TableCar[59][3], "100000");
	strcpy_s(TableCar[59][4], "000000");
	strcpy_s(TableCar[59][5], "000000");
	strcpy_s(TableCar[59][6], "100000");
	strcpy_s(TableCar[59][7], "100000");
	strcpy_s(TableCar[59][8], "000000");

	/* 'A' */
	strcpy_s(TableCar[65][0], "001000");
	strcpy_s(TableCar[65][1], "010100");
	strcpy_s(TableCar[65][2], "100010");
	strcpy_s(TableCar[65][3], "100010");
	strcpy_s(TableCar[65][4], "111110");
	strcpy_s(TableCar[65][5], "100010");
	strcpy_s(TableCar[65][6], "100010");
	strcpy_s(TableCar[65][7], "000000");
	strcpy_s(TableCar[65][8], "000000");
	/* 'B' */
	strcpy_s(TableCar[66][0], "111100");
	strcpy_s(TableCar[66][1], "100010");
	strcpy_s(TableCar[66][2], "100010");
	strcpy_s(TableCar[66][3], "111100");
	strcpy_s(TableCar[66][4], "100010");
	strcpy_s(TableCar[66][5], "100010");
	strcpy_s(TableCar[66][6], "111100");
	strcpy_s(TableCar[66][7], "000000");
	strcpy_s(TableCar[66][8], "000000");
	/* 'C' */
	strcpy_s(TableCar[67][0], "011100");
	strcpy_s(TableCar[67][1], "100010");
	strcpy_s(TableCar[67][2], "100000");
	strcpy_s(TableCar[67][3], "100000");
	strcpy_s(TableCar[67][4], "100000");
	strcpy_s(TableCar[67][5], "100010");
	strcpy_s(TableCar[67][6], "011100");
	strcpy_s(TableCar[67][7], "000000");
	strcpy_s(TableCar[67][8], "000000");
	/* 'D' */
	strcpy_s(TableCar[68][0], "111100");
	strcpy_s(TableCar[68][1], "100010");
	strcpy_s(TableCar[68][2], "100010");
	strcpy_s(TableCar[68][3], "100010");
	strcpy_s(TableCar[68][4], "100010");
	strcpy_s(TableCar[68][5], "100010");
	strcpy_s(TableCar[68][6], "111100");
	strcpy_s(TableCar[68][7], "000000");
	strcpy_s(TableCar[68][8], "000000");
	/* 'E' */
	strcpy_s(TableCar[69][0], "111110");
	strcpy_s(TableCar[69][1], "100000");
	strcpy_s(TableCar[69][2], "100000");
	strcpy_s(TableCar[69][3], "111100");
	strcpy_s(TableCar[69][4], "100000");
	strcpy_s(TableCar[69][5], "100000");
	strcpy_s(TableCar[69][6], "111110");
	strcpy_s(TableCar[69][7], "000000");
	strcpy_s(TableCar[69][8], "000000");
	/* 'F' */
	strcpy_s(TableCar[70][0], "111110");
	strcpy_s(TableCar[70][1], "100000");
	strcpy_s(TableCar[70][2], "100000");
	strcpy_s(TableCar[70][3], "111100");
	strcpy_s(TableCar[70][4], "100000");
	strcpy_s(TableCar[70][5], "100000");
	strcpy_s(TableCar[70][6], "100000");
	strcpy_s(TableCar[70][7], "000000");
	strcpy_s(TableCar[70][8], "000000");
	/* 'G' */
	strcpy_s(TableCar[71][0], "011100");
	strcpy_s(TableCar[71][1], "100010");
	strcpy_s(TableCar[71][2], "100000");
	strcpy_s(TableCar[71][3], "100110");
	strcpy_s(TableCar[71][4], "100010");
	strcpy_s(TableCar[71][5], "100010");
	strcpy_s(TableCar[71][6], "011100");
	strcpy_s(TableCar[71][7], "000000");
	strcpy_s(TableCar[71][8], "000000");
	/* 'H' */
	strcpy_s(TableCar[72][0], "100010");
	strcpy_s(TableCar[72][1], "100010");
	strcpy_s(TableCar[72][2], "100010");
	strcpy_s(TableCar[72][3], "111110");
	strcpy_s(TableCar[72][4], "100010");
	strcpy_s(TableCar[72][5], "100010");
	strcpy_s(TableCar[72][6], "100010");
	strcpy_s(TableCar[72][7], "000000");
	strcpy_s(TableCar[72][8], "000000");
	/* 'I' */
	strcpy_s(TableCar[73][0], "011100");
	strcpy_s(TableCar[73][1], "001000");
	strcpy_s(TableCar[73][2], "001000");
	strcpy_s(TableCar[73][3], "001000");
	strcpy_s(TableCar[73][4], "001000");
	strcpy_s(TableCar[73][5], "001000");
	strcpy_s(TableCar[73][6], "011100");
	strcpy_s(TableCar[73][7], "000000");
	strcpy_s(TableCar[73][8], "000000");
	/* 'J' */
	strcpy_s(TableCar[74][0], "000010");
	strcpy_s(TableCar[74][1], "000010");
	strcpy_s(TableCar[74][2], "000010");
	strcpy_s(TableCar[74][3], "000010");
	strcpy_s(TableCar[74][4], "000010");
	strcpy_s(TableCar[74][5], "100010");
	strcpy_s(TableCar[74][6], "011100");
	strcpy_s(TableCar[74][7], "000000");
	strcpy_s(TableCar[74][8], "000000");
	/* 'K' */
	strcpy_s(TableCar[75][0], "100010");
	strcpy_s(TableCar[75][1], "100100");
	strcpy_s(TableCar[75][2], "101000");
	strcpy_s(TableCar[75][3], "110000");
	strcpy_s(TableCar[75][4], "101000");
	strcpy_s(TableCar[75][5], "100100");
	strcpy_s(TableCar[75][6], "100010");
	strcpy_s(TableCar[75][7], "000000");
	strcpy_s(TableCar[75][8], "000000");
	/* 'L' */
	strcpy_s(TableCar[76][0], "100000");
	strcpy_s(TableCar[76][1], "100000");
	strcpy_s(TableCar[76][2], "100000");
	strcpy_s(TableCar[76][3], "100000");
	strcpy_s(TableCar[76][4], "100000");
	strcpy_s(TableCar[76][5], "100000");
	strcpy_s(TableCar[76][6], "111110");
	strcpy_s(TableCar[76][7], "000000");
	strcpy_s(TableCar[76][8], "000000");
	/* 'M' */
	strcpy_s(TableCar[77][0], "100010");
	strcpy_s(TableCar[77][1], "110110");
	strcpy_s(TableCar[77][2], "110110");
	strcpy_s(TableCar[77][3], "101010");
	strcpy_s(TableCar[77][4], "101010");
	strcpy_s(TableCar[77][5], "100010");
	strcpy_s(TableCar[77][6], "100010");
	strcpy_s(TableCar[77][7], "000000");
	strcpy_s(TableCar[77][8], "000000");
	/* 'N' */
	strcpy_s(TableCar[78][0], "100010");
	strcpy_s(TableCar[78][1], "110010");
	strcpy_s(TableCar[78][2], "110010");
	strcpy_s(TableCar[78][3], "101010");
	strcpy_s(TableCar[78][4], "100110");
	strcpy_s(TableCar[78][5], "100110");
	strcpy_s(TableCar[78][6], "100010");
	strcpy_s(TableCar[78][7], "000000");
	strcpy_s(TableCar[78][8], "000000");
	/* 'O' */
	strcpy_s(TableCar[79][0], "011100");
	strcpy_s(TableCar[79][1], "100010");
	strcpy_s(TableCar[79][2], "100010");
	strcpy_s(TableCar[79][3], "100010");
	strcpy_s(TableCar[79][4], "100010");
	strcpy_s(TableCar[79][5], "100010");
	strcpy_s(TableCar[79][6], "011100");
	strcpy_s(TableCar[79][7], "000000");
	strcpy_s(TableCar[79][8], "000000");
	/* 'P' */
	strcpy_s(TableCar[80][0], "111100");
	strcpy_s(TableCar[80][1], "100010");
	strcpy_s(TableCar[80][2], "100010");
	strcpy_s(TableCar[80][3], "111100");
	strcpy_s(TableCar[80][4], "100000");
	strcpy_s(TableCar[80][5], "100000");
	strcpy_s(TableCar[80][6], "100000");
	strcpy_s(TableCar[80][7], "000000");
	strcpy_s(TableCar[80][8], "000000");
	/* 'Q' */
	strcpy_s(TableCar[81][0], "011100");
	strcpy_s(TableCar[81][1], "100010");
	strcpy_s(TableCar[81][2], "100010");
	strcpy_s(TableCar[81][3], "100010");
	strcpy_s(TableCar[81][4], "100010");
	strcpy_s(TableCar[81][5], "100010");
	strcpy_s(TableCar[81][6], "011100");
	strcpy_s(TableCar[81][7], "000110");
	strcpy_s(TableCar[81][8], "000000");
	/* 'R' */
	strcpy_s(TableCar[82][0], "111100");
	strcpy_s(TableCar[82][1], "100010");
	strcpy_s(TableCar[82][2], "100010");
	strcpy_s(TableCar[82][3], "111100");
	strcpy_s(TableCar[82][4], "100010");
	strcpy_s(TableCar[82][5], "100010");
	strcpy_s(TableCar[82][6], "100010");
	strcpy_s(TableCar[82][7], "000000");
	strcpy_s(TableCar[82][8], "000000");
	/* 'S' */
	strcpy_s(TableCar[83][0], "011100");
	strcpy_s(TableCar[83][1], "100010");
	strcpy_s(TableCar[83][2], "100000");
	strcpy_s(TableCar[83][3], "011100");
	strcpy_s(TableCar[83][4], "000010");
	strcpy_s(TableCar[83][5], "100010");
	strcpy_s(TableCar[83][6], "011100");
	strcpy_s(TableCar[83][7], "000000");
	strcpy_s(TableCar[83][8], "000000");
	/* 'T' */
	strcpy_s(TableCar[84][0], "111110");
	strcpy_s(TableCar[84][1], "001000");
	strcpy_s(TableCar[84][2], "001000");
	strcpy_s(TableCar[84][3], "001000");
	strcpy_s(TableCar[84][4], "001000");
	strcpy_s(TableCar[84][5], "001000");
	strcpy_s(TableCar[84][6], "001000");
	strcpy_s(TableCar[84][7], "000000");
	strcpy_s(TableCar[84][8], "000000");
	/* 'U' */
	strcpy_s(TableCar[85][0], "100010");
	strcpy_s(TableCar[85][1], "100010");
	strcpy_s(TableCar[85][2], "100010");
	strcpy_s(TableCar[85][3], "100010");
	strcpy_s(TableCar[85][4], "100010");
	strcpy_s(TableCar[85][5], "100010");
	strcpy_s(TableCar[85][6], "011100");
	strcpy_s(TableCar[85][7], "000000");
	strcpy_s(TableCar[85][8], "000000");
	/* 'V' */
	strcpy_s(TableCar[86][0], "100010");
	strcpy_s(TableCar[86][1], "100010");
	strcpy_s(TableCar[86][2], "100010");
	strcpy_s(TableCar[86][3], "010100");
	strcpy_s(TableCar[86][4], "010100");
	strcpy_s(TableCar[86][5], "001000");
	strcpy_s(TableCar[86][6], "001000");
	strcpy_s(TableCar[86][7], "000000");
	strcpy_s(TableCar[86][8], "000000");
	/* 'W' */
	strcpy_s(TableCar[87][0], "100010");
	strcpy_s(TableCar[87][1], "100010");
	strcpy_s(TableCar[87][2], "100010");
	strcpy_s(TableCar[87][3], "101010");
	strcpy_s(TableCar[87][4], "101010");
	strcpy_s(TableCar[87][5], "010100");
	strcpy_s(TableCar[87][6], "010100");
	strcpy_s(TableCar[87][7], "000000");
	strcpy_s(TableCar[87][8], "000000");
	/* 'X' */
	strcpy_s(TableCar[88][0], "100010");
	strcpy_s(TableCar[88][1], "100010");
	strcpy_s(TableCar[88][2], "010100");
	strcpy_s(TableCar[88][3], "001000");
	strcpy_s(TableCar[88][4], "010100");
	strcpy_s(TableCar[88][5], "100010");
	strcpy_s(TableCar[88][6], "100010");
	strcpy_s(TableCar[88][7], "000000");
	strcpy_s(TableCar[88][8], "000000");
	/* 'Y' */
	strcpy_s(TableCar[89][0], "100010");
	strcpy_s(TableCar[89][1], "100010");
	strcpy_s(TableCar[89][2], "100010");
	strcpy_s(TableCar[89][3], "010100");
	strcpy_s(TableCar[89][4], "001000");
	strcpy_s(TableCar[89][5], "001000");
	strcpy_s(TableCar[89][6], "001000");
	strcpy_s(TableCar[89][7], "000000");
	strcpy_s(TableCar[89][8], "000000");
	/* 'Z' */
	strcpy_s(TableCar[90][0], "111110");
	strcpy_s(TableCar[90][1], "000010");
	strcpy_s(TableCar[90][2], "000100");
	strcpy_s(TableCar[90][3], "001000");
	strcpy_s(TableCar[90][4], "010000");
	strcpy_s(TableCar[90][5], "100000");
	strcpy_s(TableCar[90][6], "111110");
	strcpy_s(TableCar[90][7], "000000");
	strcpy_s(TableCar[90][8], "000000");

	/* 'a' */
	strcpy_s(TableCar[97][0], "000000");
	strcpy_s(TableCar[97][1], "000000");
	strcpy_s(TableCar[97][2], "011100");
	strcpy_s(TableCar[97][3], "000010");
	strcpy_s(TableCar[97][4], "011110");
	strcpy_s(TableCar[97][5], "100010");
	strcpy_s(TableCar[97][6], "011110");
	strcpy_s(TableCar[97][7], "000000");
	strcpy_s(TableCar[97][8], "000000");
	/* 'b' */
	strcpy_s(TableCar[98][0], "100000");
	strcpy_s(TableCar[98][1], "100000");
	strcpy_s(TableCar[98][2], "101100");
	strcpy_s(TableCar[98][3], "110010");
	strcpy_s(TableCar[98][4], "100010");
	strcpy_s(TableCar[98][5], "110010");
	strcpy_s(TableCar[98][6], "101100");
	strcpy_s(TableCar[98][7], "000000");
	strcpy_s(TableCar[98][8], "000000");
	/* 'c' */
	strcpy_s(TableCar[99][0], "000000");
	strcpy_s(TableCar[99][1], "000000");
	strcpy_s(TableCar[99][2], "011100");
	strcpy_s(TableCar[99][3], "100010");
	strcpy_s(TableCar[99][4], "100000");
	strcpy_s(TableCar[99][5], "100010");
	strcpy_s(TableCar[99][6], "011100");
	strcpy_s(TableCar[99][7], "000000");
	strcpy_s(TableCar[99][8], "000000");
	/* 'd' */
	strcpy_s(TableCar[100][0], "000010");
	strcpy_s(TableCar[100][1], "000010");
	strcpy_s(TableCar[100][2], "011010");
	strcpy_s(TableCar[100][3], "100110");
	strcpy_s(TableCar[100][4], "100010");
	strcpy_s(TableCar[100][5], "100110");
	strcpy_s(TableCar[100][6], "011010");
	strcpy_s(TableCar[100][7], "000000");
	strcpy_s(TableCar[100][8], "000000");
	/* 'e' */
	strcpy_s(TableCar[101][0], "000000");
	strcpy_s(TableCar[101][1], "000000");
	strcpy_s(TableCar[101][2], "011100");
	strcpy_s(TableCar[101][3], "100010");
	strcpy_s(TableCar[101][4], "111110");
	strcpy_s(TableCar[101][5], "100000");
	strcpy_s(TableCar[101][6], "011100");
	strcpy_s(TableCar[101][7], "000000");
	strcpy_s(TableCar[101][8], "000000");
	/* 'f' */
	strcpy_s(TableCar[102][0], "001100");
	strcpy_s(TableCar[102][1], "010010");
	strcpy_s(TableCar[102][2], "111000");
	strcpy_s(TableCar[102][3], "010000");
	strcpy_s(TableCar[102][4], "010000");
	strcpy_s(TableCar[102][5], "010000");
	strcpy_s(TableCar[102][6], "010000");
	strcpy_s(TableCar[102][7], "000000");
	strcpy_s(TableCar[102][8], "000000");
	/* 'g */
	strcpy_s(TableCar[103][0], "000000");
	strcpy_s(TableCar[103][1], "000000");
	strcpy_s(TableCar[103][2], "011010");
	strcpy_s(TableCar[103][3], "100110");
	strcpy_s(TableCar[103][4], "100010");
	strcpy_s(TableCar[103][5], "100110");
	strcpy_s(TableCar[103][6], "011010");
	strcpy_s(TableCar[103][7], "000010");
	strcpy_s(TableCar[103][8], "011100");
	/* 'h' */
	strcpy_s(TableCar[104][0], "100000");
	strcpy_s(TableCar[104][1], "100000");
	strcpy_s(TableCar[104][2], "101100");
	strcpy_s(TableCar[104][3], "110010");
	strcpy_s(TableCar[104][4], "100010");
	strcpy_s(TableCar[104][5], "100010");
	strcpy_s(TableCar[104][6], "100010");
	strcpy_s(TableCar[104][7], "000000");
	strcpy_s(TableCar[104][8], "000000");
	/* 'i' */
	strcpy_s(TableCar[105][0], "001000");
	strcpy_s(TableCar[105][1], "000000");
	strcpy_s(TableCar[105][2], "011000");
	strcpy_s(TableCar[105][3], "001000");
	strcpy_s(TableCar[105][4], "001000");
	strcpy_s(TableCar[105][5], "001000");
	strcpy_s(TableCar[105][6], "011100");
	strcpy_s(TableCar[105][7], "000000");
	strcpy_s(TableCar[105][8], "000000");
	/* 'j' */
	strcpy_s(TableCar[106][0], "001000");
	strcpy_s(TableCar[106][1], "000000");
	strcpy_s(TableCar[106][2], "011000");
	strcpy_s(TableCar[106][3], "001000");
	strcpy_s(TableCar[106][4], "001000");
	strcpy_s(TableCar[106][5], "001000");
	strcpy_s(TableCar[106][6], "001000");
	strcpy_s(TableCar[106][7], "001000");
	strcpy_s(TableCar[106][8], "110000");
	/* 'k' */
	strcpy_s(TableCar[107][0], "100000");
	strcpy_s(TableCar[107][1], "100000");
	strcpy_s(TableCar[107][2], "100010");
	strcpy_s(TableCar[107][3], "100100");
	strcpy_s(TableCar[107][4], "111000");
	strcpy_s(TableCar[107][5], "100100");
	strcpy_s(TableCar[107][6], "100010");
	strcpy_s(TableCar[107][7], "000000");
	strcpy_s(TableCar[107][8], "000000");
	/* 'l' */
	strcpy_s(TableCar[108][0], "011000");
	strcpy_s(TableCar[108][1], "001000");
	strcpy_s(TableCar[108][2], "001000");
	strcpy_s(TableCar[108][3], "001000");
	strcpy_s(TableCar[108][4], "001000");
	strcpy_s(TableCar[108][5], "001000");
	strcpy_s(TableCar[108][6], "011100");
	strcpy_s(TableCar[108][7], "000000");
	strcpy_s(TableCar[108][8], "000000");
	/* 'm' */
	strcpy_s(TableCar[109][0], "000000");
	strcpy_s(TableCar[109][1], "000000");
	strcpy_s(TableCar[109][2], "110100");
	strcpy_s(TableCar[109][3], "101010");
	strcpy_s(TableCar[109][4], "101010");
	strcpy_s(TableCar[109][5], "101010");
	strcpy_s(TableCar[109][6], "101010");
	strcpy_s(TableCar[109][7], "000000");
	strcpy_s(TableCar[109][8], "000000");
	/* 'n' */
	strcpy_s(TableCar[110][0], "000000");
	strcpy_s(TableCar[110][1], "000000");
	strcpy_s(TableCar[110][2], "101100");
	strcpy_s(TableCar[110][3], "110010");
	strcpy_s(TableCar[110][4], "100010");
	strcpy_s(TableCar[110][5], "100010");
	strcpy_s(TableCar[110][6], "100010");
	strcpy_s(TableCar[110][7], "000000");
	strcpy_s(TableCar[110][8], "000000");
	/* 'o' */
	strcpy_s(TableCar[111][0], "000000");
	strcpy_s(TableCar[111][1], "000000");
	strcpy_s(TableCar[111][2], "011100");
	strcpy_s(TableCar[111][3], "100010");
	strcpy_s(TableCar[111][4], "100010");
	strcpy_s(TableCar[111][5], "100010");
	strcpy_s(TableCar[111][6], "011100");
	strcpy_s(TableCar[111][7], "000000");
	strcpy_s(TableCar[111][8], "000000");
	/* 'p' */
	strcpy_s(TableCar[112][0], "000000");
	strcpy_s(TableCar[112][1], "000000");
	strcpy_s(TableCar[112][2], "101100");
	strcpy_s(TableCar[112][3], "110010");
	strcpy_s(TableCar[112][4], "100010");
	strcpy_s(TableCar[112][5], "110010");
	strcpy_s(TableCar[112][6], "101100");
	strcpy_s(TableCar[112][7], "100000");
	strcpy_s(TableCar[112][8], "100000");
	/* 'q' */
	strcpy_s(TableCar[113][0], "000000");
	strcpy_s(TableCar[113][1], "000000");
	strcpy_s(TableCar[113][2], "011010");
	strcpy_s(TableCar[113][3], "100110");
	strcpy_s(TableCar[113][4], "100010");
	strcpy_s(TableCar[113][5], "100110");
	strcpy_s(TableCar[113][6], "011010");
	strcpy_s(TableCar[113][7], "000010");
	strcpy_s(TableCar[113][8], "000010");
	/* 'r' */
	strcpy_s(TableCar[114][0], "000000");
	strcpy_s(TableCar[114][1], "000000");
	strcpy_s(TableCar[114][2], "101100");
	strcpy_s(TableCar[114][3], "110010");
	strcpy_s(TableCar[114][4], "100000");
	strcpy_s(TableCar[114][5], "100000");
	strcpy_s(TableCar[114][6], "100000");
	strcpy_s(TableCar[114][7], "000000");
	strcpy_s(TableCar[114][8], "000000");
	/* 's' */
	strcpy_s(TableCar[115][0], "000000");
	strcpy_s(TableCar[115][1], "000000");
	strcpy_s(TableCar[115][2], "011110");
	strcpy_s(TableCar[115][3], "100000");
	strcpy_s(TableCar[115][4], "011100");
	strcpy_s(TableCar[115][5], "000010");
	strcpy_s(TableCar[115][6], "111100");
	strcpy_s(TableCar[115][7], "000000");
	strcpy_s(TableCar[115][8], "000000");
	/* 't' */
	strcpy_s(TableCar[116][0], "001000");
	strcpy_s(TableCar[116][1], "001000");
	strcpy_s(TableCar[116][2], "011100");
	strcpy_s(TableCar[116][3], "001000");
	strcpy_s(TableCar[116][4], "001000");
	strcpy_s(TableCar[116][5], "001000");
	strcpy_s(TableCar[116][6], "000110");
	strcpy_s(TableCar[116][7], "000000");
	strcpy_s(TableCar[116][8], "000000");
	/* 'u' */
	strcpy_s(TableCar[117][0], "000000");
	strcpy_s(TableCar[117][1], "000000");
	strcpy_s(TableCar[117][2], "100010");
	strcpy_s(TableCar[117][3], "100010");
	strcpy_s(TableCar[117][4], "100010");
	strcpy_s(TableCar[117][5], "100110");
	strcpy_s(TableCar[117][6], "011010");
	strcpy_s(TableCar[117][7], "000000");
	strcpy_s(TableCar[117][8], "000000");
	/* 'v' */
	strcpy_s(TableCar[118][0], "000000");
	strcpy_s(TableCar[118][1], "000000");
	strcpy_s(TableCar[118][2], "100010");
	strcpy_s(TableCar[118][3], "100010");
	strcpy_s(TableCar[118][4], "100010");
	strcpy_s(TableCar[118][5], "010100");
	strcpy_s(TableCar[118][6], "001000");
	strcpy_s(TableCar[118][7], "000000");
	strcpy_s(TableCar[118][8], "000000");
	/* 'w' */
	strcpy_s(TableCar[119][0], "000000");
	strcpy_s(TableCar[119][1], "000000");
	strcpy_s(TableCar[119][2], "101010");
	strcpy_s(TableCar[119][3], "101010");
	strcpy_s(TableCar[119][4], "101010");
	strcpy_s(TableCar[119][5], "101010");
	strcpy_s(TableCar[119][6], "010100");
	strcpy_s(TableCar[119][7], "000000");
	strcpy_s(TableCar[119][8], "000000");
	/* 'x' */
	strcpy_s(TableCar[120][0], "000000");
	strcpy_s(TableCar[120][1], "000000");
	strcpy_s(TableCar[120][2], "100010");
	strcpy_s(TableCar[120][3], "010100");
	strcpy_s(TableCar[120][4], "001000");
	strcpy_s(TableCar[120][5], "010100");
	strcpy_s(TableCar[120][6], "100010");
	strcpy_s(TableCar[120][7], "000000");
	strcpy_s(TableCar[120][8], "000000");
	/* 'y' */
	strcpy_s(TableCar[121][0], "000000");
	strcpy_s(TableCar[121][1], "000000");
	strcpy_s(TableCar[121][2], "100010");
	strcpy_s(TableCar[121][3], "100010");
	strcpy_s(TableCar[121][4], "100010");
	strcpy_s(TableCar[121][5], "010100");
	strcpy_s(TableCar[121][6], "001000");
	strcpy_s(TableCar[121][7], "001000");
	strcpy_s(TableCar[121][8], "110000");
	/* 'z' */
	strcpy_s(TableCar[122][0], "000000");
	strcpy_s(TableCar[122][1], "000000");
	strcpy_s(TableCar[122][2], "111110");
	strcpy_s(TableCar[122][3], "000100");
	strcpy_s(TableCar[122][4], "001000");
	strcpy_s(TableCar[122][5], "010000");
	strcpy_s(TableCar[122][6], "111110");
	strcpy_s(TableCar[122][7], "000000");
	strcpy_s(TableCar[122][8], "000000");

}

