#include "stdafx.h"
#include "SDL.h"
#include "math.h"
#include "stdio.h"

class bloc{

private:
	int x_pos,y_pos;
	Uint32 color;

public:
	bloc(int=0,int=0 ,Uint32=0);
	//~bloc();
	int Get_X_pos();
	int Get_Y_pos();
	Uint32 Get_Color();
	void Set_bloc_Pos(int ,int);
	void Set_bloc_Color(Uint32);
	void put_bloc(int ,int ,SDL_Rect *,SDL_Surface *,SDL_Surface * );
	void efface_bloc(SDL_Rect *,SDL_Surface *,SDL_Surface * );
	void put_pixel(int , int ,SDL_Surface *,Uint32 );
};

bloc::bloc(int X,int Y,Uint32 c)
{
	x_pos=X;
	y_pos=Y;
	color=c;

}

int bloc::Get_X_pos()
{
	return x_pos;
}

int bloc::Get_Y_pos()
{
	return y_pos;
}


void bloc::put_pixel(int x, int y,SDL_Surface *image,Uint32 pixel)
{
int bpp = image->format->BytesPerPixel;
	Uint8 *p = (Uint8 *)image->pixels + y * image->pitch + x * bpp;
	if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
        p[0] = (pixel >> 16) & 0xff;
        p[1] = (pixel >> 8) & 0xff;
        p[2] = pixel & 0xff;
    } else {
        p[0] = pixel & 0xff;
        p[1] = (pixel >> 8) & 0xff;
        p[2] = (pixel >> 16) & 0xff;
    }



}

void bloc::put_bloc(int x,int y,SDL_Rect *d,SDL_Surface *image,SDL_Surface * ecran)
{

	Set_bloc_Pos(x,y);
	d->x=x_pos;
	d->y=y_pos;
	d->w=29;
	d->h=29;
	//image = SDL_LoadBMP( "P.bmp" );
	
	//image = SDL_CreateRGBSurface(SDL_HWSURFACE, 10,10, 32, 0, 0, 0, 0); // La bordure du bloc
	SDL_FillRect(image, NULL, color);
	
	SDL_BlitSurface(image, NULL, ecran, d);
	//SDL_FillRect(blocDegrade, NULL, 4599);
	//SDL_BlitSurface(blocDegrade, NULL,image, &d);
	//(image, NULL, 6543);
	//SDL_BlitSurface( image, NULL, ecran, NULL );
	SDL_UpdateRects(ecran, 1, d);
	
}
void bloc::efface_bloc(SDL_Rect *d,SDL_Surface *image,SDL_Surface *ecran )
{
	d->x=x_pos;
	d->y=y_pos;
	d->w=29;
	d->h=29;
	
	
	SDL_FillRect(image, NULL, (231<<16)+(228<<8)+233);
	SDL_BlitSurface(image, NULL, ecran, d);
	SDL_UpdateRects(ecran, 1, d);
	
}
void bloc::Set_bloc_Pos(int X,int Y)
{

	x_pos=X;
	y_pos=Y;


}

void bloc::Set_bloc_Color(Uint32 c){


	color=c;
}

Uint32 bloc::Get_Color()
{
	return color;
}