function display(k,b)

%       Etienne Balmes  07/28/92, 03/22/98
%       Copyright (c) 2001-2002 by INRIA and SDTools

%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.


if nargin==1 disp(' ');disp([inputname(1),' = ']); end

if k.ty(1)==2|k.ty(1)==3 % LU factors
   i1 = nnz(k.l)+nnz(k.u);st='LU'; if k.ty(1)==3 st='Cholesky';end
   st = sprintf('\n[ %i DOFs ] (%i elements %.1f MB) Sparse %s factors', ...
     size(k.l,1),i1,(i1*16+8*size(k.l,1))/1024^2,st);

elseif k.ty(1)==5
   st = sprintf('\n[ %i DOFs ] External %s solver matrix %i', ...
     k.ty(3),k.ind,k.ty(2));
   
else
  st = sprintf('\n[ %i DOFs ] (%i elements %.1f MB)', ...
     length(k.ind)-1,k.ind(end)-1, ...
     ((length(k.data)+length(k.ind)+1)*8/1024^2));
  if k.ty(1)==0 st=[st ' Nominal']; elseif k.ty(1)==1 st=[st ' Factored']; end

end
st = [st st(1)];disp(st)
