function  q = mldivide(k,b);

% skyline/mldivide

%	Etienne Balmes 05/28/97, 11/07/02
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.

if isstr(b) 
  if k.ty(1)==0 sp_util('sky_dec',k);end
  q=[]; 
elseif isempty(b) q=b;

elseif k.ty(1)==2 | k.ty(1)==3   q = k.u \ (k.l \ b);
elseif ~isempty(k.method.Solve)

  eval(k.method.Solve)

elseif k.ty(1)==5 % external solver

  if strcmp(k.ind,'spfmex')  q=spfmex('solve',k.ty(2),full(b));
  elseif strcmp(k.ind,'psldlt')
    q=zeros(size(b));
    for j1=1:size(b,2)   q(:,j1)=psldlt('solve',full(b(:,j1)),k.ty(2));  end
  end

else
  if issparse(b); b=full(b);end
  if k.ty(1)==0  sp_util('sky_dec',k); end
  if isreal(b) q = sp_util('sky_inv',k,b);
  else q = sp_util('sky_inv',k,real(b))+i*sp_util('sky_inv',k,imag(b));end
  %q = zeros(size(b));
  %for j1=1:size(b,2) q(:,j1) = sp_util('sky_inv',k,b(:,j1)); end
end
