function ks=mtaucs_utils(varargin);


% Gateway function for inclusion of the TAUCS solver into the 
% OpenFEM skyline object
%
% http://www.tau.ac.il/~stoledo/taucs/
%
% TAUCS Version 1.0, November 29, 2001. 
% Copyright (c) 2001 by Sivan Toledo, Tel-Aviv Univesity, 
% stoledo@tau.ac.il. All Rights Reserved. 
%
%TAUCS License:
%
% Your use or distribution of TAUCS or any derivative code implies that you agree 
% to this License. 
% THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED 
% OR IMPLIED. ANY USE IS AT YOUR OWN RISK. 
%
%Permission is hereby granted to use or copy this program, provided that the
% Copyright, this License, and the Availability of the original version is 
% retained on all copies. User documentation of any code that uses this code 
% or any derivative code must cite the Copyright, this License, the 
% Availability note, and "Used by permission." If this code or any derivative 
% code is accessible from within MATLAB, then typing "help taucs" must cite 
% the Copyright, and "type taucs" must also cite this License and the 
% Availability note. Permission to modify the code and to distribute 
% modified code is granted, provided the Copyright, this License, 
% and the Availability note are retained, and a notice that the code 
% was modified is included. This software is provided to you free of charge. 
%
%
% To modify factorization method use
% skyline('method mtaucs','FactBuild','ks=mtaucs_utils(''fact'',k,ks,[2 1 1]);')
% Methods are 1 LDLt 2 SNMF 3 SNLL 4 Symbolic 5 OOC



Cam=varargin{1};carg=2;
if comstr(Cam,'method')

   ks.name='mtaucs';
   ks.header='TAUCS sparse solver';
   ks.SymRenumber='';
   ks.FactBuild='ks=mtaucs_utils(''fact'',k,ks,[2 0 0]);';
   ks.Solve='q=mtaucs_utils(''solve'',k,full(b));';
   ks.Clear='mtaucs(''clear'',ks.ty(2));';
   ks.Available=exist('mtaucs')==3;
   ks.HandlesComplex=0;

elseif comstr(Cam,'fact')

 k=varargin{carg};carg=carg+1;
 ki=varargin{carg};carg=carg+1;
 if carg>nargin opt=[1 1 size(k,1)/32  0.01*size(k,1)];
 else opt=varargin{carg};carg=carg+1;
 end
 st={'ldlt','snmf','snll','sym','ooc'};
 

 if isstr(k)  % Matrix stored in file

 else
   if ~issparse(k) k = sparse(k); end
   t=cputime;
   i1=find(diag(k)==0);
   if ~isempty(i1) 
     if length(i1)<10
      error(sprintf('Zero terms on diagonal :%i\n',i1)); 
     else error(sprintf('%i zero terms on diagonal \n',length(i1))); end   
     return
   end
   k=tril(k);
   k=k+spalloc(size(k,1),size(k,2),0);
 end
 i1=mtaucs('fact',k,opt);
 ks.method.name=sprintf('mtaucs',st{opt(1)});

 if opt(2) fprintf('\nOptions %sm %.2f s',sprintf('%g ',opt),cputime-t); end

 ks=ki; ks.ty(2:3)=[i1 size(k,1)];
 ks.ind='mtaucs';

elseif comstr(Cam,'solve')

     k=varargin{2}; b=varargin{3};
     if issparse(b) b=full(b);end
     ks=zeros(size(b));
     for j1=1:size(b,2)
        ks(:,j1)=mtaucs('solve',k.ty(2),b(:,j1));
     end

elseif comstr(Cam,'clear')

 ks=varargin{carg};carg=carg+1;
 if isempty(ks)  mtaucs('clear',-1);
 elseif isa(ks,'double') 
    try; mtaucs('clear',ks);catch; disp(lasterr);end
 else
    try; mtaucs('clear',ks.ty(2)); catch;disp(lasterr);end
 end

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1==2  % This is used for compilation


% THIS IS WHAT WE USED TO CREATE THE MEX ON LINUX

mex -v mtaucs.c -Isrc libmetis.a /hosts/thuya/MSS/APP/matlab6.1/bin/glnx86/libmwlapack.so /hosts/thuya/MSS/APP/matlab6.1/bin/glnx86/atlas_PIII.so  -L . -lmetis  -lg2c -lm   


% try a few things to have a go at WINDOWS
wd='c:/tmp/taucs';
cd src;a=dir('*.c');cd(wd);

for j1=1:length(a)

 eval(sprintf('!cl -DTAUCS_CORE_DOUBLE  /O2 -g -D_POSIX_C_SOURCE=199506L -std=iso99:199409 -pedantic -Isrc  -DN0COLAMD -DOSTYPE_linux -DMACHTYPE_i386 -DVARIANT -DTAUCS_MEMORY_TEST_ /c /Fosrc/%s.oD src/%s',a(j1).name,a(j1).name))

end

!make clean
!make
wd='c:/tmp/taucs';
delete('mtaucs_dll.a')
cd(wd);a=dir('*.obj');
for j1=1:length(a)
 st=sprintf('!ar rv mtaucs_dll.a %s',a(j1).name);
 eval(st)
end
delete *.obj

mex -v mtaucs.c -Isrc c:/tmp/taucs/mtaucs_dll.a c:/matlabR12/extern/lib/win32/microsoft/msvc60/libmwlapack.lib c:/tmp/taucs/libmetis.a 


mex -v mtaucs.c -Isrc c:/tmp/taucs/libmetis.a c:/tmp/taucs/mtaucs_dll.a c:/matlabR12/extern/lib/win32/microsoft/msvc60/libmwlapack.lib 







% THIS FAILS BECAUSE OF 
%c:/matlabR12/bin/win32/atlas_PIII.lib


end
