function ks=spfmex_utils(varargin);

% Gateway function for inclusion of the SPFMEX solver into the 
% OpenFEM skyline object

Cam=varargin{1};carg=2;
if comstr(Cam,'method')

   ks.name='spfmex';
   ks.header='SDT sparse LDLt solver';
   ks.SymRenumber='';
   ks.FactBuild='ks=spfmex_utils(''fact'',k,ks,[1 1 size(k,1)/32  0.01*size(k,1)]);';
   ks.Solve='q=spfmex(''solve'',k.ty(2),full(b));';
   ks.Clear='spfmex_utils(''clear'',ks);';
   ks.Available=exist('spfmex')==3;
   ks.HandlesComplex=1;

elseif comstr(Cam,'fact')

 k=varargin{carg};carg=carg+1;
 ki=varargin{carg};carg=carg+1;
 if carg>nargin opt=[1 1 size(k,1)/32  0.01*size(k,1)];
 else opt=varargin{carg};carg=carg+1;
 end

 if ~issparse(k) k = sparse(k); end
 t=cputime;
 i1=find(diag(k)==0);
 if ~isempty(i1) 
     if length(i1)<10
      error(sprintf('Zero terms on diagonal :%i\n',i1)); 
     else error(sprintf('%i zero terms on diagonal \n',length(i1))); end   
     return
 end
 % opt=[matlabmsglvl msglvl maxdomainsize maxzeros]

 i1=spfmex('fact',sparse(k),opt);
 if opt(1) fprintf(' %.2f s',cputime-t); end

 ks=ki; ks.ty(2:3)=[i1 size(k,1)];
 ks.ind='spfmex';

elseif comstr(Cam,'solve')

 dbstop error
 error(1);

elseif comstr(Cam,'clear')

 ks=varargin{carg};carg=carg+1;
 if isempty(ks)  spfmex('clear',-1);
 elseif isa(ks,'double') 
    try; spfmex('clear',ks);catch; disp(lasterr);end
 else
    try; spfmex('clear',ks.ty(2)); catch;disp(lasterr);end
 end


end