function [idof,k,m]=beam3(node,elt,pe,ie,opt)

%BEAM3 element function for the 3-node 18DOF beam element
%
%	In an model description matrix a group of BEAM3 elements starts with a
%	header row [Inf  abs('beam3') 0 ...] followed by element property rows
%       ELT following the format
%	    [n1 n2 n3 MatID ProID EltID]
%         with
%	   n1,n2,n3  node numbers of the tips of the bar element
%	   MatID  material property identification number
%	   ProID  element property identification number
%	   EltID  element identifier (optional, default 0)
%
%       CURRENTLY FOR PLOT ONLY
%
%	See also help beam1, elem0
%	         doc  bar1, eltfun, elem0

%	Etienne Balmes   10/10/90, 10/05/99
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.
%       $Revision: 1.8 $  $Date: 2006/01/27 14:28:50 $

if comstr(node,'cvs')
 idof='$Revision: 1.8 $  $Date: 2006/01/27 14:28:50 $'; return;
end

% standard calls with one input argument
if ischar(node)
 [CAM,Cam]=comstr(node,1);
 if comstr(Cam,'integinfo')

   idof=[];k=[];m=[];

 elseif      comstr(node,'call')
   idof = ['[i1,k1,m1] = bar1(node(NNode(elt(cEGI(jElt),[1 2])),:),elt(cEGI(jElt),:),pl,il,[opt(1) jGroup jElt]);'];
 elseif  comstr(node,'node');  idof = [1 2 3];
 elseif  comstr(node,'prop');  idof = [4 5 6];
elseif  comstr(node,'dof');   
  idof=[1+[1:6]/100 2+[1:6]/100 3+[1:6]/100];
 elseif  comstr(node,'line');   idof = [1 3 2];
 elseif  comstr(node,'patch');  idof = [1 3;3 2];
 elseif comstr(node,'sci_face'); idof = [1 2 3];
 elseif  comstr(node,'parent');   idof = 'beam3';
 elseif  comstr(Cam,'test'); disp('beam3 test : just for display')
 end
return
end % of standard calls with one input argument

error('Element matrix computations not available yet');

FEw =[-.577350269189626 1.0;
       .577350269189626 1.0];
% x(x-1)/2 1-x^2 x(x+1)/2
FEna =[FEw(:,1).*(FEw(:,1)-1)/2 1-FEw(:,1).^2 FEw(:,1).*(FEw(:,1)+1)/2]
FEnar=[FEw(:,1)-.5  -2*FEw(:,1) FEw(:,1)+.5];



