function [EGroup,nGroup]=getegroup(elt);

%GETEGROUP get element group positions and number of groups
%
%	Syntax : [EGroup,nGroup]=getegroup(elt);

%	Etienne Balmes  05/28/01
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.
% $Revision: 1.3 $  $Date: 2006/01/27 14:28:50 $

if isempty(elt)
 EGroup=[1 1]; nGroup=0;
else
    tmp = find(~finite(elt(:,1)));
    if size(tmp,1)~=1; tmp = tmp'; end
  EGroup=[tmp size(elt,1)+1]; nGroup = length(EGroup)-1;
  if nGroup == 0; warning('no element group specified in ELT'); end
end