function [out,out1,out2]=hexa27b(CAM,varargin);

%HEXA27B 27-node,, 6 sided volume element supporting 
%       - fully anisotropic elasticity (hyperelasticity beta version)
%       - integration rule selection
%       - pressure, volume, inertial and thermal loads
%       - geometric non linearity
%
%       Elements of the same family
%         hexa8b, hexa20b, hexa27b, 
%         tetra4b, tetra10b, 
%         penta6b, penta15b,
%
%       See also doc hexa27b

%	Etienne Balmes, Jean-Michel Leclere
%       Copyright (c) 2001-2005 by INRIA and SDTools,All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if comstr(CAM,'cvs')
 out='$Revision: 1.2 $  $Date: 2006/01/27 14:28:50 $'; return;
end
% standard calls with one input argument
if ischar(CAM)
 [CAM,Cam]=comstr(CAM,1);

 if comstr(Cam,'integinfo')
 %constit integ                          ID,pl,il
  [out ,   out1] = p_solid('buildconstit',[varargin{1};81;27],varargin{2},varargin{3});
  %elmap
  out2=elem0('elmapmat_og',[27 3]);

 % - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 % Matrix assembly in fe_mknl

 elseif comstr(Cam,'matcall'); out='mat_og'; out1=0; % mat_og and non symmetric
 elseif comstr(Cam,'call'); out=elem0('callmat_og');
 elseif comstr(Cam,'rhscall'); out=elem0('rhsmat_og'); % call for load
 elseif comstr(Cam,'groupinit');out=elem0('groupinitog','hexa27b');
 elseif comstr(Cam,'dofcall');out=elem0('dofcall'); % variable field elements

 % Here one defines the constants needed for element integration
 elseif comstr(Cam,'constants');

  if nargin>3; out=p_solid('constsolid','hexa27',varargin{2:3});
  else; p_solid('constsolid','hexa27',[],[]);return;
  end
  out1=varargin{1};out1(4,:)=3; % Tell of_mk('MatrixIntegration') this is 3d 

 % end of GroupInit - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 % Basic tests of the element - - - - - - - - - - - - - - - - - - - - - -
 elseif  comstr(Cam,'test'); [CAM,Cam] = comstr(CAM,5);
   [out,out1]=femesh(strcat(['teststruct hexa27b' Cam]));
 % end Basic tests of the element - - - - - - - - - - - - - - - - - - - - - -
 elseif comstr(Cam,'node');  out = [1:27];
 elseif  comstr(Cam,'prop');  out = [28 29 30];
 elseif comstr(Cam,'dof')
   out =[1:27];k=[1:3]'/100;
   out=out(ones(3,1),:)+k(:,ones(27,1));out=out(:);
 elseif comstr(Cam,'line');
   out = ...
    [1 9 2 10 3 11 4 12 1 13 5 17 6 18 7 19 8 20 5 0 2 14 6 0 3 15 7 0 4 16 8];
 elseif comstr(Cam,'patch');
   out = [  4 11 3 10 2 9 1 12;
            5 13 1 9  2 14   6 17;
            5 17 6 18 7 19 8 20;
            4 16 8 19 7 15 3 11;
            5 20 8 16 4 12 1 13;
            2 10 3 15 7 18 6 14];

 elseif  comstr(Cam,'edge');  out = [1 2 9; 2 3 10; 3 4 11; ...
				     4 1 12; 1 5 13; 2 6 14; ...
				     3 7 15; 4 8 16; 5 6 17; ...
				     6 7 18; 7 8 19; 8 5 20];
 elseif  comstr(Cam,'face');   out = [1 4 3 2 12 11 10 9  21 ; ...
				      1 5 8 4 13 20 16 12 22 ; ...
				      1 2 6 5  9 14 17 13 23 ; ...
			              5 6 7 8 17 18 19 20 24 ; ...
				      2 3 7 6 10 15 18 14 25 ; ...
				      3 4 8 7 11 16 19 15 26 ];
 elseif comstr(Cam,'sci_face');
   out = [1 9 13 13;9 2 14 14;14 6 17 17;17 5 13 13;9 14 17 13;
          2 10 14 14;10 3 15 15;15 7 18 18;18 6 14 14;10 15 18 14;
	  6 18 17 17;18 7 19 19;19 8 20 20;20 5 17 17;18 19 20 17;
	  1 12 9 9;12 4 11 11;11 3 10 10;10 2 9 9;12 11 10 9;
	  4 16 11 11;16 8 19 19;19 7 15 15;15 3 11 11;16 19 15 11;
	  1 13 12 12;13 5 20 20;20 8 16 16;16 4 12 12;13 20 16 12];

 elseif  comstr(Cam,'parent');
   out = 'hexa27b';
 end
return
end % of standard calls with one input argument

