function [out,out1,out2]=hexa8a(CAM,varargin);

%HEXA8a	8-node 24-DOF isoparametric solid element (3q1d)
%
%	This is nearly identical to hexa8 except that it assumes fully 
%       anistropic materials
%
%	See also help hexa8, hexa20, penta6, tetra4
% 	         doc  eltfun, elem0

%	Etienne Balmes, Jean-Michel Leclere, Marina Vidrascu  
%       Copyright (c) 2001-2004 by INRIA and SDTools,All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if comstr(CAM,'cvs')
 out='$Revision: 1.8 $  $Date: 2006/01/27 14:28:50 $'; return;
end
% standard calls with one input argument
if ischar(CAM)

 [CAM,Cam]=comstr(CAM,1);
 % Build Constit, Integ, and Elmap for later integration
 if comstr(Cam,'integinfo')

  [constit,integ] = ...
     fe_mat('plil of_mk 3d',varargin{1},varargin{2},varargin{3}); %solid
  integ(3:4)=[24 8];

  % element map
  i1=find(triu(ones(24,24))); r1=zeros(24,24);r1(i1)=1:length(i1);
  out2=r1+tril(r1',-1);
  out1=integ(:); out=constit(:); 
  % Reformat constit if needed Format documentation see
  % eval(sprintf('!grep G11 %s',fileparts(which('fe_mat.m'))))
  if length(constit)==4  % Rho 0 E nu is provided

    r1=constit(3)/2/(1+constit(4));  % G
    r2=constit(3)*constit(4)/(1+constit(4))/(1-2*constit(4)); % En/(1+n)(1-n)
    dd=zeros(6);
    dd([1 2 3 7 8 9 13 14 15])=r2+[2*r1 0 0  0 2*r1 0  0 0 2*r1];
    dd([22 29 36])=r1; % G
    out=[constit(1);constit(2);dd(:)];

  elseif length(constit)~=38 
   warning('This does not have a 3D anisotropic material');
  end

 % - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 elseif comstr(Cam,'call')| comstr(Cam,'matcall'); % call for matrix assembly
   out='[k1,m1]=hexa8a(nodeE,elt(cEGI(jElt),:),pointers(:,jElt),integ,constit,elmap);';
 else out=hexa8(CAM);
 end

return
end % of standard calls with one input argument

% -----------------------------------------------------------------------------
% element matrix assembly - - - - - - - - - - - - - - - - - - - - - - - - - -

node=CAM; 
elt=varargin{1}; 
point=varargin{2};
integ=varargin{3};
constit=varargin{4};
elmap=varargin{5};
if isa(elmap,'int32'); elmap = double(elmap); end

if size(node,2)~=4
 NNode(node(:,1))=1:size(node,1);
 node=node(NNode(elt(1,1:8)),[5:7 1]);
end

if integ(point(6)+8)==3 % orthotropic 
 typ=point(5);
 if (typ==0) % mass and stiffness
  [k1,m1]=of_mk('hexa8',int32(point),integ,constit,node);
  k=reshape(k1(elmap),size(elmap,1),size(elmap,2));
  m=reshape(m1(elmap),size(elmap,1),size(elmap,2));
  if k(1)<0; error('Reorient elements using feutil(''orient'')'); end
  out=k; out1=m;
 elseif typ>99
  state=varargin{6}; ;point(30)=0;point(5)=100;
  out=of_mk('hexa8',int32(point),integ,constit,node,state);
 else
   k1=of_mk('hexa8',int32(point),integ,constit,node);
   k=reshape(k1(elmap),size(elmap,1),size(elmap,2));
   out=k; out1=[];
 end
else % really anisotropic

[FEw,FEna,FEnar,FEnas,FEnat]=shapes;

jElt=1;

  if any(elt(jElt,1:8)==0); error('Nodes 1 to 8 must be defined');end
  i1 = 1:8;  x(i1,1:3)=node(:,1:3);

  xr = FEnar*x(:,1); xs = FEnas*x(:,1); xt = FEnat*x(:,1);
  yr = FEnar*x(:,2); ys = FEnas*x(:,2); yt = FEnat*x(:,2);
  zr = FEnar*x(:,3); zs = FEnas*x(:,3); zt = FEnat*x(:,3);

  cof11 = ys.*zt - yt.*zs;
  cof12 = yt.*zr - yr.*zt;
  cof13 = yr.*zs - ys.*zr;
  cof21 = zs.*xt - zt.*xs;
  cof22 = zt.*xr - zr.*xt;
  cof23 = zr.*xs - zs.*xr;
  cof31 = xs.*yt - xt.*ys;
  cof32 = xt.*yr - xr.*yt;
  cof33 = xr.*ys - xs.*yr;

  jdet = xr.*cof11+xs.*cof12+xt.*cof13;
  jdet=jdet*sign(jdet(1));
  if any(jdet<0); warning('hexa8 negative Jacobian');end

  i2=ones(size(FEna,2),1); % number of shape functions
  nax = [FEnar.*cof11(:,i2)+FEnas.*cof12(:,i2)+FEnat.*cof13(:,i2)]; %true/jdet
  nay = [FEnar.*cof21(:,i2)+FEnas.*cof22(:,i2)+FEnat.*cof23(:,i2)]; 
  naz = [FEnar.*cof31(:,i2)+FEnas.*cof32(:,i2)+FEnat.*cof33(:,i2)]; 

 % stiffness matrix assembly - - - - - - - - - - - - - - - - - - - - - - - -
 if any([0 1]==point(5));

  k = zeros(24,24); B=zeros(6,24); 
  dd = reshape(constit(point(7)+[3:38]),6,6)*FEw(1,4); 
  %     B(1,[1:3:24       ]) = [nax(j1,:)                    ];
  %     B(2,[2:3:24       ]) = [          nay(j1,:)          ];
  %     B(3,[3:3:24       ]) = [                    naz(j1,:)];
  %     B(4,[2:3:24 3:3:24]) = [          naz(j1,:) nay(j1,:)];
  %     B(5,[1:3:24 3:3:24]) = [naz(j1,:)           nax(j1,:)];
  %     B(6,[1:3:24 2:3:24]) = [nay(j1,:) nax(j1,:)          ];

  i1 = [1:18:144 8:18:144 15:18:144 ...
        10:18:144 16:18:144 5:18:144 17:18:144 6:18:144 12:18:144];
  for j1=1:8
     r1=nax(j1,:); r2=nay(j1,:); r3=naz(j1,:);
     B(i1) = [r1 r2 r3 r3 r2 r3 r1 r2 r1];
     k = k + B'*(dd/jdet(j1))*B;
  end % loop on integration points
  out=k; out1=[];
 end;if any([0 2]==point(5)); % mass matrix assembly

  m = zeros(24,24);  B=spalloc(3,24,32);
  dd = constit(point(7)+1)*FEw(1,4); % note weights are all the same
  %  m=full(m);B=full(B);
  %B(1,[1:3:24       ]) = [FEna(j1,:)                    ];
  %B(2,[2:3:24       ]) = [          FEna(j1,:)          ];
  %B(3,[3:3:24       ]) = [                    FEna(j1,:)];
  %i1=[1:9:72 5:9:72 9:9:72];
  i1=[1 10 19 28 37 46 55 64 5 14 23 32 41 50 59 68 9 18 27 36 45 54 63 72];

  r1=FEna(1,:);B(i1)=[r1 r1 r1];  m =    B'*full(jdet(1)*dd*B);
  r1=FEna(2,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(2)*dd*B);
  r1=FEna(3,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(3)*dd*B);
  r1=FEna(4,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(4)*dd*B);
  r1=FEna(5,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(5)*dd*B);
  r1=FEna(6,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(6)*dd*B);
  r1=FEna(7,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(7)*dd*B);
  r1=FEna(8,:);B(i1)=[r1 r1 r1];  m = m+ B'*full(jdet(8)*dd*B);

% r1=diag(jdet(j1))*FEna;B(1:8,1:3:24)=r1;B(9:16,2:3:24)=r1;B(17:24,3:3:24)=r1;
% BT=zeros(24);
% r1=FEna';BT(1:8,1:3:24)=FEna;BT(9:16,2:3:24)=FEna;BT(17:24,3:3:24)=FEna;
% m=BT*B;
%  for j1=1:8
%     r1=FEna(j1,:);B(i1)=[r1 r1 r1];  m = m + B'*full(jdet(j1)*dd*B);
%  end % loop on integration points

   if point(5)==2; out=m; out1=[];  
   else out1=m; end
 end % mass matrix

 % stress output   - - - - - - - - - - - - - - - - - - - -
 if point(5)==100

  % T [SDOF x DOF]
  % SDOF [Element Component R S T x y z Jdet]
  % DOF [of deformation]

  idof =elt(jElt,1:8);m=[1:3]'/100;
  idof=idof(ones(3,1),:)+m(:,ones(8,1));idof=idof(:);

  r1=spalloc(6*size(FEna,1),size(idof,1),1);
  for j1=1:size(FEna,1) % loop on integration points
     B(1,[1:3:24       ]) = [nax(j1,:)                    ];
     B(2,[2:3:24       ]) = [          nay(j1,:)          ];
     B(3,[3:3:24       ]) = [                    naz(j1,:)];
     B(4,[2:3:24 3:3:24]) = [          naz(j1,:) nay(j1,:)];
     B(5,[1:3:24 3:3:24]) = [naz(j1,:)           nax(j1,:)];
     B(6,[1:3:24 2:3:24]) = [nay(j1,:) nax(j1,:)          ];
     dc = FEC.dd/jdet(j1)';
     r1(j1*6+[-5:0],:)=dc*B;
     r2(j1*6+[-5:0],1:9)=[elt(jElt,11)*ones(6,1) [1:6]' ...
       ones(6,1)*[FEna(j1,1:3) FEna(j1,:)*x jdet(j1)]];
  end % loop on integration points

  k=r1; m = r2;

 end

end
% ----------------------------------------------------------------------------
% ----------------------------------------------------------------------------
% ----------------------------------------------------------------------------



% -----------------------------------------------------------------------
function [FEw,FEna,FEnar,FEnas,FEnat]=shapes;


%Written by integrules('flui8')

FEw = [ -5.7735026918962584e-1 -5.7735026918962584e-1 -5.7735026918962584e-1 , ...
1.00e+0 ;
5.7735026918962584e-1 -5.7735026918962584e-1 -5.7735026918962584e-1 , ...
1.00e+0 ;
-5.7735026918962584e-1 5.7735026918962584e-1 -5.7735026918962584e-1 , ...
1.00e+0 ;
5.7735026918962584e-1 5.7735026918962584e-1 -5.7735026918962584e-1 , ...
1.00e+0 ;
-5.7735026918962584e-1 -5.7735026918962584e-1 5.7735026918962584e-1 , ...
1.00e+0 ;
5.7735026918962584e-1 -5.7735026918962584e-1 5.7735026918962584e-1 , ...
1.00e+0 ;
-5.7735026918962584e-1 5.7735026918962584e-1 5.7735026918962584e-1 , ...
1.00e+0 ;
5.7735026918962584e-1 5.7735026918962584e-1 5.7735026918962584e-1 , ...
1.00e+0 ;
];%FEw
FEna = [ 4.9056261216234409e-1 1.3144585576580212e-1 3.5220810900864506e-2 , ...
1.3144585576580212e-1 1.3144585576580212e-1 3.5220810900864506e-2 , ...
9.4373878376559257e-3 3.5220810900864506e-2 ;
1.3144585576580212e-1 4.9056261216234409e-1 1.3144585576580212e-1 , ...
3.5220810900864506e-2 3.5220810900864506e-2 1.3144585576580212e-1 , ...
3.5220810900864506e-2 9.4373878376559257e-3 ;
1.3144585576580212e-1 3.5220810900864506e-2 1.3144585576580212e-1 , ...
4.9056261216234409e-1 3.5220810900864506e-2 9.4373878376559257e-3 , ...
3.5220810900864506e-2 1.3144585576580212e-1 ;
3.5220810900864506e-2 1.3144585576580212e-1 4.9056261216234409e-1 , ...
1.3144585576580212e-1 9.4373878376559257e-3 3.5220810900864506e-2 , ...
1.3144585576580212e-1 3.5220810900864506e-2 ;
1.3144585576580212e-1 3.5220810900864506e-2 9.4373878376559257e-3 , ...
3.5220810900864506e-2 4.9056261216234409e-1 1.3144585576580212e-1 , ...
3.5220810900864506e-2 1.3144585576580212e-1 ;
3.5220810900864506e-2 1.3144585576580212e-1 3.5220810900864506e-2 , ...
9.4373878376559257e-3 1.3144585576580212e-1 4.9056261216234409e-1 , ...
1.3144585576580212e-1 3.5220810900864506e-2 ;
3.5220810900864506e-2 9.4373878376559257e-3 3.5220810900864506e-2 , ...
1.3144585576580212e-1 1.3144585576580212e-1 3.5220810900864506e-2 , ...
1.3144585576580212e-1 4.9056261216234409e-1 ;
9.4373878376559257e-3 3.5220810900864506e-2 1.3144585576580212e-1 , ...
3.5220810900864506e-2 3.5220810900864506e-2 1.3144585576580212e-1 , ...
4.9056261216234409e-1 1.3144585576580212e-1 ;
];%FEna
FEnar = [ -3.1100423396407312e-1 3.1100423396407312e-1 8.3333333333333315e-2 , ...
-8.3333333333333315e-2 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
2.2329099369260218e-2 -2.2329099369260218e-2 ;
-3.1100423396407312e-1 3.1100423396407312e-1 8.3333333333333315e-2 , ...
-8.3333333333333315e-2 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
2.2329099369260218e-2 -2.2329099369260218e-2 ;
-8.3333333333333315e-2 8.3333333333333315e-2 3.1100423396407312e-1 , ...
-3.1100423396407312e-1 -2.2329099369260218e-2 2.2329099369260218e-2 , ...
8.3333333333333315e-2 -8.3333333333333315e-2 ;
-8.3333333333333315e-2 8.3333333333333315e-2 3.1100423396407312e-1 , ...
-3.1100423396407312e-1 -2.2329099369260218e-2 2.2329099369260218e-2 , ...
8.3333333333333315e-2 -8.3333333333333315e-2 ;
-8.3333333333333315e-2 8.3333333333333315e-2 2.2329099369260218e-2 , ...
-2.2329099369260218e-2 -3.1100423396407312e-1 3.1100423396407312e-1 , ...
8.3333333333333315e-2 -8.3333333333333315e-2 ;
-8.3333333333333315e-2 8.3333333333333315e-2 2.2329099369260218e-2 , ...
-2.2329099369260218e-2 -3.1100423396407312e-1 3.1100423396407312e-1 , ...
8.3333333333333315e-2 -8.3333333333333315e-2 ;
-2.2329099369260218e-2 2.2329099369260218e-2 8.3333333333333315e-2 , ...
-8.3333333333333315e-2 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
3.1100423396407312e-1 -3.1100423396407312e-1 ;
-2.2329099369260218e-2 2.2329099369260218e-2 8.3333333333333315e-2 , ...
-8.3333333333333315e-2 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
3.1100423396407312e-1 -3.1100423396407312e-1 ;
];%FEnar
FEnas = [ -3.1100423396407312e-1 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
3.1100423396407312e-1 -8.3333333333333315e-2 -2.2329099369260218e-2 , ...
2.2329099369260218e-2 8.3333333333333315e-2 ;
-8.3333333333333315e-2 -3.1100423396407312e-1 3.1100423396407312e-1 , ...
8.3333333333333315e-2 -2.2329099369260218e-2 -8.3333333333333315e-2 , ...
8.3333333333333315e-2 2.2329099369260218e-2 ;
-3.1100423396407312e-1 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
3.1100423396407312e-1 -8.3333333333333315e-2 -2.2329099369260218e-2 , ...
2.2329099369260218e-2 8.3333333333333315e-2 ;
-8.3333333333333315e-2 -3.1100423396407312e-1 3.1100423396407312e-1 , ...
8.3333333333333315e-2 -2.2329099369260218e-2 -8.3333333333333315e-2 , ...
8.3333333333333315e-2 2.2329099369260218e-2 ;
-8.3333333333333315e-2 -2.2329099369260218e-2 2.2329099369260218e-2 , ...
8.3333333333333315e-2 -3.1100423396407312e-1 -8.3333333333333315e-2 , ...
8.3333333333333315e-2 3.1100423396407312e-1 ;
-2.2329099369260218e-2 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
2.2329099369260218e-2 -8.3333333333333315e-2 -3.1100423396407312e-1 , ...
3.1100423396407312e-1 8.3333333333333315e-2 ;
-8.3333333333333315e-2 -2.2329099369260218e-2 2.2329099369260218e-2 , ...
8.3333333333333315e-2 -3.1100423396407312e-1 -8.3333333333333315e-2 , ...
8.3333333333333315e-2 3.1100423396407312e-1 ;
-2.2329099369260218e-2 -8.3333333333333315e-2 8.3333333333333315e-2 , ...
2.2329099369260218e-2 -8.3333333333333315e-2 -3.1100423396407312e-1 , ...
3.1100423396407312e-1 8.3333333333333315e-2 ;
];%FEnas
FEnat = [ -3.1100423396407312e-1 -8.3333333333333315e-2 -2.2329099369260218e-2 , ...
-8.3333333333333315e-2 3.1100423396407312e-1 8.3333333333333315e-2 , ...
2.2329099369260218e-2 8.3333333333333315e-2 ;
-8.3333333333333315e-2 -3.1100423396407312e-1 -8.3333333333333315e-2 , ...
-2.2329099369260218e-2 8.3333333333333315e-2 3.1100423396407312e-1 , ...
8.3333333333333315e-2 2.2329099369260218e-2 ;
-8.3333333333333315e-2 -2.2329099369260218e-2 -8.3333333333333315e-2 , ...
-3.1100423396407312e-1 8.3333333333333315e-2 2.2329099369260218e-2 , ...
8.3333333333333315e-2 3.1100423396407312e-1 ;
-2.2329099369260218e-2 -8.3333333333333315e-2 -3.1100423396407312e-1 , ...
-8.3333333333333315e-2 2.2329099369260218e-2 8.3333333333333315e-2 , ...
3.1100423396407312e-1 8.3333333333333315e-2 ;
-3.1100423396407312e-1 -8.3333333333333315e-2 -2.2329099369260218e-2 , ...
-8.3333333333333315e-2 3.1100423396407312e-1 8.3333333333333315e-2 , ...
2.2329099369260218e-2 8.3333333333333315e-2 ;
-8.3333333333333315e-2 -3.1100423396407312e-1 -8.3333333333333315e-2 , ...
-2.2329099369260218e-2 8.3333333333333315e-2 3.1100423396407312e-1 , ...
8.3333333333333315e-2 2.2329099369260218e-2 ;
-8.3333333333333315e-2 -2.2329099369260218e-2 -8.3333333333333315e-2 , ...
-3.1100423396407312e-1 8.3333333333333315e-2 2.2329099369260218e-2 , ...
8.3333333333333315e-2 3.1100423396407312e-1 ;
-2.2329099369260218e-2 -8.3333333333333315e-2 -3.1100423396407312e-1 , ...
-8.3333333333333315e-2 2.2329099369260218e-2 8.3333333333333315e-2 , ...
3.1100423396407312e-1 8.3333333333333315e-2 ;
];%FEnat
