function [idof,k,m]=mass1(node,elt,pe,ie,opt)

%MASS1  concentrated diagonal mass element
%
%	As all element functions (see ELEM0), MASS1 is called by FE_MK for
%	model assembly, FEPLOT for structural deformation visualization, ...
%
%	In an model description matrix a group of MASS1 elements starts with a
%	header row [Inf  abs('mass1') 0 ...] followed by element property rows
%       ELT following the format
%	    [n mxx myy mzz ixx iyy izz EltId]
%         with
%	   n      node number for the concentrated mass
%	   mxx myy mzz ixx iyy izz, the concentrated mass is associated to the
%	          DOFs .01 to .06 (xyz translations/rotations) of the conside-
%		  node and given by diag([mxx myy mzz ixx iyy izz])
%
%       PL,IL no material or section properties used by this element
%
%	See also help bar1, beam1, ...
%                doc  eltfun

%	Etienne Balmes   10/10/90, 07/24/99
%       Copyright (c) 2001-2002 by INRIA and SDTools
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       All Rights Reserved.

if nargin==1 & comstr(node,'cvs')
 idof='$Revision: 1.9 $  $Date: 2006/01/27 14:28:50 $'; return;
end
% standard calls with one input argument
if ischar(node)
 [CAM,Cam]=comstr(node,1);
 if comstr(Cam,'integinfo')

   idof=[];k=[];m=[];

 elseif comstr(node,'matcall'); idof=mass1('call');k=0;
 elseif comstr(node,'call')
   idof = ['if opt(1)==0; k1 = zeros(6,6);m1=diag(elt(cEGI(jElt),2:7));elseif opt(1)==2; k1=diag(elt(cEGI(jElt),2:7));else k1=zeros(6);m1=zeros(6); end'];
 elseif  comstr(Cam,'groupinit');  idof = '';
 elseif  comstr(node,'node');   idof = [1];
 elseif  comstr(node,'prop');   idof = [0 0 8];
 elseif  comstr(node,'dof');    idof=1+[1:6]'/100;
 elseif  comstr(node,'line');   idof  = [1];
 elseif  comstr(node,'patch');  idof = [1];
 elseif  comstr(node,'edge');   idof  = [];
 elseif  comstr(node,'face');   idof = [];
 elseif comstr(node,'sci_face'); idof = [1 1 1];
 elseif  comstr(node,'parent'); idof = 'mass1';
 end
return
end % of standard calls with one input argument

% element matrix assembly - - - - - - - - - - - - - - - - - - - - - - - - - -

k=zeros(6,6);idof=[1:6]'/100+elt(1,1);

if     opt(1)==0; k=zeros(6,6); m = diag(elt(1,2:7));
elseif opt(1)==2; k=diag(elt(1,2:7)); 
elseif opt(1)==1; idof=[];m=[];k=[];
else error('not a valid type of call')
end

