function [idof,k,m]=mass2(node,elt,pe,ie,opt)

%MASS2  concentrated mass element with offset
%
%	As all element functions (see ELEM0), MASS2 is called by FE_MK for
%	model assembly, FEPLOT for structural deformation visualization, ...
%
%	In an model description matrix a group of MASS1 elements starts with a
%	header row [Inf  abs('mass2') 0 ...] followed by element property rows
%       ELT following the format
%	    [n1 M I11 I21 I22 I31 I32 I33 EltID CID X1 X2 X3 MatId ProId]
%
%       PL,IL no material or section properties used by this element
%
%	See also help mass1, bar1, beam1, ...
%                doc  eltfun

%	Etienne Balmes
%       Copyright (c) 2001-2005 by INRIA and SDTools, All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if nargin==1 & comstr(node,'cvs')
 idof='$Revision: 1.12 $  $Date: 2006/01/27 14:28:50 $'; return;
end
% standard calls with one input argument
if ischar(node)
 [CAM,Cam]=comstr(node,1);
 if comstr(Cam,'integinfo')

   idof=[];k=[];m=[];

 elseif      comstr(node,'call')
   idof=['[i1,k1,m1] = mass2(node(NNode(elt(cEGI(jElt),1)),:),elt(cEGI(jElt),:),pl,il,[opt(1) jGroup jElt]);'];
 elseif  comstr(Cam,'groupinit');   idof = '';
 elseif  comstr(node,'node');   idof = [1];
 elseif  comstr(node,'prop');   idof = [14 15 9];
 elseif  comstr(node,'dof');    idof=1+[1:6]'/100;
 elseif  comstr(node,'line');   idof  = [1];
 elseif  comstr(node,'patch');  idof = [1];
 elseif comstr(node,'sci_face'); idof = [1 1 1];
 elseif  comstr(node,'parent'); idof = 'mass1';
 end
return
end % of standard calls with one input argument

% element matrix assembly - - - - - - - - - - - - - - - - - - - - - - - - - -

k=zeros(6,6);idof=[1:6]'/100+elt(1,1);
if elt(10)>0;
 bas=evalin('caller','bas');
 bas=bas(find(bas(:,1)==elt(10)),:);
 if bas(3)~=0; 
  error('Bases should be defined in absolute reference, this is a bug');
 end
else;bas=[];
end

if     opt(1)==0; k=zeros(6,6);  m=offset(node,elt,bas);
elseif opt(1)==2;  k=offset(node,elt,bas); m=[];
elseif opt(1)==1; idof=[];m=[];k=zeros(6,6);
else error('not a valid type of call')
end

% ----------------------------------------------------------------
function m = offset(node,elt,bas); 

  elt(16)=0; 
  r1=elt(1:8);r1([4 6 7])=-r1([4 6 7]);
  m = sparse([1 2 3 4 5 6 4 5 6 4 5 6],[1 2 3 4 4 4 5 5 5 6 6 6], ...
             r1([2 2 2 3 4 6 4 5 7 6 7 8]));
  if any(elt(11:13))
      x=elt(11:13); if ~isempty(bas)
       error('Local basis not implemented, please contribute an example to openfem@sdtools.com');
      end
      r = [0 x(3) -x(2) ;-x(3) 0 x(1);x(2) -x(1) 0];
      r = sparse([eye(3,3) r;zeros(3,3) eye(3,3)]);
      m=r'*m*r;
   end
