/*
 Etienne Balmes, Jean Michel Leclere
 $Revision: 1.2 $  $Date: 2005/11/24 14:23:05 $
*/
/*----------------------------------------------------------- LinInterp */
void of_time_LinInterp(double* table, double * val, double* last,
		       double* out, int M, int Nc, int Npoints, int nlhs) {

     int i1, j1, j2, flag;
     double s;


  for (j2=0; j2<Npoints; j2++) { /* loop on points */
    /* search */
   i1=(int)(last[0]); flag=0;
   while (1) {
      if (i1>=M-1) { /* in the last interval */
        i1=M-1; if (val[j2]<table[i1-1]) i1--; else break; 
      } else if (val[j2]>table[i1+1]) { i1++; /* need to move right*/
      } else if  (i1<=0) { /* in the first interval */
	if (val[j2]>table[1]) i1=1; else {i1=0;break;} 
      } else if (val[j2]<table[i1]) i1--;   /* need to move left*/
      else break;
   }
   last[0]=i1; last[1]=val[0];
   if (Nc==0&&nlhs) out[j2]=i1+1;
  
   /* linear interpolation */
   /* outputs */
   if (nlhs>0) {
    if (i1==M-1) i1--;
    /* mexPrintf(" %.5g , %.5g %.5g\n",table[i1+1],table[i1],val[j2]);*/
    s = (val[j2]-table[i1]) / (table[i1+1]-table[i1]);
    last[2]=s;
    for (j1=0; j1<Nc; j1++) { /* loop on curves */
     out[j1*Npoints+j2] = (1-s)*table[i1+(j1+1)*M] + s*table[i1+1+(j1+1)*M];
    } 
   }
  } /* j2 points to interpolate */
}
