#include "mex.h" 
#include <math.h>

/*  Etienne Balmes, Jean Michel Leclere, Robert Cimrman */
/*  Claire Delforge                                     */

#ifndef int32
#define int32 int
#endif

mxArray* subs_cvs_sputil () {
 mxArray *st;
 st= mxCreateString("$Revision: 1.12 $  $Date: 2006/01/19 14:38:48 $");
 return(st);
}

/* OBSOLETE : DO NOT MAINTAIN          ------------------------------*/
/*            calculate X'*K*X                                       */
/*            X is a 3x3 block                                       */
/* ------------------------------------------------------------------*/
void x_k_x (const double* x, const double* y, double* result, 
  double* offset, int type, int YM,int YN) { 

  int             j1, j2, jOff;   
  double          *K1, *cof;
    
  K1 = mxCalloc (YM*YN, sizeof(double));      /* memory allocation for z1 */

  if (type!=2) { /* Right multiplication */
    jOff=0;cof=offset; j2=0;while (j2+2<YN) { /* loop on columns */
    for (j1=0;j1<YM;j1++) {
       K1[j1+j2*YM]=
         y[j1+j2*YM]*x[0]+y[j1+(j2+1)*YM]*x[1]+y[j1+(j2+2)*YM]*x[2];
       K1[j1+(j2+1)*YM]=
         y[j1+j2*YM]*x[3]+y[j1+(j2+1)*YM]*x[4]+y[j1+(j2+2)*YM]*x[5];
       K1[j1+(j2+2)*YM]=
         y[j1+j2*YM]*x[6]+y[j1+(j2+1)*YM]*x[7]+y[j1+(j2+2)*YM]*x[8];
    }
    j2+=3;jOff+=3;
    if (jOff==6 && offset!=NULL) {/*account for rigid link defined by offset*/
     for (j1=0;j1<YM;j1++) {
       K1[j1+(j2-3)*YM]-=cof[2]*K1[j1+(j2-5)*YM];
       K1[j1+(j2-3)*YM]+=cof[1]*K1[j1+(j2-4)*YM];
       K1[j1+(j2-2)*YM]+=cof[2]*K1[j1+(j2-6)*YM];
       K1[j1+(j2-2)*YM]-=cof[0]*K1[j1+(j2-4)*YM];
       K1[j1+(j2-1)*YM]-=cof[1]*K1[j1+(j2-6)*YM];
       K1[j1+(j2-1)*YM]+=cof[0]*K1[j1+(j2-5)*YM];
     }
      jOff=0;cof+=3;
    } /*offset*/
    }
  } else {memcpy(K1,y,YM*YN*sizeof(double));} /* right multiplication */

  if (type!=1) { /* Left multiplication */
    jOff=0;cof=offset; j1=0;while (j1+2<YM) { /* loop on columns */
    for (j2=0;j2<YN;j2++) {
       result[j1+j2*YM]=
         K1[j1+j2*YM]*x[0]+K1[j1+1+j2*YM]*x[1]+K1[j1+2+j2*YM]*x[2];
       result[j1+1+j2*YM]=
         K1[j1+j2*YM]*x[3]+K1[j1+1+j2*YM]*x[4]+K1[j1+2+j2*YM]*x[5];
       result[j1+2+j2*YM]=
         K1[j1+j2*YM]*x[6]+K1[j1+1+j2*YM]*x[7]+K1[j1+2+j2*YM]*x[8];
    }
    j1+=3;jOff+=3;
    if (jOff==6 && offset!=NULL) {/*account for rigid link defined by offset*/
     for (j2=0;j2<YN;j2++) {
       result[j1-3+j2*YM]-=cof[2]*result[j1-5+j2*YM];
       result[j1-3+j2*YM]+=cof[1]*result[j1-4+j2*YM];
       result[j1-2+j2*YM]+=cof[2]*result[j1-6+j2*YM];
       result[j1-2+j2*YM]-=cof[0]*result[j1-4+j2*YM];
       result[j1-1+j2*YM]-=cof[1]*result[j1-6+j2*YM];
       result[j1-1+j2*YM]+=cof[0]*result[j1-5+j2*YM];
     }
      jOff=0;cof+=3;
    } /*offset*/
    }
  } else {memcpy(result,K1,YM*YN*sizeof(double));} /* left multiplication */

  mxFree (K1);                                    /* desallocate k1 */
}

/* ------------------------------------------------------------------*/
/*            calculate basis z, input are 2 vectors x and y         */
/*            z is a 3x3 matrix                                      */
/* ------------------------------------------------------------------*/
void basis (const double* x, const double* y, double* z) { 

  double r1, r2, eps=1.e-16, r3;
  int        j1, j2, j3;

  r1=0.; for (j1=0;j1<3;j1++) r1+=x[j1]*x[j1];       /* x=x/sqrt(x'*x); */
  r3=r1;
  if (r1<eps) { z[0]=1.; z[1]=0.; z[2]=0.; r3=1.; }
  else {r1=sqrt(r1); z[0]=x[0]/r1; z[1]=x[1]/r1; z[2]=x[2]/r1;}
  r1=0.; for (j2=0;j2<3;j2++) r1+=z[j2]*y[j2];       /* y=y-(x'*y)*x; */
  for (j1=0;j1<3;j1++) z[j1+3]=y[j1]-r1*z[j1];

  r2=0.; for (j1=3;j1<6;j1++) r2+=z[j1]*z[j1]; /* r2=norm(y) */
  if (r2<eps*r3) {
    j1=0; j3=0;  r1=fabs(z[0]);r2=fabs(z[0]);
    while (j1<3) {                                   /* [y,i1]=min(abs(x)); */
      if (r2<r1) { r1=r2; j3=j1; }
      j1++;r2=fabs(z[j1]);
    } /* determine j3 */

    for (j1=3;j1<6;j1++) z[j1]=0.;                   /* y=zeros(3,1);    */
    z[j3+3]=1.;                                      /* y(i1(1))=1;      */

    r1=0.; for (j2=0;j2<3;j2++) r1+=z[j2]*z[j2+3];   /* y=y-(x'*y)*x;    */
    for (j1=0;j1<3;j1++)  z[j1+3]-=r1*z[j1];
    r2=0.; for (j1=3;j1<6;j1++) r2+=z[j1]*z[j1]; 

  } /* if */


  r2=sqrt(r2);   
  z[3]=z[3]/r2;z[4]=z[4]/r2;z[5]=z[5]/r2; /* y=y/sqrt(y'*y); */
  /* z=-[y(2)*x(3)-y(3)*x(2);y(3)*x(1)-y(1)*x(3);y(1)*x(2)-y(2)*x(1)]; */
  z[6]= -z[4]*z[2]+z[5]*z[1];
  z[7]= -z[5]*z[0]+z[3]*z[2];
  z[8]= -z[3]*z[1]+z[4]*z[0];

}
/* ------------------------------------------------------------------*/
/*            basis for T3                                           */
/*                                                                   */
/* ------------------------------------------------------------------*/
void basisT3 (const double* x, const int Nelt, int* Elt, double* x1) { 

 double     r1, r2, node[9], eps=1.e-16;
 double     *y1, *z1;
 int        jElt, jNode, j1, j2, j3;

 y1=x1+3; z1=x1+6;
 
 for (jElt=0;jElt<Nelt;jElt++) {

   for (jNode=0;jNode<3;jNode++) {  /* node => tmp */
     for (j1=0;j1<3;j1++) node[3*jNode+j1] = x[ 3*(Elt[3*jElt+jNode]-1)+j1 ];
   }

   r1=0.; for (j1=0;j1<3;j1++) r1+=node[j1]*node[j1]; 
   if (r1<eps) { x1[9*jElt+0]=1.; x1[9*jElt+1]=0.; x1[9*jElt+2]=0.;  }
   else { /* x=x/sqrt(x'*x); */
    r1=sqrt(r1); for (j1=0;j1<3;j1++) { x1[9*jElt+j1]=node[j1]/r1; } 
   }

   r1=0.; for (j2=0;j2<3;j2++) r1+=node[j2]*node[3+j2];  /* y=y-(x'*y)*x; */
   for (j1=0;j1<3;j1++) y1[9*jElt+j1]=node[3+j1]-r1*x1[9*jElt+j1];
   r2=0.; for (j1=0;j1<3;j1++) r2+=y1[9*jElt+j1]*y1[9*jElt+j1]; /* r2=norm(y) */

   if (r2<eps) {
     j1=0; j3=0;  r1=fabs(z1[9*jElt]);
     while (j1<3) {                                   /* [y,i1]=min(abs(x)); */
       j1++; r2=fabs(x1[9*jElt+j1]);
       if (r2<r1) { r1=r2; j3=j1; }
     } /* determine j3 */
     for (j1=0;j1<3;j1++) y1[9*jElt+j1]=0.;            /* y=zeros(3,1);    */
     y1[9*jElt+j3]=1.;                                 /* y(i1(1))=1;      */
     r1=0.; for (j2=0;j2<3;j2++) r1+=node[j2]*node[3+j2];  /* y=y-(x'*y)*x; */
     for (j1=0;j1<3;j1++) y1[9*jElt+j1]=node[3+j1]-r1*x1[9*jElt+j1];
     r2=0.; for (j1=0;j1<3;j1++) r2+=y1[9*jElt+j1]*y1[9*jElt+j1]; /* r2=norm(y) */
   } /* if */
   r2=sqrt(r2);   
   for (j1=0;j1<3;j1++) { y1[9*jElt+j1]=y1[9*jElt+j1]/r2; }/* y=y/sqrt(y'*y); */
   /* z=-[y(2)*x(3)-y(3)*x(2);y(3)*x(1)-y(1)*x(3);y(1)*x(2)-y(2)*x(1)]; */
   z1[9*jElt+0]= -x1[9*jElt+4]*x1[9*jElt+2] + x1[9*jElt+5]*x1[9*jElt+1];
   z1[9*jElt+1]= -x1[9*jElt+5]*x1[9*jElt+0] + x1[9*jElt+3]*x1[9*jElt+2];
   z1[9*jElt+2]= -x1[9*jElt+3]*x1[9*jElt+1] + x1[9*jElt+4]*x1[9*jElt+0];
 } /* jElt */
}
/* ------------------------------------------------------------------*/
/*            basis for Q4                                           */
/*                                                                   */
/* ------------------------------------------------------------------*/
void basisQ4 (const double* x, const int Nelt, int32 *Elt, double *x1,
              double *X, double *out3    ) { 

 double     r1, node[12];
 double     *y1, *z1, out2[3];
 int        jElt, jNode, j1, j2, j3;

 y1=x1+3; z1=x1+6;
 
 for (jElt=0;jElt<Nelt;jElt++) {

   for (jNode=0;jNode<4;jNode++) {  /* node => tmp */
     for (j1=0;j1<3;j1++) node[3*jNode+j1] = x[ 3*(Elt[4*jElt+jNode]-1)+j1 ];
   }
   for (j1=0;j1<3;j1++) { /* out2 = mean(x); */
     out2[j1]=0.; for (j2=0;j2<4;j2++) out2[j1]+=node[3*j2+j1]/4.;
   }
   for (j1=0;j1<3;j1++) { /* node = x(1:4,:)-out2(ones(4,1),:); */
     r1=out2[j1]; 
     for (j2=0;j2<4;j2++)  node[3*j2+j1]=x[3*(Elt[4*jElt+j2]-1)+j1]-r1;
   }
   /* x = node(3,:)-node(1,:); x=x/sqrt(x*x'); */
   for (j1=0;j1<3;j1++) { x1[9*jElt+j1]=node[6+j1]-node[j1];  }
   r1=0.; for (j1=0;j1<3;j1++) r1+=x1[9*jElt+j1]*x1[9*jElt+j1]; 
   for (j1=0;j1<3;j1++) { x1[9*jElt+j1]/=sqrt(r1); }
   /* y = node(4,:)-node(2,:); y=y/sqrt(y*y'); */
   for (j1=0;j1<3;j1++) { y1[9*jElt+j1]=node[9+j1]-node[3+j1]; }
   r1=0.; for (j1=0;j1<3;j1++) r1+=y1[9*jElt+j1]*y1[9*jElt+j1]; 
   for (j1=0;j1<3;j1++) { y1[9*jElt+j1]/=sqrt(r1); }
   /* x = x-y; x=x'/sqrt(x*x'); */
   for (j1=0;j1<3;j1++) x1[9*jElt+j1]-=y1[9*jElt+j1];
   r1=0.; for (j1=0;j1<3;j1++) r1+=x1[9*jElt+j1]*x1[9*jElt+j1]; 
   for (j1=0;j1<3;j1++) { x1[9*jElt+j1]/=sqrt(r1); }
   /* y=y';y=y-(x'*y)*x; y=y/sqrt(y'*y); */
   r1=0.; for (j1=0;j1<3;j1++) r1+=x1[9*jElt+j1]*y1[9*jElt+j1];
   for (j1=0;j1<3;j1++) y1[9*jElt+j1]-=r1*x1[9*jElt+j1];
   r1=0.; for (j1=0;j1<3;j1++) r1+=y1[9*jElt+j1]*y1[9*jElt+j1]; 
   for (j1=0;j1<3;j1++) { y1[9*jElt+j1]/=sqrt(r1);  }
   /* z=-[y(2)*x(3)-y(3)*x(2);  y(3)*x(1)-y(1)*x(3);  y(1)*x(2)-y(2)*x(1)]; */
   z1[9*jElt+0] = -y1[9*jElt+1]*x1[9*jElt+2] + y1[9*jElt+2]*x1[9*jElt+1];
   z1[9*jElt+1] = -y1[9*jElt+2]*x1[9*jElt+0] + y1[9*jElt+0]*x1[9*jElt+2];
   z1[9*jElt+2] = -y1[9*jElt+0]*x1[9*jElt+1] + y1[9*jElt+1]*x1[9*jElt+0];

 } /* jElt */

  if (X!=NULL) { /* X=node*p; */
   for (j1=0;j1<12;j1++) X[j1]=0.;

   for (j2=0;j2<4;j2++) {   
    for (j3=0;j3<3;j3++) {
      X[j2]   += node[3*j2+j3]*x1[j3]; 
      X[4+j2] += node[3*j2+j3]*y1[j3]; 
      X[8+j2] += node[3*j2+j3]*z1[j3];    
      /*      X[j2]   += node[j2+4*j3]*x1[j3]; 
      X[4+j2] += node[j2+4*j3]*y1[j3]; 
      X[8+j2] += node[j2+4*j3]*z1[j3];    */
    }   
   } 

  } /* X */
  if (out3!=NULL) {  for (j1=0;j1<3;j1++)  out3[j1]=out2[j1];   }


} /* end basisQ4 */
