function out=ofutil(varargin);

% OpenFEM developper utilities
%
% Accepted commands are
%
%  Path     : checks path consistency with possible removal of SDT
%  mexall   : compiles all needed DLL on UNIX and all C-mex files on Windows
%             On windows, run mex('-setup') and ofutil('of_mk') for Fortran mex
%  of_mk    : compiles of_mk.c (see openfem/mex directory)
%  nopo2sd  : compiles nopo2sd.c (located in openfem/mex directory)
%  sp_util  : compiles sp_ufil.c
%  zip      : creates a zip archive of the OpenFEM library 
%  hevea    : generates documentation with HEVEA
%  latex    : generates documentation with LaTeX
%   You may need to adjust the following preferences
%   setpref('OpenFEM','TexPath',fullfile(fileparts(which('ofutil')),'tex'))
%   setpref('OpenFEM','LatexFcn','!pdflatex')
%
%  validate : validate compatibility with SciLab
%
% HP-UX start MATAB R13 : setenv LD_PRELOAD /usr/lib/libF90.sl;matlab

%

%	E. Balmes, F. Genot, ...
%       Copyright (c) 2001-2005 by INRIA and SDTools,All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license
%       Use ofutil('cvs') for revision information

[CAM,Cam]=comstR(varargin{1},1);


%Path Target verifications

Hom=fileparts(which('ofutil')); 

assignin('base','Hom',Hom);
if ~ispref('OpenFEM','TexPath') 
 setpref('OpenFEM','TexPath',fullfile(fileparts([Hom '.tex']),'tex'));
end
if ~ispref('OpenFEM','LatexFcn') 
 setpref('OpenFEM','LatexFcn','!pdflatex ')
end


% ---------------------------------------------------------------
if comstR(Cam,'cvs')

 out='$Revision: 1.80 $  $Date: 2006/05/16 15:06:39 $';

% ---------------------------------------------------------------
elseif comstR(Cam,'cd') [CAM,Cam]=comstR(CAM,3);

if comstR(Cam,'tex') cd(getpref('OpenFEM','TexPath'));
elseif comstR(Cam,'h') cd(Hom);
end

% ---------------------------------------------------------------
elseif comstR(Cam,'cleana64')

pw0=pwd;
cd(fullfile(fileparts(which('ofutil')),'src'));
a=dir('*.c');
for j1=1:length(a)
 fid=fopen(a(j1).name);st=fscanf(fid,'%c');fclose(fid);
 st=strrep(st,'integer ','int ');
 fid=fopen(a(j1).name,'w');fprintf(fid,'%c',st);fclose(fid);
end
cd(fullfile(fileparts(which('ofutil')),'mex'));
a=dir('*.c');
for j1=1:length(a)
 fid=fopen(a(j1).name);st=fscanf(fid,'%c');fclose(fid);
 st=strrep(st,'integer ','int ');
 fid=fopen(a(j1).name,'w');fprintf(fid,'%c',st);fclose(fid);
end
cd(pw0);

% ---------------------------------------------------------------
elseif comstR(Cam,'of_mk') % Revised version where FORTRAN is converted with F2C

if strcmp(mexext,'mexa64'); ofutil('cleana64');end

if 1==2
 a=dir('*.c');
 for j1=1:length(a);
  fid=fopen(a(j1).name,'r');st=fscanf(fid,'%c');fclose(fid);
  st=strrep(st,'integer ','int ');
  fid=fopen(a(j1).name,'w');fprintf(fid,'%c',st);fclose(fid);
 end

end

 objectfiles = {'tab0d.o' ,'tab1d.o' ,'tab2d.o' ,'taba0d.o' ,'taba1d.o' ,'taba2d.o' ,'taba6d.o' ,'taba8d.o' ,'tabaxd.o' ,'tabszd.o' ,'ab0d.o' ,'ab1d.o' ,'ab4d.o' ,'ab5d.o' ,'hookax.o' ,'plmasd.o' ,'plonad.o' ,'etr3p1d.o' ,'etm3p1d.o' ,'ets3p1d.o' ,'etc3p1d.o' ,'etr3q1d.o' ,'etm3q1d.o' ,'ets3q1d.o' ,'etc3q1d.o' ,'etm3q2c.o' ,'etr3q2c.o' ,'ets3q2c.o' ,'ec3c2c.o' ,'etc3q2c.o' ,'etr3r1d.o' ,'etm3r1d.o' ,'ets3r1d.o' ,'etc3r1d.o' ,'er3c2c.o' ,'em3c2c.o' ,'es3d2c.o' ,'es3c2c.o' ,'emaq2c.o' ,'dpaq2c.o' ,'etr3r2c.o' ,'etm3r2c.o' ,'ets3r2c.o' ,'etc3r2c.o' ,'etr3p2c.o' ,'etm3p2c.o' ,'ets3p2c.o' ,'etc3p2c.o' ,'fobase.o' ,'dcopy.o' ,'etm2p1d.o' ,'etr2p1d.o' ,'ets2p1d.o' ,'etc2p1d.o' ,'etm2p2c.o' ,'etr2p2c.o' ,'ets2p2c.o' ,'etc2p2c.o' ,'etm2q1d.o' ,'etr2q1d.o' ,'ets2q1d.o' ,'etc2q1d.o' ,'etm2q2c.o' ,'etr2q2c.o' ,'ets2q2c.o' ,'etc2q2c.o' ,'e1ap1d.o' ,'etrap1d.o' ,'etmap1d.o' ,'etsap1d.o' ,'etcap1d.o' ,'e2ap2c.o' ,'etrap2c.o' ,'etmap2c.o' ,'etsap2c.o' ,'etcap2c.o' ,'e1aq1c.o' ,'etmaq1d.o' ,'etraq1d.o' ,'etsaq1d.o' ,'etcaq1d.o' ,'e2aq2c.o' ,'etmaq2c.o' ,'etraq2c.o' ,'eraq2c.o' ,'etsaq2c.o' ,'etcaq2c.o' ,'etmdktp.o' ,'etrdktp.o' ,'etsdktp.o' ,'etcdktp.o' ,'etm5noe.o' ,'etr5noe.o' ,'ets5noe.o' ,'etc5noe.o' ,'etrmit4.o' ,'etsmit4.o' ,'bremit.o' ,'etsmitx.o' ,'inmit4.o' ,'mitlin.o' ,'fonmit.o' ,'melmit.o' ,'replo1.o' ,'pcq12d.o' ,'canoq1.o' ,'chan57mod.o','chan56.o' ,'ddot.o'};

if strcmp(mexext,'mexmac');
 objectfiles=setdiff(objectfiles,{'ddot.o','dcopy.o'});
end
if exist(fullfile(Hom,'src'),'dir');SrcWd=fullfile(Hom,'src');
else;SrcWd=fullfile(Hom,'..','src');
end

cd(SrcWd); a=dir('*.f');

% If the .c file does not exist create it with f2c
for j1=1:length(objectfiles)
 if ~exist(fullfile(SrcWd,[objectfiles{j1}(1:end-2) '.c']),'file')
   if isunix
            system(sprintf('f2c %s',[objectfiles{j1}(1:end-2) '.f']));
   else
            system(sprintf('c:/scilab/bin/f2c %s',[objectfiles{j1}(1:end-2) '.f']));
   end
 end
end

% If the .object file does not exist create it with mex
if isunix ext='.o'; else;ext='.obj';end

for j1=1:length(objectfiles)
 if ~exist(fullfile(SrcWd,[objectfiles{j1}(1:end-2) ext]),'file')
    mex('-c','-v',[objectfiles{j1}(1:end-2) '.c']);
 end
end
pw0=MexTarget(Hom);pw0=pwd; cd(SrcWd);

if isunix % This is for compilation on unix systems

 if ~isempty(strfind(SrcWd,'../src'))
   objectfiles2 = strcat(fullfile('..','..','src'),filesep,objectfiles);
 else
   objectfiles2 = strcat(fullfile('..','src'),filesep,objectfiles);
 end

  %if strfind(SrcWd,'../src')  
% st=sprintf('mex -v  -Isrc -DOSTYPE%s -DFORMATLAB of_mk.c %s %s %s\n!mv of_mk.%s %s',mexext,fullfile(SrcWd,'of_mk_subs.c'),sprintf('%s ',objectfiles2{:}),ofutil('blaslib'),mexext,pw0);
% On UNIX one is not supposed to need linking to BLASLIB
st=sprintf('mex -v  -Isrc -DOSTYPE%s -DFORMATLAB of_mk.c hyper.c visco_1.c cardio.c %s %s\n!mv of_mk.%s %s',mexext,fullfile(SrcWd,'of_mk_subs.c'),sprintf('%s ',objectfiles2{:}),mexext,pw0);

    cd(fullfile(Hom,'mex'));
   
else % Now for windows assuming that f2c is located in Scilab

% Compile of_mk.c (now in openfem/mex) and of_mk_subs.c LOCATED IN SRC

  objectfiles=strrep(objectfiles,'.o ','.obj ');

  if ~isempty(strfind(SrcWd,'../src'))|~isempty(strfind(SrcWd,'..\src'))
  st=sprintf('mex -v  -DOSTYPE%s -DFORMATLAB ../openfem/mex/of_mk.c ../src/of_mk_subs.c ../mex/hyper.c %s %s\n!mv of_mk.dll %s',mexext,sprintf('%sbj ',objectfiles{:}),ofutil('blaslib'),pw0);

  else
   cd(SrcWd)
 st=sprintf('mex -outdir %s -v -DFORMATLAB ../mex/of_mk.c of_mk_subs.c ../mex/hyper.c %s %s',pw0,sprintf('%sbj ',objectfiles{:}),ofutil('blaslib'));

  end

end
clear of_mk;assignin('base','st',st); evalin('base','eval(st)');
MexTarget(Hom);
which('of_mk'); of_mk('cvs');disp(ans(:,2))

% ---------------------------------------------------------------
elseif comstR(Cam,'of_mk_old') 

pw0=MexTarget(Hom);
clear functions

st={'-v'};
if ~isunix&exist('fortran_mexopts.bat') 
 % allow for a local  fortran options file
 st={'-f' 'fortran_mexopts.bat' st{:}};
end

% modification of FLIBS options to allow compiling with MATLAB R13
if strcmp(mexext,'mexhpux')  

  mex(st{:},sprintf('-I%s',fullfile(Hom,'..','src')),'FFLAGS=+Z +DA2.0','FLIBS=-L/tmp_mnt/opt/matlab/bin/hpux -lmx -lmex -lmat -lm -lm -L/opt/fortran90/lib/pa2.0 -lcl -lc -lisamstub',fullfile(Hom,'mex','of_mk.f'));

elseif strcmp(mexext,'mexsg')|strcmp(mexext,'mexmac')
  mex(st{:},sprintf('-I%s ',fullfile(Hom,'..','src')), ...
         fullfile(Hom,'mex','of_mk.f'));

elseif isunix
    objectfiles = {'tab0d.o' ,'tab1d.o' ,'tab2d.o' ,'taba0d.o' ,'taba1d.o' ,'taba2d.o' ,'taba6d.o' ,'taba8d.o' ,'tabaxd.o' ,'tabszd.o' ,'ab0d.o' ,'ab1d.o' ,'ab4d.o' ,'ab5d.o' ,'hookax.o' ,'plmasd.o' ,'plonad.o' ,'etr3p1d.o' ,'etm3p1d.o' ,'ets3p1d.o' ,'etc3p1d.o' ,'etr3q1d.o' ,'etm3q1d.o' ,'ets3q1d.o' ,'etc3q1d.o' ,'etm3q2c.o' ,'etr3q2c.o' ,'ets3q2c.o' ,'ec3c2c.o' ,'etc3q2c.o' ,'etr3r1d.o' ,'etm3r1d.o' ,'ets3r1d.o' ,'etc3r1d.o' ,'er3c2c.o' ,'em3c2c.o' ,'es3d2c.o' ,'es3c2c.o' ,'emaq2c.o' ,'dpaq2c.o' ,'etr3r2c.o' ,'etm3r2c.o' ,'ets3r2c.o' ,'etc3r2c.o' ,'etr3p2c.o' ,'etm3p2c.o' ,'ets3p2c.o' ,'etc3p2c.o' ,'fobase.o' ,'dcopy.o' ,'etm2p1d.o' ,'etr2p1d.o' ,'ets2p1d.o' ,'etc2p1d.o' ,'etm2p2c.o' ,'etr2p2c.o' ,'ets2p2c.o' ,'etc2p2c.o' ,'etm2q1d.o' ,'etr2q1d.o' ,'ets2q1d.o' ,'etc2q1d.o' ,'etm2q2c.o' ,'etr2q2c.o' ,'ets2q2c.o' ,'etc2q2c.o' ,'e1ap1d.o' ,'etrap1d.o' ,'etmap1d.o' ,'etsap1d.o' ,'etcap1d.o' ,'e2ap2c.o' ,'etrap2c.o' ,'etmap2c.o' ,'etsap2c.o' ,'etcap2c.o' ,'e1aq1c.o' ,'etmaq1d.o' ,'etraq1d.o' ,'etsaq1d.o' ,'etcaq1d.o' ,'e2aq2c.o' ,'etmaq2c.o' ,'etraq2c.o' ,'eraq2c.o' ,'etsaq2c.o' ,'etcaq2c.o' ,'etmdktp.o' ,'etrdktp.o' ,'etsdktp.o' ,'etcdktp.o' ,'etm5noe.o' ,'etr5noe.o' ,'ets5noe.o' ,'etc5noe.o' ,'etrmit4.o' ,'etsmit4.o' ,'bremit.o' ,'etsmitx.o' ,'inmit4.o' ,'mitlin.o' ,'fonmit.o' ,'melmit.o' ,'replo1.o' ,'pcq12d.o' ,'canoq1.o' ,'chan56.o' ,'ddot.o','of_mk_subs.o'};
    cd(fullfile(Hom,'..','src'));
    for j1=1:length(objectfiles);
        mex('-c',[objectfiles{j1}(1:end-2) '.c']);
    end
    cd(fullfile(Hom,'sdt3'));
    objectfiles2 = strcat(fullfile(Hom,'..','src/'),objectfiles);
    mex('-v','-Isrc','-DFORMATLAB',fullfile(Hom,'mex','of_mk.c'), ...
     sprintf('%s ',objectfiles2{:})) 
    cd(Hom);   

else
 mex(st{:},sprintf('-I "%s"',fullfile(Hom,'..','src')), ...
         fullfile(Hom,'mex','of_mk.f'));
end

fprintf('\nof_mk.%s was created in : %s',mexext,pwd)

cd(pw0)

% ---------------------------------------------------------------
elseif comstR(Cam,'mexall')

st={'of_mk','nopo2sd','sp_util','of_time'};

for j1=1:length(st);
 pw0=MexTarget(Hom);
 try; ofutil(st{j1});
 catch;
  st1='--------------------------------------------------------';
  fprintf('%s\n%s\n%s\n Error with %s\n %s\n%s\n%s\n',st1,st1,st1,st{j1},st1,st1,st1);
 end
end

% ---------------------------------------------------------------
elseif comstR(Cam,'of_time')

pw0=MexTarget(Hom);
clear functions
mex('-v',fullfile(Hom,'mex','of_time.c'));
cd(pw0)
which('of_time');eval('of_time cvs');disp(ans(:,2))

% ---------------------------------------------------------------
elseif comstR(Cam,'of_celt')

pw0=MexTarget(Hom);
clear functions
mex('-v',fullfile(Hom,'mex','of_celt.c'));
cd(pw0)

% ---------------------------------------------------------------
elseif comstR(Cam,'nopo2sd')

pw0=MexTarget(Hom);
clear functions
mex('-v',fullfile(Hom,'mex','nopo2sd.c'));
cd(pw0)

if 1==2
 cd c:/balmes/sdt.old/openfem/test
 [nodes,elms]=readnopo('care','2D','v');
 [nodes,elms]=readnopo('q1','3D','v');
end

% ---------------------------------------------------------------
elseif comstR(Cam,'medit')

pw0=MexTarget(Hom);
clear functions
mex('-v',fullfile(Hom,'mex','write_mesh.c'));
mex('-v',fullfile(Hom,'mex','write_bb.c'));
cd(pw0)

% ---------------------------------------------------------------
elseif comstR(Cam,'sp_util')


pw0=MexTarget(Hom);
if exist('fe_caseg')~=2
 clear functions
 mex('-v','-DFORMATLAB',fullfile(Hom,'mex','sp_util.c'));
else
 warning('SDT provides it''s own version of sp_util, nothing DONE')
 return
end
cd(pw0)
which('sp_util');eval('sp_util cvs');disp(ans(:,2))

% ---------------------------------------------------------------
elseif comstR(Cam,'blaslib')

if ispref('OpenFEM','blaslib')
  out=getpref('OpenFEM','blaslib');
elseif ~isunix
 out=fullfile(matlabroot,'extern','lib','win32','microsoft', 'msvc60', ...
   'libmwlapack.lib');
else
 pw0=pwd;
 wd=fullfile(matlabroot,'bin');
 cd(wd); st=mexext;
 if strcmp(st,'mexglx')    
   wd=fullfile(matlabroot,'bin','glnx86','libmwlapack.so');
 elseif strcmp(st,'mexa64') 
   wd=fullfile(matlabroot,'bin','glnxa64','liblapack.so');
 elseif strcmp(st,'mexsg') 
   wd=fullfile(matlabroot,'bin','sgi','libmwlapack.so');
 elseif strcmp(st,'mexhp7') 
    wd=fullfile(matlabroot,'bin','hp700','libmwlapack.sl');
 elseif strcmp(st,'mexhpux') 
    wd=fullfile(matlabroot,'bin','hpux','libmwlapack.sl');
 elseif strcmp(st,'mexaxp') 
    wd=fullfile(matlabroot,'bin','axp','libmwlapack.so');
 elseif strcmp(st,'mexsol') 
    wd=fullfile(matlabroot,'bin','sol2','libmwlapack.so');
 elseif strcmp(st,'mexrs6') 
    wd=fullfile(matlabroot,'bin','ibm_rs','libmwlapack.a');
 elseif strcmp(st,'mexmac') 
    wd=fullfile(matlabroot,'bin','mac','libmwlapack.dylib');
 elseif strcmp(st,'mexw32') 
    wd=fullfile(matlabroot,'bin','mac','libmwlapack.dylib');
 end
 out=wd;
end
out=strcat('''',out,'''');

% ---------------------------------------------------------------
elseif comstR(Cam,'zip') [CAM,Cam]=comstR(CAM,4);

 pw0=pwd; cd(Hom); cd ..;

 if isunix cd(tempdir); st=pwd; 
 else; st='c:/tmp'; end

 if isempty(CAM)
   st0=fullfile(st,'of10b1.zip')
   delete(st0)
   st1=sprintf(['!zip -r %s openfem src tex html -x *~ *.el *.mex* *.dll ' ...
          '*.mtc* *.*aux *.log *.ilg *.*ind *.out *.blg'],st0);
   disp(st1);eval(st1)
 end

 cd(pw0);

% ---------------------------------------------------------------
elseif comstR(Cam,'validate') [CAM,Cam]=comstR(CAM,4);

if isunix Shell='unix'; else Shell='dos';end
pw0=pwd; 
cd(fileparts(which('ofutil')));

% Do not use persistent variables
[a,b]=feval(Shell,'grep persistent *.m */*.m');
if ~isempty(b)
 fprintf('----------------------------------------------------------\n');
 fprintf('persistent is used in :\n%s',b)
end

% Do not use evalin
[a,b]=feval(Shell,'grep evalin *.m */*.m');
if ~isempty(b)
 fprintf('----------------------------------------------------------\n');
  fprintf('evalin is used in :\n%s',b)
end

% Do not use the same function name more than once
[a,b]=feval(Shell,'grep function *.m sdt3/*.m @ofact/*.m');
ind=[0 find(b==10)];

st={}; 
for j1=1:length(ind)-1
 st1=b(ind(j1)+1:ind(j1+1)-1); if ~isempty(strfind(st1,'ofutil')) st1='';end
 st1=regexprep(st1,'(.*).m:','');
 i1=find(st1=='%'); if ~isempty(i1) st1(i1:end)='';end
 st1=strrep(st1,'_function','');
 st1=regexprep(st1,'''(.*)''','');
 if  isempty(strfind(st1,'function')) st1='';end
 st1=regexprep(st1,'%(.*)','');
 st1=regexprep(st1,'function \[(.*)\]=','');
 st1=regexprep(st1,'function (.*)=','');
 st1=regexprep(st1,'function','');
 st1=regexprep(st1,'\((.*)\)','');
 st1=regexprep(st1,';','');st1=comstR(st1,1);
 if ~isempty(st1) st{end+1}=st1;end 
end
fprintf('----------------------------------------------------------\n');
fprintf('Repeated functions called\n\n')
st=st(:); [st1,i1,i2]=unique(st);
i3=find(sparse(i2,1,1)>1);disp(char(st1(i3)));

% Do use second arg for : ones, zeros, eyes
%                         sum, cumsum, prod, cumprod
st3={'ones(', 'zeros(', 'eyes(', 'sum(', 'prod('};

for j2=1:length(st3)
 [a,b]=feval(Shell,['grep ' st3{j2} ' *.m sdt3/*.m @ofact/*.m']);
 ind=[0 find(b==10)];
 st={}; 
 for j1=1:length(ind)-1
  st1=b(ind(j1)+1:ind(j1+1)-1);
  st2=st1;
  st1=st1(strfind(st1,st3{j2})+length(st3{j2}):end);
  % if min(findstr(st1,'(')) < min(findstr(st1,')'))    
  %   st1([min(findstr(st1,'(')) min(findstr(st1,')')) ])='';
  % end
  if min(strfind(st1,')')) < min(strfind(st1,','))    
   st{end+1}=st2;
  end
 end % j1
 fprintf('----------------------------------------------------------\n');
 fprintf('Bad number of input arguments for function %s : \n',st3{j2});
 st=st(:);disp(char(st(:)));
end %j2

% Do not use a(end,..) or (...,end)
%xxx

%




cd(pw0);

% -----------------------------------------------------------------------
elseif comstR(Cam,'chmod') [CAM,Cam]=comstR(CAM,6);
 
 a=fileparts(which(strcat('of_mk.',mexext)));
 if isunix
  st=sprintf('!chmod a+rx %s',fullfile(a,'*.mex*'));
 else
  st=sprintf('!cacls "%s" /E /G "%%username%%:R"',fullfile(a,'*.dll'));
 end
 disp(st);
 eval(st);

% ---------------------------------------------------------------
elseif comstR(Cam,'path') [CAM,Cam]=comstR(CAM,5);


pw0=pwd;if isempty(CAM) & nargin==2 CAM=varargin{2};end
if ~isempty(CAM) cd(CAM);end
st=which('ofutil');[wd,st1]=fileparts(st);
try; eval('sdtcheck(''pathnone'');','');end

cd(wd);st = path; i1=strfind(st,[filesep 'sdt']);
i2 = [0 find(st==pathsep) length(st)+1];
for j1=1:length(i1)
  st1=st(i2(max(find(i2<i1(j1))))+1:i2(min(find(i2>i1(j1))))-1);
  if ~isempty(strfind(st1,path)) rmpath(st1); end
end

addpath(pwd);
st2={'demos','sdt3'}
for j1=1:length(st2)
 if ~isempty(strfind(st2{j1},'5.3'))
  if exist(st2{j1})==7&comstR(version,'5')
   st1=fullfile(pwd,st2{j1});addpath(st1);fprintf('%s\n',st1);
  end
 elseif ~isempty(strfind(st2{j1},'6.0'))
  if exist(st2{j1})==7&(comstR(version,'6')|comstR(version,'7')) % Matlab 6 7
    st1=fullfile(pwd,st2{j1});addpath(st1);fprintf('%s\n',st1);
  end
 elseif exist(st2{j1})==7
  st1=fullfile(pwd,st2{j1});addpath(st1);fprintf('%s\n',st1);
 end
end

cd(pw0);


% ---------------------------------------------------------------
elseif comstR(Cam,'latex')

pw0=pwd;cd(getpref('OpenFEM','TexPath',fullfile(fileparts(which('ofutil')),'tex')));

fprintf('Running latex manual in %s',pwd);
st=sprintf('%s manual',getpref('OpenFEM','LatexFcn','!pdflatex'));
eval(st);
try; eval('!makeindex manual');end
cd(pw0);

% ---------------------------------------------------------------
elseif comstR(Cam,'hevea')

pw0=pwd;cd(getpref('OpenFEM','TexPath'));

if exist('manual.bbl')
 copyfile manual.bbl man_hevea.bbl
end
eval('!hevea mathaccents.hva man_hevea.tex');

pw2=fullfile(fileparts([getpref('OpenFEM','TexPath') '.tex']),'html');
if ~exist(pw2) 
 error(['You must create this directory : ' pw2]);
end


fid=fopen('man_hevea.html','r'); st=fscanf(fid,'%c'); fclose(fid);
delete man_hevea.html
st=strrep(st,'NAME="#','NAME="');
st=strrep(st,'<H1>Index</H1>','<A Name="Index"></a><H1>Index</H1>');
st=strrep(st,'<H1>References</H1>','<A Name="ref"></a><H1>References</H1>');
st2=fullfile(pw2,'man_hevea.html');if exist(st2) delete(st2);end
fid=fopen(st2,'w'); fprintf(fid,'%c',st); fclose(fid);

cd(pw2)
eval('!hacha -tocbis man_hevea.html');
delete man_hevea.html
eval('!cp ../tex/plots/*.gif .');
fprintf('Plots copied\n');
cd(pw0);

% ---------------------------------------------------------------
end

function st = OF_HOME;

[st,st1,st2]=fileparts(which('ofutil'));


% -----------------------------------------------------------------------
% -----------------------------------------------------------------------
% -----------------------------------------------------------------------
function pw0=MexTarget(Hom)

pw0=pwd;
Vers=version; Vers=Vers(1:3); if Vers(1)=='6'|Vers(1)=='7'; Vers='6.0';end
[st,st1,st2]=fileparts(which('feplot'));

if exist(fullfile(st,Vers),'dir')
  of.MexTarget=fullfile(st,Vers);
elseif exist(fullfile(Hom,'sdt3'),'dir')
  of.MexTarget=fullfile(Hom,'sdt3');
else error('of.MexTarget was not properly defined');
end

if ispref('OpenFEM','MexTarget')
  of.MexTarget=getpref('OpenFEM','MexTarget');
end
fprintf('%%---------------\n%%---------------\n%%---------------\n');
fprintf('Target mex directory : %s\n',of.MexTarget)
fprintf('%%---------------\n%%---------------\n%%---------------\n');
cd(of.MexTarget);


% -----------------------------------------------------------------------
% -----------------------------------------------------------------------
% -----------------------------------------------------------------------
function [CAM,Cam,st]=comstR(CAM,ind,opt)

if nargin==2&ischar(ind) %initial string comparison

   if ~isempty(ind) & length(CAM)>=length(ind)
    if all(CAM(1:length(ind))==ind) CAM=1;return; end
   end
   CAM=0; return;

elseif ischar(ind)&nargin>2 % parameter extraction utility

   if length(CAM)<length(ind) ind=ind(1:length(CAM));end
   i1=min([find(comstR(CAM(1:length(ind)),-27)~=ind) length(ind)+1 length(CAM)+1]);
   CAM=CAM(i1:length(CAM));
   if ~isempty(CAM)
    i1=find(CAM==','); if ~isempty(i1) CAM(i1)=setstr(32*ones(size(i1)));end
    i1=find(CAM==''''); if ~isempty(i1) CAM(i1)=setstr(32*ones(size(i1)));end
   end
   if ischar(opt) % format given
     if comstR(opt,'%s') [i1,i2,i3,i4]=sscanf(CAM,opt,1);
     else [i1,i2,i3,i4]=sscanf(CAM,opt);end
     Cam=CAM(i4:length(CAM));CAM=i1(:)';
     if ~isempty(Cam)
      ind = find(Cam~=32);ind = [min(ind):max(ind)];
      if ~isempty(ind) Cam = Cam(ind); else Cam=[]; end
     end
     if nargout==3 st=comstR(Cam,-27);
     elseif nargout==2 & ischar(CAM) Cam=comstR(CAM,-27); end
   else Cam=comstR(CAM,-27); end % return the string

elseif length(ind)==1 & ind(1)>0  % eliminate front and tail blanks

   CAM = CAM(ind:length(CAM));

   if ~isempty(CAM)
    ind = find(CAM~=32&CAM~=0);
    if ~isempty(ind)
       CAM = CAM(ind(1):ind(length(ind))); Cam=comstR(CAM,-27);
    else CAM='';Cam='';end
   else Cam=''; end

end
