function [out,out1,out2]=p_beam(varargin)

%P_BEAM Beam element property function
%
%       Syntax : mat= p_beam('default') 
%                mat= p_beam('database','name') 
%                il = p_beam('dbval ProId name');
%                il = p_beam('dbval -unit MM ProId name');
%
%       Currently the only supported subtype is
%               [ProID   type   J I1 I2 A   k1 k2 Lump]
%
%               pro=p_beam('database','name') : returns struct array
%                   for reference beam sections. If 'name' is provided a match
%                   in the section database is made. The database supports
%                   standard sections
%                    circle (r)      : full circular section
%                    rectangle (b h) : full rectangle
%                   For example p_beam('database circle .1')
%
%       See also : help fe_mat
%                  doc  fem (handling materials section), pl, fe_mat, p_shell

%	Etienne Balmes  1/10/00, 22/07/02
%       Copyright (c) 2001-2004 by INRIA and SDTools, All Rights Reserved.
%       Use under OpenFEM trademark.html license and LGPL.txt library license

if nargin==1 & comstr(varargin{1},'cvs')
 out='$Revision: 1.16 $  $Date: 2006/04/27 13:42:18 $'; return;
end

if nargin<1 help p_beam;return; end
if ischar(varargin{1}) [CAM,Cam]=comstr(varargin{1},1); il=[]; carg=2;
else il=varargin{1};[CAM,Cam]=comstr(varargin{2},1); carg=3;
end

sdtdef('diag',['p_beam(''' Cam ''')'])

% -------------------------------------------------------------------------
if comstr(Cam,'propertyunittype')

 i1=varargin{carg}; 
 out1={};
 switch i1
 case 1 % 
     %     [ProID   type   J I1 I2 A   k1 k2]
     st={... 
         'ProId'                 0;
         'Type'                  0;
         'J (torsion)'          11;
         'I1 (bending)'         11; 
         'I2 (bending)'         11;
         'A (area)'             12;
         'k1 (shear factor)'     0;
         'k2 (shear factor)'     0 };
 otherwise; st={'ProId' 0; 'Type', 0};
 end
 if ~isempty(strfind(Cam,'cell')); out=st; else; out=[st{:,2}]; end

% -------------------------------------------------------------------------
elseif comstr(Cam,'default')

  out=p_beam('database');
  out=out(1);

% -------------------------------------------------------------------------
elseif comstr(Cam,'dbval') 

 i1=strfind(comstr(Cam,-27),'-unit'); out1={};
 if ~isempty(i1)
  [Unit,i2,i3,i4]=sscanf(CAM(i1+5:end),'%s',1);
  i4=i1+[0:4+i4];CAM(i4)=''; [CAM,Cam]=comstr(CAM,1);
 else Unit=''; end

 while 1==1
  [CAM,Cam]=comstr(CAM,6);
  [i1,CAM,Cam]=comstr(CAM,'','%i');
  if isempty(CAM)&carg<=nargin st=varargin{carg};carg=carg+1; 
  else st=CAM;end
  mat=p_beam('database',st);
  if ~isempty(Unit)
   mat.il=fe_mat(sprintf('convert %s %s',mat.unit,Unit),mat.il);
  end
  r1=mat.il; if length(i1)==1 r1(1)=i1;end
  if ~isempty(il) i2=find(il(:,1)==r1(1)); else i2=[];end
  if isempty(i2) i2=size(il,1)+1;end
  il(i2,1:length(r1))=r1;
  if carg>nargin break;end
  [CAM,Cam]=comstr(varargin{carg},1);carg=carg+1;
 end
 out=il;

% -------------------------------------------------------------------------
elseif comstr(Cam,'database') 

  st=comstr(CAM,9);
  if isempty(st)&carg<=nargin st=varargin{carg}; carg=carg+1;end
  [MatId,i2,i3,i4]=sscanf(st,'%i',1); if i2~=1 MatId=1;end
  st=comstr(st,i4);

  out    = create_section_beam('circle .01 m'); out.il(1)=MatId; 
  out(2) = create_section_beam('rectangle .01 .02 m');   out(2).il(1)=MatId;

  out1='Beam section';

  i1=strmatch(st,{out.name},'exact');
  if ~isempty(i1) out=out(i1);
  elseif ~isempty(st)
   out=create_section_beam(st,out);  out.il(1)=MatId;
  end


% -------------------------------------------------------------------------
elseif comstr(Cam,'subtypestring')

 i1=varargin{carg}; carg=carg+1;
 switch i1
 case 1;  out='p_beam';
 otherwise out='p_beam';
 end


end
% -------------------------------------------------------------------------

% --------------------------------------------------------------------
% Creation of standard section properties
function out = create_section_beam(CAM,out)

[CAM,Cam]=comstr(CAM,1);

if comstr(Cam,'circle')

  r1=comstr(Cam,'circle','%g');

  out=[];
  out.il=[1 fe_mat('p_beam',1,1) pi*[1/2 1/4 1/4]*r1^4 pi*r1^2 0 0];
  out.name=Cam;
  out.type='p_beam';
  out.unit='SI';

elseif comstr(Cam,'rectangle')

  r1=comstr(Cam,'rectangle','%g');
  if length(r1)~=2
    error('You must specify 2 dimensions for rectangle beam section');
  end
  out=[];
  b=r1(1); h=r1(2); 
  out.il=[1 fe_mat('p_beam',1,1) 0 b*h^3/12 b^3*h/12 b*h 0 0];
  out.il(1,3)=sum(out.il(1,4:5)); % J xxx this is not very good
  out.name=Cam;
  out.type='p_beam';
  out.unit='SI';

else warning('Using default beam property'); out=out(1);
end

% --------------------------------------------------------------------
 
